#!/usr/local/bin/perl

# Commport:/htdocs/cp/c_edit.cgi
#
# Allows editing of a custom channel, including external URL fetching
# if user's access level is high enough.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/c_edit.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.08.02 - CH  - Added this copyright/changelog section.
# 1999.08.03 - CH  - Added URL syntax check, demanding "http://.../".
# 1999.10.01 - CH  - Added quoting of text fields in Insert and Update.

use CGI;
use DBI;

require "../../common/common.pl";

$Query = new CGI;

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

&GetUserInfo;

if ($Method eq "POST") {
   $ID = $Query->param("ID");
   $Name = $Query->param("Name");
   $URL = $Query->param("URL");
   $Descript = $Query->param("Descript");
   $Access = $Query->param("Access");
   $Sort = $Query->param("Sort");
   $F_URL = $Query->param("F_URL");
   $F_Time = $Query->param("F_Time");
   $F_Type = $Query->param("F_Type");
   $F_Type_Orig = $Query->param("F_Type_Orig");
   $Cat1 = $Query->param("Cat1");
   $I_C = $Query->param("ImgCache");
   $Delete = $Query->param("Delete");
   $F_PlugIn = $Query->param("F_PlugIn");

   if ($Delete ne "") {
      $Results = &DoDelete;
      print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/prefs.cgi");
      exit;
   }

   $ReqStr = $ErrStr = "";

# Check for missing required fields.

   if ($Name =~ /^\s*$/) {
      $ReqStr .= ", Name"; }

# Check for other errors.
   $l = length($Descript);
   if ($l > 200) {
      $ErrStr .= ", Description is limit to 200 characters, currently at $l";
   }

   if ($URL ne "") {
      if (!($URL =~ /^[^:]+:\/\/[^\.]+\.[^\\]+\//)) {
         $ErrStr .= ", URL not valid - must include http://server/";
      }
   }


# Merge required errors into main errors.

   if ($ReqStr ne "") {
      $ReqStr =~ s/^, //;
      $ErrStr .= ", ${ReqStr} required";
   }
   $ErrStr =~ s/^, //;

   if ($ErrStr eq "") {

      if ($I_C == 0) { $Img_Cache = 0; $Img_Mode = 0;
      } elsif ($I_C == 1) { $Img_Cache = 0; $Img_Mode = 1;
      } elsif ($I_C == 2) { $Img_Cache = 1; $Img_Mode = 3;
      } elsif ($I_C == 3) { $Img_Cache = 3; $Img_Mode = 3;
      } elsif ($I_C == 4) { $Img_Cache = 2; $Img_Mode = 3;
      } elsif ($I_C == 5) { $Img_Cache = 0; $Img_Mode = 2;
      } else { $Img_Cache = 0; $Img_Mode = 0;
         print STDERR "c_edit.cgi - Bad I_C (${I_C}\n";
      }


      if ($ID == 0) {
      $Results = &DoInsert;
      } else {
      $Results = &DoUpdate;
      }

      if ($Results == 0) {
         print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/prefs.cgi");
         exit;
      } elsif ($Results == 1) {
         $ErrStr = "Username already in use.  Please choose another.";
      } else {
         $ErrStr = "Insert unsuccessful - ${Results}.";
      }
   } else {
      $ErrStr .= ".";
   }
} else {
   $ID = $QueryString;
   &DoSelect;
}

print $Query->header;
&RenderHeader("$QueryString",0);

if ($ID > 0) {
$Sub_Button = $LangStr{"CEDT017"};
} else {
$Sub_Button = $LangStr{"CEDT016"};
print <<HTML
<blockquote>
$LangStr{"CEDT023"} <a href="p_list.cgi">$LangStr{"CEDT024"}</a> 
$LangStr{"CEDT025"}.
</blockquote>
HTML

}

$A_0 = $A_1 = "";
if ($Access == 0) { $A_0 = " SELECTED" ;
} else { $A_1 = " SELECTED"; }

$S_0 = $S_1 = $S_2 = "";
if ($Sort == 0) { $S_0 = " SELECTED" ;
} elsif ($Sort == 1) { $S_1 = " SELECTED";
} else { $S_2 = " SELECTED"; }

print <<HTML;
<form action="${CP_URLPath}/c_edit.cgi" method="post">
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF">
<table border=0 width="100%">
HTML

if ($ErrStr ne "") {
print "<tr><th align=\"right\" valign=\"top\" width=\"10%\">"
."<font color=\"red\">Error:</font></th>"
."<th align=\"left\"><font color=\"red\">${ErrStr}</font></th></tr>";
}

print <<HTML;
<tr><th align="right" width="10%">$LangStr{"CEDT001"}</th>
<td><input type="text" name="Name" value="${Name}" size=40 maxlength=40>
</td></tr>

<tr><th align="right">$LangStr{"CEDT002"}</th>
<td><input type="text" name="URL" value="${URL}" size=40 maxlength=120> 
<input type="hidden" name="ID" value="${ID}">
</td></tr>

<tr><th align="right" valign="top">$LangStr{"CEDT003"}</th>
<td><textarea cols=40 rows=5 name="Descript" wrap="virtual">${Descript}</textarea></td></tr>

<tr><th align="right">$LangStr{"CEDT004"}</th>
<td><select name="Access">
<option value="0"$A_0>$LangStr{"CEDT018"}
<option value="1"$A_1>$LangStr{"CEDT019"}
</select></td></tr>

<tr><th align="right">$LangStr{"CEDT005"}</th>
<td><select name="Sort">
<option value="0"${S_0}>$LangStr{"CEDT020"}
<option value="1"${S_1}>$LangStr{"CEDT021"}
<option value="2"${S_2}>$LangStr{"CEDT022"}
</select></td></tr>

<tr><th align="right">$LangStr{"CEDT006"}</th>
<td><select name="Cat1"><option value=""> ---
HTML

&BuildCatList;
$Cnt = 0;
foreach $t (@Cats) {
if ($Cats_ID[$Cnt] == $Cat1) { $Sel = " SELECTED" } else {$Sel="";};
print "<option value=\"$Cats_ID[$Cnt]\"${Sel}>${t}\n";
$Cnt++;
}

print "</select></td></tr>\n";

if ($User_Priv >= $Admin_Importer) {
print <<HTML;
<tr><th colspan=2 bgcolor="#FFEEEE">&nbsp;<br>External URL Fetch of RDF file<br>&nbsp;<br></th></tr>

<tr><th align="right">Fetch URL</th>
<td><input type="text" name="F_URL" value="${F_URL}" size=42 maxlength=250> 
</td></tr>

<tr><th align="right">Interval (minutes)</th>
<td><input type="text" name="F_Time" value="${F_Time}" size=6 maxlength=6> 
Set to 0 to never fetch.
</td></tr>
HTML


if ($User_Priv >= $Admin_Importer) {
print <<HTML;
<tr><th align="right">Data Type</th>
<td><input type="text" name="F_Type" value="${F_Type}" size=6 maxlength=6>
2 == raw text, 7 == PlugIn, 20 == XML.
</td></tr>
<tr><th align="right">Plug In</th>
<td><input type="text" name="F_PlugIn" value="${F_PlugIn}" size=20 maxlength=50>
Only relevant if Type == 7 ; must have PlugIn installed.
</td></tr>
HTML
}

$C_0 = $C_1 = $C_2 = $C_3 = $C_4 = $C_5 = "";
if ($Img_Mode == 0) { $C_0 = " SELECTED" ;
} elsif ($Img_Mode == 1) { $C_1 = " SELECTED";
} elsif ($Img_Mode == 2) { $C_5 = "<option value=\"5\" SELECTED>Uploaded image";
} elsif ($Img_Mode >= 3) { 
if ($Img_Cache <= 1) { $C_2 = " SELECTED";
} elsif ($Img_Cache == 2) { $C_4 = " SELECTED";
} elsif ($Img_Cache == 3) { $C_3 = " SELECTED";
} else { print STDERR "c_edit.cgi -- Bad Img state - $Img_Mode - $Img_Cache\n"; }
} else { print STDERR "c_edit.cgi -- Bad Img state - $Img_Mode - Img_Cache\n"; }

print <<HTML;
<tr><th align="right">Image Cache</th>
<td>
<select name="ImgCache">
<option value="0"${C_0}>Don't cache - remote image link.
<option value="1"${C_1}>Ignore - no image is shown.
<option value="2"${C_2}>Cache once.
<option value="3"${C_3}>Cache once a day.
<option value="4"${C_4}>Cache every fetch.
${C_5}
</select>
</td></tr>

HTML

print <<HTML;
<tr><th align="right">Last Fetched</th>
<td>${F_Last} (Now == ${F_Now})
</td></tr>

<tr><th colspan=2 bgcolor="#FFEEEE">&nbsp;<br>&nbsp;</th></tr>
HTML
}



if ($ID > 0) {
print <<HTML;
<tr><th align="right">...OR...</th>
<td><input type="checkbox" name="Delete"> Remove Channel.
<input type="hidden" name="F_Type_Orig" value="${F_Type}">
</td></tr>
HTML
}

print <<HTML;
<tr><th></th>
<td><input type="submit" value="${Sub_Button}">

</table>
</td>
</tr>

</table>
</form>

HTML

sub DoInsert {
   local ($cmd);
   local ($N,$U,$D);

   &OpenDB;

   $N = $dbh->quote($Name);
   $U = $dbh->quote($URL);
   $D = $dbh->quote($Descript);

   if ($User_Priv < $Admin_Importer) {
   $cmd = "insert into Channel (ID_User,Name,URL,Descript,Public"
.",Sorting,Cat1,State,Img_Mode,Img_Cache) values "
."(\"${User_ID}\",${N},${U},${D},\"${Access}\""
.",\"${Sort}\",\"${Cat1}\",3,\"${Img_Mode}\",\"${Img_Cache}\")";
   } else {

   if ($F_URL eq "") { $Type = 0; } else { $Type = 20; };

   $cmd = "insert into Channel (ID_User,Name,URL,Descript,Public,Sorting"
.",FetchURL,F_Time,Type,Cat1,State) values "
."(\"${User_ID}\",${N},${U},${D},\"${Access}\",\"${Sort}\""
.",\"${F_URL}\",\"${F_Time}\",\"${Type}\",\"${Cat1}\",4)";
   }
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoUpdate {
   local ($cmd,$sth);
   local ($N,$U,$D);

   &OpenDB;

   $N = $dbh->quote($Name);
   $U = $dbh->quote($URL);
   $D = $dbh->quote($Descript);

   $cmd = "update Channel SET"
." Name=${N}"
.",URL=${U}"
.",Descript=${D}"
.",Public=\"${Access}\""
.",Sorting=\"${Sort}\""
.",Img_Mode=\"${Img_Mode}\""
.",Img_Cache=\"${Img_Cache}\""
.",Cat1=\"${Cat1}\"";

if ($F_URL eq "") {
   $F_Type = 0;
} else {
   if ($F_Type == 0) {
      $F_Type = $F_Type_Orig;

      if ($F_TypeOrig == 0) {
         $F_Type = 20;
      }
   }
}
   if ($User_Priv >= $Admin_Importer) {
   $cmd .= ",FetchURL=\"${F_URL}\""
.",F_Time=\"${F_Time}\""
.",Type=\"${F_Type}\""
.",PlugIn=\"${F_PlugIn}\"";
   }

   $cmd .= " where ID=${ID} AND (ID_User=${User_ID} OR ${User_Priv} >= ${Admin_Moderator})"
;

#print STDERR "$cmd\n";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoDelete {
   local ($cmd,$sth);

   &OpenDB;

   $cmd = "delete from Item"
." where ID_Channel=${ID}";
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   $cmd = "delete from Channel"
." where ID=${ID} AND ID_User=${User_ID}";
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoSelect {
   local ($cmd);

   &OpenDB;

   if ($ID eq "") {
      return 0
   }
   $cmd = "select ID_User,Name,URL,Descript,Public,FetchURL,F_Time,F_Last,now(),Type,Cat1,Cat2,Sorting,Img_Mode,Img_Cache,Img_W,Img_H,PlugIn from Channel"
." where ID=${ID}"
;

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Channel = $sth->fetchrow_array;
   $sth->finish;

   if ($Channel[0] != $User_ID && $User_Priv < $Admin_Moderator) {
      return 1;
   }

   $Name = $Channel[1];
   $URL = $Channel[2];
   $Descript = $Channel[3];
   $Access = $Channel[4];

   $F_URL = $Channel[5];
   $F_Time = $Channel[6];
   $F_Last = $Channel[7];
   $F_Now = $Channel[8];
   $F_Type = $Channel[9];
   $Cat1 = $Channel[10];
   $Cat2 = $Channel[11];

   $Sort = $Channel[12];
   $Img_Mode = $Channel[13];
   $Img_Cache = $Channel[14];
   $Img_W = $Channel[15];
   $Img_H = $Channel[16];

   $F_PlugIn = $Channel[17];

   return 0;
}

