#!/usr/local/bin/perl


# CommPort:/htdocs/cp/admin/users.cgi
#
# Presents list of all users in the system.  Can be sorted by different
# columns.

# The contents of this file are subject to the CommPort Public License
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code is ${CPHOME}/htdocs/cp/admin/users.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion
# into the root public codebase.
#
# Contributor(s): Chris Halsall, Ian White,
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.

# Changelog:
#
# 2000.06.10 - CH  - Added this copyright/changelog section.


use CGI;
use DBI;

require "../../../common/common.pl";

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$User = $ENV{'REMOTE_USER'};
$QStr = $ENV{'QUERY_STRING'};

$Query = new CGI;

&GetUserInfo;

print $Query->header;
&RenderHeader("Current Users",0);

if ($QStr) {
   if ($QStr =~ /Name/) {
      $QStr = "lname,fname";
   }
   $Order = "order by ${QStr}";
} else {
   $Order = "order by lname,fname";
}
$cmd = "select User.ID,un,fname,lname,email,count(ID_User) as NumPan,ID_User,Joined,Priv from User LEFT JOIN Panel on ID_User=User.ID group by ID ${Order}";

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

print <<HTML;
<h2><a href="${CP_URLPath}/admin/">Admin:</a> Current Users</h2>
<table border=1 width="100%" cellspacing=0>
<tr bgcolor="#FFFF00">
<th align="right">#</th>
<th><a href="users.cgi?ID">ID</a></th>
<th><a href="users.cgi?Priv">Priv</a></th>
<th><a href="users.cgi?UN">User Name</a></th>
<th><a href="users.cgi?Name">Name</a></th>
<th><a href="users.cgi?EMail">EMail</a></th>
<th><a href="users.cgi?NumPan"># Pan.</a></th>
<th><a href="users.cgi?Joined">Joined</a></th>
</tr>
HTML

$cnt = 0;
while (@rec = $sth->fetchrow_array) {
   if ($rec[6]) { $Count = $rec[5]; } else { $Count = 0 };

   $cnt++;
   print <<HTML;
<tr>
<td align="right">$cnt</td>
<td align="right">${rec[0]}</td>
<td>${Admin_Labels_Short{$rec[8]}}</td>
<td><a href="${CP_URLPath}/admin/user.cgi?${rec[0]}">$rec[1]</a></td>
<td>$rec[3], $rec[2]</td>
<td>${rec[4]}</td>
<td align="right">${Count}</td>
<td>$rec[7]</td>
</tr>
HTML

#      print "<li>$rec[3], $rec[2] ($rec[4]) as $rec[1] ($rec[5] panels)\n";

}

print "</table>";

