#!/usr/local/bin/perl

# CommPort:/htdocs/cp/admin/user.cgi
#
# Lowest level admin drill-down view on a user in the system.


# The contents of this file are subject to the CommPort Public License
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code is ${CPHOME}/htdocs/cp/admin/user.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion
# into the root public codebase.
#
# Contributor(s): Chris Halsall, Ian White,
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.

# Changelog:
#
# 2000.06.10 - CH  - Added this copyright/changelog section.


use CGI;
use DBI;

require "../../../common/common.pl";

$Query = new CGI;

#print $Query->header;
$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

&GetUserInfo;

if ($Method eq "POST") {
   $ID = $Query->param("ID");
   $UName = $Query->param("UName");
   $FName = $Query->param("FName");
   $LName = $Query->param("LName");
   $EMail = $Query->param("EMail");
   $Priv = $Query->param("Priv");
   $PW1 = $Query->param("PW1");
   $PW2 = $Query->param("PW2");
   $Delete = $Query->param("Delete");

   if ($Delete ne "") {
      $Results = &DoDelete;
      print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/admin/users.cgi");
      exit;
   }

   $ReqStr = $ErrStr = "";

# Check for missing required fields.

   if ($PW1 ne "") {
      if ($PW1 ne $PW2) {
         $ErrStr .= ", Password and Confirmation do not match";
      } elsif (length($PW1) < 3) {
         $ErrStr .= ", Password must be 3 characters or longer";
      }
   }
# Check for other errors.

   if ($User_Priv < $Admin_UserAdmin) {
      print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/");
      return 0;
   }

# Merge required errors into main errors.

   $ErrStr =~ s/^, //;

   if ($ErrStr eq "") {

      if ($ID == 0) {
      $Results = &DoInsert;
      } else {
      $Results = &DoUpdate;
      }

      if ($Results == 0) {
         print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/admin/users.cgi");
         exit;
      } elsif ($Results == 1) {
         $ErrStr = "Username already in use.  Please choose another.";
      } else {
         $ErrStr = "Insert unsuccessful - ${Results}.";
      }
   } else {
      $ErrStr .= ".";
   }
} else {
   ($ID,$Channel_ID) = split(/\//,$QueryString);
   &DoSelect;
}

print $Query->header;
&RenderHeader("View User - ${UName}",0);

if ($ID > 0) {
$Sub_Button = "Update User";
} else {
$Sub_Button = "Add new Item";
}

print <<HTML;
<h2><a href="${CP_URLPath}/admin/">Admin:</a> 
<a href="${CP_URLPath}/admin/users.cgi">Current Users:</a> ${UName}</h2>

<form method="post">
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF">
<table border=0 width="100%">
HTML

if ($ErrStr ne "") {
print "<tr><th align=\"right\" valign=\"top\" width=\"10%\">"
."<font color=\"red\">Error:</font></th>"
."<th align=\"left\"><font color=\"red\">${ErrStr}</font></th></tr>";
}

print <<HTML;
<tr><th align="right" width="10%">User&nbsp;Name</th>
<td>${UName}
<input type="hidden" name="UName" value="${UName}">
</td></tr>

<tr><th align="right" width="10%">Name</th>
<td>${LName}, ${FName}
<input type="hidden" name="LName" value="${LName}">
<input type="hidden" name="FName" value="${FName}">
</td></tr>

<tr><th align="right" width="10%">E-Mail</th>
<td>${EMail}
<input type="hidden" name="EMail" value="${EMail}">
</td></tr>

<tr><th align="right" width="10%">Access</th>
<td>
<input type="hidden" name="ID" value="${ID}">
<select name="Priv">
HTML

if ($User_Priv >= $Admin_UserAdmin) {
   foreach $T (@Admin_Values) {
      if ($T == $Priv) { $Admin_Sel = " selected";
      } else { 
         $Admin_Sel = "";
         # Except for superuser, admin can only promote another to below themselves.
         next if ($T > $User_Priv && $User_Priv < $Admin_SuperUser );  
      }

      print "<option value=\"${T}\"${Admin_Sel}> ${Admin_Labels{${T}}}\n";
   }
} else {
   print "<option value=\"${Priv}\"> ${Admin_Labels{${Priv}}}\n";
}


print "</select></td></tr>";


if ($User_Priv >= $Admin_UserAdmin) {
print <<HTML;
<tr><th align="right" width="10%">Reset PW</th>
<td>
<input type="password" name="PW1" value="${PW1}" size=16 maxlength=16>
</td></tr>

<tr><th align="right" width="10%">Confirm</th>
<td>
<input type="password" name="PW2" value="${PW2}" size=16 maxlength=16>
</td></tr>

<tr><th align="right">...OR...</th>
<td><input type="checkbox" name="Delete"> Remove User.
</td></tr>
<tr><th></th>
<td><input type="submit" value="${Sub_Button}">
</td></tr>
HTML
}

print <<HTML;
</table>
</td>
</tr>

</table>
</form>

<table border=1 width="100%">
<tr bgcolor="#FFFF00">
<th align="right">#</th>
<th align="right">Public</th>
<th>Name</th>
<th>URL</th>
<th>Type</th>
<th>Cat</th>
</tr>
HTML

$cmd = "select ID,name,URL,Public,F_Time,F_Last,Type,Cat1,Img_Src from Channel where ID_User=${ID}";

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

$cnt = 0;
while (@rec = $sth->fetchrow_array) {

   $cnt++;
   print <<HTML;
<tr>
<td align="right">$cnt</td>
<td>${rec[3]}</td>
<td><a href="${CP_URLPath}/c_view.cgi?${rec[0]}">${rec[1]}</a></td>
<td><a href="${rec[2]}">$rec[2]</a></td>
<td>${rec[6]}</td>
<td>$rec[7]</td>
</tr>
HTML

#      print "<li>$rec[3], $rec[2] ($rec[4]) as $rec[1] ($rec[5] panels)\n";

}








print <<HTML;
</table>
HTML









sub DoInsert {
   local ($cmd);

   return 0;  # This should never be called.

   &OpenDB;

   $cmd = "insert into Item (ID_Channel,Title,URL) values "
."(\"${Channel_ID}\",\"${Title}\",\"${URL}\")";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}


sub DoUpdate {
   local ($cmd,$PWC,$Salt);

   &OpenDB;

   $cmd = "update User SET"
." Priv=\"${Priv}\"";

   if ($PW1 ne "") {
      $Salt = sprintf("%02d", $$%100);
      $PWC = crypt($PW1, $Salt);
      $cmd .= ",pw='${PWC}'";
   }

   $cmd .= " where ID=${ID}";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   if ($PW1 ne "") {
      &BuildPWFile;
   }
   return 0;
}

sub DoDelete {
   local ($cmd,$sth);

   &OpenDB;

#   &LockUsers;

   $cmd = "delete from User where ID=${ID}";
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   $cmd = "delete from Panel where ID_User=${ID}";
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   &BuildPWFile;
#   &UnLockUsers;

   return 0;
}

sub DoSelect {
   local ($cmd);

   &OpenDB;

   $cmd = "select UN,FName,LName,EMail,Priv from User"
." where ID=${ID}"
;

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Item = $sth->fetchrow_array;
   $sth->finish;

   if ($Item[0] != $Channel_ID) {
      return 1;
   }

   $UName = $Item[0];
   $FName = $Item[1];
   $LName = $Item[2];
   $EMail = $Item[3];
   $Priv = $Item[4];

   return 0;
}

