#!/usr/local/bin/perl

use CGI;
use DBI;

require "../../../common/common.pl";

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$User = $ENV{'REMOTE_USER'};

$Query = new CGI;

&GetUserInfo;

print $Query->header;
&RenderHeader("Commport - To Do",0);

print <<HTML;
<h1>Where do we go from here?</h1>

<blockquote>

This is a quick list of things we can/should do with the CommPort system
if it's decided to proceed with further development/deployment.  The
list is in order of importance (opinion of C.H.), and was last updated 
Wednesday, Sep 22th, 1999.

<ol>

<b><li> Administrative system
</b><p>
Extend the user system to allow:
<ul>
<li>A "super-user" who controls the layout of the "public page" (as now).
<li>Same user to be able to grant administrative access to other users.
<li>Administrative users can then grant publishing rights to users, allowing
them to make public any channels they wish.
<li>Alternatively, Administrators could approve specific channels for public
access from a user upon request.
<li>Various reports on users and channels.
<li>Ability to reset a user's password or change one or more fields.
<li>Ability to change ownership of a channel.
<li>Additional channel control, such as hidding a channel from public
view, editing a user's channel, etc.
</ul>
<p>

<b><li> "I forgot my password" sub-system
</b><p>
<ul>
<li>Facility for a user who's forgotten their password to have a new one
set and e-mailed to them.
<li>Will include anti-cracking measures:
<ul>
<li>the original password is saved
and restored if the reset password is not used within a fixed length of 
time
<li>a single remote machine cannot reset more than one password within a
fixed length of time -- 
warning messages to adiministrators if this occurs, but without giving
any notice to the remove machine's user.

</ul>
</ul>
<p>


<b><li> Simplified Rendering Option
</b><p>
Allow the user to select a rendering complexity for slower machines.  
This would result in fewer nested tables, thus demanding less of the
remote systems
<p>


</ol>
</blockquote>


<h1>Additional, cool things we could do...</h1>

<blockquote>

<ol>
<b><li> Additional customization
</b>
<p>
Provide additional customization ability for each user, including:
<ul>
<li>ability to set the number of items which show up in each panel
<li>...leads to...a panel click-through to show all the items in a panel
<li>custom colour choices for the background, links and text.
</ul>
<p>

<b><li> Link checker
</b>
<p>
Create a link-checker sub-system which would ensure links within the
system are still resolvable.  Would notify the owner of the channel if
one or more links cannot be fetched.
<p>


<b><li> User comment and reviews
</b>
<p>
Create a means by which users could comment on the publiclly available
channels.  Include a rating system for people to recommend or recommend
against a particular channel's content.
<p>
</ol>

</blockquote>

HTML
