#! /usr/bin/perl

# CommPort:/cron/plugins/worldmap.pl 
#
# Performs the fetching and parcing of external channels.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/cron/plugins/worldmap.pl
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall


# Changelog:
#
# 2000.06.15 - CH  - Created this first plugin.

use LWP::UserAgent;
use HTML::LinkExtor;
use URI::URL;
use DBI;

require "/home/piwcommport/common/common.pl";
require "/home/piwcommport/common/images.pl";

$ua = new LWP::UserAgent;
$ua->agent("CommPort/${CP_Ver} http://commport.csp.net");


$ID = shift;
$RawFile = shift;
$TmpFile = shift;

$cmd = "grep cache ${RawFile}";
$rslt= `$cmd`;

if ($rslt =~ /cache\/(\d*.jpg)/) {
   $File = $1;

   GetAndScaleImg($TmpFile, 
      "http://www.fourmilab.ch/earthview/cache/${File}", 
      $ID);
}


print "${ID} - ${RawFile} - ${TmpFile} - $rslt\n$File\n";



sub GetAndScaleImg {
   local ($TmpFile, $URL, $ID) = @_;
   local ($ImgFile,$ImgThum);
   local ($T,$W,$H);
 
   $ImgFile = "${SYSROOT}/fetched/imgs/${ID}.raw";
   $ImgThum = "${HTDOCROOT}/cimgs/${ID}.jpg";

   print "Want to GET \"$URL\"\n";

   $req = new HTTP::Request 'GET', $URL;

   $res = $ua->request($req);

   # check the outcome
   if (!$res->is_success) {
      return 0;
   }

   open (OUT, ">${ImgFile}");
   print OUT $res->content;
   close OUT;

   ($T,$W,$H) = ImageTypeAndSize($ImgFile);

   print "T:$T W:$W H:$H\n";

   $shellcmd = "${Cmd_Loc_Convert} -geometry ${CAM_X_LIMIT}x${CAM_Y_LIMIT}!"
." ${T}:${ImgFile} ${ImgThum}";
   $rslt = `$shellcmd`;

   print "About to do: \"$shellcmd\"\n";

   open (OUT, ">${TmpFile}");
   print OUT "<center><a href=\"${URL}\"><img src=\"/cimgs/${ID}.jpg\""
." width=\"${CAM_X_LIMIT}\""
." height=\"${CAM_Y_LIMIT}\" border=\"0\"></a></center>";
   close (OUT);


   return 1;
}
