#! /usr/bin/perl

# CommPort:/common/images.pl
#
# File of local defines for the system.

# The contents of this file are subject to the CommPort Public License
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code is ${CPHOME}/common/images.pl
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.09.20 - CH  - Created this file to contain image support routes.

# Needed support program paths.

$FileExec = "file";
$JPGExec = "rdjpgcom";


sub ImageTypeAndSize {
   local ($File) = @_;
   local ($W,$H,$T,$IT);
   local ($rslt,$H,$T,$IT);

   $shellcmd = "${FileExec} ${File}";
#print STDERR "About to do \"$shellcmd\"\n";
   $rslt = `$shellcmd`;
#print STDERR "...\"$rslt\"\n";

   $T = $rslt;
   $C = $T =~ s/([^:]*: GIF image data.*) (\d+) x (\d+)//i;

   if ($C ne "") {
      $W=$2; $H=$3;
      $IT = "gif";
   } else {
      $T = $rslt;
      $T =~ s/([^:]*: JPEG image data.*)//;
      if ($1 ne "") {
         $IT = "jpg";

         $shellcmd = "${JPGExec} -v ${File}";
#print STDERR "About to do \"$shellcmd\"\n";
         $rslt = `$shellcmd`;
#print STDERR "...\"$rslt2\"\n";

         $rslt =~ s/JPEG image is (\d+)w \* (\d+)h//i;
         $W = $1; $H = $2;

      } else {
      $T = $rslt;
      $T =~ s/([^:]*: PNG image data.*) (\d+) x (\d+)//;
      if ($1 ne "") { # PNG.
         $W=$2; $H=$3;
         $IT = "png";
      } else {
         # Huh?  We don't do tiff, nor bmp, nor....
      }
      }
   }

print STDERR "Image Type: $IT ($W x $H)\n";

   return ($IT,$W,$H);
}






return 1;
