#!/usr/bin/perl

require "/home/piwcommport/common/local.pl";

# CommPort:/common/common.pl
#
# Library of code and defines for the system.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/index.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.08.02 - CH  - Added this copyright/changelog section.
# 1999.09.15 - CH  - Added Image caching and size determining.
# 1999.09.17 - CH  - Released 0.51.
# 1999.09.21 - CH  - Added Image Uploading.
# 1999.09.21 - CH  - Added new channel parcers.
# 1999.09.22 - CH  - Added rss.cgi export.
# 1999.09.22 - CH  - Released 0.52.
# 2000.04.26 - CH  - Added language support.
# 2000.05.16 - CH  - Commited to CVS as .70.
# 2000.06.15 - CH  - Commited to CVS as 1.00 in prep for release.


# Name and URL defaults

$CP_Version = "1.00";
$CP_Name = "Community Portal";


$PWFileBase = ".commport";

# Handles the fallback for Lynx viewing.

$CP_Lynx_Viewer = 0;
$CP_User_Agent = $ENV{HTTP_USER_AGENT};

if ($CP_User_Agent =~ /Lynx/) {
   $CP_Lynx_Viewer = 1;
} elsif ($CP_User_Agent eq "") {
   $CP_Lynx_Viewer = 1;
}

# Handles the language selection.
# Note: this is a one-pass fetch, so each locale file must be complete

%LangAvail = ("en",1,"fr",1,"es",1);

$CP_Lang_Req = $T = $ENV{'HTTP_ACCEPT_LANGUAGE'};
$T =~ s/\s//g;
@T = split(/,/,$T);

$CP_Lang = "en";
foreach $T (@T) {
  $T =~ s/(^-)*(-.*)/\1/;
  if ($LangAvail{$T}) {
    $CP_Lang = $T;
    last;
  }
}

$LangStr{"INDX000"} = "No Locale Files.";
$LangStr{"INDX001"} = "No Locale Files.";

$LangStr{"MYCP000"} = "No Locale Files.";
$LangStr{"MYCP001"} = "No Locale Files.";

# Now we have our language.

if (open (LANG, "${LOCALE_PATH}/${CP_Lang}.txt")) {
   while (<LANG>) {
      s/(.*) : (.*)//;
      $LangStr{$1} = $2;
   }
}

$CP_Name = $LangStr{"INDX000"};  # This is a bit of a hack...




sub RenderHeader {
   local ($Title, $Links) = @_;
   local ($Ref,$Self);

$Self = $ENV{'SCRIPT_NAME'};
$Self =~ s/.*\/([^\/]*)/\1/;
$Self =~ s/\.cgi//;

if ($Links) {
$Ref = "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"1800\">";
$Ref .="<META HTTP-EQUIV=\"Pragma\" CONTENT=\"No-Cache\">";
}
print <<HTML;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
"http://www.w3.org/TR/REC-html40/loose.dtd">
<html><head>${Ref}<title>${CP_Name} - ${Title}</title>
<style type="text/css">
<!--
        TD,TH { font-family: helvetica,arial,sans-serif;}
        A, A:link { text-decoration: none; color:blue; }
        A:visited { text-decoration: none; color:light blue}
        A:hover { text-decoration: underline; color:red; }
        .sym { color: red; font-weight: bold; }
-->
</style>
</head>
<body bgcolor="#eaeed3" link="#333399" vlink="#333399" 
topmargin=4 leftmargin=4 marginheight=4 marginwidth=4>

<table border=0 width="100%" cellspacing=0 cellpadding=0 background="/gifs/bg-heading.gif">
<tr><td><a href="${CP_URLPath}/"><img src="/gifs/heading.gif" border=0 hspace=24 vspace=12 alt="$LangStr{"INDX000"}"></a></td>
<th>
$LangStr{"INDX001"} ${User_FN} ${User_LN}<br>
HTML

if ($User_Gst) {
print <<HTML;
<a href="${CP_URLPath}/">$LangStr{"INDX003"}</a> |
<a href="signup.cgi">$LangStr{"INDX004"}</a>
HTML
} else {
print <<HTML;
<a href="${CP_URLPath}/p_list.cgi">$LangStr{"MYCP000"}</a> | 
<a href="${CP_URLPath}/prefs.cgi">$LangStr{"MYCP001"}</a> |
<a href="http://hp.bccna.bc.ca/cgi-tcbin/cwmail.cgi">$LangStr{"MYCP002"}</a> |
<a href="${CP_URLPath}/exit.cgi">$LangStr{"MYCP003"}</a> |
<a href="${CP_URLPath}/help.cgi?${Self}">$LangStr{"MYCP004"}</a>
HTML
}

print "</th></tr></table>\n";

}

sub RenderFooter {
print <<HTML;
<table border=0 cellpadding=1 cellspacing=0 bgcolor="#000000" width="100%"><tr><td>
<table border=0 cellpadding=2 cellspacing=0 bgcolor="#FFFFFF" width="100%"><tr><td align="center">
<a href="http://www.ic.gc.ca/"><img src=\"/gifs/indcan2.jpg\" width=230 height=43 alt=\"$LangStr{"INDX005"}\" border=0></a>
<a href="http://cap.ic.gc.ca/"><img src=\"/gifs/captini.gif\" width=85 height=34 alt=\"$LangStr{"INDX006"}\" border=0></a>
<a href="http://www.tc.ca/"><img src=\"/gifs/tclogo.gif\" width=303 height=45 
alt=\"$LangStr{"INDX007"}\" border=0></a>
</td></tr></table>
</td></tr></table>
HTML
}

# - Database functions

sub LockUsers {
        $cmd = "lock tables User WRITE";
        $rc = $dbh->do($cmd);
}

sub UnLockUsers {
        $cmd = "unlock tables";
        $rc = $dbh->do($cmd);
}

sub OpenDB {
   if (!$dbh) {
   $dbh = DBI->connect($DBI_STR, $SQL_PUN, $SQL_PPW); }
}

sub CloseDB {
   $dbh->disconnect;
   undef($dbh);
}

sub BuildPWFile {
   local ($cmd,$sth,$rv);

   &OpenDB;

   $cmd = "select id,un,pw,priv from User";
   open (OUT, ">${AUTH_PATH}/${PWFileBase}.${$}");
   open (OUTA, ">${AUTH_PATH}/${PWFileBase}admin.${$}");
   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   while (@rec = $sth->fetchrow_array) {
      print OUT "$rec[1]:$rec[2]\n";
      $LCase = $rec[1];
      $LCase =~ tr/A-Z/a-z/; # This is so lower-case versions always are valid.
      if ($LCase ne $rec[1]) { print OUT "$LCase:$rec[2]\n"; }
      if ($rec[3] >= 50) {
      print OUTA "$rec[1]:$rec[2]\n";
      }
   }
   close (OUT);
   close (OUTA);
   rename("${AUTH_PATH}/${PWFileBase}.${$}","${AUTH_PATH}/${PWFileBase}");
   rename("${AUTH_PATH}/${PWFileBase}admin.${$}","${AUTH_PATH}/${PWFileBase}admin");
   $sth->finish;
}


sub GetUserInfo {
   local ($cmd,$sth,$rv);

   &OpenDB;

   $User = $ENV{'REMOTE_USER'};
   $User =~ tr/A-Z/a-z/;

   if ($User ne "") {

   $cmd = "select id,fname,lname,priv from User where upper(un)=\"${User}\"";
   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @User = $sth->fetchrow_array;
   $sth->finish;

   $User_ID = $User[0];
   $User_FN = $User[1];
   $User_LN = $User[2];
   $User_Priv = $User[3];
   $User_Gst = 0;
   } else {
   $User_ID = 1;
   $User_FN = $LangStr{"INDX008"};
   $User_LN = $LangStr{"INDX009"};
   $User_Gst = 1;
   }
}

sub BuildCatList {
   $cmd = "select id,Name from Category order by in_column,sort_hint";

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

   while (@rec = $sth->fetchrow_array) {
      push(@Cats_ID,$rec[0]);
      push(@Cats,$LangStr{"CATE" . sprintf("%03d", $rec[0])});
   }
}

sub ChanSortStr {
   local ($Sort) = @_;
   local ($S_Str);

   $S_Str = "Title asc";
   if ($Sort == 1) { $S_Str = "Last_Alt asc"; }
   elsif ($Sort == 2) { $S_Str = "Last_Alt desc"; }

   return $S_Str;
}


sub RenderPanel {
   local ($Name,$URL,$PID,$CID,$DMode,$Type,
      $I_S,$I_U,$I_T,
      $I_M,$I_W,$I_H,
      $Sort,$I_L) = @_;
   local ($sth,$rv,@rec,$cnt);
   local ($URL_TS,$URL_TE,$PID_T,$Type_T,$S_Str);

   if ($URL ne "") {
      if (!($URL =~ /^[a-zA-Z]*:/)) { $URL = "http://" . $URL; }
      $URL_TS = "<a href=\"$URL\">";
      $URL_TE = "</a>";
   }

   if ($PID && !$User_Gst) {
      $PID_T = "<a href=\"${CP_URLPath}/p_edit.cgi?${PID}\"><img src=\"/gifs/but-settings.gif\" width=12 height=12 alt=\"".$LangStr{"MYCP005"}."\" border=0></a>";
   }

   if ($Type) {
      $Type_T = "&nbsp;<font size=\"-2\">(<i>".$LangStr{"INDX010"}."</i>)</font>";
   }

   $S_Str = &ChanSortStr($Sort);

   print <<HTML;

<!-- Start of Panel... -->
<table border=0 cellpadding=3 cellspacing=0 width="100%" bgcolor="#A0C0A0">
HTML

   if ($Type == 1) {
      print "<tr><td><font size=\"-1\">&nbsp;<b>" . $LangStr{"INDX002"}
         ." ${User_FN} ${User_LN}</b></font></td></tr><tr><td>";

   open (IN, "${SYSROOT}/cached/${CID}.inc");
   while (<IN>) {
      print "$_";
   }
   close (IN);

   print "</td></tr></table>";
   print "<table border=0 width=\"100%\" height=3><tr><td></td></tr></table>";

   return;
   }

print <<HTML;
<tr><th align="left"><font size="-1">&nbsp;${URL_TS}${Name}${URL_TE}${Type_T}</font></th>
<th align="right" valign="top">${PID_T}&nbsp;</th></tr>
<tr><td colspan=2>
<table bgcolor="white" width="100%" cellpadding=4 cellspacing=0 border=0><tr><td><font size="-1">
HTML

   if ($I_M != 1 && ($I_S ne "" || $I_L ne "")) {
      if ($I_U) { print "<a href=\"${I_U}\">"; }
      if ($I_L ne "") { $IStr ="${I_L}"; } else {
         $IStr ="${I_S}"; }
      print "<img src=\"${IStr}\" alt=\"${I_T}\" border=0 align=\"right\"";
      if ($I_W + 0 != 0 && $I_H + 0 != 0) {
         print " width=\"${I_W}\" height=\"${I_H}\"";
      }
      print ">\n";
      if ($I_U) { print "</a>"; }
   }

   if ($Type >= 10 || $Type == 0) {
      $SLine = "<li>";
      if ($CP_Lynx_Viewer) { print "<ul>"; }
   } else {
      $SLine = "";
   }

   if ($Type) {

      open (IN, "${SYSROOT}/cached/${CID}.inc");
      $cnt = 1;
      while (<IN>) {
         print "${SLine}$_";
         last if ($cnt++ >= 8 && $Type > 9);
      }
      close (IN);

   } else {

   $cmd = "select ID,Title,URL from Item"
." where ID_Channel=${CID} order by $S_Str"
;

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

$Cnt=0;
while (@rec = $sth->fetchrow_array) {
   $URL = $rec[2];
   if (!($URL =~ /^[a-zA-Z]*:/)) { $URL = "http://" . $URL; }
if ($DMode == -1) {
print "<li> <i><font size=\"-2\"><a href=\"${CP_URLPath}/i_edit.cgi?${rec[0]}/${ID}\"> ".$LangStr{"INDX012"}." </a></font></i>";
} else {
print "<li> ";
}
   print "<a href=\"${URL}\">$rec[1]</a>\n";
   $Cnt=1;
}

if (!$Cnt) {
 print "<li> ".$LangStr{"INDX011"};
}

   }

   if (($Type >= 10 || $Type==0) && $CP_Lynx_Viewer) { print "</ul>"; }

print <<HTML;
</font>
</td></tr></table>
</td></tr>
</table>
<table border=0 width="100%" height=3><tr><td></td></tr></table>
<!-- End of Panel -->

HTML

}




sub RenderPanelNew {
   local ($Name,$URL,$PID,$CID,$DMode,$Type,
      $I_S,$I_U,$I_T,
      $I_M,$I_W,$I_H,
      $Sort,$I_L) = @_;
   local ($sth,$rv,@rec,$cnt);
   local ($URL_TS,$URL_TE,$PID_T,$Type_T,$S_Str);

   if ($URL ne "") {
      if (!($URL =~ /^[a-zA-Z]*:/)) { $URL = "http://" . $URL; }
      $URL_TS = "<a href=\"$URL\">";
      $URL_TE = "</a>";
   }

   if ($PID && !$User_Gst) {
      $PID_T = "<a href=\"${CP_URLPath}/p_edit.cgi?${PID}\">".$LangStr{"MYCP005"}."</a>";
   }

   if ($Type) {
      $Type_T = "&nbsp;<font size=\"-2\">(<i>Ext</i>)</font>";
   }

   $S_Str = &ChanSortStr($Sort);

   print <<HTML;
<tr><td>
<table border=0 bgcolor="black" width="100%" cellspacing=0 cellpadding=1>
<tr><td>
<table border=0 bgcolor="#EEEEFF" width="100%" cellspacing=0 cellpadding=1>
HTML

   if ($Type == 1) {
      print "<tr><th align=\"left\"><font size=\"-1\">Hello "
         ."${User_FN} ${User_LN}</font></th></tr><tr><td>";

   open (IN, "${SYSROOT}/cached/${CID}.inc");
   while (<IN>) {
      print "$_";
   }
   close (IN);

   print "</td></tr></table></td></tr></table></td></tr>";

   return;
   }

print <<HTML;
<tr><th align="left"><font size="-1">${URL_TS}${Name}${URL_TE}${Type_T}</font></th>
<th align="right" valign="top">${PID_T}&nbsp;
</th></tr>
<tr><td colspan=2>
<table bgcolor="white" width="100%"><tr><td><font size="-1">
HTML

   if ($I_M != 1 && ($I_S ne "" || $I_L ne "")) {
      if ($I_U) { print "<a href=\"${I_U}\">"; }
      if ($I_L ne "") { $IStr ="${I_L}"; } else {
         $IStr ="${I_S}"; }
      print "<img src=\"${IStr}\" alt=\"${I_T}\" border=0 align=\"right\"";
      if ($I_W + 0 != 0 && $I_H + 0 != 0) {
         print " width=\"${I_W}\" height=\"${I_H}\"";
      }
      print ">\n";
      if ($I_U) { print "</a>"; }
   }

   if ($Type >= 10 || $Type == 0) {
      $SLine = "<li>";
      if ($CP_Lynx_Viewer) { print "<ul>"; }
   } else {
      $SLine = "";
   }

   if ($Type) {

      open (IN, "${SYSROOT}/cached/${CID}.inc");
      $cnt = 1;
      while (<IN>) {
         print "${SLine}$_";
         last if ($cnt++ >= 8 && $Type > 9);
      }
      close (IN);

   } else {

   $cmd = "select ID,Title,URL from Item"
." where ID_Channel=${CID} order by $S_Str"
;

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

$Cnt=0;
while (@rec = $sth->fetchrow_array) {
   $URL = $rec[2];
   if (!($URL =~ /^[a-zA-Z]*:/)) { $URL = "http://" . $URL; }
 print "<li><a href=\"${URL}\">$rec[1]</a>\n";
   $Cnt=1;
}

if (!$Cnt) {
 print "<li>No items in this channel.";
}

   }

   if (($Type >= 10 || $Type==0) && $CP_Lynx_Viewer) { print "</ul>"; }

print <<HTML;
</font>
</td></tr></table>
</td></tr></table>
</td></tr>
</table>
</td></tr>
HTML

}

sub IncludeFile {
   local ($FN) = @_;

   unless (open (IN, $FN)) {return 0};

   while (<IN>) {
      print "$_";
   }
   close (IN);

   return 1;
}


@Admin_Values = (0,10,25,50,75,100);

%Admin_Labels = (0,"Normal User",
10,"Can publish.",
25,"Can import.",
50,"Can moderate.",
75,"Can admin users.",
100,"Super-user."
);

%Admin_Labels_Short = (0,"Nor.",
10,"Pub.",
25,"Imp.",
50,"Mod.",
75,"Admin.",
100,"Super."
);

$Admin_Publisher = 10;
$Admin_Importer = 25;
$Admin_Moderator = 50;
$Admin_UserAdmin = 75;
$Admin_SuperUser = 100;


@Public_Values = (0,1,2);

%Public_Lables = (0, "Private Only",
1, "Make Public",
2, "Public"
);

%Public_Labels_Short = (0, "Priv.",
1, "Req.",
2, "Pub."
);


return 1;
