#!/usr/bin/perl
# Program: WebUtil - A collection of net commands 
# Author: The Puppet Master
# Created: 12/13/1998
# Last Modified: 07/15/2001

$show_hist = "1";          # 0=No | 1=Yes

# $IMGURL is the url where you keep your images.  Please put the directnic.gif
# file within that directory.  Please do not remove the affiliate info for
# DirectNic.  Thank you...

$IMGURL="http://www.domain.com/images/";


# $cgi_url is the location of this script.
$cgi_url = "http://www.domain.com/cgi-bin/webutil.pl";

# $pingnum is the number of packets to send on ping. 
$pingnum = 5;

# $nameserver is the DNS Server to use for NSLookup
$nameserver = "ns1.nationwide.net";


# Done With Configuration.

$version = "2.7";
$history = "webutil.history";

$HOSTNAME=`hostname`;

# Extentions for whois to check...
@EXTENTION=(".com",".net",".org",".tv");

require 'parsform.pl';
require 'formdate.pl';

if ($ENV{'QUERY_STRING'} ne '') {
	$command = "$ENV{'QUERY_STRING'}";
}
else {
	&parse_form;
}


if ($command =~ '&') {
	($command,$domain)=(split(/\&/,$command));
}


print "Content-type: text/html\n\n";

# Ping
if ($command eq 'ping') {
	print "<html><head><title>WebUtil Ping</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Ping</b> A default of $pingnum packets will be sent.\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"ping\">\n";
	print "Domain Name or IP Address: <input type=text name=\"webaddress\" size=\"30\">\n";
	print "<br>\n";
	print "<br>\n";
	print "Number of ping packets: <input type=text name=\"pingnum\" value=\"$pingnum\" size=\"2\">\n";
	print "<p>\n";
	print "<input type=submit value=\" Ping \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "<font size=-1><br>Thanks to <a href=\"http://bocuse.xs4all.nl\">Paul Boot</a> for some very helpful tips.</font>\n";
	print "</body></html>\n";
}

# Traceroute
elsif ($command eq 'traceroute') {
	print "<html><head><title>WebUtil Traceroute</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Traceroute</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"traceroute\">\n";
	print "Nameserver to use: <input type=text name=\"nameserver\" value=\"$nameserver\" size=30><BR>\n";
	print "Domain Name or IP Address: <input type=text name=\"webaddress\" size=\"30\">\n";
	print "<p>\n";
	print "<input type=submit value=\" Traceroute \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "<font size=-1><br>Thanks to <a href=\"http://bocuse.xs4all.nl\">Paul Boot</a> for some very helpful tips.</font>\n";
	print "</body></html>\n";
}
	
# Whois
elsif ($command eq 'whois') {
	print "<html><head><title>WebUtil Whois</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Whois</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"whois\">\n";
	print "www.<input type=text name=\"webaddress\" size=\"63\">\n";
	print "<p>\n";
	print "DO NOT ENTER SUFFIX (\n"; 
	foreach $line(@EXTENTION) {
		print "$line\n";
	}
	print ") as these will be automatically checked for you!<P>\n";
	print "<input type=submit value=\" Whois \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# Finger
elsif ($command eq 'finger') {
	print "<html><head><title>WebUtil Finger</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Finger</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"finger\">\n";
	print "Email Address: <input type=text name=\"emailaddress\" size=\"30\">\n";
	print "<p>\n";
	print "<input type=submit value=\" Finger \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# NSLOOKUP
elsif ($command eq 'nslookup') {
	print "<html><head><title>WebUtil NS-Lookup</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil NS-Lookup</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"nslookup\">\n";
	print "Server To Use: <input type=text name=\"server\" value=\"$nameserver\" size=\"30\"><p>\n";
	print "Example: <i>$nameserver</i><p>\n";
	print "<p>\n";
	print "DNS Query Type:<br><input type=radio name=querytype checked value=\"A\">A (address)<br>\n";
	print "<input type=radio name=querytype value=\"PTR\">PTR (pointer)<br>\n";
	print "<input type=radio name=querytype value=\"NS\">NS (name server)<br>\n";
	print "<input type=radio name=querytype value=\"MX\">MX (mail exchanger)<br>\n";
	print "<input type=radio name=querytype value=\"SOA\">SOA (start of authority)<br>\n";
	print "<input type=radio name=querytype value=\"ANY\">ANY\n";
	print "<p>\n";
	print "DNS Query Input: <input type=text name=\"webaddress\" size=\"30\">\n";
	print "<p>\n";
	print "For A and PTR records, use IP ADDRESS,<br>for all others, use DOMAIN NAME<P>\n";
	print "<input type=submit value=\" NSLOOKUP \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# HOST
elsif ($command eq 'host') {
	print "<html><head><title>WebUtil Host</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Host</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"host\">\n";
	print "Domain Name: <input type=text name=\"webaddress\" size=\"30\">\n";
	print "<p>\n";
	print "<input type=submit value=\" HOST \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# DNSQuery
elsif ($command eq 'dnsquery') {
	print "<html><head><title>WebUtil DNS-Query</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil DNS-Query</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"dnsquery\">\n";
	print "Domain Name: <input type=text name=\"webaddress\" size=\"30\">\n";
	print "<p>\n";
	print "<input type=submit value=\" DNSQuery \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# DIG
elsif ($command eq 'dig') {
	print "<html><head><title>WebUtil Dig (Domain Information Groper)</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Dig (Domain Information Groper)</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"dig\">\n";
	print "Domain Name: <input type=text name=\"webaddress\" size=\"30\">\n";
	print "<p>\n";
	print "<input type=submit value=\" DIG \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# Calendar
elsif ($command eq 'calendar') {
	$dmonthformat="<m>";
	$yearformat="<year>";
	$dmonth = &format_date(time,$dmonthformat);
	$year = &format_date(time,$yearformat);
	print "<html><head><title>WebUtil Calendar</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Calendar</b>\n";
	print "<form method=\"POST\" action=\"$cgi_url\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"calendar\">\n";
	print "Month (1-12 or blank for entire year): <input type=text name=\"month\" value=\"$dmonth\" size=\"2\">\n";
	print "Year (4 digits): <input type=text name=\"year\" value=\"$year\" size=\"4\">\n";
	print "<p>\n";
	print "Example: <i>$dmonth $year</i><p>\n";
	print "<input type=submit value=\" Calendar \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}	

# The Ping Routine
elsif ($FORM{'action'} eq 'ping') {
   &data_entry unless $FORM{'webaddress'};

   #Some sanity check on number of pings
   if ( $FORM{'pingnum'} < 1 ) {
		$pingnum=1;
   }
   elsif ( $FORM{'pingnum'} > 20 ) {
		$pingnum=20;
   }
   else {
		$pingnum = $FORM{'pingnum'};
   }

	# Turn off buffering
	$| = 1;

   print "<html><head><title>WebUtil Ping</title></head>\n";
   print "<body>\n";
   print "<b>WebUtil Real-Time Ping</b><p>\n";
   print "<br>\n";
   print "<b>Executed Command:</b>\n";
   print "<pre>ping -c$pingnum $FORM{'webaddress'}</pre>";
   print "<p>\n";
   print "<b>Pinging $FORM{'webaddress'}...</b><p>\n";
   print "<pre>\n";
   system ("ping -c$pingnum $FORM{'webaddress'}");
   print "</pre>\n";
   print "<p><b>Done!</b>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
   print "</body></html>\n";
}

# The Traceroute Routine
elsif ($FORM{'action'} eq 'traceroute') {
	&data_entry unless $FORM{'webaddress'};

	# Turn off buffering
	$| = 1;

	print "<html><head><title>WebUtil Traceroute</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Real-Time Traceroute</b>\n";
   print "<br>\n";
   print "<b>Executed Command:</b>\n";
   print "<pre>traceroute $FORM{'webaddress'} $nameserver</pre>";
	print "<p><b>\n";
	print "Traceroute Results For: $FORM{'webaddress'}</b><p>\n";
   print "<pre>\n";
   system ("traceroute $FORM{'webaddress'} $nameserver");
   print "</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The Whois Routine
elsif ($FORM{'action'} eq 'whois') {
	&data_entry unless $FORM{'webaddress'};
	$webaddress=$FORM{'webaddress'};
	if ($webaddress =~ /\./) {
		&no_suffix;
	}
	$x = 1;
	foreach $line(@EXTENTION) {
		$address=$webaddress.$line;
		$whois = `whois -h whois.opensrs.net $address`;
			
		$add[$x]=substr($whois,1,12);
		if ($add[$x] eq "No match for") {
			$whois[$x]="<td align=center>$address</td><td align=center>AVAILABLE</td><td align=center><a href=\"$cgi_url?register&$address\">REGISTER IT!</A></td>";
		}
		else {
			$whois[$x]="<td align=center>$address</td><td align=center><font color=\"RED\">UNAVAILABLE</font></td><td align=center><a href=\"$cgi_url?details&$address\">DETAILS</A></td>";
		}
		$x++;
	}

	print "<html><head><title>WebUtil Whois</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Whois</b>\n";
	print "<p><b>\n";
	print "Whois Results For: $webaddress</b><p>\n";
	$y = 1;
	print "<table border=1>\n";
	print "<TH>DOMAIN</TH><TH>STATUS</TH><TH>ACTION</TH>\n";
	print "<TR>\n";
	while ($y < $x) {
		print "<TR>$whois[$y]</TR>\n";
		$y++;
	}
	print "</TABLE>\n";
	print "<P>You can also <a href=\"http://www.directnic.com\">pre-register</a> .biz and .info top level domains.\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The Finger Routine
elsif ($FORM{'action'} eq 'finger') {
	&data_entry unless $FORM{'emailaddress'};
	$finger = `finger $FORM{'emailaddress'}`;
	print "<html><head><title>WebUtil Finger</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Finger</b>\n";
	print "<p><b>\n";
	print "Finger Results For: $FORM{'emailaddress'}</b><p>\n";
	print "<pre>$finger</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The NS-Lookup Routine
elsif ($FORM{'action'} eq 'nslookup') {
	&data_entry unless $FORM{'webaddress'};
	$nslookup = `nslookup -type=$FORM{'querytype'} $FORM{'webaddress'} $FORM{'server'}`;
	$executed="nslookup -type=$FORM{'querytype'} $FORM{'webaddress'} $FORM{'server'}";
	print "<html><head><title>WebUtil NS-Lookup</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil NS-Lookup</b>\n";
	print "<p>\n";
	print "<B>Executed Command:</B><P>$executed\n";
	print "<p><b>\n";
	print "NS-Lookup Results For: $FORM{'webaddress'}</b><p>\n";
	print "<pre>$nslookup</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The Host Routine
elsif ($FORM{'action'} eq 'host') {
	&data_entry unless $FORM{'webaddress'};
	$host = `host -v $FORM{'webaddress'}`;
	print "<html><head><title>WebUtil Host</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Host</b>\n";
	print "<p><b>\n";
	print "Host Results For: $FORM{'webaddress'}</b><p>\n";
	print "<pre>$host</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The DNSQuery Routine
elsif ($FORM{'action'} eq 'dnsquery') {
	&data_entry unless $FORM{'webaddress'};
	$dnsquery = `dnsquery -v $FORM{'webaddress'}`;
	print "<html><head><title>WebUtil DNSQuery</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil DNSQuery</b>\n";
	print "<p><b>\n";
	print "DNSQuery Results For: $FORM{'webaddress'}</b><p>\n";
	print "<pre>$dnsquery</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The DIG Routine
elsif ($FORM{'action'} eq 'dig') {
	&data_entry unless $FORM{'webaddress'};
	$dig = `dig $FORM{'webaddress'}`;
	print "<html><head><title>WebUtil Dig (Domain Information Groper)</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Dig (Domain Information Groper)</b>\n";
	print "<p><b>\n";
	print "Dig Results For: $FORM{'webaddress'}</b><p>\n";
	print "<pre>$dig</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The Calendar Routine
elsif ($FORM{'action'} eq 'calendar') {
	&data_entry unless $FORM{'year'};
	$calendar = `cal $FORM{'month'} $FORM{'year'}`;
	print "<html><head><title>WebUtil Calendar</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Calendar\n";
	print "<p>\n";
	print "Calendar Results</b><p>\n";
	print "<pre>$calendar</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The uptime routine
elsif ($command eq 'uptime') {
	$uptime = `uptime`;
	($a,$b,$c,$d,$e,$f,$g,$h,$i,$j,$k,$l)=(split(/\s+/,$uptime));
	if ($a eq "") {
		($z,$a,$b,$c,$d,$e,$f,$g,$h,$i,$j,$k,$l)=(split(/\s+/,$uptime));
	}
	$j =~ (s/\,//);
	$k =~ (s/\,//);
	($hours,$minutes)=(split(/\:/,$e));
	$minutes=substr($minutes,0,2);

	print "<html><head><title>WebUtil Uptime</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Uptime\n";
	print "<p>\n";
	print "Uptime Results</b><p>\n";
	if ($HOSTNAME eq "") {
		print "This system has been up $c $d $hours Hour(s) and $minutes Minute(s).<br>\n";
	}
	else {
		print "<B>$HOSTNAME</B> has been up $c $d $hours Hour(s) and $minutes Minute(s).<br>\n";
	}
	$IS_ARE="Are";
	if ($f == 1) {
	   $IS_ARE="Is";
	}
	print "There $IS_ARE $f User(s) Online.<br>\n";
	print "The Current Time Is: $a.<br>\n";
	print "Load Averages:<p>\n";
	print "<UL>\n";
	print "<li>15 Minutes Ago: $j</li>\n";
	print "<li>10 Minutes Ago: $k</li>\n";
	print "<li> 5 Minutes Ago: $l</li>\n";
	print "</ul>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

elsif ($command eq 'details') {
	$whois = `whois -h whois.networksolutions.com $domain`;
	$executed = "whois -h whois.networksolutions.com $domain";
		
	print "<html><head><title>WebUtil Whois</title></head>\n";
	print "<body>\n";
	print "<b>WebUtil Whois</b>\n";
	print "<p>\n";
	print "Executed Command: $executed<p>\n";
	print "Whois Results For $domain</b><p>\n";
	print "<pre>$whois</pre>\n";
	print "<p>Done!\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}
	
elsif ($command eq 'register') {
	$REGIMG="<img src=\"$IMGURL/directnic.gif\" border=0 align=middle>";
	###########################################################################
	# This script is free... But it would be nice to recoupe some of the time #
	# that it took in developing it.  Therefore, when someone uses the whois  #
	# lookup (via webutil) on your page, and decides to register a domain, I  #
	# will get a referral fee.                                                # 
	# So I'm asking you ... PLEASE DO NOT REMOVE THE AFFILIATE INFO BELOW!!!  # 
	###########################################################################
	print "<html><head><title>WebUtil Register</title></head>\n";
	print "<body>\n";
	print "<center><h2>$REGIMG</h2></center>\n";
	print "<form method=\"POST\" action=\"http://www.directnic.com/search/index.cgi\">\n";
	print "<input type=hidden name=function value=\"search_domains\">\n";
	print "<input type=hidden name=affiliate value=\"2928\">\n";
	print "<input type=text name=\"q\" value=\"$domain\" size=25 maxlength=64>\n";
	print "<p>\n";
	print "<input type=submit value=\" Check It \"> <input type=reset>\n";
	print "</form>\n";
	print "<p><a href=\"$cgi_url\">RETURN TO MAIN MENU</a>\n";
	print "</body></html>\n";
}

# The Main Menu!
else {
	print "<html><head><title>WebUtil</title></head>\n";
	print "<body><center><h1>WebUtil Version: $version</h1>\n";
	if ($show_hist eq "1") {
		print "<font size=-1><a href=\"$history\">View History</a></font><p>\n";
	}
	print "<h6>By The Puppet Master</h6>\n";
	print "<h3>Make Your Choice Below</h3></center>\n";
	print "<hr><center>\n";
	print "<table border=0 width=600>\n";
	print "<tr><td align=center>\n";
	print "Note: Depending on present net traffic and the speed of your link,\n";
	print "<br>Some of these commands may take a long time.  Patience is\n";
	print "a virtue.\n";
	print "</td></tr></table>\n";
	print "<table border=0 width=150>\n";
	print "<tr><td>\n";
	print "<ul>\n";
	print "<li><a href=\"$cgi_url?ping\">ping</a></li>\n";
	print "<li><a href=\"$cgi_url?traceroute\">traceroute</a></li>\n";
	print "<li><a href=\"$cgi_url?whois\">whois</a></li>\n";
	print "<li><a href=\"$cgi_url?finger\">finger</a></li>\n";
	print "<li><a href=\"$cgi_url?nslookup\">nslookup</a></li>\n";
	print "<li><a href=\"$cgi_url?host\">host</a></li>\n";
	print "<li><a href=\"$cgi_url?dnsquery\">dnsquery</a></li>\n";
	print "<li><a href=\"$cgi_url?dig\">dig</a></li>\n";
	print "<li><a href=\"$cgi_url?calendar\">calendar</a></li>\n";
	print "<li><a href=\"$cgi_url?uptime\">uptime</a></li>\n";
	print "</ul>\n";
	print "</td></tr></table>\n";
	print "<p>\n";
	print "<font size=\"-1\">WebUtil \&copy; Copyright 1998-2001 <a href=\"http://www.ravensclaw.com/~pmaster/perl/\">The Puppet Master</a><br>\n";
	print "Parsform.pl Is \&copy; Copyright <a href=\"http://www.cgi-perl.com\">The CGI/Perl Cookbook</a><br>by Matt Wright \&amp; Craig Patchett\n";
	print "</font></center>\n";
	print "</body></html>\n";
}

# Missing Fields
sub data_entry {
	print "<html><head><title>Data Entry Error</title></head>\n";
	print "<body><center><h1>Data Entry Error</h1>\n";
	print "You didn't enter the data you were looking for!\n";
	print "<p>Use your Browsers back button to try again.\n";
	print "</body></html>\n";
	exit;
}
	
sub no_suffix {
	print "<html><head><title>Data Entry Error</title></head>\n";
	print "<body><center><h1>Data Entry Error</h1>\n";
	print "<font size=+2>DO NOT ENTER SUFFIX (\n"; 
	foreach $line(@EXTENTION) {
		print "$line\n";
	}
	print ")</font><P>\n";
	print
	print "<p>Use your Browsers back button to try again.\n";
	print "</body></html>\n";
	exit;
}
	
# END OF WEBUTIL
