#!/usr/bin/perl
##############################################################################
# WebSupport                        Version 1.0                              #
# Copyright 1999-2002 DHWW.org      websupport@dhww.org                      #
# WebSupport site:                  http://websupport.sourceforge.net        #
##############################################################################

require '/home/dhwworg/public_html/cgi-bin/ws/ws.conf';
require '/home/dhwworg/public_html/cgi-bin/ws/ws-lib.pl';

use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser carpout);

############### MAIN PROGRAM ###############################
############################################################

my $script_url = url();
my $form = path_info();
$form =~ s!^/!!;

if (!$form) {
	show_request_form();
}

elsif ($form eq 'new') {
	my $name = param('name');
	my $username = param('username');
	my $domain = param('domain');
	my $email = param('email');
	my $problem = param('problem');
	my $priority = param('priority');

	check_url();

	# Clean problem field
	$problem =~ s/\cM//g;
	$problem =~ s/\n/ /g;

	check_fields($name,$username,$domain,$email,$problem);

	my $date = get_date();				# Get date
	my $ticket = assign_ticket();		# Get ticket number
	
	write_database($ticket,$date,$name,$username,$domain,$email,$problem,$priority);
	email_ticket($ticket,$name,$email);

	if ($notify) {
		email_me($ticket,$name,$username,$domain,$email,$problem,$priority);
	}

	print_details($ticket,$name,$username,$domain,$email,$problem,$priority);

}

elsif ($form eq 'view') {
	show_status_form()
}

elsif ($form eq 'show') {
	my $ticket = param('ticket');
	my $username = param('username');

	check_ticket($ticket,$username);
}

else {
	error_page("<li>Illegal calling of script.");
}

############### FUNCTIONS AND SUBROUTINES ##################
############################################################

sub show_request_form {
	my $nr;

	open (NEW_REQUEST, "$new_request_tpl") || error_page("<li>Can't find template file");
	&lock_file(*NEW_REQUEST);
	while (<NEW_REQUEST>) {
			$nr .= $_;
	}
	close (NEW_REQUEST);

	$nr =~ s/\[SCRIPT_URL\]/$script_url/egs;
	$nr =~ s/\[VERSION NUMBER\]/$version_no/egs;

	print "Content-type: text/html\n\n";
	print "$nr";
	exit(0);
}

sub check_fields {
	my ($errmsg,$message,$errmsg);
	my $name = shift;
	my $username = shift;
	my $domain = shift;
	my $email = shift;
	my $problem = shift;
	
	$errmsg = "<li>Your name seems to be missing.\n";
		if ($name eq "") {
			$message = $message.$errmsg;
			$found_err = 1;
		}
	$errmsg = "<li>Please enter a valid email address.\n";
		if ($email !~ /^[\w\-\.\!\%\+\/]+\@[a-zA-z0-9\-]+(\.[a-zA-Z0-9\-]+)*\.[a-zA-Z0-9\-]+$/) {
			$message = $message.$errmsg;
			$found_err = 1; 
		}
	$errmsg = "<li>Your username seems to be missing.\n";
		if ($username eq "") {
			$message = $message.$errmsg;
			$found_err = 1; 
		}
	$errmsg = "<li>Your domain name seems to be missing.\n";
		if ($domain eq "") {
			$message = $message.$errmsg;
			$found_err = 1; 
		}
	$errmsg = "<li>Where's your problem?\n";
		if ($problem eq "") {
			$message = $message.$errmsg;
			$found_err = 1; 
		}
	if ($found_err) {
		error_page($message); 
	}
}

sub get_date {
    @days   = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
    @months = ('January','February','March','April','May','June','July','August','September','October','November','December');
    ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
    $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
    $year += 1900;

    my $date = "$days[$wday], $months[$mon] $mday at $time";
	return $date;
}

sub assign_ticket {
	my $ticket;

	if (-e "$countdb") {
		open (NUMBER,"$countdb") || error_page("<li>Can't open $countdb");
		&lock_file(*NUMBER);
		$ticket = <NUMBER>;
		close(NUMBER);

		open (NUM,">$countdb") || error_page("<li>Can't write to $countdb");
		&lock_file(*NUM);
		$ticket++;
		print NUM "$ticket";
		close(NUM);
	} else {
		error_page("<li>Count file missing. Please inform the site administrator");
	}

	return $ticket;
}

sub write_database {
	my $ticket = shift;
	my $date = shift;
	my $name = shift;
	my $username = shift;
	my $domain = shift;
	my $email = shift;
	my $problem = shift;
	my $priority = shift;

	if (-e "$maindb") {
		open (DFILE, ">>$maindb") || error_page("<li>Can't append to $maindb");
		&lock_file(*DFILE);
		print DFILE "$ticket|$date|$name|$username|$domain|$email|$problem|$priority||0\n";
		close(DFILE);
	} else {
		error_page("<li>Main database is missing. Please inform the site administrator");
	}
}

sub email_ticket {
	my $tp;
	my $ticket = shift;
	my $name = shift;
	my $email = shift;

	if (-e "$email_tpl") {
		open(TEMPLATE, "$email_tpl") || &error_page("<li>Can't open email message template.");
		&lock_file(*TEMPLATE);
		while (<TEMPLATE>) {
			$tp .= $_;
		}
		close(TEMPLATE);
		
		$tp =~ s/\[TICKET\]/$ticket/egs;
		$tp =~ s/\[NAME\]/$name/egs;
		$tp =~ s/\[EMAIL\]/$email/egs;
		$tp =~ s/\[SCRIPT_URL\]/$script_url/egs;
		
		open(MAIL, "|$mailprog -t") || error_page("<li>Can't find sendmail program");
		print MAIL "$tp";
		close(MAIL);
	} else {
		error_page("<li>Can't find the email message template");
	}
}

sub email_me {
	my $ticket = shift;
	my $name = shift;
	my $username = shift;
	my $domain = shift;
	my $email = shift;
	my $problem = shift;
	my $priority = shift;

	open (MAIL,"|$mailprog -t") || error_page("<li>Can't find sendmail program");
	print MAIL <<"HERE";
To: $notifywho
From: $name <$email>
Subject: New Support Request ID $ticket

There is a new request for support.
The following information was submitted:

Ticket number: $ticket
Name: $name
Email: $email
Username: $username
Domain: $domain
Problem: $problem
Priority: $priority

HERE
	close (MAIL);
}

sub print_details {
	my $template;
	my $ticket = shift;
	my $name = shift;
	my $username = shift;
	my $domain = shift;
	my $email = shift;
	my $problem = shift;
	my $priority = shift;

	open (TEMPLATE, "$request_details_tpl") || error_page("<li>Can't open template file");
	&lock_file(*TEMPLATE);
	while (<TEMPLATE>) {
			$template .= $_;
	}
	close (TEMPLATE);

	$template =~ s/\[VERSION NUMBER\]/$version_no/egs;
	$template =~ s/\[SCRIPT_URL\]/$script_url/egs;

	$template =~ s/\[TICKET\]/$ticket/egs;
	$template =~ s/\[NAME\]/$name/egs;
	$template =~ s/\[USERNAME\]/$username/egs;
	$template =~ s/\[DOMAIN\]/$domain/egs;
	$template =~ s/\[EMAIL\]/$email/egs;
	$template =~ s/\[PROBLEM\]/$problem/egs;
	$template =~ s/\[PRIORITY\]/$priority/egs;

	print "Content-type: text/html\n\n";
	print "$template";
	exit(0);
}

sub show_status_form {
	my $ss;

	open (STATUS, "$view_status_tpl") || error_page("<li>Can't find template file");
	&lock_file(*STATUS);
	while (<STATUS>) {
			$ss .= $_;
	}
	close (STATUS);

	$ss =~ s/\[VERSION NUMBER\]/$version_no/egs;
	$ss =~ s/\[SCRIPT_URL\]/$script_url/egs;

	print "Content-type: text/html\n\n";
	print "$ss";
	exit(0);
}

sub check_ticket {
	my (@all,$found,$line,$template,$ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status);
	my $t = shift;
	my $u = shift;
	
	$found = 0;		# Initialize boolean variable

	if (-e "$maindb") {
		open (DATA, "$maindb") || error_page("<li>Can't open $maindb");
		&lock_file(*DATA);
		while(<DATA>) {
			@all = split(/\n/);
			foreach $line (@all) {
				($ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status) = split(/\|/, $line);
				if ($ticket eq "$t" && $username eq "$u") {
					$found = 1;

					# Make status readable
					if ($status eq "0") { $status = "New" }
					if ($status eq "1") { $status = "Assigned" }
					if ($status eq "2") { $status = "Completed" }

					# Show ticket details
					open (TEMPLATE, "$ticket_view_tpl") || error_page("<li>Can't open template file");
					&lock_file(*TEMPLATE);
					while (<TEMPLATE>) {
							$template .= $_;
					}
					close (TEMPLATE);

					$template =~ s/\[VERSION NUMBER\]/$version_no/egs;

					$template =~ s/\[DATE\]/$date/egs;
					$template =~ s/\[STATUS\]/$status/egs;
					$template =~ s/\[TICKET\]/$ticket/egs;
					$template =~ s/\[NAME\]/$name/egs;
					$template =~ s/\[USERNAME\]/$username/egs;
					$template =~ s/\[DOMAIN\]/$domain/egs;
					$template =~ s/\[EMAIL\]/$email/egs;
					$template =~ s/\[PROBLEM\]/$problem/egs;
					$template =~ s/\[SOLUTION\]/$solution/egs;
					$template =~ s/\[PRIORITY\]/$priority/egs;

					print "Content-type: text/html\n\n";
					print "$template";
					exit(0);
				}
			}
		}
	} else {
		error_page("<li>Main database cannot be found");
	}
	close(DATA);

	if (!$found) {
		error_page("<li>Wrong combination of ticket number and username")
	}
}