#!/usr/bin/perl
##############################################################################
# WebSupport                        Version 1.0                              #
# Copyright 1999-2002 DHWW.org      websupport@dhww.org                      #
# WebSupport site:                  http://websupport.sourceforge.net        #
##############################################################################

require '/home/dhwworg/public_html/cgi-bin/ws/ws.conf';
require '/home/dhwworg/public_html/cgi-bin/ws/ws-lib.pl';

use CGI qw/:standard/;

############### MAIN PROGRAM ###############################
############################################################

my $script_url = url();
my $action = path_info();
$action =~ s!^/!!;

if (!$action) {
	show_requests($action);
}

elsif ($action eq 'full') {
	show_requests($action);
}

elsif ($action eq 'edit') {
	my $ticket = param('id');
	
	check_url();
	show_ticket_screen($ticket);
}

elsif ($action eq 'update') {
	my $ticket = param('id');
	my $solution = param('solution');
	my $nstatus = param('nstatus');

	check_url();

	# Clean solution field
	$solution =~ s/\cM//g;
	$solution =~ s/\n/ /g;

	write_to_database($ticket,$solution,$nstatus);
	redirect_back();
}

elsif ($action eq 'email') {
	my $ticket = param('id');

	check_url();
	show_email_form($ticket);
}

elsif ($action eq 'send') {
	my $to = param('to');
	my $from = param('from');
	my $subject = param('subject');
	my $message = param('message');

	check_url();
	send_email($to,$from,$subject,$message);
	redirect_back();
}

else {
	error_page("<li>Illegal calling of script");
}

############### FUNCTIONS AND SUBROUTINES ##################
############################################################

sub show_requests {
	my $action = shift;
	my (@all,$found,$line,$ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status);
	
	print "Content-type: text/html\n\n";
	print <<"(HEADER)";
<html>
<head>
<title>WebSupport Admin - View Requests</title>
</head>
<body bgcolor="#ffffff" text="#000000" link="#ffffff" vlink="#ffffff" alink="#ffffff">

<center>
<table border=0 cellpadding=0 cellspacing=0 width="100%">

<tr>
<td align=center bgcolor="#001549"><font face="arial,verdana" size="3" color="#ffffff"><b>WebSupport Administration - View Requests</b></font></td>
</tr>

<tr><td bgcolor="#b9cefc">
<br>
<table align=center border="1" bgcolor="f4f4f4">
<tr>
<td><font face="arial" size=2 color="000090"><b>TICKET</b></font></td>
<td><font face="arial" size=2 color="000090"><b>STATUS</b></font></td>
<td><font face="arial" size=2 color="000090"><b>DETAILS</b></font></td>
<td><font face="arial" size=2 color="000090"><b>ACTIONS</b></font></td> 
</tr>
(HEADER)

	if (-e "$maindb") {
		open (DATA, "$maindb") || error_page("<li>Can't open $maindb");
		while(<DATA>) {
			@all = split(/\n/);
			foreach $line (@all) {
				($ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status) = split(/\|/, $line);
				
				$status = "$status";
				if ($status eq "0") { $status = "New"; }
				if ($status eq "1") { $status = "Assigned"; }
				if ($status eq "2") { $status = "Completed";}

				if ($action eq 'full') {
					print "<tr>\n"; 
					print "<td align=center><font face=\"arial\" size=2>$ticket</font></td>\n";
					print "<td align=center><font face=\"arial\" size=2>\n";
					print uc($status) . " / " . uc($priority) . "<br></font></td>\n";
					print "<td><font face=\"arial\" size=2>$problem<br>\n";
					print "<font face=\"arial\" size=1 color=\"000090\">Submitted by <b>$name</b><br>\n";
					print "on <b>$date</b></font></font></td>\n";
					print "<td align=center><font face=\"arial\" size=2><form method=post action=\"$script_url/edit\"><input type=\"hidden\" name=\"id\" value=\"$ticket\"><input type=\"submit\" value=\"EDIT\"></form><form method=post action=\"$script_url/email\"><input type=\"hidden\" name=\"id\" value=\"$ticket\"><input type=\"submit\" value=\"EMAIL\"></form></font></td>\n";
					print "</tr>\n";
				} else {
					if ($status ne "Completed") {
						print "<tr>\n"; 
						print "<td align=center><font face=\"arial\" size=2>$ticket</font></td>";
						print "<td align=center><font face=\"arial\" size=2>\n";
						print uc($status) . " / " . uc($priority) . "<br></font></td>\n";
						print "<td><font face=\"arial\" size=2>$problem<br>\n";
						print "<font face=\"arial\" size=1 color=\"000090\">Submitted by <b>$name</b><br>\n";
						print "on <b>$date</b></font></font></td>\n";
						print "<td align=center><font face=\"arial\" size=2><form method=post action=\"$script_url/edit\"><input type=\"hidden\" name=\"id\" value=\"$ticket\"><input type=\"submit\" value=\"EDIT\"></form><form method=post action=\"$script_url/email\"><input type=\"hidden\" name=\"id\" value=\"$ticket\"><input type=\"submit\" value=\"EMAIL\"></form></font></td>\n";
						print "</tr>\n";
					}
				}
			}
		}
		close(DATA);
	}

	print <<"(FOOTER)";
</table></td></tr>
<tr>
<td align=right bgcolor="#001549"><font face="arial,verdana" size=1 color="#ffffff">Powered by <a href="http://websupport.sourceforge.net/">WebSupport v$version_no</a>&nbsp;</font></td>
</tr>

</table>
</center>

</body>
</html>
(FOOTER)
	exit(0);
}

sub show_ticket_screen {
	my $id = shift;
	my (@all,$found,$line,$ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status);
	
	print "Content-type: text/html\n\n";
	print <<"(HEADER)";
<html>
<head>
<title>WebSupport Admin - Update Ticket ID $id</title>
</head>
<body bgcolor="#ffffff" text="#000000" link="#ffffff" vlink="#ffffff" alink="#ffffff">

<center>
<table border=0 cellpadding=0 cellspacing=0 width="500">

<tr>
<td align=center bgcolor="#001549"><font face="arial,verdana" size="3" color="#ffffff"><b>WebSupport Administration - Update Ticket ID $id</b></font></td>
</tr>

<tr><td bgcolor="#b9cefc">
<br>
<blockquote>
<font face="arial" size=2>
<p>
(HEADER)

	if (-e "$maindb") {
		open (DATA, "$maindb") || error_page("<li>Can't open $maindb");
		&lock_file(*DATA);
		while(<DATA>) {
			@all = split(/\n/);
			foreach $line (@all) {
				($ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status) = split(/\|/, $line);
				if ($ticket eq "$id") {
					$status = "$status";
					if ($status eq "0") { $status = "New"; }
					if ($status eq "1") { $status = "Assigned"; }
					if ($status eq "2") { $status = "Completed"; }

					print "<b>Date submitted</b>: $date<br>\n";
					print "<b>Current Status</b>: $status<br>\n";
					print "<b>Priority</b>: $priority<br>\n";
					print "<b>Name</b>: $name<br>\n";
					print "<b>Email Address</b>: $email<br>\n";
					print "<b>Username</b>: $username<br>\n";
					print "<b>Domain name</b>: $domain<br><br>\n";
					print "<form method=post action=\"$script_url/update\">\n";
					print "<b>The problem</b>:<br>\n";
					print "<center><textarea rows=5 name=\"problem\" cols=\"45\">$problem</textarea></center>\n";
					print "<br><hr><br>\n";
					print "<b>Steps taken</b>:<br>\n";
					print "<center><textarea rows=5 name=\"solution\" cols=\"45\">$solution</textarea></center><br>\n";
					print "<b>New Status</b>:<br>\n";
					print "<select name=\"nstatus\">\n";
					print "<option value=\"1\">Assigned\n";
					print "<option value=\"2\">Completed\n";
					print "</select><br><br>\n";
					print "<input type=\"hidden\" name=\"id\" value=\"$id\">\n";
					print "<input type=\"submit\" value=\"Save Changes\">\n";
					print "</form>\n";
					print "</font>\n";
					print "</blockquote>\n";
					print "</td></tr>\n";
				}
			}
		}
	}
	close(DATA);

	print <<"(FOOTER)";
<tr>
<td align=right bgcolor="#001549"><font face="arial,verdana" size=1 color="#ffffff">Powered by <a href="http://websupport.sourceforge.net/">WebSupport v$version_no</a>&nbsp;</font></td>
</tr>

</table>
</center>

</body>
</html>
(FOOTER)

	exit(0);
}

sub write_to_database {
	my (@lines,$line,$ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status);
	my $id = shift;
	my $nsolution = shift;
	my $nstatus = shift;

	if (-e "$maindb") {
		# Get data from database
		open (OLDFILE,"$maindb") || error_page("<li>Can't read from $maindb");
		&lock_file(*OLDFILE);
		@lines = <OLDFILE>;
		close(OLDFILE);
		
		# Overwrite data in database
		open(NEWFILE,">$maindb") || error_page("<li>Can't write to $maindb");
		&lock_file(*NEWFILE);
		foreach $line (@lines) {
			($ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status) = split (/\|/, $line);
			if ($ticket eq "$id") {
				print NEWFILE "$ticket|$date|$name|$username|$domain|$email|$problem|$priority|$nsolution|$nstatus\n";
				if ($nstatus eq "2") {
					inform_user($ticket,$name,$email);
				}	
			} else {
				print NEWFILE $line;
			}
		}
		close(NEWFILE);
	} else {
		error_page("<li>Main database cannot be found");
	}
}

sub inform_user {
	my $tp;
	my $ticket = shift;
	my $name = shift;
	my $email = shift;

	if (-e "$notify_tpl") {
		open(TEMPLATE, "$notify_tpl") || &error_page("<li>Can't open email message template.");
		&lock_file(*TEMPLATE);
		while (<TEMPLATE>) {
			$tp .= $_;
		}
		close(TEMPLATE);
		
		$tp =~ s/\[TICKET\]/$ticket/egs;
		$tp =~ s/\[NAME\]/$name/egs;
		$tp =~ s/\[EMAIL\]/$email/egs;
		$tp =~ s/\[SCRIPT_URL\]/$script_url/egs;
		
		open(MAIL, "|$mailprog -t") || error_page("<li>Can't find sendmail program");
		print MAIL "$tp";
		close(MAIL);
	} else {
		error_page("<li>Can't find the email message template");
	}
}

sub show_email_form {
	my $id = shift;
	my (@all,$found,$line,$ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status);
	
	if (-e "$maindb") {
		open (DATA, "$maindb") || error_page("<li>Can't open $maindb");
		&lock_file(*DATA);
		while(<DATA>) {
			@all = split(/\n/);
			foreach $line (@all) {
				($ticket,$date,$name,$username,$domain,$email,$problem,$priority,$solution,$status) = split(/\|/, $line);
				if ($ticket eq "$id") {
					print "Content-type: text/html\n\n";
					print <<"(EMAIL SCREEN)";
<html>
<head>
<title>WebSupport Admin - Email User for Ticket ID $id</title>
</head>
<body bgcolor="#ffffff" text="#000000" link="#ffffff" vlink="#ffffff" alink="#ffffff">

<center>
<table border=0 cellpadding=0 cellspacing=0 width="500">

<tr>
<td align=center bgcolor="#001549"><font face="arial,verdana" size="3" color="#ffffff"><b>WebSupport Administration - Email User for Ticket ID $id</b></font></td>
</tr>

<tr><td bgcolor="#b9cefc">
<br>
<blockquote>
<font face="arial" size=2>
<form method=post action="$script_url/send">
<table cellpadding=0 cellspacing=0 width="100%">
<tr>
<td valign=top>To:</td>
<td valign=top><input type="text" size="30" name="to" value="$email"></td>
</tr>
<tr>
<td valign=top>From:</td>
<td valign=top><input type="text" size="30" name="from" value="$notifywho"></td>
</tr>
<tr>
<td valign=top>Subject:</td>
<td valign=top><input type="text" size="30" name="subject" value="RE: Support Request ID $id"></td>
</tr>
<tr>
<td valign=top>Message:</td>
<td valign=top><textarea rows="10" name="message" cols="40"></textarea></td>
</tr>
<tr>
<td valign=top></td>
</tr>
<tr>
<td valign=top></td>
<td valign=top><input type="submit" value="Send Message"></td>			
</tr>
</table>
</form>
</font>
</blockquote>
</td></tr>

<tr>
<td align=right bgcolor="#001549"><font face="arial,verdana" size=1 color="#ffffff">Powered by <a href="http://websupport.sourceforge.net">WebSupport v$version_no</a>&nbsp;</font></td>
</tr>

</table>
</center>

</body>
</html>
(EMAIL SCREEN)
				}
			}
		}
		close(DATA);
	}

	exit(0);
}

sub send_email {
	my $to = shift;
	my $from = shift;
	my $subject = shift;
	my $message = shift;

	open (MAIL,"|$mailprog -t") || error_page("<li>Can't find sendmail program");
	print MAIL <<"HERE";
To: $to
From: $from
Subject: $subject

$message

HERE
	close (MAIL);
}

sub redirect_back {
	print ("Location: $script_url\n\n");
	exit(0);
}