#!/usr/bin/perl
#
# dclinks98admin.cgi
# Written By David S. Choi, dc@sitedeveloper.com
# 5 Feb 1998
#
##########  YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT ###############
# Copyright  1997 DCScripts All Rights Reserved
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCGUEST97.
# You should carefully read the following terms and conditions before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
#
# Versions of the Software 
# You may install as many copies of DCGUEST97 Script.
# 
# License to Redistribute
# Distributing the software and/or documentation with other products
# (commercial or otherwise) or by other than electronic means without
# DCScripts's prior written permission is forbidden.
# All rights to the DCGUEST97 software and documentation not expressly
# granted under this Agreement are reserved to DCScripts.
#
# Disclaimer of Warranty
# THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
# WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
# WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
# AND SOFTWARE ENVIRONMENTS INTO WHICH HKDBOARD MAY BE USED, NO WARRANTY OF
# FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
# ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF HKDESIGN WILL BE
# LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
# IN NO CASE SHALL DCSCRIPTS BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
# CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
# OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
# BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
# NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
# DCSCRIPTS IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
# DCSCRIPT'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
# BY LICENSEE TO DCSCRIPTS.
#
#
# CREDITS = This script uses Matt Wright's cookie.lib library file
# You can get you free copy at www.worldwidemart/scripts --
#
###########################################################################

# Define directory path to this script
# If relative path will work leave it as is

$path = ".";

# inlcude library files...

require "$path/dclinks98.setup";
require "$path/dclinks98admin.setup";

# $cgidir is defined in dclinks98.setup

require "$cgidir/cgi-lib.pl";
require "$cgidir/cookie.lib";

# ----------------- Shouldn't have to change anything below here --------------#

# Read in Form data

&ReadParse;

# If Password file doesn't exist, create one
# with username dcscripts and password dcscripts

&check_password_file;

print "Content-type: text/html\n";

if ($ENV{'QUERY_STRING'} eq "LOGON") {
	&logon;
}

if ($in{'change_password'}) {
	print "\n";
	&change_password_form;
	&display_output;
	exit(0);
}

$action = $in{"action"};

&check_password;

if ($action eq "list") {

	print "\n";
   &display_links;

} elsif ($action eq "remove") {

	print "\n";
	$header = $display_removedone_header;
	$sub_header = $display_removedone_sub_header;
    &remove_links;

} elsif ($action eq "add_links") {

	print "\n";
	$header = $display_edone_header;
	$sub_header = $display_edone_sub_header;
    &add_links;

} elsif ($action eq "edit_form") {

	print "\n";
	$header = $display_eform_header;
	$sub_header = $display_eform_sub_header;
    &display_form;   
   
} elsif ($action eq "change_password") {

   &change_password;

	print "\n";

   $header = $display_change_header;
   $header = $display_change_sub_header;
   &logon;
	
} else {

	print "\n";
	$header = $display_main_header;
	$sub_header = $display_main_sub_header;
	&display_main;

}

&display_output;

exit(0);

sub display_main {

	$html_output .= qq~
		<font face="$font_face" size="$font_size" color="$font_color">
		<ul>
	<li><a href="$adminurl?action=list">Remove Links</a>
	<li><a href="$adminurl?action=list&type=edit">Edit Links</a>
	</ul></font>
	~;
}

sub remove_links {

	@records = split(/\0/,$in{'records'});

	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	$new_links = "";

	my $html_output .= qq~
		<font face="$font_face" size="$font_size" color="$font_color">
		<ul>
	~;
	
	foreach $line (@linksdata) {

		chop($line) if ($line =~ /\n$/);
		@row = split(/\|/,$line);			
		$hit = "no";

		foreach ($j = 0;$j <= @row-1;$j++) {
			$rowdata{$link_fields[$j]} = $row[$j];
		}

		foreach $record (@records) {
			if ($line =~ /$record\|/) {
				$hit="yes";
				$html_output .= qq~
				<li>
				<input type="$type" name="records" value="$rowdata{'ID'}">
				<a href="$rowdata{"Homepage"}">$rowdata{"Name"}</a>
				$rowdata{"Description"}
				</li>
				~;
				$last;
			}
		}
		
		unless ($hit eq "yes") { $new_links .= "$line\n"; }
	}

	open(LINKSDATA,">$datafile") || die $!;
	flock(LINKSDATA,2);
		print LINKSDATA $new_links;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	$html_output .= qq~
		</ul></font>
	~;
}


sub display_links {

	if ($in{'type'}) {
		$type = "radio";
		$todo = "edit_form";
		$submit_value = "Edit Selected Link";
		$header = $display_edit_header;
		$sub_header = $display_edit_sub_header;
	} else {
		$type = "checkbox";
		$todo = "remove";
		$submit_value = "Remove Links";
		$header = $display_remove_header;
		$sub_header = $display_remove_sub_header;
	}
	
	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	$html_output .= qq~
	<form action="$adminurl" method="post">
	<input type="hidden" name="action" value="$todo">
	~;
	
	foreach $category (@Category_list) {

		$html_output .= qq~
		<center>
		<font face="$font_face" size="$font_size" color="$font_color">
		<B>Links in $category</b>
		</center>
		<ul>
		~;
		
		foreach $line (@linksdata) {
			@row = split(/\|/,$line);
	
			foreach ($j = 0;$j <= @row-1;$j++) {
				$rowdata{$link_fields[$j]} = $row[$j];
			}
			
			if ($rowdata{$link_fields[$cat_id]} =~ /$category/) {
				$html_output .= qq~
				<li>~;
				$html_output .= &list_record($type,@rowdata);
			}
		}

		$html_output .= "</ul></font>";
	}

	$html_output .= qq~
	<center>
	<input type="submit" value="$submit_value">
	<input type="reset" value="Reset Form">	
	</center>
	</form>
	~;
}

sub change_password_form {

	$header = "Change Password and Username";
	$sub_header = "Complete following form to Change your username and password";
	
	$html_output .= qq~
	<font face="$font_face" size="$font_size" color="$font_color">
	<form action="$adminurl" method="post">
	<input type="hidden" name="action" value="change_password">
	Old Username: <input type="text" name="username" width="40"><br>
	New Username: <input type="text" name="new_username" width="40"><br>
	Old Password: <input type="password" name="password" width="40"><br>
	New Password: <input type="password" name="new_password1" width="40"><br>
	New Password: <input type="password" name="new_password2" width="40"><br>
	<input type="submit" value="Change Now">
	<input type="reset" value="Reset">
	</form>
	</font>
~;
}


sub display_logon {

	$html_output .= qq~
	
	<form action="$adminurl" method="post">
	<input type="hidden" name="action" value="logon">
	Username: <input type="text" name="username" width="40"><br>
	Password: <input type="password" name="password" width="40"><br>
	<input type="submit" value="Logon">
	<input type="submit" name="change_password" value="Change Password">
	</form>
~;
}


sub display_output {

	open(TEMPLATE,"$booktemplate") || die $!;
		while (<TEMPLATE>) {
			$template .= $_;
		}
	close(TEMPLATE);
	$template =~ s/\$HTML_OUTPUT/$html_output/g;
	$template =~ s/\$HEADER/$header/g;
	$template =~ s/\$SUB_HEADER/$sub_header/g;
	print $template;

}

sub change_password {

	if (!$in{'username'}) {

       &error(no_username);

	} elsif (!$in{'password'}) {

       &error(no_password);

	}

	$username = $in{'username'};
	$new_username = $in{'new_username'};
	$password = $in{'password'};
	$new_password1 = $in{'new_password1'};
	$new_password2 = $in{'new_password2'};

	open(PASSWORD,"$password_file") || &error(password_file);
		$username_password = <PASSWORD>;
		chop($username_password) if ($username_password =~ /\n$/);
	close(PASSWORD);

   ($orig_username,$orig_password) = split(/:/,$username_password);
   
   $test = crypt($password, substr($password, 0, 2));

	if (!($test eq $orig_password && $orig_username eq $username)) {

      	&error(bad_combo);

	} elsif ($new_password1 ne $new_password2) {

		&error('not_same');

	} else {

		$new_password = crypt($new_password1, substr($new_password1, 0, 2));
		$username_password = join(":",$new_username,$new_password);
		
		open(PASSWORD,">$password_file") || &error(password_file);
			print PASSWORD "$username_password\n";
   		close(PASSWORD);

		&SetCookies('username',$new_username,'password',$new_password);

	}

   print "\n";
	
}


###
###
### subroutine check_password
###
###

sub check_password {

	open(PASSWORD,"$password_file") || &error(password_file);
		$username_password = <PASSWORD>;
      	chop($username_password) if $username_password =~ /\n$/;
   	close(PASSWORD);

	($orig_username,$orig_password) = split(/:/,$username_password);

	if (&GetCookies('username','password')) {

		$username = $Cookies{'username'};
		$password = $Cookies{'password'};

		if (!($password eq $orig_password && $username eq $orig_username)) {
	      &error(bad_combo);
		}

	} else {

		if ($in{'action'} eq "logon") {

			if (!$in{'username'}) {
				&error(no_username);
			}
			elsif (!$in{'password'}) {
		       &error(no_password);
			}
			
			$test = crypt($in{'password'}, substr($in{'password'}, 0, 2));
	
			if (!($test eq $orig_password && $in{'username'} eq $orig_username)) {
		      &error(bad_combo);
			}
			
			&SetCookies('username',$in{'username'},'password',$test);
			
		} else {
		
			&logon;
		}		
	}
	
}

sub logon {
	print "\n";
	$header = $display_logon_header;
	$sub_header = $display_logon_sub_header;
	&display_logon;
	&display_output;
	exit(0);
}


sub error {

   $error = $_[0];

	print "\n";

    if ($error eq 'bad_combo') {
      $header = "Bad Username Password Combo";
      $sub_header = "You entered Bad Username-Password Combination.<br>  Go Back and Try Again";
    }
   elsif ($error eq 'password_file') {
      $header = "Could Not Open Password File For Reading";
      $sub_header = "Could not open the password file for reading!<br> Check permissions and try again.";
   }
   elsif ($error eq 'no_username') {
      $header = "No Username";
      $sub_header = "You forgot to enter username.  Go back and try again.";
   }
   elsif ($error eq 'no_password') {
      $header = "No Password";
      $sub_header = "You forgot to enter Password.  Go back and try again.";
    }
   elsif ($error eq 'not_same') {
      $header = "Incorrect Password Type-In";
      $sub_header = "The passwords you typed in for your new password were not the same.";
      $sub_header .= "<br>You may have mistyped, please try again.\n";
   }
   elsif ($error eq 'no_change') {
      $header = "Could Not Open Password File For Writing";
      $sub_header = "Could not open the password file for writing!  Password not changed!";
   }

   &display_output;
   exit(0);
}

sub check_password_file {

	if (!(-e "$password_file")) {
	   	$username = "dcscripts";
   		$password = crypt("dcscripts", substr("dcscripts", 0, 2));
   		$username_password = join(":",$username,$password);
		open(PASSWORD,">$password_file") || &error(password_file);
			print PASSWORD "$username_password\n";
		close(PASSWORD);
	}
}


sub list_record {

	local($type,@rowdata) = @_;
	local($output);
	
	$output .= qq~
	<input type="$type" name="records" value="$rowdata{'ID'}">
	<a href="$rowdata{"Homepage"}">$rowdata{"Name"}</a>
	$rowdata{"Description"}
	~;
	
	$output;
}

sub add_links {

	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	$id = $in{'records'};
	($date,$localtime) = &get_date();
	$date = $localtime." ".$date;

	$in{'ID'} = $id;
	$in{'Date'} = $date;

	foreach $field (@link_fields)
	{
		$in{$field} =~ s/\|/\s/g;
		$update .= $in{$field}."|";
	}
	
	chop($update);
	$update .= "\n";

	foreach $link (@linksdata) {
		if ($link =~ /$id\|/) {
			$newline .= $update;
			@row = split(/\|/,$link);
			foreach ($j = 0;$j <= @row-1;$j++) {
				$rowdata{$link_fields[$j]} = $row[$j];
			}

		} else {
			$newline .= $link;
		}
	}

	open(LINKSDATA,">$datafile") || die $!;
	flock(LINKSDATA,2);
		print LINKSDATA $newline;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	$html_output .= qq~
	<a href="$rowdata{"Homepage"}">$rowdata{"Name"}</a>
	$rowdata{"Description"}
	~;
		
}

sub display_form {


	$id = "$in{'records'}";

	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);
	
	foreach $line (@linksdata) {
		chop($line) if ($line =~ /\n$/);
		if ($line =~ /$id\|/) {
			@row = split(/\|/,$line);
			last;
		}
	}
	
	foreach ($j = 0;$j <= @row-1;$j++) {
		$record{$link_fields[$j]} = $row[$j];
	}
		
	$html_output .= qq~
	<center>
	<table border="0">

	<form action="$adminurl" method="post">
	<input type="hidden" name="action" value="add_links">
	<input type="hidden" name="records" value="$id">~;
	
	foreach $link_field (@link_fields)
	{
		$html_output .= &table_row($link_field,$field_input_type{$link_field},$record{$link_field});
	}
	
	$html_output .= qq~
	<tr>
	<td colspan="2" align="center">
	<input type="submit" value="Update My Link!">
	<input type="reset">
	</form>
	</table>
	</center>~;
}

sub table_row {

	local($field,$type);
	($field,$type,$value) = @_;
	local($table_row);
	
	if ($type eq "text") {
		$table_row .= qq~
		<tr>
		<td valign="top">
		$field
		</td>
		<td>
		<input type="$type" name="$field" value="$value" size="40">
		</td>
		</tr>
		~;
	} elsif ($type eq "textarea") {
		$table_row .= qq~
		<tr>
		<td valign="top">
		$field
		</td>
		<td>
		<textarea name="$field" rows="6" cols="40" wrap="physical">$value</textarea>
		</td>
		</tr>
		~;
		
	} elsif ($type eq "select") {
		@option_list = eval("@".$field."_list");
		$table_row .= qq~
		<tr>
		<td valign="top">
		$field
		</td>
		<td>
		<select name="$field">~;
		foreach $option (@option_list)
		{
			if ($option eq $value) {
				$table_row .= "<option selected value=\"$option\">$option\n";
			} else {
				$table_row .= "<option value=\"$option\">$option\n";
			}
		}
		
		$table_row .= qq~
		</select>
		</td>
		</tr>
		~;

	}

	
	$table_row;
}


sub get_date {

   local($date,$localtime);
   
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   if ($sec < 10) {
      $sec = "0$sec";
   }
   if ($min < 10) {
      $min = "0$min";
   }
   if ($hour < 10) {
      $hour = "0$hour";
   }
   if ($mon < 10) {
      $mon = "0$mon";
   }
   if ($mday < 10) {
      $mday = "0$mday";
   }

   $month = ($mon + 1);

   @months = ("January","February","March","April","May","June","July","August","September","October","November","December");

   $localtime = "$hour\:$min\:$sec";
   $date = "$month/$mday/$year";
   chop($date) if ($date =~ /\n$/);
   chop($local) if ($local =~ /\n$/);

   ($date,$localtime);
   
}
