#!/usr/bin/perl

require "/cgi-bin/cgi-lib.pl/";
require "domo.setup";  # File that contains all the variables.

#######################################################################################
# Logging script of PerlDomo. Needs domo.setup, del.pl and mailer.pl as well.         #
# This script can be modified at will according to the GNU as long as comments remain.#
# Kevin Meltzer 3/6/97 | kmeltz@cris.com | www.cris.com/~kmeltz                       #
# Do not sell this package under any circumstances without my permission please.      #
#######################################################################################

# Define Variables
# This ($lock_sec) is the only variable in this script to reset if needed.
# All other variables are located in domo.setup
        
        $lock_sec = 3;
        
print &PrintHeader;
&ReadParse;

        $EMAIL = $in{'email'};

# Lock file so if it is being used by more than one person at a time, it shouldn't be destroyed.        
        &check_lock($lock_sec);

# Open the file 
open (LOG, "$EMAIL_LOG");
@LOG = <LOG>;
close (LOG);

$RECIPS = join('',@LOG);
@recips = split(/$DELIMITER/, $RECIPS);
&check_dup;

#######################################################
# Subroutine to check to make sure eMail address being
# submitted isn't already on the recipient list.
#######################################################

sub check_dup {
$DUP = 0;
foreach $ADDY (@recips) {
if ($ADDY eq $EMAIL) {
$DUP++;
        }
}
# Alert of duplicate entry, unlock the file and exit program 
if ($DUP ne 0) {
        print "<title>Duplicate Address</title>";
        print "<body bgcolor=\"$bgcolor\">\n";
        print "<center><h1>Duplicate Address</h1></center>\n";
        print "<center>$EMAIL is already on this mailing list.</center>\n";
        &clean_up;
        exit;

        }
# Not a duplicate entry, so re-open the file and write to it.
else {
open (LOG, ">>$EMAIL_LOG") || die "Can't open $FILE to write to.";
print LOG "$EMAIL\n";
close (LOG);
&return_page;
&clean_up;
&send_mail;
  }
}

#######################################
# Subroutine to check/lock file
#######################################

sub check_lock {
   $time = $_[0];

   for ($i = 1;$i <= $time; $i++) {
      if (-e "$lock_file") {
         sleep 1;
      }
      else {
         open(LOCK,">$lock_file");
         print LOCK "0";
         close(LOCK);
         last;
      }
   }
}

#######################################
# Unlock file
#######################################
sub clean_up {
   unlink("$lock_file");
}

#######################################
# Returns successfule subscribe
#######################################

sub return_page {

print<<EOM
        <title>Successful Submission</title>
        <body bgcolor="$bgcolor">
        <center><h1>Thank you</h1></center>
        <center>$EMAIL has been added to the mailing list.
        You should recieve confirmation eMail to that address.</center>

EOM
}

########################################
# Subroutine to send confirmation eMail
########################################

sub send_mail {

open(MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";

print MAIL "TO: $EMAIL\n";
print MAIL "FROM: $from\n";
print MAIL "SUBJECT: $con_subj\n\n";
if ($confirm ne '') {
open (CONFIRM, "$confirm") || die "Can't open confirm file.";
$CONFIRM = <CONFIRM>;
close (CONFIRM);
print MAIL "$CONFIRM\n";
}
else {
print MAIL "This confirms that you are now on the mailing list for $list_name.\n";
print MAIL "If you wish to unsubscribe, please go to $del_site and enter your eMail address.\n";
}
close (MAIL);
}

# End
