#!/usr/bin/perl

#use CGI::Carp qw(fatalsToBrowser);

# Fresh Guest Book Version 2.0 by Webfresh (TM)
# Copyright 1999-2001 Webfresh All Rights Reserved
#
# This program is being distributed as shareware.  It may be used and
# modified by anyone, so long as this copyright notice and the header
# above remain intact, but any usage should be registered.  (See the
# program documentation for registration information.)  Selling the
# code for this program without prior written consent is expressly
# forbidden.  Obtain permission before redistributing this program
# over the Internet or in any other medium.  In all cases copyright
# and header must remain intact.
#
# VERSIONS OF SOFTWARE
#-----------------------------------------------------------------------
# Only one copy of the shareware or registered version of Fresh Guest
# Book may be used on one web site owned by one owner or an entity.
#
# LICENSE TO REDISTRIBUTE
#-----------------------------------------------------------------------
# Distributing the software and/or documentation with other products
# (commercial or otherwise) or by other than electronic means without
# Webfresh prior written permission is forbidden.
# All rights to the Fresh Guest Book software and documentation not 
# expressly granted under this Agreement are reserved to Webfresh.
#
# DISCLAIMER OR WARRANTY
#-----------------------------------------------------------------------
# THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
# WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
# WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
# AND SOFTWARE ENVIRONMENTS INTO WHICH THE FRESH GUEST BOOK MAY BE USED, 
# NO WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE IS OFFERED. THE USER MUST
# ASSUME THE ENTIRE RISK OF USING THIS PROGRAM. ANY LIABILITY OF WEBFRESH WILL BE
# LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
# IN NO CASE SHALL WEBFRESH BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
# CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
# OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
# BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
# NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
# WEBFRESH IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
# WEBFRESH'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
# BY LICENSEE TO WEBFRESH.
#
#################################################################################

#########################################################
# NO EDITING REQUIRED BELOW

#########################################################
# PATH INFO

if ($0=~m#^(.*)(\\|/)#)	{ $dir = $1; }
else { $dir = `pwd`; chomp $dir; }

$script_url  = $ENV{'SCRIPT_NAME'};
$data_dir = "$dir/data";
$guest_dat = "$data_dir/guest.dat";
$info_dat = "$data_dir/info.dat";
$header_file = "$data_dir/header.html";
$footer_file = "$data_dir/footer.html";
$admin_mail_file = "$data_dir/adminmail.txt";
$guest_mail_file = "$data_dir/guestmail.txt";
$hits_dat = "$data_dir/hits.dat";
$ip_dat = "$data_dir/ip.dat";
$dirty_dat = "$data_dir/dirty.dat";
$emails_dat = "$data_dir/emails.dat";

%in = &ReadForm;

&load_data;

&hits;


#########################################################
# ADD ENTRY

if($action eq "add") {

if ($ip_banned_filter eq "1") {

open (BANNED_IP, "<$ip_dat");
@banned_ip = split /\s+/, <BANNED_IP>;
close(BANNED_IP);

foreach $ip (@banned_ip) {
if ($ip eq $ENV{'REMOTE_ADDR'}) {
&banned_ip_error;
}
}

}

if (!$guest_name_new && $req_name) {
$error = "Name";
&required_error;
}
if (!$guest_email_new && $req_email) {
$error = "Email";
&required_error;
}
if (!$guest_url_new && $req_url) {
$error = "Homepage";
&required_error;	
}
if (!$guest_message_new && $req_message) {
$error = "Message";
&required_error;
}

if ($words_dirty_filter eq "1") {

open (DIRTY_DAT, "<$dirty_dat");
@dirty_words = split /\s+/, <DIRTY_DAT>;
close(DIRTY_DAT);

foreach $dwords (@dirty_words) {
$guest_name_new =~ s/$dwords/****/ig;
$guest_message_new =~ s/$dwords/****/ig;
}

}


if ($html_filter eq "1") {

$guest_message_new =~ s/&#60;/</g;
$guest_message_new =~ s/&#62;/>/g;
$guest_message_new =~ s/<p>/&60;p&#62;/ig;
$guest_message_new =~ s/<br>/&60;br&#62;/ig;
$guest_message_new =~ s/<([^>]|\n)*>//g;
$guest_message_new =~ s/&60;p&#62;/<p>/ig;
$guest_message_new =~ s/&60;br&#62;/<br>/ig;

}

if ($fresh_filter eq "0") {

$guest_message_new =~ s/\:D/<img src="$smilies_url\/biggrin.gif">/sg;
$guest_message_new =~ s/\:confused:/<img src="$smilies_url\/confused.gif">/sg;
$guest_message_new =~ s/\:cool:/<img src="$smilies_url\/cool.gif">/sg;
$guest_message_new =~ s/\:eek:/<img src="$smilies_url\/eek.gif">/sg;
$guest_message_new =~ s/\:o:/<img src="$smilies_url\/redface.gif">/sg;
$guest_message_new =~ s/\:\(/<img src="$smilies_url\/frown.gif">/sg;
$guest_message_new =~ s/\:mad:/<img src="$smilies_url\/mad.gif">/sg;
$guest_message_new =~ s/\:rolleyes:/<img src="$smilies_url\/rolleyes.gif">/sg;
$guest_message_new =~ s/\:\)/<img src="$smilies_url\/smile.gif">/sg;
$guest_message_new =~ s/\:p/<img src="$smilies_url\/tongue.gif">/sg;
$guest_message_new =~ s/\;\)/<img src="$smilies_url\/wink.gif">/sg;

}


if ($guest_email_new) {
$temp = $guest_email_new;
$temp =~ s/-/a/g;
$temp =~ s/_/a/g;
unless ($temp =~ /\w+@\w+\.\w\w+/) {
&format_error;
}

open(EMAILS,">>$emails_dat");
print EMAILS "$guest_email_new\n";
close(EMAILS);

}

if ($guest_url_new && $req_url) {
unless ($guest_url_new =~ /^(f|ht)tp:\/\/.+\..+/) {
&format_error;
}
}
elsif($guest_url_new ne "http://") {
unless ($guest_url_new =~ /^(f|ht)tp:\/\/.+\..+/) {
&format_error;
}
}
else {$guest_url_new = "";}

&sub_date;

open(GUEST_DAT,"<$guest_dat");
flock(GUEST_DAT, $LOCK_EX);
@guest_content = <GUEST_DAT>;
flock(GUEST_DAT, $LOCK_UN);
close(GUEST_DAT);

$content = @guest_content[0];
($ID,$guest_date,$guest_name,$guest_email,$guest_url,$guest_message,$ip,$browser) = split(/\|/,$content);
$new_ID = $ID +1;
	
open(GUEST_DAT,">$guest_dat");
flock(GUEST_DAT, $LOCK_EX);
print GUEST_DAT "$new_ID|$date|$guest_name_new|$guest_email_new|$guest_url_new|$guest_message_new|$ENV{'REMOTE_ADDR'}|$ENV{'HTTP_USER_AGENT'}\n";
foreach $line (@guest_content) {
print GUEST_DAT $line;
}
flock(GUEST_DAT, $LOCK_UN);
close(GUEST_DAT);
        	
if ($guest_mail eq "1" && $guest_email_new) {
	
open(GUEST_MAIL_TEXT,"$guest_mail_file");
@guest_text = <GUEST_MAIL_TEXT>;
close(GUEST_MAIL_TEXT);

open(MAIL,"|$sendemail -t");
print MAIL "To: $guest_email_new\n";
print MAIL "From: $home_addr\n";
print MAIL "Subject: $guest_mail_subject\n";
foreach $line (@guest_text) {
print MAIL "$line\n";
}
close MAIL;
	
}

if ($home_mail eq "1" && $home_addr) {
	
open(HOME_MAIL_TEXT,"$admin_mail_file");
@home_text = <HOME_MAIL_TEXT>;
close(HOME_MAIL_TEXT);

open(MAIL,"|$sendemail -t");
print MAIL "To: $home_addr\n";
print MAIL "From: $guest_email_new\n";
print MAIL "Subject: $admin_mail_subject\n";
foreach $line (@home_text) {
print MAIL "$line\n";
}
close MAIL;
	
}

if($forward_guest eq "1"){
print "Location: $forward_url\n\n";
}

}


#########################################################
# GUESTBOOK CONTENT

&Template("$data_dir/plain.temp");

open(GUEST_DAT,"<$guest_dat");
flock (GUEST_DAT, $LOCK_SH);
@guest_dat_content = <GUEST_DAT>;
flock (GUEST_DAT, $LOCK_UN);
close(GUEST_DAT);

foreach$content(@guest_dat_content) {
($ID,$guest_date,$guest_name,$guest_email,$guest_url,$guest_message,$ip,$browser) = split(/\|/,$content);
$push = "$ID\|$guest_date\|$guest_name\|$guest_email\|$guest_url\|$guest_message|$ip|$browser\n";
push(@guest_dat,$push);
$total++;
}

open(HEADER,"<$header_file");
@header = <HEADER>;
close(HEADER);

foreach $line19(@header) {
$header = $header.$line19;
}

open(FOOTER,"<$footer_file");
@footer = <FOOTER>;
close(FOOTER);

foreach $line20(@footer) {
$footer = $footer.$line20;
}

#########################################################
# GUESTBOOK ADD ENTRY PAGE

if($guest eq "add") {

if ($html_filter eq "1") {$filter_html = "not allowed";}
else {$filter_html = "allowed";}
if ($fresh_filter eq "1") {$filter_fresh = "not allowed";}
else {$filter_fresh = "allowed";}
$display_add_entry .= &Cell('add_entry');
        	
}


#########################################################
# GENERATE GUESTBOOK

$show_max = $guest_per_page;
$fcolor_show=1;

if($guest eq "") {

for($guest_content = $show; $guest_content < scalar @guest_dat;) {
($ID,$guest_date,$guest_name,$guest_email,$guest_url,$guest_message,$ip,$browser) = split(/\|/,$guest_dat[$guest_content]);
	
unless (!$guest_email) {
$guest_email = "<tr><td><font face=\"$font\" size=\"$fontsize5\">[<a href=\"mailto:$guest_email\">Email</a>]</font></td></tr>";
}

unless (!$guest_url) {
$guest_url = "<tr><td><font face=\"$font\" size=\"$fontsize5\">[<a href=\"$guest_url\">Homepage</a>]</font></td></tr>";
}
	
if ($fcolor_show eq '1') {$fcolor=$fcolor1; $fcolor_show++;}
elsif ($fcolor_show eq '2') {$fcolor=$fcolor2; $fcolor_show++;}
elsif ($fcolor_show eq '3') {$fcolor=$fcolor3; $fcolor_show++;}
elsif ($fcolor_show eq '4') {$fcolor=$fcolor4; $fcolor_show=1;}
if($ID ne "") {
$display_content .= &Cell('guest_content');
}
$guest_content++;
last if $guest_content-$show == $show_max;
}
$show_next = $show+$show_max;
$show_from = $total - $show_next;
$show_to = $show_from + $show_max;
$show_from = $show_from + 1;
if ($show_from <= 0) {$show_from = 1;}


if($guest_content > $show_max || $guest_content < @guest_dat) {
	
if($guest_content > $show_max) {
$show_back = $show-$show_max;
$back_span = "<a href=\"$script_url\?show=$show_back\">Back</a>";
}

if($guest_content < @guest_dat && $guest_content-$show == $show_max) {
$show_next = $show+$show_max;
$next_span = "<a href=\"$script_url\?show=$show_next\">Next</a>";
}

if ($back_span && $next_span) {
$display_span .= &Cell("show_span");
$display_back_span .= &Cell("show_back_span");
$display_next_span .= &Cell("show_next_span");
}

elsif ($back_span) {
$display_span .= &Cell("show_span");
$display_back_span .= &Cell("show_back_span");
}

elsif ($next_span) {
$display_span .= &Cell("show_span");
$display_next_span .= &Cell("show_next_span");
}
	
}

if(!$display_content) { $display_content = "<tr><td><center><br><font face=\"arial, verdana\" size=\"2\"><b>There are currently no entries in my Guestbook.<P>Please be the first to contribute.<p></b></font></center></td></tr>" };

}

print &Template("$data_dir/plain.temp",'temp');

exit;


sub load_data {

open(INFO,"<$info_dat");
@info = <INFO>;
close(INFO);

$content_info = @info[0];
($guestbook_name,$guest_per_page,$guest_mail,$guest_mail_subject,$home_mail,$admin_mail_subject,$home_addr,$sendemail,$datetype,$admin_pass,$fcolor1,$fcolor2,$fcolor3,$fcolor4,$hcolor,$mcolor,$scolor,$bcolor,$bgcolor,$bgpic,$tcolor,$lcolor,$vcolor,$font,$fontsize1,$fontsize2,$fontsize3,$fontsize4,$fontsize5,$table,$bordersize,$home_url,$admin_cgi,$guest_cgi,$smilies_html,$smilies_url,$data_path,$script_path,$req_name,$req_email,$req_url,$req_message,$ip_banned_filter,$words_dirty_filter,$html_filter,$fresh_filter,$forward_guest,$forward_url) = split(/\|/,$content_info);

}


sub hits {

open(HITSFILE, "+<$hits_dat");
flock(HITSFILE, $LOCK_EX);

$hits = <HITSFILE>;

seek HITSFILE, 0, 0;
print HITSFILE ++$hits."\n";
truncate HITSFILE, tell( HITSFILE );

flock(HITSFILE, $LOCK_UN);
close(HITSFILE);

}


sub banned_ip_error {

&Template("$data_dir/plain.temp",'temp');
$display_banned_ip .= &Cell('banned_ip');
print &Template("$data_dir/plain.temp",'temp');
exit;
}

sub required_error {

&Template("$data_dir/plain.temp",'temp');
$display_required_fields .= &Cell('required_fields');
print &Template("$data_dir/plain.temp",'temp');
exit;
}

sub format_error {
&Template("$data_dir/plain.temp",'temp');
$display_format_words .= &Cell('format_words');
print &Template("$data_dir/plain.temp",'temp');
exit;
}


sub sub_date {

@days = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
@months = ('January','February','March','April','May','June','July','August','September','October','November','December');

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

$mon_num = $mon+1;
$savehour = $hour;
$hour = "0$hour" if ($hour < 10);
$min = "0$min" if ($min < 10);
$sec = "0$sec" if ($sec < 10);
$saveyear = ($year % 100);
$year = 1900 + $year;

if ($datetype == 1) {
	$mon_num = "0$mon_num" if ($mon_num < 10);
	$mday = "0$mday" if ($mday < 10);
	$saveyear = "200$saveyear" if ($saveyear < 10);
	$date = "$mon_num/$mday/$saveyear";
} elsif ($datetype == 2) {
	$mon_num = "0$mon_num" if ($mon_num < 10);
	$mday = "0$mday" if ($mday < 10);
	$saveyear = "200$saveyear" if ($saveyear < 10);
	$date = "$mday\.$mon_num\.$saveyear";
} elsif ($datetype == 3) {
	$mon_num = "0$mon_num" if ($mon_num < 10);
	$mday = "0$mday" if ($mday < 10);
	$saveyear = "200$saveyear" if ($saveyear < 10);
	$date = "$mon_num/$mday/$saveyear-$hour\:$min";
} elsif ($datetype == 4) {
	$mon_num = "0$mon_num" if ($mon_num < 10);
	$mday = "0$mday" if ($mday < 10);
	$saveyear = "200$saveyear" if ($saveyear < 10);
	$date = "$mday\.$mon_num\.$saveyear-$hour\:$min";
}

}

#########################################################
# TEMPLATE

sub Template {  

local(*FILE);

if    ($_[1] eq 'temp') { print "Content-type: text/html\n\n"  unless ($ContentType++ > 0); }
elsif ($_[1] eq 'text') { print "Content-type: text/plain\n\n" unless ($ContentType++ > 0); }

if    (!$_[0])	{ return "<br>\nTemplate : No file was specified<br>\n"; }
elsif (!-e "$_[0]")	{ return "<br>\nTemplate : File '$_[0]' does not exist<br>\n"; }
else {
open(FILE, "<$_[0]") || return "<br>\nTemplate : Could open $_[0]<br>\n";
while (<FILE>) { $FILE .= $_; }
close(FILE);
for ($FILE) {
s/<!-- ins : (.*?) -->/\1/gi;				# show hidden inserts
s/<!-- def : (\w+) -->(?:\r\n|\n)?(.*?)<!-- \/def : \1 -->/
$CELL{$1}=$2;''/ges;					# read/remove template cells
s/\%(\w+)\%/${$1}/g;					# translate %%
}
}
return $FILE;

}

#########################################################
# TRANSLATE CELL

sub Cell {  

my($CELL);
for (0..$#_) { if ($_[$_]) { $CELL .= $CELL{$_[$_]}; }}

if    (!$_[0]) { return "<br>\nCell : No cell was specified<br>\n"; }
elsif (!$CELL) { return "<br>\nCell : Cell '$_[0]' is not defined<br>\n"; }
else		 { $CELL =~ s/\%(\w+)\%/${$1}/g; }		# translate %%
  
return $CELL;

}

#########################################################
# PARSE FORM

sub ReadForm {

my($max) = $_[1];					# Max Input Size
my($name,$value,$pair,@pairs,$buffer,%hash);		# localize variables

# Check input size if max input size is defined
if ($max && ($ENV{'CONTENT_LENGTH'}||length $ENV{'QUERY_STRING'}) > $max) {
die("ReadForm : Input exceeds max input limit of $max bytes\n");
}

# Read GET or POST form into $buffer
if    ($ENV{'REQUEST_METHOD'} eq 'POST') { read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'}); }
if    ($ENV{'QUERY_STRING'}) { $buffer .= $ENV{'QUERY_STRING'}; }

@pairs = split(/&/, $buffer);				# Split into name/value pairs
foreach $pair (@pairs) {		

($name, $value) = split(/=/, $pair);		# split into $name and $value
$value =~ s/\+/ /g;
$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
$value =~ s/~!/ ~!/g;
$value =~ s/\n/<br>/sg;
$value =~ s/\[\]//g;
$value =~ tr/+/ /;					# replace "+" with " "
$value =~ s/%([A-F0-9]{2})/pack("C", hex($1))/egi;	# replace %hex with char
$$name = $value;
}

return %hash;

}
