#!/usr/bin/perl

#use CGI::Carp qw(fatalsToBrowser);

# Fresh Guest Book Version 2.0 by Webfresh (TM)
# Copyright  1999-2001 Webfresh All Rights Reserved
#
# This program is being distributed as shareware.  It may be used and
# modified by anyone, so long as this copyright notice and the header
# above remain intact, but any usage should be registered.  (See the
# program documentation for registration information.)  Selling the
# code for this program without prior written consent is expressly
# forbidden.  Obtain permission before redistributing this program
# over the Internet or in any other medium.  In all cases copyright
# and header must remain intact.
#
# VERSIONS OF SOFTWARE
#-----------------------------------------------------------------------
# Only one copy of the shareware or registered version of Fresh Guest
# Book may be used on one web site owned by one owner or an entity.
#
# LICENSE TO REDISTRIBUTE
#-----------------------------------------------------------------------
# Distributing the software and/or documentation with other products
# (commercial or otherwise) or by other than electronic means without
# Webfresh prior written permission is forbidden.
# All rights to the Fresh Guest Book software and documentation not 
# expressly granted under this Agreement are reserved to Webfresh.
#
# DISCLAIMER OR WARRANTY
#-----------------------------------------------------------------------
# THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
# WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
# WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
# AND SOFTWARE ENVIRONMENTS INTO WHICH THE FRESH GUEST BOOK MAY BE USED, 
# NO WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE IS OFFERED. THE USER MUST
# ASSUME THE ENTIRE RISK OF USING THIS PROGRAM. ANY LIABILITY OF WEBFRESH WILL BE
# LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
# IN NO CASE SHALL WEBFRESH BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
# CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
# OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
# BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
# NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
# WEBFRESH IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
# WEBFRESH'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
# BY LICENSEE TO WEBFRESH.
#
################################################################################

#########################################################
# NO EDITING REQUIRED BELOW

#########################################################
# PATH INFO

if ($0=~m#^(.*)(\\|/)#)	{ $dir = $1; }
else { $dir = `pwd`; chomp $dir; }

$script_url  = $ENV{'SCRIPT_NAME'};
$data_dir = "$dir/data";
$guest_dat = "$data_dir/guest.dat";
$info_dat = "$data_dir/info.dat";
$header_file = "$data_dir/header.html";
$footer_file = "$data_dir/footer.html";
$admin_mail_file = "$data_dir/adminmail.txt";
$guest_mail_file = "$data_dir/guestmail.txt";
$hits_dat = "$data_dir/hits.dat";
$ip_dat = "$data_dir/ip.dat";
$dirty_dat = "$data_dir/dirty.dat";
$emails_dat = "$data_dir/emails.dat";

%in = &ReadParse;

&load_data;

if($action eq "admin" && $pass eq $admin_pass){&main;}
if($action eq "admin" && $pass ne $admin_pass){&error;}
elsif($action eq "guest_info" && $pass eq $admin_pass){&sub_guest_info;}
elsif($action eq "mail_info" && $action2 eq "send_mailing" && $pass eq $admin_pass){&sub_send_mailing;}
elsif($action eq "mail_info" && $pass eq $admin_pass){&sub_mail_info;}
elsif($action eq "security_info" && $pass eq $admin_pass){&sub_security_info;}
elsif($action eq "settings_info" && $pass eq $admin_pass){&sub_settings_info;}
elsif($action eq "guest_info" && $set_pass){&set_admin_pass;}
elsif($action eq "delete_guest" && $delete_ID && $pass eq $admin_pass){&delete;}
elsif($action eq "delete_all" && $pass eq $admin_pass){&delete_all;}
elsif($action eq "ip_ban" && $ban_ip && $pass eq $admin_pass){&banning_ip;}
elsif($action eq "administration" && $pass eq $admin_pass){&administration;}
elsif($action eq "layout" && $pass eq $admin_pass){&layout;}
elsif($action eq "mail" && $pass eq $admin_pass){&mail;}
elsif($action eq "security" && $pass eq $admin_pass){&security;}
elsif($action eq "stats" && $pass eq $admin_pass){&stats;}
elsif($action eq "settings" && $pass eq $admin_pass){&settings;}
elsif($action eq "save_config"){&save_config;}
elsif(!$admin_pass) {&set_config;}
else{&admin_login;}
exit;


#########################################################
# SET CONFIG

sub set_config {

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="save_config">
<input type="hidden" name="guest_cgiX" value="http://$ENV{'HTTP_HOST'}/guestbook/guest.cgi" size="60">
<input type="hidden" name="admin_cgiX" value="http://$ENV{'HTTP_HOST'}/guestbook/admin.cgi" size="60">
<input type="hidden" name="data_pathX" value="$ENV{'DOCUMENT_ROOT'}/guestbook/data" size="60">
<input type="hidden" name="script_pathX" value="$ENV{'DOCUMENT_ROOT'}/guestbook" size="60">
<input type="hidden" name="smilies_htmlX" value="http://$ENV{'HTTP_HOST'}/guestbook/smilies.html" size="60"></td>
<tr>
<td valign="top" width="100%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>SERVER SETTINGS:<br>
The default setup as explained in the README.txt file should be fine for most Unix servers.<br>
Please consult the README.txt file for an explanation of the settings.
</b></font></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Admin Password:</b></font><br>
<input type="text" name="admin_passX" size="60"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Homepage URL:</b></font><br>
<input type="text" name="home_urlX" value="http://$ENV{'HTTP_HOST'}" size="60"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>OPTIONAL SETTING (Only required if you do not want to follow the default setup)<br>
URL to smilies.html, smilie images and colors.html: (no trailing slash / at the end)</b></font><br>
<input type="text" name="smilies_urlX" value="http://$ENV{'HTTP_HOST'}/guestbook/smilies" size="60"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="2">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<input type="submit" Value="Submit Action"></td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


#########################################################
# ADMIN LOGIN

sub admin_login {

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<tr>
<td>
<table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="purple" align="center">
<form action="$script_url" method="post">
<input type="hidden" name="action" value="admin">
<tr>
<td><center><font face="verdana, arial" size=2>
<b>Enter Admin Password: </b></font>
<input type="password" Name="pass" size="24">
<input type="submit" value="Submit"></center></td>
</tr>
</form>
</table>
</td>
</tr>
</table>
</body>
</html>
!; 

exit;

}


#########################################################
# PROCESSING
  
sub sub_guest_info {

open(GUEST_INFO,">$info_dat");
print GUEST_INFO "$guestbook_nameX|$guest_per_pageX|$guest_mail|$guest_mail_subject|$home_mail|$admin_mail_subject|$home_addr|$sendemail|$datetypeX|$admin_pass|$fcolor1X|$fcolor2X|$fcolor3X|$fcolor4X|$hcolorX|$mcolorX|$scolorX|$bcolorX|$bgcolorX|$bgpicX|$tcolorX|$lcolorX|$vcolorX|$fontX|$fontsize1X|$fontsize2X|$fontsize3X|$fontsize4X|$fontsize5X|$tableX|$bordersizeX|$home_url|$admin_cgi|$guest_cgi|$smilies_html|$smilies_url|$data_path|$script_path|$req_name|$req_email|$req_url|$req_message|$ip_banned_filter|$words_dirty_filter|$html_filter|$fresh_filter|$forward_guestX|$forward_urlX";
close(GUEST_INFO);

chomp $header;
open(HEADER,">$header_file");
print HEADER "$header";
close(HEADER);

chomp $footer;
open(FOOTER,">$footer_file");
print FOOTER "$footer";
close(FOOTER);

print "Location: $script_url?admin&pass=$admin_pass&action=layout\n\n";

}

sub sub_mail_info {

open(GUEST_INFO,">$info_dat");
print GUEST_INFO "$guestbook_name|$guest_per_page|$guest_mailX|$guest_mail_subjectX|$home_mailX|$admin_mail_subjectX|$home_addrX|$sendemailX|$datetype|$admin_pass|$fcolor1|$fcolor2|$fcolor3|$fcolor4|$hcolor|$mcolor|$scolor|$bcolor|$bgcolor|$bgpic|$tcolor|$lcolor|$vcolor|$font|$fontsize1|$fontsize2|$fontsize3|$fontsize4|$fontsize5|$table|$bordersize|$home_url|$admin_cgi|$guest_cgi|$smilies_html|$smilies_url|$data_path|$script_path|$req_name|$req_email|$req_url|$req_message|$ip_banned_filter|$words_dirty_filter|$html_filter|$fresh_filter|$forward_guest|$forward_url";
close(GUEST_INFO);

#chomp $admin_mail_text;
open(MAIL_TO_ADMIN,">$admin_mail_file");
print MAIL_TO_ADMIN "$admin_mail_text";
close(MAIL_TO_ADMIN);

#chomp $guest_mail_text;
open(MAIL_TO_GUEST,">$guest_mail_file");
print MAIL_TO_GUEST "$guest_mail_text";
close(MAIL_TO_GUEST);

print "Location: $script_url?admin&pass=$admin_pass&action=mail\n\n";

}

sub sub_send_mailing {

open(EMAILS,"<$emails_dat");
@emails = <EMAILS>;
close(EMAILS);

foreach$line15(@emails) {
chomp ($line15);
open(MAIL,"|$sendemail -t");
print MAIL "To: $line15 \n";
print MAIL "From: $home_addr \n";
print MAIL "Subject: $mailing_subject \n";
print MAIL "$mailing_message";
close MAIL;
}

print "Location: $script_url?admin&pass=$admin_pass&action=mail\n\n";

}

sub sub_security_info {

open(GUEST_INFO,">$info_dat");
print GUEST_INFO "$guestbook_name|$guest_per_page|$guest_mail|$guest_mail_subject|$home_mail|$admin_mail_subject|$home_addr|$sendemail|$datetype|$admin_pass|$fcolor1|$fcolor2|$fcolor3|$fcolor4|$hcolor|$mcolor|$scolor|$bcolor|$bgcolor|$bgpic|$tcolor|$lcolor|$vcolor|$font|$fontsize1|$fontsize2|$fontsize3|$fontsize4|$fontsize5|$table|$bordersize|$home_url|$admin_cgi|$guest_cgi|$smilies_html|$smilies_url|$data_path|$script_path|$req_nameX|$req_emailX|$req_urlX|$req_messageX|$ip_banned_filterX|$words_dirty_filterX|$html_filterX|$fresh_filterX|$forward_guest|$forward_url";
close(GUEST_INFO);

open(IP_DAT,">$ip_dat");
print IP_DAT "$ip_banned";
close(IP_DAT);

open(DIRTY_DAT,">$dirty_dat");
print DIRTY_DAT "$words_dirty";
close(DIRTY_DAT);

print "Location: $script_url?admin&pass=$admin_pass&action=security\n\n";

}

sub sub_settings_info {

open(GUEST_INFO,">$info_dat");
print GUEST_INFO "$guestbook_name|$guest_per_page|$guest_mail|$guest_mail_subject|$home_mail|$admin_mail_subject|$home_addr|$sendemail|$datetype|$admin_passX|$fcolor1|$fcolor2|$fcolor3|$fcolor4|$hcolor|$mcolor|$scolor|$bcolor|$bgcolor|$bgpic|$tcolor|$lcolor|$vcolor|$font|$fontsize1|$fontsize2|$fontsize3|$fontsize4|$fontsize5|$table|$bordersize|$home_urlX|$admin_cgi|$guest_cgi|$smilies_html|$smilies_urlX|$data_path|$script_path|$req_name|$req_email|$req_url|$req_message|$ip_banned_filter|$words_dirty_filter|$html_filter|$fresh_filter|$forward_guest|$forward_url";
close(GUEST_INFO);

print "Location: $script_url?admin&pass=$admin_pass&action=settings\n\n";

}

sub save_config {

open(GUEST_INFO,">$info_dat");
print GUEST_INFO "$guestbook_name|$guest_per_page|$guest_mail|$guest_mail_subject|$home_mail|$admin_mail_subject|$home_addr|$sendemail|$datetype|$admin_passX|$fcolor1|$fcolor2|$fcolor3|$fcolor4|$hcolor|$mcolor|$scolor|$bcolor|$bgcolor|$bgpic|$tcolor|$lcolor|$vcolor|$font|$fontsize1|$fontsize2|$fontsize3|$fontsize4|$fontsize5|$table|$bordersize|$home_urlX|$admin_cgiX|$guest_cgiX|$smilies_htmlX|$smilies_urlX|$data_pathX|$script_pathX|$req_name|$req_email|$req_url|$req_message|$ip_banned_filter|$words_dirty_filter|$html_filter|$fresh_filter|$forward_guest|$forward_url";
close(GUEST_INFO);

print "Location: $script_url?admin&pass=$set_pass\n\n";

}

sub delete {

open(GUEST_DAT,"<$guest_dat");
@guest_content = <GUEST_DAT>;
close(GUEST_DAT);

open(GUEST_DAT,">$guest_dat");
foreach $line (@guest_content) {
($ID,$guest_date,$guest_name,$guest_email,$guest_url,$guest_message) = split(/\|/,$line);
if ($ID eq $delete_ID) {next;}
print GUEST_DAT "$line";
}
close(GUEST_DAT);

print "Location: $script_url?admin&pass=$admin_pass&action=administration\n\n";

}

sub delete_all {

open(NEWS_DAT,">$guest_dat");
print NEWS_DAT "";
close(NEWS_DAT);

print "Location: $script_url?admin&pass=$admin_pass&action=administration\n\n";

}

sub banning_ip {

open(IP_DAT,"<$ip_dat");
$iplist = <IP_DAT>;
close(IP_DAT);

chomp $ban_ip;
open(IP_DAT2,">$ip_dat");
#print IP_DAT2 "$ban_ip\n";
#foreach$line11(@iplist){
#print IP_DAT2 "$line11";
#}
print IP_DAT2 "$iplist $ban_ip";
close(IP_DAT2);

print "Location: $script_url?admin&pass=$admin_pass&action=administration\n\n";

}


#########################################################
# LAYOUT


sub main {

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<tr>
<td>
<table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="purple" align="center">
<form action="$script_url" method="post">
<tr>
<td align="right">
<input type="hidden" name="pass" value="$admin_pass">
<input type="hidden" name="action" value="administration">
<input type="submit" value="Administration">
</td>
<td>
<font face="verdana,arial" size="1">Delete Entries, Delete all Entries, Ban IPs</font></td>
</tr>
</form>
<form action="$script_url" method="post">
<tr>
<td align="right">
<input type="hidden" name="pass" value="$admin_pass">
<input type="hidden" name="action" value="layout">
<input type="submit" value="Layout">
</td>
<td>
<font face="verdana,arial" size="1">Guestbook Headline, Entries per Page,
Date display, Layout Management (Color, Font, Border, Size),
Header & Footer Customization.</font></td>
</tr>
</form>
<form action="$script_url" method="post">
<tr>
<td align="right">
<input type="hidden" name="pass" value="$admin_pass">
<input type="hidden" name="action" value="mail">
<input type="submit" value="Mail">
</td>
<td>
<font face="verdana,arial" size="1">Admin Email Address, Sendmail Path,
Email to Admin/Guest, Email Response Admin/Guest, MAILING to Guests</font></td>
</tr>
</form>
<form action="$script_url" method="post">
<tr>
<td align="right">
<input type="hidden" name="pass" value="$admin_pass">
<input type="hidden" name="action" value="security">
<input type="submit" value="Security">
</td>
<td>
<font face="verdana,arial" size="1">Filter Management (HTML, Smilies, Dirty Words,
IP Addresses), Required Fields</font></td>
</tr>
</form>
<form action="$script_url" method="post">
<tr>
<td align="right">
<input type="hidden" name="pass" value="$admin_pass">
<input type="hidden" name="action" value="stats">
<input type="submit" value="Stats">
</td>
<td>
<font face="verdana,arial" size="1">Guestbook entries, Hits</font></td>
</tr>
</form>
<form action="$script_url" method="post">
<tr>
<td align="right">
<input type="hidden" name="pass" value="$admin_pass">
<input type="hidden" name="action" value="settings">
<input type="submit" value="Settings">
</td>
<td>
<font face="verdana,arial" size="1">Admin Password, Server URLs, Server Paths</font></td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


sub administration {

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<tr>
<td valign="top" width="70%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
!;

if(!@guest_dat_content) {
print "<tr><td><font face=\"arial, verdana\" size=\"2\"><b>Currently no data stored.</b></font></td></tr>";
}

foreach$content_dat(sort { $b <=> $a } @guest_dat_content) {
($ID,$guest_date,$guest_name,$guest_email,$guest_url,$guest_message,$ip,$browser) = split(/\|/,$content_dat);
print "<tr><td width=\"10%\" align=\"right\">\n";
print "<font face=\"verdana,arial\" size=\"2\"><b>$ID</b></font></td>\n";
print "<td width=\"30%\">\n";
print "<font face=\"verdana,arial\" size=\"2\"><b>$guest_name</b></font></td>\n";
print "<td width=\"30%\">\n";
print "<font face=\"verdana,arial\" size=\"2\"><b>$ip</b></font></td></tr>\n";
}

print qq!
</table>
</td>

<td valign="top" width="30%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<form action="$script_url?admin" method="post">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<input type="radio" name="action" value="delete_guest">
<font face="verdana,arial" size="1"><b>DELETE ENTRY<br>
Delete ID:</b></font>
<input type="text" name="delete_ID" size="5"></td>
</tr>
<tr>
<td><input type="radio" name="action" value="delete_all">
<font face="verdana,arial" size="1"><b>DELETE ALL</b></font></td>
</tr>
<tr>
<td><input type="radio" name="action" value="ip_ban">
<font face="verdana,arial" size="1"><b>BAN IP<br>
Ban IP Number:</b></font>
<input type="text" name="ban_ip" size="15"></td>
</tr>
<tr>
<td colspan="2">
<input type="submit" Value="Submit Action"></td>
</tr>
</form>
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="admin">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td colspan="2">
<input type="submit" Value="Main Menu">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


sub layout {

open(HEADER,"<$header_file");
@header = <HEADER>;
close(HEADER);
chomp @header;

open(FOOTER,"<$footer_file");
@footer = <FOOTER>;
close(FOOTER);
chomp @footer;

if($datetype eq "1"){$selected1 = "selected";}
elsif($datetype eq "2"){$selected2 = "selected";}
elsif($datetype eq "3"){$selected3 = "selected";}
elsif($datetype eq "4"){$selected4 = "selected";}

if($forward_guest eq "0"){$checked9 = "checked";}
elsif($forward_guest eq "1"){$checked10 = "checked";}

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="guest_info">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td valign="top" width="50%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Guestbook Headline:</b></font><br>
<input type="text" name="guestbook_nameX" value="$guestbook_name" size="30"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Entries per page:</b></font><br>
<input type="text" name="guest_per_pageX" value="$guest_per_page" size="5"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Date display:</b></font><br>
<select name="datetypeX">
<option value="1" $selected1>MM/DD/YY</option>
<option value="2" $selected2>DD.MM.YY</option>
<option value="3" $selected3>MM/DD/YY-07:24</option>
<option value="4" $selected4>DD.MM.YY-07:24</option></select></td>
<tr>
<td>
<table border="0" width="100%" cellspacing="0" cellpadding="1">
<tr>
<td width="33%" valign="top">
<font face="verdana,arial" size="1"><b>Guestentry<br>Bordercolor 1:</b></font><br>
<input type="text" name="fcolor1X" value="$fcolor1" size="9"><br>
<font face="verdana,arial" size="1"><b>Guestentry<br>Bordercolor 2:</b></font><br>
<input type="text" name="fcolor2X" value="$fcolor2" size="9"><br>
<font face="verdana,arial" size="1"><b>Guestentry<br>Bordercolor 3:</b></font><br>
<input type="text" name="fcolor3X" value="$fcolor3" size="9"><br>
<font face="verdana,arial" size="1"><b>Guestentry<br>Bordercolor 4:</b></font><br>
<input type="text" name="fcolor4X" value="$fcolor4" size="9"></td>
<td width="33%" valign="top">
<font face="verdana,arial" size="1"><b>Headline<br>Bordercolor:</b></font><br>
<input type="text" name="hcolorX" value="$hcolor" size="9"><br>
<font face="verdana,arial" size="1"><b>Menu<br>Bordercolor:</b></font><br>
<input type="text" name="mcolorX" value="$mcolor" size="9"><br>
<font face="verdana,arial" size="1"><b>Back/Next<br>Bordercolor:</b></font><br>
<input type="text" name="scolorX" value="$scolor" size="9"><br>
<font face="verdana,arial" size="1"><b>Bottom<br>Bordercolor:</b></font><br>
<input type="text" name="bcolorX" value="$bcolor" size="9"></td>
<td width="34%" valign="top">
<font face="verdana,arial" size="1"><b>Background<br>Color:</b></font><br>
<input type="text" name="bgcolorX" value="$bgcolor" size="9"><br>
<font face="verdana,arial" size="1"><b>Text<br>Color:</b></font><br>
<input type="text" name="tcolorX" value="$tcolor" size="9"><br>
<font face="verdana,arial" size="1"><b>Link<br>Color:</b></font><br>
<input type="text" name="lcolorX" value="$lcolor" size="9"><br>
<font face="verdana,arial" size="1"><b>Visited Link<br>Color:</b></font><br>
<input type="text" name="vcolorX" value="$vcolor" size="9"></td>
</tr>
<tr>
<td colspan="2">
<font face="verdana,arial" size="1"><b>Font Type:<br>
(ex. verdana, arial, helvetica)</b></font><br>
<input type="text" name="fontX" value="$font" size="20"></td>
<td>
<font face="verdana,arial" size="1" color="red"><b>
<a href="#" onClick="MyWindow=window.open('$smilies_url/colors.html','MyWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=450,height=500')\; return false\;">
Click here<br>
for a Color<br>Code Chart\!</a></b></font></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Table Width:<br>
(ex. 600)</b></font><br>
<input type="text" name="tableX" value="$table" size="12"></td>
<td colspan="2">
<font face="verdana,arial" size="1"><b>Border Size:<br>
(ex. 1)</b></font><br>
<input type="text" name="bordersizeX" value="$bordersize" size="3"></td>
</tr>
<tr>
<td colspan="3">
<table width="100%" cellspacing="0" cellpadding="0" border="0">
<tr>
<td width="20%" valign="top">
<font face="verdana,arial" size="1"><b>Headline<br>Font<br>Size</b></font><br>
<input type="text" name="fontsize1X" value="$fontsize1" size="2"></td>
<td width="20%" valign="top">
<font face="verdana,arial" size="1"><b>Menu<br>Font <br>Size</b></font><br>
<input type="text" name="fontsize2X" value="$fontsize2" size="2"></td>
<td width="20%" valign="top">
<font face="verdana,arial" size="1"><b>Name<br>Font<br>Size</b></font><br>
<input type="text" name="fontsize3X" value="$fontsize3" size="2"></td>
<td width="20%" valign="top">
<font face="verdana,arial" size="1"><b>Message<br>Font<br>Size</b></font><br>
<input type="text" name="fontsize4X" value="$fontsize4" size="2"></td>
<td width="20%" valign="top">
<font face="verdana,arial" size="1"><b>Misc<br>Font<br>Size</b></font><br>
<input type="text" name="fontsize5X" value="$fontsize5" size="2"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="3">
<font face="verdana,arial" size="1"><b>Background Picture (URL):<br>
(ex. http://yourdomain.com/pic.gif")</b></font><br>
<input type="text" name="bgpicX" value="$bgpic" size="30"><br>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>After successful signing forward guest to:</b></font><br>
<input type="radio" name="forward_guestX" value="0" $checked9><font face="verdana,arial" size="1"><b>Guestbook</b></font><br>
<input type="radio" name="forward_guestX" value="1" $checked10><font face="verdana,arial" size="1"><b>Custom URL<br>(ex.
http://yourdomain.com/thankyou.html)<br>Enter Custom URL here:</b></font><br>
<input type="text" name="forward_urlX" value="$forward_url" size="30"></td>
</td>
</tr>
</table>
</td>

<td valign="top" width="50%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Header HTML:<br>
(The HTML Code you want to display<br> ABOVE your Guestbook Template)</b></font><br>
<textarea name="header" rows="15" cols="30">
!;
foreach$line3(@header) {
print "$line3";
}
print qq!</textarea><br>
<font face="verdana,arial" size="1"><b>Footer HTML:<br>
(The HTML Code you want to display<br> BELOW your Guestbook Template)</b></font><br>
<textarea name="footer" rows="16" cols="30">
!;
foreach$line4(@footer) {
print "$line4";
}
print qq!</textarea></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="2">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<input type="submit" Value="Submit Action"></td>
</tr>
</form>
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="admin">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<input type="submit" Value="Main Menu">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


sub mail {

open(MAIL_TO_ADMIN,"<$admin_mail_file");
@admin_mail_text = <MAIL_TO_ADMIN>;
close(MAIL_TO_ADMIN);
chomp @admin_mail_text;

open(MAIL_TO_GUEST,"<$guest_mail_file");
@guest_mail_text = <MAIL_TO_GUEST>;
close(MAIL_TO_GUEST);
chomp @guest_mail_text;

if($home_mail eq "1"){$selected1 = "selected";}
elsif($home_mail eq "0"){$selected2 = "selected";}
if($guest_mail eq "1"){$selected3 = "selected";}
elsif($guest_mail eq "0"){$selected4 = "selected";}

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="mail_info">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td valign="top" width="50%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Admin Email Address:<br>
(be sure to set when using the email function)</b></font><br>
<input type="text" name="home_addrX" value="$home_addr" size="30"></td>
</tr>
</table>
</td>
<td>
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Sendmail path (ex.: /usr/sbin/sendmail):<br>
(be sure to set when using the email function)</b></font><br>
<input type="text" name="sendemailX" value="$sendemail" size="30"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td valign="top" width="50%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Email notification to ADMIN:</b></font>
<select name="home_mailX">
<option value="1" $selected1>ON</option>
<option value="0" $selected2>OFF</option></select><br>
<font face="verdana,arial" size="1"><b>Admin Email Subject:</b></font><br>
<input type="text" name="admin_mail_subjectX" value="$admin_mail_subject" size="30"><br>
<font face="verdana,arial" size="1"><b>Admin Email Text:</b></font><br>
<textarea name="admin_mail_text" rows="9" cols="30">
!;
foreach$line5(@admin_mail_text) {
print "$line5\n";
}
print qq!</textarea></td>
</tr>
</table>
</td>
<td>
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Email response to GUEST:</b></font>
<select name="guest_mailX">
<option value="1" $selected3>ON</option>
<option value="0" $selected4>OFF</option></select><br>
<font face="verdana,arial" size="1"><b>Guest Email Subject:</b></font><br>
<input type="text" name="guest_mail_subjectX" value="$guest_mail_subject" size="30"><br>
<font face="verdana,arial" size="1"><b>Guest Email Text:</b></font><br>
<textarea name="guest_mail_text" rows="9" cols="30">
!;
foreach$line6(@guest_mail_text) {
print "$line6\n";
}
print qq!</textarea></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="2">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<input type="radio" name="action2" value="send_mailing">
<font face="verdana,arial" size="1"><b>Send Mailing to Guests\!</b></font><br>
<font face="verdana,arial" size="1"><b>Mailing Subject:</b></font><br>
<input type="text" name="mailing_subject" size="30"><br>
<font face="verdana,arial" size="1"><b>Message:</b></font><br>
<textarea name="mailing_message" rows="8" cols="60"></textarea></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="2">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<input type="submit" Value="Submit Action"></td>
</tr>
</form>
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="admin">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<input type="submit" Value="Main Menu">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


sub security {

open(IP_DAT,"<$ip_dat");
$banned_ip = <IP_DAT>;
close(IP_DAT);

open(DIRTY_DAT,"<$dirty_dat");
$dirty_words= <DIRTY_DAT>;
close(DIRTY_DAT);

if($req_name eq "1"){$checked1 = "checked";}
if($req_email eq "1"){$checked2 = "checked";}
if($req_url eq "1"){$checked3 = "checked";}
if($req_message eq "1"){$checked4 = "checked";}

if($html_filter eq "1"){$selected5 = "selected";}
elsif($html_filter eq "0"){$selected6 = "selected";}
if($fresh_filter eq "1"){$selected7 = "selected";}
elsif($fresh_filter eq "0"){$selected8 = "selected";}

if($words_dirty_filter eq "1"){$selected1 = "selected";}
elsif($words_dirty_filter eq "0"){$selected2 = "selected";}
if($ip_banned_filter eq "1"){$selected3 = "selected";}
elsif($ip_banned_filter eq "0"){$selected4 = "selected";}

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="security_info">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>HTML Filter:</b></font>
<select name="html_filterX">
<option value="1" $selected5>ON</option>
<option value="0" $selected6>OFF</option></select>
<font face="verdana,arial" size="1"><b>Turn ON to disallow HTML in Guest Entries</b></font></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Smilie Filter:</b></font>
<select name="fresh_filterX">
<option value="1" $selected7>ON</option>
<option value="0" $selected8>OFF</option></select>
<font face="verdana,arial" size="1"><b>Turn ON to disallow SMILIES in Guest Entries</b></font></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Dirty Words Filter: </b></font>
<select name="words_dirty_filterX">
<option value="1" $selected1>ON</option>
<option value="0" $selected2>OFF</option></select><br>
<font face="verdana,arial" size="1"><b>Dirty Words:
(Please list your dirty words here, separated by spaces)</b></font><br>
<input type="text" name="words_dirty" value="$dirty_words" size="60"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Banned IPs: </b></font>
<select name="ip_banned_filterX">
<option value="1" $selected3>ON</option>
<option value="0" $selected4>OFF</option></select><br>
<font face="verdana,arial" size="1"><b>Banned IPs:
(Please list your banned IPs here, separated by spaces)</b></font><br>
<input type="text" name="ip_banned" value="$banned_ip" size="60"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Required Fields:<br>
(Check to make required)</b></font><br>
<input type="checkbox" name="req_nameX" value="1" $checked1><font face="verdana,arial" size="1"><b>Name</b></font><br>
<input type="checkbox" name="req_emailX" value="1" $checked2><font face="verdana,arial" size="1"><b>Email</b></font><br>
<input type="checkbox" name="req_urlX" value="1" $checked3><font face="verdana,arial" size="1"><b>Homepage</b></font><br>
<input type="checkbox" name="req_messageX" value="1" $checked4><font face="verdana,arial" size="1"><b>Message</b></font></td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<input type="submit" Value="Submit Action"></td>
</tr>
</form>
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="admin">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<input type="submit" Value="Main Menu">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


sub stats {

foreach$line(@guest_dat_content) {
$entries++;
}

open(HITS,"<$hits_dat");
$hits = <HITS>;
close(HITS);

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<tr>
<td valign="top" width="50%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Guestbook Entries: $entries</b></font></td>
</tr>
</table>
</td>
<td valign="top" width="50%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>Guestbook Hits: $hits</b></font></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="2">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="admin">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<input type="submit" Value="Main Menu">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


sub settings {

&admin_header;

print qq!
<table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="settings_info">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td valign="top" width="100%">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<font face="verdana,arial" size="1"><b>SERVER SETTINGS:<br>
The default setup as explained in the README.txt file should be fine for most Unix servers.<br>
Please consult the README.txt file for an explanation of the settings.</b></font></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Admin Password:</b></font><br>
<input type="text" name="admin_passX" value="$admin_pass" size="60"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>Homepage URL:</b></font><br>
<input type="text" name="home_urlX" value="$home_url" size="60"></td>
</tr>
<tr>
<td>
<font face="verdana,arial" size="1"><b>OPTIONAL SETTING (Only required if you do not want to follow the default setup)<br>
URL to smilies.html, smilie images and colors.html:</b></font><br>
<input type="text" name="smilies_urlX" value="$smilies_url" size="60"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan="2">
<table width="100%" cellspacing="0" cellpadding="4" border="1" bordercolor="purple">
<tr>
<td>
<input type="submit" Value="Submit Action"></td>
</tr>
</form>
<form action="$script_url?admin" method="post">
<input type="hidden" name="action" value="admin">
<input type="hidden" name="pass" value="$admin_pass">
<tr>
<td>
<input type="submit" Value="Main Menu">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
!;

&admin_footer;

exit;

}


#########################################################
# ADMIN LOGIN FAILURE

sub error {

print "Content-Type: text/html\n\n";
if($set_pass) {
print "Please <a href =\"$script_url\">click here</a> to login using your new password";
}       	
else {
print "Sorry wrong password";
}

}


sub admin_header {

print qq!
<html>
<head>
<title>Fresh Guest Book - Admin Control Panel - by Webfresh</title>
</head>
<body text="black" link="red" vlink="red">
<table width="596" cellspacing="0" cellpadding="5" border="1" bordercolor="purple" align="center">
<tr>
<td align="center"><font face="verdana,arial" size="3" color="purple"><b>
Fresh Guest Book - Admin Control Panel - by 
<a href="http://www.webfresh.com">Webfresh</a></b></font></td>
</tr>
</table>
!;

}


sub admin_footer {

print qq!
<table width="596" cellspacing="0" cellpadding="5" border="1" bordercolor="purple" align="center">
<tr>
<td align="center"><font face="verdana,arial" size="3" color="purple"><b>
Fresh Guest Book - Admin Control Panel - by 
<a href="http://www.webfresh.com">Webfresh</a></b></font></td>
</tr>
</table>
</body>
</html>
!;

}


sub load_data {

open(GUEST_INFO,"<$info_dat");
@info = <GUEST_INFO>;
close(GUEST_INFO);

$content_info = @info[0];
($guestbook_name,$guest_per_page,$guest_mail,$guest_mail_subject,$home_mail,$admin_mail_subject,$home_addr,$sendemail,$datetype,$admin_pass,$fcolor1,$fcolor2,$fcolor3,$fcolor4,$hcolor,$mcolor,$scolor,$bcolor,$bgcolor,$bgpic,$tcolor,$lcolor,$vcolor,$font,$fontsize1,$fontsize2,$fontsize3,$fontsize4,$fontsize5,$table,$bordersize,$home_url,$admin_cgi,$guest_cgi,$smilies_html,$smilies_url,$data_path,$script_path,$req_name,$req_email,$req_url,$req_message,$ip_banned_filter,$words_dirty_filter,$html_filter,$fresh_filter,$forward_guest,$forward_url) = split(/\|/,$content_info);

open(GUEST_DAT,"<$guest_dat");
@guest_dat_content = <GUEST_DAT>;
close(GUEST_DAT);

}


#########################################################
# PARSE FORM

sub ReadParse {

  	my($max) = $_[1];					# Max Input Size
  	my($name,$value,$pair,@pairs,$buffer,%hash);		# localize variables

  	# Check input size if max input size is defined
 	 if ($max && ($ENV{'CONTENT_LENGTH'}||length $ENV{'QUERY_STRING'}) > $max) {
    	die("ReadForm : Input exceeds max input limit of $max bytes\n");
    	}

 	 # Read GET or POST form into $buffer
 	 if    ($ENV{'REQUEST_METHOD'} eq 'POST') { read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'}); }
  	elsif ($ENV{'REQUEST_METHOD'} eq 'GET')  { $buffer = $ENV{'QUERY_STRING'}; }

  	@pairs = split(/&/, $buffer);				# Split into name/value pairs
  	foreach $pair (@pairs) {		
	($name, $value) = split(/=/, $pair);		# split into $name and $value
    	$value =~ s/\+/ /g;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/~!/ ~!/g;
	$value =~ s/\n\r/\n/sg; # <br>
	$value =~ s/\[\]//g;
	$value =~ tr/+/ /;					# replace "+" with " "
    	$value =~ s/%([A-F0-9]{2})/pack("C", hex($1))/egi;	# replace %hex with char
	$value =~ s/@/\@/sg;
	$$name = $value;
    	}

  	return %hash;

}
