#!/usr/bin/perl
$|=1; 
############################################################################
#                                                                          #
# Application  : arguest.cgi                                               #
# Description  : Argala GuestBook Script                                   #
# Version      : 1.00                                                      #
# Created      : 7th February 2000                                         #
# Last Updated : 17th March 2000                                           #
#                                                                          #
# Copyright (c) 2000 Argala.com All rights reserved.                       #
# WWW    : http://www.argala.com                                           #
# Email  : webmaster@argala.com                                            #
#                                                                          #
############################################################################

require "cgi-lib.pl";
require "arguest.cfg";
require "config.pl";

if (-e "custom.pl") {
  require "custom.pl";
}

# script url
$guestbook_url = "arguest.cgi";

# Guestbook count file
$countfile     = "$guestbookdata_path/guestcount.dat"; 

# Guestbook data file
$guestbook_datafile = "$guestbookdata_path/guestbook.dat"; 	

# Guestbook html files
$inputform_file = "$guestbookdata_path/guestform.htm";
$display_file   = "$guestbookdata_path/display.htm";
$thankyou_file  = "$guestbookdata_path/thankyou.htm";

$db{'num'}      = 0;
$db{'name'}     = 1;
$db{'email'}    = 2;
$db{'city'}     = 3;
$db{'state'}    = 4;
$db{'country'}  = 5;
$db{'url'}      = 6;
$db{'date'}     = 7;
$db{'howfound'} = 8;
$db{'message'}  = 9;
$db{'ipaddr'}   = 10; 
        
@inputform_variables = (        
         "|$name_text|name|30|100|",
         "|$email_text|email_address|30|100|",
         "|$city_text|city|30|100|",
         "|$state_text|state|30|100|",
         "|$country_text|country|30|100|",
         "|$url_text|url|30|100|http://|",
         "SELECT|$howfound_text|howfound|",         
         "SELECT|$private_message_text|private|",   
         "MESSAGE|$message_text|message|6|30|",     
         "HIDDEN|action|submit|",
         "SUBMIT|$submit_text|"                  
);  

&read_form;
  
$action = $fields{'action'};
$page = $fields{'page'};

if ($page eq '') {
  $page = '0';
}

if ($action eq 'form'){   
   &createform;
   exit;
}
elsif ($action eq 'submit') {

   &validation;
   &construct_entry;
   &send_emails;
   if ($fields{'private'} ne "YES") { 
      &update_entry;
   }     
   &thankyou;
   exit;
}
elsif ($field{'action'} eq '' || $field{'action'} eq 'display'){
   &display;
   exit;
}


# functions

sub send_emails{

$comment = $fields{'message'};
$comment =~ s/~nl~/\r\n/g;

$reply_email = qq~
Hi $fields{'name'},

$reply_message

\n
~;

$reply_email .= &format_text($name_text, 30)     . ":     $fields{'name'}\n";
$reply_email .= &format_text($email_text, 30)    . ":     $fields{'email_address'}\n";
$reply_email .= &format_text($city_text, 30)     . ":     $fields{'city'}\n";
$reply_email .= &format_text($state_text, 30)    . ":     $fields{'state'}\n";
$reply_email .= &format_text($country_text, 30)  . ":     $fields{'country'}\n";
$reply_email .= &format_text($url_text, 30)      . ":     $fields{'url'}\n";
$reply_email .= &format_text($howfound_text, 30) . ":     $fields{'howfound'}\n";
$reply_email .= qq~
$message_text  :     
$comment
~;
  
  if ($fields{'email_address'} ne "" && $send_to_signer) {  
     &send_mail("$from_email", "$fields{'email_address'}", "$email_subject", "$reply_email");
  }    

  if ($notify) {
     &send_mail("$from_email", "$notify_email", "$email_subject", "$reply_email");  
  }

}


sub read_form {

  $i=0;
  if ( $ENV{'REQUEST_METHOD'} eq "GET"){ 
     $temp=$ENV{'QUERY_STRING'};
  }
  else { 
     read(STDIN,$temp,$ENV{'CONTENT_LENGTH'});
  }                                          
  
  @pairs=split(/&/,$temp);
  
  foreach $item(@pairs){
  
    ($key,$content)=split(/=/,$item,2);
    $content=~tr/+/ /;
    $content=~s/%(..)/pack("c",hex($1))/ge;
    
    #strip comments to prevent server side include calls
    
    $content =~ s/<!--(.|\n)*-->//g;

    $content=~ s/\r\n/~nl~/g;    

    if ($content ne "form"){     
       foreach $censored_word (@censored_words) {                                                
          $content =~ s/\b$censored_word\b/\*\*\*/gi;
       }                                                    
    }   
    
    if ($allow_html eq "") {    
      $content =~ s/<([^>]|\n)*>//g;
      $fields{$key}=$content;      
    }
    else {
       $tocheck = $content;
       $fields{$key}=$content;        
       &check_html;
    }    
  }
}

sub validation {

   local($invalid_email) = 0;
   
   foreach $line (@required_fields) { 
      if ($fields{$line} eq "") {                        
           $required_field{$line} = qq~<FONT COLOR="$alert_color">$required_text</FONT>~;                     
      }   
   }
   
   # check email address
   if ($fields{'email_address'} ne ""){   
      $testmail = $fields{'email_address'};    
      if ($testmail =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/ || $testmail !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) {
         $invalid_email = 1;
      }
   }   

   if (%required_field != 0 || $invalid_email) {
      &createform;
      exit;
   }
       
}

sub thankyou {

  open (THANKYOU_HTML,"$thankyou_file") || &CgiDie ("Cannot open $thankyou_file file");
  @thankyou_html = <THANKYOU_HTML>;
  close (THANKYOU_HTML);

  print "Content-type: text/html\n\n";
  $thankyou_text = "<FONT FACE=\"$inputform_font\"><B><center>$thankyou_text<br><a href=\"$guestbook_url\">$view_guestbook_text</a></center></B></FONT>";
  foreach $line(@thankyou_html) {
    $line =~ s/#THANKYOU#/$thankyou_text/gi;
    print $line;
  }

}

sub update_entry{
   
   $guestbook_count = 1;
   
   &get_file_lock("update_guestbook.lock");
   
   if (-e $countfile) {
   
      open (COUNT,"$countfile")|| &CgiDie ("Cannot open $countfile file");
      $guestbook_count = <COUNT>;
      close (COUNT);
      $guestbook_count++;
   }
      
   $line = $guestbook_count . "|" . $page_entry;
   $line .= "\n";
      
   open  (GUESTBOOKDATA,">>$guestbook_datafile")|| &CgiDie ("Cannot open Guestbook Database");
   print GUESTBOOKDATA "$line";
   close (GUESTBOOKDATA);
   
   open (COUNT, ">$countfile")|| &CgiDie ("Cannot open $countfile file");
   print COUNT "$guestbook_count";
   close (COUNT);
   
   &release_file_lock("update_guestbook.lock");
   
}

sub createform {

  local($form_html);

  $form_html = &display_inputform;

  open (INPUT_HTML,"$inputform_file") || &CgiDie ("Cannot open $inputform_file file");
  @inputform_html = <INPUT_HTML>;
  close (INPUT_HTML);

  print "Content-type: text/html\n\n";

  foreach $line(@inputform_html) {
    $line =~ s/#GUESTBOOK_FORM#/$form_html/gi;
    print $line;
  }

}

sub display {

  local($message_html);

  $message_html = &display_message;

  open (DISPLAY_HTML,"$display_file") || &CgiDie ("Cannot open $display_file file");
  @display_html = <DISPLAY_HTML>;
  close (DISPLAY_HTML);

  print "Content-type: text/html\n\n";

  foreach $line(@display_html) {
    $line =~ s/#DISPLAY_FORM#/$message_html/gi;
    print $line;
  }

}

sub display_message {

  local($message_html);

  if(-e $guestbook_datafile) {
  
  open (DATA, "$guestbook_datafile") || &CgiDie ("Cannot open $guestbook_datafile");  
  open (COUNT,"$countfile")|| &CgiDie ("Cannot open count file");
  $count = <COUNT>;
  $count ++;
  close (COUNT);  
  @data = <DATA>;  
  if ($lifo) {
    @data = reverse(@data);
    $tmp = $previous_text;
    $previous_text = $next_text;
    $next_text = $tmp;
  }  
  close (DATA);
  
  }
  
  foreach $line (@data) {
  
     @message_fields = split(/\|/,$line);
    
     $num = $message_fields[$db{'num'}];
     $mess = $message_fields[$db{'message'}];

     $num ++;
     if ($lifo) {
        $anum = $count - $num + 1; 
        $anum ++;
     } 
     else {
        $anum = $num ;
     }
     
     $d = ($page + 1) * $viewperpage + 1;
     
     if ($page ne '0' && !$previous_flag){
         $previous_flag = 1;         
         $nav_prev = "[<a href=\"$guestbook_url?page=".($page-1)."\">$previous_text<\/a>]";                  
     }
     
     if ($d < $count && $d ne '' && !$flag){
         $flag = 1;
         $nav_next .= "[<a href=\"$guestbook_url?page=". ($page+1)."\">$next_text<\/a>]";
     }
     
     if ($lifo){
        $nav = "$nav_next$nav_prev<br><br>";
     }
     else {
        $nav = "$nav_prev$nav_next<br><br>";
     }
          
     if (($flag || $previous_flag) && !$nav_flag ) {  
       $nav_flag = 1;
       $message_html =  qq~<center><FONT FACE="$display_font" SIZE="$display_fontsize">$nav</font></center>~;     
     }  

     if ($anum > ($d - $viewperpage) && $anum <= $d ) {
     
       $entry_html .= "<tr><td>";
       $entry_html .= &print_entry;
       $entry_html .= "</td></tr>";
       
     }
     
  }

  $message_html .= 
  qq~
  
  <center>
  <table border=1 bgcolor="$display_bgcolor">
  <tr bgcolor="$display_header_bgcolor">
  <td>
  
  <center>
  <FONT FACE="$display_font" color="$display_header_color"><B>$guestbook_header_text</B></font><BR>
  <a href="$guestbook_url?action=form"><FONT FACE="$display_font" color="$display_header_color"><b>$sign_guestbook_text</b></font></a>
  <br><br>
  </center>
  </td>
  </tr>
  $entry_html
  ~;
  
  $message_html .= qq~
  </table>
  </center>
  ~;
  $message_html .=  qq~<BR><center><FONT FACE="$display_font" SIZE="$display_fontsize">$nav</font></center>~;     

}

sub print_entry {

$num--; 

$mess =~ s/~nl~/<br>/g;        

return qq~
<center>
<TABLE WIDTH="$display_table_width" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR="$display_bgcolor">
<TR>
 <TD WIDTH=$display_col_width1><FONT FACE="$display_font" SIZE="$display_fontsize">Message No. :</FONT></TD>
 <TD WIDTH=$display_col_width2><FONT FACE="$display_font" SIZE="$display_fontsize"> $num</FONT></TD></TR>
<TR> 
<TR>
 <TD WIDTH=$display_col_width1><FONT FACE="$display_font" SIZE="$display_fontsize">$name_text :</FONT></TD>
 <TD WIDTH=$display_col_width2><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'name'}] \&nbsp</FONT></TD></TR>
<TR> 
 <TD WIDTH=$display_col_width1 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$email_text :</FONT></TD>
 <TD WIDTH=$display_col_width2 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'email'}] \&nbsp</FONT></TD></TR>
<TR> 
 <TD WIDTH=$display_col_width1 ><FONT FACE="$display_font" SIZE="$display_fontsize">$city_text :</FONT></TD>
 <TD WIDTH=$display_col_width2><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'city'}] \&nbsp</FONT></TD></TR>
<TR> 
 <TD WIDTH=$display_col_width1 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$state_text :</FONT></TD>
 <TD WIDTH=$display_col_width2 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'state'}] \&nbsp</FONT></TD></TR>
<TR> 
 <TD WIDTH=$display_col_width1 ><FONT FACE="$display_font" SIZE="$display_fontsize">$country_text :</FONT></TD>
 <TD WIDTH=$display_col_width2><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'country'}] \&nbsp</FONT></TD></TR> 
<TR> 
 <TD WIDTH=$display_col_width1 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$url_text :</FONT></TD>
 <TD WIDTH=$display_col_width2 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'url'}] \&nbsp</FONT></TD> </TR>
<TR> 
 <TD WIDTH=$display_col_width1 ><FONT FACE="$display_font" SIZE="$display_fontsize">$date_text :</FONT></TD>
 <TD WIDTH=$display_col_width2><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'date'}] \&nbsp</FONT></TD></TR>
<TR> 
 <TD WIDTH=$display_col_width1 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$howfound_text :</FONT></TD>
 <TD WIDTH=$display_col_width2 BGCOLOR="$altrow_bgcolor"><FONT FACE="$display_font" SIZE="$display_fontsize">$message_fields[$db{'howfound'}] \&nbsp</FONT></TD></TR>
<TR> 
 <TD BGCOLOR="#FFFFFF" COLSPAN=2><I><FONT FACE="$display_font" SIZE="$display_fontsize">$message_text :</FONT></I><BR><P><FONT FACE="$display_font" SIZE="$display_fontsize">$mess \&nbsp</FONT></P></TD> </TR>
</TABLE>

~;

}

sub get_file_lock {

  local ($lock_file) = @_;
  local ($endtime);
  $endtime = 50;
  $endtime = time + $endtime;

  while (-e $lock_file && time < $endtime){
    sleep(1);
  }

  open(LOCK_FILE, ">$lock_file") || &CgiDie ("Could not open the lock file");
  if($flock) {
     flock(LOCK_FILE, 2);
  }
  
} 

sub release_file_lock{
  local ($lock_file) = @_;
  if($flock) {
     flock(LOCK_FILE, 8);
  }
  close(LOCK_FILE);
  unlink($lock_file);
} 


sub display_inputform {

  local($form_html);

  $form_html = qq~
  <CENTER>
  <FORM METHOD="POST" ACTION="$guestbook_url">  
  <TABLE WIDTH="$input_table_width" BORDER=0 BGCOLOR="$inputform_bgcolor">
  <TR>
  <TD VALIGN=MIDDLE>

  <CENTER>

  <FONT COLOR="$inputform_header_color" FACE="$inputform_header_font">
  <B>$invite_sign_text</B></FONT><BR>
  <a href="$guestbook_url"><b><FONT COLOR="$inputform_header_color" FACE="$inputform_header_font">$view_guestbook_text</FONT></b></a><br><br>    
  </CENTER>

  <CENTER>
  <TABLE BGCOLOR="#CCE6FF" CELLPADDING=1 CELLSPACING=1 BORDER=1 WIDTH=100%>
  ~;
       
  foreach $line(@inputform_variables) {

     @form_fields = split(/\|/,$line);
     
     $required_mark = "";   
     
     foreach $req_field(@required_fields) {        
        if( $form_fields[2] eq $req_field) {     
          $required_mark = "*";
          last;
        }
        else {
          $required_mark = "";
        }                               
     }
   
     if ($fields{$form_fields[2]} ne "") {
        $form_fields[5] = $fields{$form_fields[2]};
        $form_fields[5] =~ s/~nl~/\n/g;                
     }
     
     if ($invalid_email && $form_fields[2] eq "email_address" ) {        
        $bad_email_address = qq~<BR><FONT COLOR="$alert_color">$invalid_email_address_text</FONT>~;        
     }
     else {
        $bad_email_address = "";
     }
      
     if ($invalid_html && $form_fields[2] eq "message") {
       $bad_html = qq~<BR><FONT COLOR="$alert_color">$invalid_html_text</FONT>~;        
     }
     else {
       $bad_html = "";     
     }
          
     if ($form_fields[0] eq "") {
   
       $form_html .= qq~
       <TR>
       <TD WIDTH=$input_col_width1><FONT FACE="$inputform_font" SIZE="$inputform_fontsize">$form_fields[1] $required_mark $required_field{$form_fields[2]} $bad_email_address $bad_html</FONT></TD>
       <TD WIDTH=$input_col_width2><FONT FACE="$inputform_font" SIZE="$inputform_fontsize"><INPUT NAME="$form_fields[2]" TYPE="TEXT" SIZE="$form_fields[3]" MAXLENGTH="$form_fields[4]" VALUE="$form_fields[5]"></FONT></TD>
       </TR>
       ~; 
    
     }
   
     if ($form_fields[0] eq "MESSAGE") {
    
       $form_html .= qq~
       <TR>
       <TD VALIGN=TOP WIDTH=$input_col_width1><FONT FACE="$inputform_font" SIZE="$inputform_fontsize">$form_fields[1] $required_mark $required_field{$form_fields[2]} $bad_html</FONT></TD>
       <TD WIDTH=$input_col_width2><FONT FACE="$inputform_font" SIZE="$inputform_fontsize"><TEXTAREA NAME="$form_fields[2]" WRAP=VIRTUAL ROWS="$form_fields[3]" COLS="$form_fields[4]">$form_fields[5]</textarea></FONT></TD>
       </TR>
       ~;
     }
   
     @display_list = "";
     
     if ($form_fields[0] eq "SELECT") {
                 
       if ($form_fields[2] eq "howfound") {            
          @display_list = @howfound_list;            
       }
       elsif($form_fields[2] eq "private"){
          @display_list = @private_list;        
       }
        
       if (@display_list) {       
          $form_html .= qq~
          <TR>
          <TD WIDTH=$input_col_width1><FONT FACE="$inputform_font" SIZE="$inputform_fontsize">$form_fields[1] $required_mark $required_field{$form_fields[2]}</FONT></TD>
          <TD WIDTH=$input_col_width2><FONT FACE="$inputform_font" SIZE="$inputform_fontsize">
          <SELECT NAME="$form_fields[2]">
          ~;
         
          foreach $display_line (@display_list){                                 
              
             @display_fields = split(/\|/,$display_line);                           
             
             if ($form_fields[5] ne "") {
                if ($form_fields[5] eq "$display_fields[0]") {                
                  $display_fields[1] = "SELECTED";
                }                  
                else {
                  $display_fields[1] = "";
                }                
             }
             
             $form_html .= qq~
             <OPTION VALUE="$display_fields[0]" $display_fields[1]>$display_fields[0]</OPTION>
             ~;                                        
          }
           
          $form_html .= qq~
          </FONT>          
          </SELECT>          
          </TD>
          </TR> 
          ~;                                    
       }               
     }

     if ($form_fields[0] eq "HIDDEN") {
         $form_html .= qq~
         <INPUT TYPE="HIDDEN" NAME="$form_fields[1]" VALUE="$form_fields[2]">
         ~;      
     }

     if ($form_fields[0] eq "SUBMIT") {
         $form_html .= qq~
         <TR>
         <TD COLSPAN=2><CENTER>
         <INPUT TYPE="SUBMIT" VALUE="$form_fields[1]">
         </TD>
         </TR>
         ~;      
     }

  }

  $form_html .=qq~
  </TABLE>
  </TD>
  </TR>
  </TABLE>
  </FORM>
  ~;
  
  return $form_html;

}

sub get_date {

  local ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst,$date);
  local (@days, @months);
 
  @days   = ('Sunday','Monday','Tuesday','Wednesday','Thursday',
             'Friday','Saturday');
  @months = ('January','February','March','April','May','June','July',
             'August','September','October','November','December');

  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

  if ($hour < 10) { 
    $hour = "0$hour"; 
  }
  if ($min < 10) { 
    $min = "0$min"; 
  }
  if ($sec < 10) {
    $sec = "0$sec";
  }
  
  $year = 1900 + $year;

  $date = "$days[$wday], $months[$mon] $mday, $year at $hour\:$min\:$sec";
  return $date;

}

sub construct_entry{

  local($date);
  
  $email_address = $fields{'email_address'};
  if ($convert_email == 1 ) {
    $email_address =~ s/\./_dot_/g;
    $email_address =~ s/\@/_at_/g;
  }
  $date = &get_date; 
  $page_entry = "$fields{'name'}|$email_address|$fields{'city'}|$fields{'state'}|$fields{'country'}|<A HREF=\"$fields{'url'}\">$fields{'url'}</A>";
  $page_entry = $page_entry . "|$date|$fields{'howfound'}|$fields{'message'}|$ENV{'REMOTE_ADDR'}";

}

sub format_text{   
   local($text , $len) = @_;   
   local($format_text);   
   $format_text = $text . substr( (" " x $len) ,length($text));   
   return $format_text;
}

sub real_send_mail {

    local($fromuser, $fromsmtp, $touser, $tosmtp, 
      $subject, $messagebody) = @_;

    open (MAIL, "|$mailprog -t") ;
    print MAIL <<__END_OF_MAIL__;
To: $touser
From: $fromuser
Subject: $subject

$messagebody

__END_OF_MAIL__

    close (MAIL);

} 

sub send_mail {

    local($from, $to, $subject, $messagebody) = @_;

    local($fromuser, $fromsmtp, $touser, $tosmtp);

    $fromuser = $from;
    $touser = $to;

    $fromsmtp = (split(/\@/,$from))[1];
    $tosmtp = (split(/\@/,$to))[1];

    &real_send_mail($fromuser, $fromsmtp, $touser, $tosmtp, $subject, $messagebody);

}

sub check_html {

$quote_count=0;
$left_count=0;
$right_count=0;

for ($i=0;$i<length($tocheck);$i++){

  $tc= substr($tocheck,$i,1);
  if ($tc eq "\"") {$quote_count++;}
  if ($tc eq "<") {$left_count++;}
  if ($tc eq ">") {$right_count++;}
  
}

if ( (($left_count % 2) != 0) || (($right_count % 2) != 0) 
    || (($quote_count % 2) != 0)) {
    
     $invalid_html = 1;
     
     print "Content-type: text/html\n\n";
     
     &createform;

     exit;
     
  }
  
}
