#!/usr/bin/perl
$|=1;
############################################################################
#                                                                          #
# Application  : admin.cgi                                                 #
# Description  : Configure Argala GuestBook Script                         #
# Version      : 1.00                                                      #
# Created      : 7th February 2000                                         #
# Last Updated : 17th March 2000                                           #
#                                                                          #
# Copyright (c) 2000 Argala.com All rights reserved.                       #
# WWW    : http://www.argala.com                                           #
# Email  : webmaster@argala.com                                            #
#                                                                          #
############################################################################

require "../arguest.cfg";
require "$guestbook_path/cgi-lib.pl";
require "$guestbook_path/config.pl";

$custom_file = "$guestbook_path/custom.pl";

if (-e "$custom_file"){
   require "$custom_file"; 
}

$script_url = "admin.cgi";

$fontface         = "verdana, arial, helvetica";
$fontface_button  = "courier new,courier";

$menu_bgcolor          = "#3399FF";
$menu_header_bgcolor   = "#CCFFCC";
$menu_header_textcolor = "#0000FF";

$fontcolor  = "#FFFFFF";
$fontcolor1 = "#000000";
$fontsize   = 2;
$fontsize_small = "-1";

if ($flock == 1){
  $flock_radio_yes = "CHECKED";
  $flock_radio_no  = "";
}
else{
  $flock_radio_yes = "";
  $flock_radio_no  = "CHECKED";
}

if ($lifo == 1){
  $lifo_radio_yes = "CHECKED";
  $lifo_radio_no  = "";
}
else{
  $lifo_radio_yes = "";
  $lifo_radio_no  = "CHECKED";
}

if ($allow_html == 1){
  $allow_html_radio_yes = "CHECKED";
  $allow_html_radio_no  = "";
}
else{
  $allow_html_radio_yes = "";
  $allow_html_radio_no  = "CHECKED";
}

if ($convert_email == 1){
  $convert_email_radio_yes = "CHECKED";
  $convert_email_radio_no  = "";
}
else{
  $convert_email_radio_yes = "";
  $convert_email_radio_no  = "CHECKED";
}

if ($notify == 1){
  $notify_radio_yes = "CHECKED";
  $notify_radio_no  = "";
}
else{
  $notify_radio_yes = "";
  $notify_radio_no  = "CHECKED";
}

if ($send_to_signer == 1){
  $send_to_signer_radio_yes = "CHECKED";
  $send_to_signer_radio_no  = "";
}
else{
  $send_to_signer_radio_yes = "";
  $send_to_signer_radio_no  = "CHECKED";
}

# configure selection

$config_button{'guestbook_cfg'} = 1;

@config_variables = (
                      "guestbook_cfg|Configure|Configure email address, shipping methods and payment methods etc."
                    );
                    
@mainmenu_variables = (
                       "Press the 'Configure' button to configure Argala Guestbook.|configure_guestbook|Configure"
                    );

@form_variables = (  	      
         "SECTION|Argala Guestbook.",         
         "sendmail program system path|mailprog|40||$mailprog",
         "OPTION|If your system supports flock() function, please select 'Yes', otherwise select 'No'?|flock|1,0|$flock_radio_yes,$flock_radio_no|Yes,No",                  
         "SELECT|No. of entries per page|viewperpage|$viewperpage",                                    
         "OPTION|Would you like to show the entries in Last In First Out order?|lifo|1,0|$lifo_radio_yes,$lifo_radio_no|Yes,No",
         "OPTION|Would you like to allow signer to enter HTML?|allow_html|1,0|$allow_html_radio_yes,$allow_html_radio_no|Yes,No",
         "CHECKBOX|Please select which fields are required.|required_fields|Name=name,Email=email_address,City=city,State=state,Country=country,URL=url,How found=howfound,Message=message",         
         "OPTION|Would you like to convert email address to avoid spam?|convert_email|1,0|$convert_email_radio_yes,$convert_email_radio_no|Yes,No",
         "OPTION|Would you like to receive email when someone signed your guestbook?|notify|1,0|$notify_radio_yes,$notify_radio_no|Yes,No",                           
         "|notify_email|30||$notify_email|Your Email Address",         
         "OPTION|Would you like to send email to the signers after they signed the guestbook?|send_to_signer|1,0|$send_to_signer_radio_yes,$send_to_signer_radio_no|Yes,No",         
         "Please indicate who this email will be from |from_email|30||$from_email|",         
         "|email_subject|30||$email_subject|Email Subject",                  
         "TEXTBOX|Email Content|reply_message|6|40|$reply_message",
         "TEXTBOX|Censored words (please enter the censored words line by line)|censored_words|10|40|$censored_words",                  
         "Sign Up Table Width|input_table_width|5|5|$input_table_width",                      
         "Sign Up First Column Width|input_col_width1|5|5|$input_col_width1",                      
         "Sign Up Second Column Width|input_col_width2|5|5|$input_col_width2",                        
         "Invite Sign Up Text|invite_sign_text|40||$invite_sign_text",                           
         "Name Text|name_text|40||$name_text",
         "Email Text|email_text|40||$email_text",
         "City Text|city_text|40||$city_text",
         "State Text|state_text|40||$state_text",
         "Country Text|country_text|40||$country_text",
         "URL Text|url_text|40||$url_text",
#         "Private Message Text|private_message_text|40|$private_message_text",
         "How Text|howfound_text|40||$howfound_text",         
         "Please enter the following fields such that your visitors can select how they hear you.|howfound_list1|40||$howfound_list1",         
         "|howfound_list2|40||$howfound_list2",         
         "|howfound_list3|40||$howfound_list3",         
         "|howfound_list4|40||$howfound_list4",         
         "|howfound_list5|40||$howfound_list5",         
         "|howfound_list6|40||$howfound_list6",         
         "|howfound_list7|40||$howfound_list7",         
         "|howfound_list8|40||$howfound_list8",         
         "|howfound_list9|40||$howfound_list9",         
         "|howfound_list10|40||$howfound_list10",                                     
         "Message Text|message_text|40||$message_text",         
         "Date Text|date_text|40||$date_text",
         "Submit Button Caption|submit_text|40||$submit_text",         
         "Previous Text|previous_text|40||$previous_text",
         "Next Text|next_text|40||$next_text",                                      
         "Sign Up Form Font|inputform_font|40||$inputform_font",                           
         "SELECT|Sign Up Form Font Size|inputform_fontsize|$inputform_fontsize",                                    
         "Sign Up Form Header Font|inputform_header_font|40||$inputform_header_font",         
         "Sign Up Form Background Color (e.g. #660000)|inputform_bgcolor|10|7|$inputform_bgcolor",         
         "Sign Up Form Header Color (e.g. #999999)|inputform_header_color|10|7|$inputform_header_color",
         
         "Guestbook Table Width|display_table_width|5|5|$display_table_width",                      
         "Guestbook First Column Width|display_col_width1|5|5|$display_col_width1",                      
         "Guestbook Second Column Width|display_col_width2|5|5|$display_col_width2",                                        
         "Guestbook Header Text|guestbook_header_text|40||$guestbook_header_text",                                        
         "Sign Up Form Link Text|sign_guestbook_text|40||$sign_guestbook_text",                                        
                  
         "Guestbook Font|display_font|40||$display_font",                           
         "SELECT|Guestbook Font Size|display_fontsize|$display_fontsize",                                    
         "Guestbook Background Color (e.g. #999999)|display_bgcolor|10|7|$display_bgcolor",
         "Guestbook Header Background Color (e.g. #6699CC)|display_header_bgcolor|10|7|$display_header_bgcolor",         
         "Guestbook Header Font Color (e.g. #6699CC)|display_header_color|10|7|$display_header_color",         
         "Alternate Row Color (e.g. #FFFFCC)|altrow_bgcolor|10|7|$altrow_bgcolor",         
         "Thank You Text|thankyou_text|40||$thankyou_text",                                      
         "View Guestbook Text|view_guestbook_text|40||$view_guestbook_text",                                      
         "Required Field Text|required_text|40||$required_text",                  
         "Alert Color (e.g. #FF0000)|alert_color|10|7|$alert_color",         
         "Invalid Email Address Message|invalid_email_address_text|40||$invalid_email_address_text",                  
         "Invalid HTML Message|invalid_html_text|40||$invalid_html_text",                           
         );                  
         
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($FORM{$name}) { $FORM{$name} = $FORM{$name}.",".$value; }
	else { $FORM{$name} = $value; }
      $value =~ s/<!--(.|\n)*-->//g;
}

@path_variables = (            
      "$guestbook_path/arguest.cgi|erx",
      "$guestbook_path/arguest.cfg|er",
      "$guestbook_path/cgi-lib.pl|er",
      "$guestbook_path/config.pl|er",            
      "$guestbookdata_path/guestform.htm|er",
      "$guestbookdata_path/display.htm|er",
      "$guestbookdata_path/thankyou.htm|er",                  
);
                     
if ($FORM{'verify'}) {

  &html_header_config("Argala Guestbook Configuration");
  
  $is_path_ok = &validate;     
 
  if ( $is_path_ok ne "") {     
     &error_message;      
  }
  else {       
     &verify($config_button{'guestbook_cfg'});        
  }   
}
elsif ($FORM{'update'}) {
  &html_header_config("Argala Guestbook Configuration");  
  &update($config_button{'guestbook_cfg'});
}
elsif ($FORM{'configure_guestbook'}) {
  &html_header_config("Argala Guestbook Configuration");    
  &config_form($config_button{'guestbook_cfg'});
}
else {
  &html_header_config("Argala Guestbook Main Menu");
  &main_menu;
}

&html_footer_config;

exit;



# functions

sub config_form{

local($choice) = @_;

local($check);

local($section_count);

print qq~
<FORM METHOD=POST ACTION="$script_url">
<TABLE BORDER="0" WIDTH=100%>
~;

&menu_table_header(0);

foreach $line(@form_variables){

   @form_fields = split(/\|/,$line);
   
   if ($form_fields[0] eq "SECTION") {
     $section_count ++;
   }
   
   if ($section_count != $choice){
      next;
   }
      
   $form_fields[4] =~ s/>/&gt;/gi;
  
   if($form_fields[0] eq "SECTION"){           
       print qq~
       <TR BGCOLOR="$menu_header_bgcolor">
       <TD COLSPAN=2 ALIGN=CENTER>
       <FONT FACE="$fontface" COLOR="$menu_header_textcolor">
       <FONT SIZE=+1><B>Argala Guestbook</B></FONT><BR>
       <B>Please answer the following questions about <BR>$form_fields[1]</B>
       </FONT>
       </TD>
       </TR>
       ~;
   }
   elsif($form_fields[0] eq "OPTION"){           
              
       ($yes[0], $no[0]) = split(/\,/,$form_fields[3]);
       ($yes[1], $no[1]) = split(/\,/,$form_fields[4]);
       ($yes[2], $no[2]) = split(/\,/,$form_fields[5]);
       print qq~
       <TR>
       <TD COLSPAN=2 ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>
       <TD WIDTH=30%>\&nbsp</TD>
       <TD>
       <INPUT TYPE=radio NAME="$form_fields[2]" VALUE="$yes[0]" $yes[1]><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$yes[2]</FONT>\&nbsp <INPUT TYPE=radio NAME="$form_fields[2]" VALUE="$no[0]" $no[1]><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$no[2]</FONT> \&nbsp 
       </TD>
       </TR>
       ~;
   }
   elsif($form_fields[0] eq "SELECT"){
       print qq~
       <TR>
       <TD colspan=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>
       <TD colspan=2>
       <center>
       <SELECT NAME="$form_fields[2]">
       ~;
       
       if ($form_fields[2] eq "display_fontsize") {        
          for($i = -7 ; $i <= 7 ; $i ++) {          
             if ($display_fontsize == $i) {
               $select_mark = "SELECTED";
             }
             else {
               $select_mark = "";
             }  
             
             if ($i > 0 ) {
               $j = "+".$i;
             }
             else {
               $j = $i;
             }         
             
             print qq~
             <OPTION VALUE="$j" $select_mark>$j</OPTION>
             ~;       
          }
       }   

       if ($form_fields[2] eq "inputform_fontsize") {        
          for($i = -7 ; $i <=7 ; $i ++) {          
             if ($inputform_fontsize == $i) {
               $select_mark = "SELECTED";
             }
             else {
               $select_mark = "";
             }  

             if ($i > 0 ) {
               $j = "+".$i;
             }    
             else {
               $j = $i;
             }         
             print qq~             
             <OPTION VALUE="$j" $select_mark>$j</OPTION>
             ~;       
          }
       }   
       
       if ($form_fields[2] eq "viewperpage") {        
          for($i = 1 ; $i <=50 ; $i ++) {          
             if ($viewperpage == $i) {
               $select_mark = "SELECTED";
             }
             else {
               $select_mark = "";
             }  
             print qq~
             <OPTION VALUE="$i" $select_mark>$i</OPTION>
             ~;       
          }       
       
       }
       
       print qq~
       </SELECT>
       </center>
       </TD>
       </TR>
       ~
   }   
   elsif($form_fields[0] eq "TEXTBOX"){
       print qq~
       <TR>
       <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>
       <TD COLSPAN=2 ALIGN=CENTER>
       <TEXTAREA NAME="$form_fields[2]" ROWS="$form_fields[3]" COLS="$form_fields[4]">$form_fields[5]</TEXTAREA>
       </TD>
       </TR>
       ~
   }
   elsif($form_fields[0] eq "CHECKBOX"){
       
       @req_names = split(/\,/,$form_fields[3]);
       
       print qq~
       <TR>
       <TD VALIGN=TOP><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       <TD>
       ~;
       
       $i = 0;
       foreach $req_name(@req_names) {
          
          $i ++;          
          ($cc1, $cc2) = split(/\=/,$req_name);  
          
          $check_ccname = "";
          foreach $tmp_ccname(@required_fields) {
              
              ($tmp_cc1, $tmp_cc2) = split(/\=/,$tmp_ccname);  
              if ($cc2 eq $tmp_cc1){
                $check_ccname = "CHECKED";
                last;
              }                            
          }
                  
          print qq~<INPUT TYPE=CHECKBOX NAME="$cc2" $check_ccname><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$cc1</B></FONT><BR>~;
         
       }
       
       print qq~
       </TD>
       </TR>
       ~;
       
   }
   else{              

       $tab_width = 100;
              
       if ($form_fields[0] eq ""){
          print qq~
          <TR>
          <TD WIDTH=$tab_width ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=-1><INPUT TYPE=TEXT NAME="$form_fields[1]" SIZE="$form_fields[2]" VALUE="$form_fields[4]"></FONT>
          </TD>
          </TR>
          ~;       
       }
       else {
          print qq~
          <TR>
          <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[0]</B></FONT></TD>
          </TR>
          <TR>
          <TD WIDTH=$tab_width ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=-1><INPUT TYPE=TEXT NAME="$form_fields[1]" SIZE="$form_fields[2]" VALUE="$form_fields[4]"></FONT>
          </TD>
          </TR>
          ~;
       }    
   }
}

print qq~
<TR>
<TD COLSPAN=2 ALIGN=CENTER>
<INPUT TYPE=HIDDEN VALUE="$FORM{'configure'}" NAME="config_choice">
<BR><FONT FACE="$fontface_button" SIZE="$fontsize_small">
<INPUT TYPE=SUBMIT VALUE="Verify" NAME="verify">\&nbsp <INPUT TYPE=RESET>
</FONT></TD> 
</TR>
~;

&menu_table_footer(2);

print qq~
</FORM>
~;

}

sub verify{

local($choice) = @_;
local($section_count);

&menu_table_header(0);

foreach $line(@form_variables){

   @form_fields = split(/\|/,$line);

   if ($form_fields[0] eq "SECTION") {
     $section_count ++;
   }
   
   if ($section_count != $choice){
      next;
   }

   if($form_fields[0] eq "SECTION"){           
          
       print qq~
       <TR BGCOLOR="$menu_header_bgcolor">
       <TD COLSPAN=2 ALIGN=CENTER>
       <FONT FACE="$fontface" COLOR="$menu_header_textcolor">
       <FONT SIZE=+1><B>Argala Guestbook</B></FONT><BR>       
       <B>$form_fields[1]</B></FONT>
       </TD>
       </TR>
       ~;       
       
   }
   elsif($form_fields[0] eq "OPTION"){           

       print qq~
       <TR>
       <TD COLSPAN=2 ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>       
       ~;
       
       if ($FORM{$form_fields[2]} == 1){         
         print qq~
         <TR>
         <TD COLSPAN=2 ALIGN=CENTER>
         <TABLE BORDER COLS=1 WIDTH="20%" BGCOLOR="#FFFFFF" >
         <TR>
         <TD ALIGN=CENTER><FONT FACE="$fontface" SIZE=$fontsize COLOR="$fontcolor1"><B>Yes</B></FONT></TD>
         </TR>
         </TABLE>         
         </TD>
         </TR>
         ~;
       }
       else {
         print qq~
         <TR>
         <TD COLSPAN=2 ALIGN=CENTER>

         <TABLE BORDER COLS=1 WIDTH="20%" BGCOLOR="#FFFFFF" >
         <TR>
         <TD ALIGN=CENTER><FONT FACE="$fontface" SIZE=$fontsize COLOR="$fontcolor1"><B>No</B></FONT></TD>
         </TR>
         </TABLE>         

         </TD>
         </TR>
         ~;       
       }            
       
   }
   elsif($form_fields[0] eq "SELECT"){
 
       $FORM{$form_fields[2]} =~ s/</\&lt;/gi;
       $FORM{$form_fields[2]} =~ s/>/\&gt;/gi;       
       
       print qq~
       <TR>
       <TD COLSPAN=2 ALIGN=LEFT>
       <TABLE CELLSPACING=0 CELLPADDING=0>
       <TR>
       <TD COLSPAN=2>
       <FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT>
       </TD>
       </TR>
       <TR>
       <TD COLSPAN=2 ALIGN=CENTER>
       <TABLE BORDER COLS=1 WIDTH="50%" >
       <TR>
       <TD ALIGN=CENTER BGCOLOR="#FFFFFF" ><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{"$form_fields[2]"}</B></FONT>\&nbsp 
       </TD>
       </TR>
       </TABLE>                           
       </TD>
       </TR>
       </TABLE>
       </TD>               
       </TR>
       ~;    
   }   
   elsif($form_fields[0] eq "TEXTBOX"){
 
       $FORM{$form_fields[2]} =~ s/</\&lt;/gi;
       $FORM{$form_fields[2]} =~ s/>/\&gt;/gi;             
       
       print qq~
       <TR>
       <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>       
       <TD COLSPAN=2 ALIGN=CENTER>
               
       <TABLE BORDER COLS=1 WIDTH="70%" BGCOLOR="#FFFFFF" >
       <TR>
       <TD ALIGN=LEFT><PRE><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{$form_fields[2]}</B></FONT></PRE>\&nbsp</TD>
       </TR>
       </TABLE>                           
       
       </TD>
       </TR>
       ~;
   
   }
   elsif($form_fields[0] eq "CHECKBOX"){
      
       if ($FORM{"name"} ) {
            $cc_checked .= "Name<BR>\n";
       }

       if ($FORM{"email_address"} ) {
            $cc_checked .= "Email<BR>\n";
       }
       
       if ($FORM{"city"} ) {
            $cc_checked .= "City<BR>\n";
       }

       if ($FORM{"state"} ) {
            $cc_checked .= "State<BR>\n";
       }
       
       if ($FORM{"country"} ) {
            $cc_checked .= "Country<BR>\n";
       }

       if ($FORM{"url"} ) {
            $cc_checked .= "URL<BR>\n";
       }

       if ($FORM{"howfound"} ) {
            $cc_checked .= "How found<BR>\n";
       }

       if ($FORM{"message"} ) {
            $cc_checked .= "Message<BR>\n";
       }

   }   
   else{       
 
       $FORM{$form_fields[1]} =~ s/</\&lt;/gi;
       $FORM{$form_fields[1]} =~ s/>/\&gt;/gi;       
 
       if ($form_fields[0] eq ""){
          print qq~
          <TR>
          <TD WIDTH=40% ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD>
          <TABLE BORDER COLS=1 WIDTH="70%" BGCOLOR="#FFFFFF" >
          <TR>
          <TD ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{$form_fields[1]}</B> \&nbsp</FONT></TD>
          </TR>
          </TABLE>                                              
          </TD>
          </TR>
          ~;       
       }
       else {
          print qq~
          <TR>
          <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[0]</B></FONT></TD>
          </TR>
          <TR>
          <TD ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD>          
          <TABLE BORDER COLS=1 WIDTH="70%" BGCOLOR="#FFFFFF" >
          <TR>
          <TD ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{$form_fields[1]}</B> \&nbsp </FONT></TD>
          </TR>
          </TABLE>                                               
          </TD>
          </TR>
          ~;
       }           
   }
}

print qq~<FORM METHOD=POST ACTION="$script_url">~;

@fields = sort(keys(%FORM));

foreach $field(@fields){       
    if($field eq "verify" || $field eq "config_choice"){ 
       next;
    }    

    $FORM{$field} =~ s/</\&lt;/gi;
    $FORM{$field} =~ s/>/\&gt;/gi;
    $FORM{$field} =~ s/"/\%22/gi;

    print qq~
    <INPUT TYPE=HIDDEN VALUE="$FORM{$field}" NAME="$field">
    ~;       
}

print qq~
<TR>
<TD COLSPAN=2 ALIGN=CENTER>
<INPUT TYPE=HIDDEN VALUE="$FORM{'config_choice'}" NAME="update_choice">
<CENTER><FONT FACE="$fontface_button" SIZE="$fontsize_small">
<INPUT TYPE=SUBMIT VALUE="Update" NAME="update">
</FONT><CENTER>
</FORM>
</TD> 
</TR>
~;

&menu_table_footer(2);

}

sub update{
  
  local($choice) = @_;
  
  @fields = sort(keys(%FORM));
  
  local($variables);

  local($howfound_list);
  local($required_fields);
  
  $variables = "";
  
  $howfound_list = "";
    
  $required_fields = "";
          
  foreach $field(sort @fields){     
    
    if ($field eq "update" || $field eq "update_choice") {        
        next;
    }    
                
    if ( ($field eq "howfound_list1") || ($field eq "howfound_list2") || ($field eq "howfound_list3")
         || ($field eq "howfound_list4") || ($field eq "howfound_list5") 
         || ($field eq "howfound_list6") || ($field eq "howfound_list7") 
         || ($field eq "howfound_list8") || ($field eq "howfound_list9") 
         || ($field eq "howfound_list10") ) {
         
        if ($FORM{"$field"} ne "") {            
            $howfound_list .= "'" . $FORM{"$field"} . "'," ;            
        }             
    }

    if ( ($field eq "name") || ($field eq "email_address") || ($field eq "city") || ($field eq "state")
         || ($field eq "country") || ($field eq "url") || ($field eq "howfound") 
         || ($field eq "message") ) {

       if ($field eq "name") {
          $required_fields .= '"name",';  
       }
         
       if ($field eq "email_address") {
          $required_fields .= '"email_address",';  
       }

       if ($field eq "city") {
          $required_fields .= '"city",';         
       }

       if ($field eq "state") {
          $required_fields .= '"state",';         
       }

       if ($field eq "country") {
          $required_fields .= '"country",';         
       }
       
       if ($field eq "url") {
          $required_fields .= '"url",';         
       }
       
       if ($field eq "howfound") {
          $required_fields .= '"howfound",';         
       }                    

       if ($field eq "message") {
          $required_fields .= '"message",';         
       }                    
       
    }         
    
    if ($field eq "censored_words") {
       @censored_list = split(/\r\n/,$FORM{'censored_words'});
       foreach $line(@censored_list) {
             $line =~ s/ //gi;
             if ($line ne "") {
                $censored_list .= '"'. "$line".'",';         
             }
       };

    }    
            
    $FORM{$field} =~ s/'/\\'/gi; 
    $variables .= qq~\$$field = '$FORM{$field}';\n~;      
    
  }
  
  chop($required_fields);    
  $variables .= qq~\@required_fields = ( $required_fields );\n~;
  
  chop($howfound_list);
  $variables .= qq~\@howfound_list = ( $howfound_list );\n~;
  chop($censored_list);
  $variables .= qq~\@censored_words = ( $censored_list );\n~;
     
  $variables =~ s/\&lt;/</gi;
  $variables =~ s/\&gt;/>/gi;  
  $variables =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  
  if (-e "$custom_file") {
     open (CUSTOM_TEXT, "$custom_file")|| cgidie("Can't read $custom_file");
     @lines = <CUSTOM_TEXT> ;
     close (CUSTOM_TEXT);     
  }   

  open (CUSTOM_TEXT, ">$custom_file")|| cgidie("Can't write $custom_file");
  
  $is_new_section = 1;
      
  foreach $line(@lines) {
     
     if ($line =~ /1\;/i ) {
        next;
     }
          
     if ($line =~ /\#\#\#\#$FORM{'update_choice'}-start/i ) {
        $section_start = 1;               
        $is_new_section = 0;
        print CUSTOM_TEXT "####$FORM{'update_choice'}-start\n";        
     }                 

     if ($line =~ /\#\#\#\#$FORM{'update_choice'}-end/i ) {              
        print CUSTOM_TEXT $variables;       
        $section_start = 0;               
     }
     
     if ($section_start == 1) {
        next;
     }
     else{            
        print CUSTOM_TEXT $line;            
     }            
  }
  
  if(@lines == 0 || $is_new_section == 1) {
     print CUSTOM_TEXT "####$FORM{'update_choice'}-start\n";
     print CUSTOM_TEXT $variables;       
     print CUSTOM_TEXT "####$FORM{'update_choice'}-end\n";         
  }  
  print CUSTOM_TEXT "1;\n";     
  close (CUSTOM_TEXT);     
  &main_menu;      
}

sub html_header_config{
   
   local($title) = @_;
   local($warning) ;

   ($ENV{'REMOTE_USER'} or $ENV{'AUTH_USER'}) ? ($warning = '') :
   ($warning = '<h1><blink><FONT COLOR=#FF0000>WARNING: ADMIN Directory is not Password Protected!</FONT></blink></h1>');

   print "Content-type: text/html\n\n";
   print "<HTML>\n";
   print "<HEAD><TITLE>$title</TITLE></HEAD>\n";   
   print qq~
   <body text="#000000" BGCOLOR="#CCFFFF" link="#0000EE" vlink="#0000FF" alink="#FF0000">
   <center>$warning</center>    
   ~;
}

sub html_footer_config{    
   print "</BODY></HTML>\n";   
}

sub copyright_link{
   print qq~
   <FONT FACE="$fontface" COLOR="$menu_header_textcolor" SIZE=-1><B>Copyright &copy; <A HREF="http://www.argala.com">Argala.com</a> 2000 All rights reserved</B></FONT>
   ~;
}
  
sub validate{
  
  local($path_error);
  
  foreach $path_variable(@path_variables){     
      ($path_name,$path_right) = split(/\|/,$path_variable);      
      $path_error .= &check_path($path_name, $path_right);   
  }
  
  if(not &isnumeric($FORM{"input_table_width"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Sign Up Table Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  

  if(not &isnumeric($FORM{"input_col_width1"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Sign Up Table Column 1 Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  

  if(not &isnumeric($FORM{"input_col_width2"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Sign Up Table Column 2 Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  

  if(not &isnumeric($FORM{"display_table_width"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Guestbook Table Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  

  if(not &isnumeric($FORM{"display_col_width1"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Guestbook Table Column 1 Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  

  if(not &isnumeric($FORM{"display_col_width2"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Guestbook Table Column 2 Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  
        
  return $path_error;
}

sub check_path {
    
  local($path, $rights) = @_;

  local($out);
  
  if ($rights =~ /e/i) { # exist
    if (!(-e $path)) {
      $out .= qq~
      <TR><TD>      
      <FONT FACE="$fontface" color="$fontcolor"><B>$path does not exist.</B></FONT></TD>
      </TR>
      ~;
    } 
  }

  if ($rights =~ /r/i) { # read
    if (!(-r $path)) {
      $out .= qq~
      <TR><TD>
      <FONT FACE="$fontface" color="$fontcolor"><B>Can't read from $path </B></FONT></TD>
      </TR>
      ~;
    } 
  }

  if ($rights =~ /w/i) { # write
    if (!(-w $path)) {
      $out .= qq~
      <TR><TD>
      <FONT FACE="$fontface" color="$fontcolor"><B>Can't write from $path </B></FONT></TD>
      </TR>
      ~;
    } 
  }

  if ($rights =~ /x/i) { # execute
    if (!(-x $path)) {
      $out .= qq~
      <TR><TD>
      <FONT FACE="$fontface" color="$fontcolor"><B>Can't execute from $path </B></FONT></TD>
      </TR>
      ~;      
    } 
  } 
  
  return $out;
} 

sub error_message {
      
      &menu_table_header(0);
      
      print qq~
      <TR BGCOLOR="$menu_header_bgcolor">
      <TD ALIGN=CENTER>
      <FONT FACE="$fontface" COLOR="$menu_header_textcolor">
      <FONT SIZE=+1><B>Argala Guestbook</B></FONT><BR>       
      <B>Error(s)</B></FONT>
      </TD>
      </TR>
      ~;            
      
      print "$is_path_ok";      
      &menu_table_footer(1);
      
      print qq~
      <CENTER>
      <FORM>
      <INPUT TYPE=BUTTON VALUE="  Go Back  " onClick="history.go(-1)">
      </FORM>
      </CENTER>
      ~;
}

sub menu_table_header {
  
  local($border) = @_;    
  print qq~
  <center>
  <TABLE WIDTH="550" BORDER="1" CELLSPACING="0" CELLPADDING="0" BORDERCOLOR="#666633" ALIGN="CENTER">
  <TR>
  <TD>
  <TABLE BORDER="$border" CELLSPACING="0" CELLPADDING="5" WIDTH="100%" BGCOLOR="$menu_bgcolor">
  ~;  
}

sub menu_table_footer {  
  local($colspan) = @_;  
  print qq~
  <TR BGCOLOR="$menu_header_bgcolor">
  <TD COLSPAN=$colspan ALIGN=CENTER>
  ~;
  &copyright_link;
  print qq~  
  </TD>
  </TR>  
  </TABLE>
  </TD>
  </TR>
  </TABLE>
  </CENTER>
  ~;
}

sub main_menu {
        
  &menu_table_header(1);
    
  print qq~
  <tr BGCOLOR="$menu_header_bgcolor">
  <TD colspan=2 align=center><FONT FACE="$fontface" COLOR="$menu_header_textcolor" SIZE=+1><B>Argala Guestbook Main Menu</B></FONT></td>
  </tr>
  ~;

  foreach $line(@mainmenu_variables){
     @form_fields = split(/\|/,$line);
     print qq~  
     <FORM METHOD=POST ACTION="$script_url">               
     <TR>
     <TD ALIGN=LEFT VALIGN=TOP><FONT FACE="$fontface" SIZE=$fontsize COLOR="$fontcolor">
     <B>$form_fields[0]</B>
     </FONT>
     </TD>
     <TD ALIGN=CENTER VALIGN=TOP>
     <FONT FACE="$fontface_button" SIZE="$fontsize_small">
     <INPUT TYPE=HIDDEN NAME="configure"        VALUE="guestbook_cfg">     
     <INPUT TYPE=SUBMIT NAME="$form_fields[1]"  VALUE="$form_fields[2]">
     </FONT>
     </TD>
     </TR>  
     </FORM>
     ~;     
  }  
  &menu_table_footer(2);
}

sub isnumeric {

   local($in) = @_;
   local($i);
   local($count);   
   local($out) = 0;
   
   for($i = 0; $i < length($a) ; $i++) {  
      if ( substr($in , $i , 1) eq ".") {
      $count ++;
      } 
   }
   if ($count > 1) {
      $out = 0;
   }
   else {
      $in =~ s/\.//gi;
      if (not $in =~ /\D/) {
         $out = 1;
      }   
      else {
        $out = 0;
      }
   }   
   return $out;   
}
