use CGI;

use CGI qw/:standard :html3/, shortcuts, a, escapeHTML, standard, html2;
use CGI::Carp qw(fatalsToBrowser);
use English;

$query = new CGI;
$query->import_names('ARG');

$thisScript=$0;
if ($thisScript =~ /(.*)\/(.*)/) {
  $directory=$1;
  $scriptName=$2;
} else {
  $directory=".";
  $scriptName=$thisScript;
}

################################################################
# Default templates                                            #
################################################################

$templateTxt = '
<html>
<head><title>Guestbook</title></head>
<body bgcolor=#ffffff>
<h1>Welcome to ${username}\'s guestbook</h1>

<table bgcolor=#000000 noborder cellpadding=1 cellspacing=0><tr><td>

<table noborder bgcolor=#c0ffc0 cellpadding=0 cellspacing=0><tr><td>
<form action="${scriptname}" method=post>
<table noborder>
<tr>
 <td colspan=2 align=center>
 <b><font size=+2 color=#c03030><u>Sign my guestbook</u></font></b>
 </td>
</tr>
<tr>
 <td align=right><b>Your Name</b></td>
 <td><input type=text size=60 name=fullname></td>
</tr>
<tr>
 <td align=right><b>Your E-Mail</b></td>
 <td><input type=text size=60 name=email></td>
</tr>
<tr>
 <td colspan=2><b>Your message:</b></td>
</tr>
<tr>
 <td colspan=2><textarea name=body cols=78 rows=10></textarea></td>
</tr>
<td>
<tr colspan=2><td>
<input type=submit value="Sign the guestbook">
</td></tr>
</table>
<input type=hidden name=op value=post>
</form>
</body>

</td></tr></table>
</td></tr></table>

<table bgcolor=#ffffff border=0 cellpadding=0 cellspacing=0 width=90%>

BEGIN_MESSAGES

<tr><td colspan=2>&nbsp;</td></tr>

<tr><td width=0%>
<table bgcolor=#000000 border=0 cellpadding=2 cellspacing=0 width=100%><tr><td>
<table bgcolor=e0e0ff border=0 cellspacing=0 cellpadding=3 width=100%>
<tr><td><b>From:</b></td><td align=left nowrap width=100%>${fullname}</td></tr>
<tr><td><b>E-mail:</b></td><td algin=left nowrap>${email}</td></tr>
<tr><td><b>Date:</b></td><td align=left nowrap>${date}</td></tr>
</table></td></tr></table>

</td><td width=100%>&nbsp;</td></tr>

<tr><td colspan=2>
<table bgcolor=#000000 border=0 cellpadding=2 cellspacing=0 width=100%><tr><td>
<table bgcolor=#f8f8ff width=100% border=0 cellspacing=0 cellpadding=3><tr><td>
${body}</td></tr></table>
</td></tr></table>

END_MESSAGES

</td></tr></table>

</body></html>
';

$guestBook = "$directory/guestbook.txt";


if (defined $template) {
  $templateFile = $template;
} elsif (-f "$directory/guestbook-template.html") {
  $templateFile = "$directory/guestbook-template.html";
}

if(defined $templateFile) {
  open(IN, "$templateFile") || 
    die "Could not open $templateFile ($ERRNO)\n";
  $templateTxt = join("", <IN>);
  close(IN);
}

# Read /etc/passwd to get Unix user id
open(PASSWD, "</etc/passwd");
while(<PASSWD>) {
  @line = split(":");
  if ($line[2] eq $UID) {
    $uid = $line[0];
    if (!defined $username) {
      $username = $line[4];
      if ($username eq "") {
	$username = $uid;
      } else {
	$username =~ s/,.*//g;
      }
    }
  }
}
close(PASSWD);

if (!defined $mail) {
  $mail = "$uid";
}

$templateTxt =~ s/\$\{username\}/$username/ge;
$templateTxt =~ s/\$\{scriptname\}/$scriptName/ge;

if ($templateTxt !~ /(.*)BEGIN_MESSAGES(.*)END_MESSAGES(.*)/s) {
  die "No message text\n";
}

$headerTxt   = $1;
$msgTemplate = $2;
$footerTxt   = $3;

################################################################
# End of default templates                                     #
################################################################


################################################################
# Get messages that have been posted so far                    #
################################################################
sub getMessages {
  my ($header, $msgBegun);
  my ($fullname, $email, $date, $body);
  if (! -f "$guestBook") {
    return ();
  }

  open (IN, "<$guestBook") || 
    die "Could not open $guestBook ($ERRNO)\n";
  my @messages = ();

  $header=1;
  $msgBegun=0;
  while(<IN>) {
    chomp;
    if ($header) {
      if (!$msgBegun) {
	$msgBegun=1;
      }
      if (/^Date: (.*)/) {
	$date = $1;
	next;
      }
      
      if (/^E-mail: (.*)/) {
	$email = $1;
	next;
      }

      if (/^IP: (.*)/) {
	$ip = $1;
	next;
      }

      if (/^From: (.*)/) {
	$fullname = $1;
	next;
      }
      
      if (/^$/) {
	$header = 0;
	next;
      }
    } else {
      if (/^\.$/) {
	$body =~ s/\n+$//g;
	unshift (@messages, {body=>$body, 
			     email=>$email,
			     date=>$date,
			     ip=>$ip,
			     fullname=>$fullname});
	$header = 1;
	$msgBegun=0;
	undef $date;
	undef $email;
	undef $fullname;
	$body="";
      } else {
	if (/^\.(\.*)$/) {
	  $_ = $1;
	}
	$body .= $_ . "\n";
      }
    }
  }
  close(IN);
  return @messages;
}

################################################################
# Guestbook locking                                            #
################################################################
$LOCK_SH = 1;
$LOCK_EX = 2;
$LOCK_NB = 4;
$LOCK_UN = 8;

if ($ARG::op eq "post") {
  ################################################################
  # Post a message                                               #
  ################################################################

  if ($ARG::fullname eq "" && $ARG::email eq "") {
    if (-f "$directory/whoru.html") {
      print $query->redirect("whoru.html");
    } else {
      print header;
      print "<html><head><title>Guestbook error</title></head><body bgcolor=\#ffffff><h1><center>Guestbook Error</center></h1>You need supply your name or your e-mail address</body></html><br>\n";
      print "<a href=\"$scriptName?read\">Click here to try again</a>\n";
      print "</html></body>\n";
    }
    exit(0);
  }

  $date = localtime();

  open(OUT, ">>$guestBook") ||
    die "Could not open $guestBook\n";
  flock OUT, $LOCK_EX;

  print OUT "Date: $date\n";

  if ($mail ne "") {
    open(PIPE, "|/usr/sbin/sendmail $mail");
    if ($ARG::email ne "") {
      $from = "$ARG::fullname".($ARG::fullname ne "" ? " ":"")."<$ARG::email>";
    } else {
      $from = "Guestbook Manager <root\@localhost>";
    }
    $from =~ s/[\r\n]+/ /g;
    print PIPE "To: $mail\n";
    print PIPE "From: $from\n";
    print PIPE "Subject: New Guestbook entry\n";
    print PIPE "\nA new entry has been added to your guestbook:\n\n";
    print PIPE "Date: $date\n";
    print PIPE "Ip: $ENV{REMOTE_ADDR}\n";
  }

  if (defined $ARG::fullname) {
    $ARG::fullname =~ s/[\r\n]+/ /g;
    print OUT "From: $ARG::fullname\n";
    if ($mail ne "") {
      print PIPE "From: $ARG::fullname\n";
    }
  }

  if (defined $ARG::email) {
    $ARG::email =~ s/[\r\n]+/ /g;
    print OUT "E-mail: $ARG::email\n";
    if ($mail ne "") {
      print PIPE "E-mail: $ARG::email\n";
    }
  }

  print OUT "IP: $ENV{REMOTE_ADDR}\n";
  print OUT "\n";

  $body = $query->escapeHTML($ARG::body);
  $body =~ s/\r\n?/\n/g;

  if ($mail ne "") {
    print PIPE "\n$body\n";
    close(PIPE);
  }

  foreach $line (split("\n", $body)) {
    if ($line =~ /^(\.+)$/) {
      $line = ".$line";
    }
    print OUT "$line\n";
  }
  print OUT ".\n";
  flock OUT, $LOCK_UN;
  close(OUT);

  #&Lock::unlock("$file");
  if (-f "$directory/thanks.html") {
    print $query->redirect("thanks.html");
  } else {
    print $query->redirect("$scriptName?op=read");
  }
  print "\n";
} else {  
  ################################################################
  # Display the messages                                         #
  ################################################################
  print
    $query->header;
  print $headerTxt;

  @messages=getMessages();

  foreach $message (@messages) {
    $text = $msgTemplate;

    if($message->{fullname} ne "") {
      $maillink = $message->{fullname};
    } else {
      $maillink = $message->{email};
    }
    $maillink = $query->escapeHTML($maillink);
    if ($message->{email}) {
      $maillink = "<a href=\"mailto:".$query->escape($message->{email}).
	"\">$maillink</a>";
    }


    $text =~ s/\$\{(date|email|fullname|ip)\}/$query->escapeHTML($message->{$1})."&nbsp;"/ge;
    $text =~ s/\$\{maillink\}/$maillink/ge;
    $message->{body} =~ s/\n/<br>\n/g;
    $text =~ s/\$\{body\}/$message->{body}/ge;
    print $text;
  }

  print $footerTxt;
}  

1;
