#!/usr/bin/perl
# 
# ezmbgen.$cgi - EZ Message Board Generator - by Manny Juan <manny@jps.net> 10/20/00
# http://www.inet-images.com/manny/mb
#
# this program was adapted from ezhomepg by manny juan
#
# This will give your visitors the opportunity to set up a wwwboard message board
# at your site. the generated board page uses ezwboard.$cgi, modified version of
# matt wright's wwwboard.pl script and ezwadmin.$cgi, modified version of wwwadmin.pl
# for maintaining the board
#
#####################################################################################
$cgi="pl";
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<([^>]|\n)*>//g;
    $FORM{$name} = $value;
    }

######################################################################################
# set variables HERE

$win95=0;

# Set this to your base HTML directory. This is a PATH not a URL
# $base_dir = "/home/htdocs/your.isp.com/website/mb";
# $base_dir = "../webpages/mb";
$base_dir = "/iiw/htdocs/www.inet-images.com/manny/mb";

# $cgiurl = "http://www.isp.com/website/cgi-bin";
# $cgiurl = "/cgi-bin";
$cgiurl = "http://www.inet-images.com:8080/manny/cgi-bin";

# This is your URL of where the new HTML pages will be kept 
# $baseurl = "http://www.isp.com/website/mb";
# $baseurl = "/mb";
$baseurl = "http://www.inet-images.com/manny/mb";

# This is a URL and dir for the images sub directory in the userpages directory.
# Create the images directory in the userpages directory.
$imageurl = $baseurl;

# This is the path for user pages. You don't really need to change this
# Just make sure to create a directory: userpages and chmod it 777
$page_dir = "$base_dir/";

# This is the index list of all generated message boards
# $indexpage = "../webpages/mb/index.html";
$indexpage = "/iiw/htdocs/www.inet-images.com/manny/mb/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$users = "$base_dir/users.txt";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$nextmsg = "board1.txt";


#Site title

$title="EZ Message Board Mall";

# self explanatory variables for your site logo
$logo = "$imageurl/mjmall.jpg";
$logoalt = "Cyber Mall";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'manny@jps.net';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

# Lets do some translating first
$updact = $FORM{'updact'};
$usrname = $FORM{'usrname'};
$retlink=$FORM{'retlink'};
$login = $FORM{'login'};
$email = $FORM{'email'};
$pagename = $FORM{'pagename'};
$adminpwd=$FORM{'adminpwd'};
$font_face=$FORM{'font_face'};
$font_size=$FORM{'font_size'};
$yourmail=$email;
$replymail=$FORM{'replymail'};
$maxthreads=$FORM{'maxthreads'};
$max=$FORM{'max'};
$max_reply=$FORM{'max_reply'};
$html=$FORM{'html'};
$require_name=$FORM{'require_name'};
$require_subject=$FORM{'require_subject'};
$require_email=$FORM{'require_email'};
$boardname=$FORM{'boardname'};
$colorset=$FORM{'colorset'};
$flock=$FORM{'flock'};
$usemylogo=$FORM{'usemylogo'};
$mylogo=$FORM{'mylogo'};

$pagename=~s/\W//g;
$adminpwd=~s/\W//g;

# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$pagename =~ s/ /_/g;

if ($FORM{'action'} eq "New Page") {
    &newpage;
    }
if ($FORM{'action'} eq "Create Page") {
    &create;
    }
if ($FORM{'action'} eq "Edit Page") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "Delete Page") {
    &confirm("delete");
    }
    exit;

sub newpage {
    $adminpwd="";
    $html="0";
    $require_subject="1";
    $maxthreads="100";
    $max="10";
    $max_reply="20";
    $colorset='#00ffff,#ff0000,#0737EB,#ffffff,#A4A4EB,#B8B8FB,#CCCCFF,#0C0C4C';
    $font_face="Arial";
    $font_size="3";
    $replymail="1";
    $retlink="http://";
    $mylogo="http://";
    $usemylogo=0;
    
    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Create Your Own Message Board</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Create Your Own Message Board</h2></font></p>\n";
    print "<p>Below is an empty form for you to fill in. The next five fields (<b>bold</b>) are required.\n";
    print "You can edit any part of your page later</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezmbgen.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"action\" value=\"Create Page\">\n";
    print "<b>Your name:</b>";
    print "<font size=\"-1\">(will appear in page as link to your email)</font><br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "<h3>(The next 4 fields will be used for editing - REMEMBER THEM!)</h3>\n";
    print "<b>Login Id:</b>\n";
    print "<font size=\"-1\">(one word only you should know, used later for editing)</font><br>\n";
    print "<input type=text size=40 name=\"login\" value=\"$login\"><br><br>\n";
    print "<b>Your e-mail:</b>\n";
    print "<font size=\"-1\">(used for editing, will also appear in page)</font><br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "<b>Your page:</b>\n";
    print "<font size=\"-1\">(one word, will become the name of your message board)</font><br>\n";
    print "<input type=text size=40 name=\"pagename\" value=\"$pagename\"><br><br>\n";
    print "<b>Admin Password:</b>";
    print "<font size=\"-1\">(enter a one-word administrator's password)</font>";
    print "<br><input type=password size=20 name=\"adminpwd\" value=\"$adminpwd\"><br><br>\n";
    print "<br><b>Message Board Title:</b>\n";
    print "<font size=\"-1\">(title of message board - will also be listed in index)</font><br>\n";
    print "<input type=text size=40 name=\"boardname\" value=\"$boardname\"><br>\n";
    print "<br><b>Logo (Optional):</b><br>";
    &prt_ckb($usemylogo, 'usemylogo', 'use my logo.  URL:');
    print "<input type=text size=40 name=\"mylogo\" value=\"$mylogo\"><br><br><br>\n";

    &build_form_content;
    print "<P><input type=submit value=\"create page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub create {

    # Now, lets do some error checking. Making sure they filled out each field
    &missing(missing_name) unless $usrname;
    &missing(missing_email) unless $email;
    &missing(missing_pagename) unless $pagename;

    # if they try to name their page "index" This will stop them
    if (uc($pagename) eq "INDEX") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
        print "<p>You cannot name your page <b>index</b>\n";
        print "Please go back and re-name your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }
    # if they Don't give their page a boardname This will stop them
    if ($boardname eq "") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>You MUST give your page a <b>message board title</b>\n";
        print "Please go back and enter one for your page</p>\n";
        exit;
        }

    # if the user tries to name their page 
    # something that is already taken
    # this should stop them - it's a check for directory-present
    if (-d "$base_dir/$pagename") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>The page name: <b>$pagename</b>\n";
        print "is already taken.\n";
        print "Please go back and rename your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }
    &chk_maxthreads;
    &chk_max;
    &chk_max_reply;

    # create the new directory for pagename
    umask(000);  # UNIX file permission junk
    mkdir("$base_dir/$pagename", 0777) unless (-d "$base_dir/$pagename");     

    # create the new directory for the messages of pagename
    umask(000);  # UNIX file permission junk
    mkdir("$base_dir/$pagename/messages", 0777) unless (-d "$base_dir/$pagename/messages");     

    # create the config file
    open (CFGFILE,">$base_dir/$pagename/myconfig.txt")||die "i can't open >$base_dir/$pagename/myconfig.txt";
    print CFGFILE "$usrname&&$retlink&&$font_face&&$font_size&&$yourmail&&$replymail&&$maxthreads&&$max&&$max_reply&&$html&&$require_name&&$require_subject&&$require_email&&$boardname&&$colorset&&$usemylogo&&$mylogo";
    close(CFGFILE);

    # create the next message file
    open (MSGNFILE,">$base_dir/$pagename/$nextmsg")||die "i can't open >$base_dir/$pagename/$nextmsg";
    print MSGNFILE "1";
    close(MSGNFILE);

    # Write the login name and email address to a separate file for confirmation
    # when they want to edit their page
    open (FILE, ">>$users") || die "I can't open >>$users\n";
    if($win95==0){flock (FILE, 2) or die "can't lock data file\n";}
    $cryptpwd=crypt($adminpwd,substr($adminpwd,0,2));
    print FILE "$login&&$email&&$pagename&&$cryptpwd\n";
    close(FILE);

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    # Now, re-open the links file, and add the new link
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file\n";}

    for ($a = 0; $a <= $sizelines; $a++) {

        $_ = $lines[$a];

        if (/<!--begin-->/) {

            print FILE "<!--begin-->\n";
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/mbview.pl?site=$pagename\">$boardname</a></font></p>\n";

        } else {
            print FILE $_;
            }
        }
    close(FILE);


    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";

    print "Your message board has been created, and you will receive an e-mail confirming this!\n";
    print "You can visit your message board by clicking ";
    print "<a href=\"$cgiurl/mbview.pl?site=$pagename\">here</a>\n";
    print "  The index page has been updated with this link.\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";


    # Send the user an e-mail confirming their page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your new URL on the $title\n";
    print MAIL "Your page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/mbview.pl?site=$pagename\n";
    print MAIL "\nlogin: $login";
    print MAIL "\nemail: $email";
    print MAIL "\npagename: $pagename";
    print MAIL "\nadminpwd: $adminpwd";
    print MAIL "\n\nPlease save this information for future reference.";
    print MAIL "\nThank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager - $myemail\n";
    close (MAIL);

    # Notify us when someone creates a page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $myemail\n";
    print MAIL "From: $usrname <$email>\n";
    print MAIL "Subject: $title New Page Report\n";
    print MAIL "$usrname created a new page:\n";
    print MAIL "$baseurl/$pagename\n";
    close(MAIL);

    }

sub recreate {
    &chk_maxthreads;
    &chk_max;
    &chk_max_reply;

    # Suck the index page, and update site name (in case it changed)
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and replace the index entry
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/$pagename\b/) {
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/mbview.pl?site=$pagename\">$boardname</a></font></p>\n";
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    # recreate the config file
    open (CFGFILE,">$base_dir/$pagename/myconfig.txt")||die "i can't open >$base_dir/$pagename/myconfig.txt";
    print CFGFILE "$usrname&&$retlink&&$font_face&&$font_size&&$yourmail&&$replymail&&$maxthreads&&$max&&$max_reply&&$html&&$require_name&&$require_subject&&$require_email&&$boardname&&$colorset&&$usemylogo&&$mylogo";
    close(CFGFILE);

    &ntfy_usr_edt;

    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Your message board has been revised, and you will receive an e-mail confirming this!\n";
    print "You can visit your message board by clicking ";
    print "<a href=\"$cgiurl/mbview.pl?site=$pagename\">here</a>\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    }

sub ntfy_usr_edt {
    # Send the user a notice that their page has been re-done
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your Changes on the $title\n";
    print MAIL "Your revised page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/mbview.pl?site=$pagename\n";
    print MAIL "\nOnce again thank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager\n";
    close (MAIL);
    }

sub chk_maxthreads {
    if (($maxthreads !~ /^(\d){1,3}$/)|($maxthreads>200)) {
        &input_error("invalid or unreasonable value for maximum threads (enter 1 to 200)");
        exit;
        }
    }
sub chk_max {
    if ($max !~ /^(\d){1,2}$/) {
        &input_error("invalid or unreasonable value for max threads per page (enter 1 to 99)");
        exit;
        }
    }
sub chk_max_reply {
    if ($max_reply !~ /^(\d){1,2}$/) {
        &input_error("invalid or unreasonable value for maximum replies per threads (enter 1 to 99)");
        exit;
        }
    }
sub chk_bad_maxdays {
    if ($maxdays !~ /^(\d){1,3}$/) {
        &input_error("invalid or unreasonable value for max retention days (enter 1 to 99)");
        exit;
        }
    }
sub chk_hexcolor {
    if ($maxthreads !~ /^[0-9a-fA-F]{6}$/) {
        &input_error("invalid color value, enter 6 hex digits");
        exit;
        }
    }
sub input_error {
    local ($errmsg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<h1>Input Error!</h1><h3>$errmsg.</h3>\n";
    print "<p>Please go back and correct</p>\n";
    }

# Standard error message for any missing required fields
sub missing {
    local ($missing) = @_;
    print "content-type: text/html\n\n";

    print "<HTML><head><TITLE>You missed something</TITLE></head>\n";
    print "<body>\n";
    &put_banner;    
    print "You forgot to fill in one of the fields. Please go back and make\n";
    print "sure that all required fields are filled in! $missing\n";
    print "</body></HTML>\n";
    exit;
    }

sub confirm {
    local ($updact) = @_;

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\"  border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p><h3>Please Enter your login name, e-mail and name of your file to $updact\n";
    print "<br>and the administrator's password</h3>";
    print "<form action=\"$cgiurl/ezmbgen.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<P><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Login name:<br>\n";
    print "<input size=40 type=text name=\"login\"><br>\n";
    print "E-mail:<br>\n";
    print "<input size=40 type=text name=\"email\"><br>\n";
    print "Name of your file:<br>\n";
    print "<input type=text size=40 name=\"pagename\"><br>\n";
    print "Admin Password:<br>\n";
    print "<input type=password size=40 name=\"adminpwd\"><br><br>\n";
    print "<input type=submit value=submit>\n";
    print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
    print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
    print "</FONT>\n";
    print "</form></body></html>\n";
    }

sub checkuser {
    open(FILE, "$users") || die "I can't open $users\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock users file\n";}
    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    ($loginname, $loginemail, $loginpagename, $logincrypt) = split(/&&/, $line);
    if($loginname eq "$login" && $loginemail eq "$email" 
    && $loginpagename eq "$pagename" && crypt($adminpwd,substr($logincrypt,0,2)) eq $logincrypt) {
        $match = 1;
        if($updact eq "edit") {
          &edit($loginpagename);
          }
        else {
          &delpage($loginpagename);
          }
        }
      }
    }

    close(FILE);
#    print "content-type: text/html\n\n";
#    print "storedpwd $logincrypt ";
#    print "computed " . crypt($adminpwd,substr($logincrypt,0,2));
#    print "match=" . (crypt($adminpwd,substr($logincrypt,0,2)) eq $logincrypt);

    if (! $match) {
        &error;
        }

    # del entry from data
    if($updact eq "delete") {

        # Suck the index page, and update it
        open(FILE, "$users") || die "I can't open that file $users\n";
        if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
            @lines = <FILE>;
            close(FILE);
            $sizelines = @lines;

        # Now, re-open the links file, and comment out the page to delete
        open(FILE, ">$users") || die "I can't open that file >$users\n";
        if($win95==0){flock (FILE,2) or die "can't lock index file for append\n";}
        chop;
            for ($a = 0; $a <= $sizelines; $a++) {
            $_ = $lines[$a];
            $w = $_;
            $w =~ s/\cM//g;
            $w =~ s/\n//g;
            ($loginname, $loginemail, $loginpagename, $logincrypt) = split(/&&/, $line);
            if($loginname eq "$login" && $loginemail eq "$email" 
            && $loginpagename eq "$pagename" && crypt($adminpwd,substr($logincrypt,0,2)) eq $logincrypt) {
              # do nothing  (ie. don't write)
              } 
            else {
              if($w eq "") {
                # do nothing (skip)
                }
              else {
                print FILE "$w\n";
                }
              }
            }
        close(FILE);
        print "content-type: text/html\n\n";
        print "<html><head><title>$updact Confirmation</title></head>\n";
        print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
        &put_banner; 
        print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
        print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
        print "<p>your page has been deleted";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        print "</form></body></html>\n";
      }
    }

sub edit {
    local ($pagename) = @_;
    # get the config file
    open(CFGFILE, "$base_dir/$pagename/myconfig.txt") || die "I can't open $base_dir/$pagename/myconfig.txt\n";
    if($win95==0){flock (CFGFILE, 1) or die "can't lock data file for edit\n";}
    $txrec=<CFGFILE>;
($usrname,$retlink,$font_face,$font_size,$yourmail,$replymail,$maxthreads,$max,$max_reply,$html,$require_name,$require_subject,$require_email,$boardname,$colorset,$usemylogo,$mylogo)=split('&&',$txrec);
    &build_edit_form;
    close(CFGFILE);
    }

sub delpage {
    local ($pagename) = @_;
    &deltree(0,"$base_dir/$pagename");

    # Suck the index page, and store entries in array
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, recreate the page but do not write the deleted page
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if (/$pagename\b/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    # Suck the users page, and store entries in array
    open(FILE, "$users") || die "I can't open that file $users\n";
    if($win95==0){flock (FILE, 1) or die "can't lock users file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, recreate the page but do not write the deleted page
    open(FILE, ">$users") || die "I can't open that file >$users\n";
    if($win95==0){flock (FILE, 2) or die "can't lock users file to delete entry\n";}
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if (/$pagename\b/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);
    }

sub deltree {
    local ($lvl, $dir) = @_;
    local @tnlist;
    opendir (TN, "$dir");
    rewinddir (TN);
    @tnlist =  grep(!/^\.\.?$/, readdir (TN));
    closedir (TN);
    foreach $tn (@tnlist) {
        if (-d "$dir/$tn") {
            $lvl++;
            &deltree($lvl,"$dir/$tn" );
            $lvl--;
            }
        else {
            $cnt=unlink("$dir/$tn");
#            print "<br>deleting $dir/$tn";
            }
        }
    rmdir ("$dir");
#    print "<br>removing $dir";
    }

sub build_edit_form {

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Edit Your Page</title></head>\n"; 
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";

    &put_banner; 
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Edit Your Page</h2></font></p>\n";
    print "<p>Below is a form with the contents\n";
    print "of the message board you created. You can edit any part of your board</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezmbgen.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"recreate\">\n";
    print "Your name:<br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "Your e-mail:<br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "Title of Message Board:<br>\n";
    print "<input type=text size=40 name=\"boardname\" value=\"$boardname\"><br><br>\n";
    print "</td></tr></table>\n";
    print "Name of Message Board: <b>$pagename</b><br><br>\n";
    print "<input type=hidden name=\"pagename\" value=\"$pagename\">\n";
    print "<br><b>Logo (Optional):</b><br>";
    &prt_ckb($usemylogo, 'usemylogo', 'use my logo.  URL:');
    print "<input type=text size=40 name=\"mylogo\" value=\"$mylogo\"><br><br><br>\n";

    &build_form_content;
    print "<P><input type=submit name=\"selection\" value=\"update page\">\n";
    print "<hr><font face=\"Arial, Geneva\"><h2>Manage Your Board</h2></font></p>\n";
    print "<b>Message Board Administration</b>";
    print "<br>To perform administration tasks, click&nbsp;";
    print "<a href=\"$cgiurl/mbadmin.pl?site=$pagename\">here</a>";
    print "</form>\n";
    print "</body></html>\n";
    }

sub build_form_content {

    print "<b>Select Preset Colors:</b>&nbsp;(will be applied to index page and new threads only)";
    print "<table width=\"25%\">";
    &put_clropt($colorset,'#00ffff,#ff0000,#0737EB,#ffffff,#A4A4EB,#B8B8FB,#CCCCFF,#0C0C4C');
    &put_clropt($colorset,'#efb07a,#fb0803,#9f1122,#ffffff,#ff3407,#df6e29,#f77a2e,#0C0C4C');
    &put_clropt($colorset,'#fff0ef,#ff03f4,#ff0f52,#ffffff,#ff7fa5,#ff4bf7,#0098ff,#000000');
    &put_clropt($colorset,'#fff99b,#3b0503,#8957ff,#ffffff,#a36e09,#cf8c0c,#ffac0e,#000000');
    &put_clropt($colorset,'#fba7d1,#734d60,#6a0173,#ffffff,#a3886f,#cfad8d,#f3cba5,#000000');
    &put_clropt($colorset,'#9f8d9a,#ff0000,#0c529f,#ffffff,#5e9f73,#73c38c,#8ff4af,#000000');
    &put_clropt($colorset,'#307AF3,#F31203,#3B3223,#ffffff,#55A318,#6ed31f,#83fb25,#000000');
    &put_clropt($colorset,'#ffc0c0,#ff0000,#0033e0,#ffffc0,#ff8040,#ffa040,#ffc040,#000000');
    &put_clropt($colorset,'#00FF00,#0000FF,#FF0000,#FFFFC0,#9980CC,#99A0CC,#99C0CC,#990000');
    &put_clropt($colorset,'#33CCFF,#000000,#FF0000,#FFFFFF,#FFB070,#00D070,#00FF80,#990000');
    &put_clropt($colorset,'#FFC0C0,#FF0000,#0033CC,#FFFFFF,#FF00C0,#FF66C0,#CCFFC0,#000000');
    &put_clropt($colorset,'#60C0F0,#000040,#006080,#FFFFFF,#FF0020,#FF6020,#FFC020,#000000');
    &put_clropt($colorset,'#ffeeff,#FF0020,#000066,#FFFFFF,#99cc99,#cce5cc,#99cc33,#000000');
    &put_clropt($colorset,'#FFE0E0,#FF00E0,#00406C,#FFFFFF,#20C040,#20C080,#20C0A0,#000000');
    &put_clropt($colorset,'#20F080,#C01050,#D02020,#FFFFFF,#6060C0,#6080C0,#60C0C0,#000000');
    &put_clropt($colorset,'#20B090,#2010FF,#C01050,#FFFFFF,#D07020,#D09020,#D0C020,#000000');
    print "</table>";

    print "<br><br><b>Font Face:</b>&nbsp;name of font to be used throughout the board (except titles)";
    print "<br><SELECT NAME=\"font_face\">";
    &put_opt($font_face,'Arial','Arial');
    &put_opt($font_face,'Courier New','Courier New');
    &put_opt($font_face,'Times New Roman','Times New Roman');
    &put_opt($font_face,'Comic Sans MS','Comic Sans MS');
    &put_opt($font_face,'Verdana','Verdana');
    print "\n</SELECT>";
    print "<br><br><b>Font Size:</b>&nbsp;size of font used throughout the board (except titles)";
    print "<br><SELECT NAME=\"font_size\">";
    &put_opt($font_size,'2','2');
    &put_opt($font_size,'3','3');
    &put_opt($font_size,'4','4');
    print "\n</SELECT>";
    print "<br><br><b>Require Name:</b><br>";
    &prt_ckb($require_name, 'require_name', 'name is required to post message');
    print "<br><br><b>Require Subject:</b><br>";
    &prt_ckb($require_subject, 'require_subject', 'subject is required to post message');
    print "<br><br><b>Require Email:</b><br>";
    &prt_ckb($require_email, 'require_email', 'email is required to post message');
    print "<br><br><b>Allow Reply Notice:</b><br>";
    &prt_ckb($replymail, 'replymail', 'allow users to be notified when someone posts a reply to a thread');
    print "<br><br><b>Allow HTML:</b><br>";
    &prt_ckb($html, 'allow_HTML', 'allow users to enter HTML in message body');
    print "<br><br><b>Max Threads:</b>&nbsp;&nbsp;maximum number of threads to keep on the board at all times<br>\n";
    print "<input type=text size=5 name=\"maxthreads\" value=\"$maxthreads\"><br>\n";
    print "<br><b>Threads Per Page:</b>&nbsp;&nbsp;maximum number of threads to display on one page<br>\n";\
    print "<input type=text size=5 name=\"max\" value=\"$max\"><br>\n";
    print "<br><b>Max Replies:</b>&nbsp;&nbsp;maximum number of replies allowed for a thread<br>\n";\
    print "<input type=text size=5 name=\"max_reply\" value=\"$max_reply\"><br>\n";

    print "\n<br><br><b>Return Link (URL):</b>link here when user clicks Return<br>\n";
    print "<input type=text size=50 name=\"retlink\" value=\"$retlink\"><br>\n";
    }

sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<INPUT TYPE=\"CHECKBOX\" NAME=\"$varname\" VALUE=\"1\"";
    if ($var eq "1") {print " CHECKED";} 
    print ">&nbsp;$ckbdesc";
    }

sub put_clropt  {
    local ($colorset, $colors)=@_;
    print "<tr><td rowspan=4 valign=top bgcolor=teal>\n<input type=radio name=\"colorset\" value=\"$colors\"";
    if ($colorset eq $colors) {print "checked";}
    print "></td>\n";
    ($c1,$c2,$c3,$c4,$c5,$c6,$c7,$c8)=split(',',$colors);
    print <<EOHTML;
<td bgcolor="$c1" colspan=2><font color="$c2"><b>title</b></font></td></tr>
<td bgcolor="$c3" colspan=2><font color="$c4">heading</font></td></tr>
<td bgcolor="$c5" rowspan=2><font color="$c8">author</font></td>
<td bgcolor="$c6"><font color="$c8">subject</font></td></tr>
<tr><td bgcolor="$c7"><font color="$c8">message</font></td>
</tr>
<tr><td colspan=3></td></tr>
EOHTML
#    print <<EOHTML;
#<td bgcolor="$c1"><font color="$c2"><b>title</b></font></td>
#<td bgcolor="$c3"><font color="$c4">heading</font></td>
#<td bgcolor="$c5"><font color="$c8">author</font></td>
#<td bgcolor="$c6"><font color="$c8">subject</font></td>
#<td bgcolor="$c7"><font color="$c8">message</font></td>
#</tr>
#EOHTML
    }

sub put_opt  {
    local ($inval, $id, $val)=@_;
    print "\n<OPTION VALUE=\"$val\"";
    if ($inval eq $val) {print " SELECTED";}
    print ">$id";
    }

sub error {
    local ($updact) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Permission Denied</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "<p><h1>Permission Denied</h1></p>\n";
    print "You do not have permission to $updact\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }
sub put_banner {
    # do nothing
    }
