#!/usr/bin/perl
package iB;

#
# Updates the tables for the RC.
#


#+------------------------------------------------------------------------------------------------------
#| Ikonboard by Matthew Mecham [ v3.0 ]
#|
#| No parts of this script can be used outside Ikonboard without prior consent.
#| You must keep this header intact and all copyright links visable.
#| (c)2001 Ikonboard.com <http://www.ikonboard.com>
#|
#| Please Read the licence for more information.
#+------------------------------------------------------------------------------------------------------

use strict;

BEGIN {

    $iB::PTH = '.';
    
    #### Getting errors? Enter your path below!
    # Remeber to remove the comment first (# is a comment)
    
    
    #$iB::PTH = 'E:\inent\wwww\htdocs\ikonboard';
    
    
    unshift (@INC, "$iB::PTH");
    unshift (@INC, "$iB::PTH/Data");
    unshift (@INC, "$iB::PTH/Sources");
    unshift (@INC, "$iB::PTH/Skin");
    unshift (@INC, "$iB::PTH/Languages");
    unshift (@INC, "$iB::PTH/Sources/Lib");
    
}
#+------------------------------------------------------------------------------------------------------
use CGI;
use CGI::Carp "fatalsToBrowser";
$iB::Q = new CGI;
use DBI;
use Boardinfo;
$iB::INFO = Boardinfo->new();

### What are we doing?

if ($iB::Q->param('act') eq 'run') {
    iB::run();
} else {
    iB::show();
}




sub show {
    print $iB::Q->header();
    print $iB::Q->start_html();

    print qq~<b><font size=4>Alter Tables</font></b>
             <br><br><font size='3'>This convertor will update your mySQL tables to the new format.</font>
             <a href='alter_table.cgi?act=run'>Run the upgrader</a>
            ~;
    print $iB::Q->end_html();
}


sub run {
    # Get the board info file.
    my $info = Boardinfo->new();
    
    # Get a DB connection
    
    my $dsn  = "DBI:mysql:$info->{'DB_NAME'}:$info->{'DB_IP'}";
    $dsn    .= ":$info->{'DB_PORT'}" if $info->{'DB_PORT'};

    my $dbh = DBI->connect($dsn, $info->{'DB_USER'}, $info->{'DB_PASS'});

    if ($DBI::errstr) {
        &errors("mySQL connection error: $DBI::errstr");
    }
    
    my $pre = $info->{DB_PREFIX};
    
    print $iB::Q->header();
    print $iB::Q->start_html("Alter Table Output");
    ##############################################################                
    print "Altering Table: ".$pre."active_sessions...<br><br>";
    
    $dbh->do("ALTER TABLE ".$pre."active_sessions CHANGE THIS_IP THIS_IP varchar(16) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from THIS_IP column<br>";
    
    $dbh->do("ALTER TABLE ".$pre."active_sessions CHANGE USER_AGENT USER_AGENT varchar(64) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from USER_AGENT column<br>";
    ##############################################################
    
    print "<br>Altering Table: ".$pre."address_books...<br><br>";

    $dbh->do("ALTER TABLE ".$pre."address_books CHANGE IN_MEMBER_DESC IN_MEMBER_DESC char(50) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from IN_MEMBER_DESC column<br>";
    ##############################################################    
    
    print "<br>Altering Table: ".$pre."authorisation...<br><br>";

    $dbh->do("ALTER TABLE ".$pre."authorisation CHANGE THIS_IP THIS_IP varchar(16) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from THIS_IP column<br>";
    
    $dbh->do("ALTER TABLE ".$pre."authorisation CHANGE _WHERE _WHERE varchar(64) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from _WHERE column, changed to varchar from char<br>";
    
    ##############################################################    
    
    print "<br>Altering Table: ".$pre."categories...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."categories CHANGE SUB_CAT_ID SUB_CAT_ID int(10) NULL");
    $dbh->do("ALTER TABLE ".$pre."categories ADD IMAGE varchar(128) NULL");
    $dbh->do("ALTER TABLE ".$pre."categories ADD URL varchar(128) NULL");
    #&errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "SUB_CAT_ID column changed to int(10)<br>";    

    ##############################################################    
    
    print "<br>Altering Table: ".$pre."forum_moderators...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."forum_moderators CHANGE DELTE_POST DELETE_POST tinyint(1)  DEFAULT '0' NULL");
    #&errors("mySQL error: $DBI::errstr") if $DBI::errstr;  # For those who have already fixed this..
    print "DELTE_POST column changed to DELETE_POST<br>";
    $dbh->do("ALTER TABLE ".$pre."forum_moderators CHANGE MEMBER_ID MEMBER_ID varchar(32)  DEFAULT '0' NULL");
    print "MEMBER_ID column changed to varchar(32)<br>";  
    ##############################################################    
    
    print "<br>Altering Table: ".$pre."forum_polls...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."forum_polls CHANGE POLL_STARTER POLL_STARTER varchar(32)");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "POLL_STARTER column changed to varchar(32)<br>";
    $dbh->do("ALTER TABLE ".$pre."forum_polls CHANGE ID ID bigint(20) DEFAULT '0' NOT NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "ID column changed to bigint(20)<br>";
    $dbh->do("ALTER TABLE ".$pre."forum_polls CHANGE FORUM_ID FORUM_ID bigint(20)");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "FORUM_ID column changed to bigint(20)<br>";

    ##############################################################    
    
    print "<br>Altering Table: ".$pre."forum_poll_voters...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."forum_poll_voters CHANGE ID ID bigint(20) DEFAULT '0' NOT NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "ID column changed to bigint(20)<br>";
    $dbh->do("ALTER TABLE ".$pre."forum_poll_voters CHANGE FORUM_ID FORUM_ID bigint(20)");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "FORUM_ID column changed to bigint(20)<br>";
    $dbh->do("ALTER TABLE ".$pre."forum_poll_voters CHANGE MEMBER_ID MEMBER_ID varchar(32)");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "MEMBER_ID column changed to varchar(32)<br>";
    
    ##############################################################    
    
    print "<br>Altering Table: ".$pre."forum_topics...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."forum_topics CHANGE MOVED_TO MOVED_TO varchar(64) NULL");
    #&errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "MOVED_TO column changed to varchar(64)<br>";

    ##############################################################    
    
    print "<br>Altering Table: ".$pre."forum_rules...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."forum_rules ADD SHOW_ALL tinyint(1) NULL");
    #&errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "SHOW_ALL column added to table<br>";
    
    ##############################################################    
    
    print "<br>Altering Table: ".$pre."message_data...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."message_data ADD RECIPIENT_ID varchar(32) NULL");
    #&errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "RECIPIENT_ID column added to table<br>";
    
    $dbh->do("ALTER TABLE ".$pre."message_data ADD RECIPIENT_NAME varchar(32) NULL");
    #&errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "RECIPIENT_NAME column added to table<br>"; 
        
    ##############################################################    

    print "<br>Altering Table: ".$pre."mem_groups...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."mem_groups CHANGE TEAM_ICON TEAM_ICON varchar(64) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from TEAM_ICON column<br>";
    $dbh->do("ALTER TABLE ".$pre."mem_groups CHANGE ATTACH_MAX ATTACH_MAX bigint(20) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "Removed NOT NULL attribute from ATTACH_MAX column<br>";

    ##############################################################
           
    print "<br>Altering Table: ".$pre."member_titles...<br><br>";
      
    $dbh->do("ALTER TABLE ".$pre."member_titles CHANGE PIPS PIPS varchar(128) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "PIPS column now varchar(128)<br>";

    ##############################################################
    
    print "<br>Altering Table: ".$pre."member_profiles...<br><br>";    
    $dbh->do("ALTER TABLE ".$pre."member_profiles CHANGE INTERESTS INTERESTS text NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "INTERESTS changed to text<br>";    
    $dbh->do("ALTER TABLE ".$pre."member_profiles CHANGE MEMBER_AVATAR MEMBER_AVATAR varchar(128) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "MEMBER_AVATAR now varchar(128)<br>";
    $dbh->do("ALTER TABLE ".$pre."member_profiles CHANGE ICQNUMBER ICQNUMBER varchar(40) NULL");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;
    print "ICQNUMBER now varchar(40)<br>";   

    ##############################################################
    
    print "<br>Creating Table: ".$pre."calendar...<br><br>";    
    $dbh->do("CREATE TABLE ".$pre."calendar (
              MEMBER_ID              varchar(32)       not null,
              MEMBER_NAME            varchar(32)       not null,
              DAY                    smallint(5)       not null,
              MONTH                  smallint(5)       not null,
              YEAR                   smallint(5)       not null,
              TIME_ADJUST            varchar(4),
              PRIMARY KEY            (MEMBER_ID)
           )");
    &errors("mySQL error: $DBI::errstr") if $DBI::errstr;    
    
        
    print "All done, you may now remove this script";   
                
    print $iB::Q->end_html();
    exit;
}









sub errors {
    my $error = shift;
    print $iB::Q->header();
    print $iB::Q->start_html("Fatal Errors");
    print "ERROR: $error";
    print $iB::Q->end_html();
    exit;
}


