#!/usr/bin/perl
package iB;

#
# Updates the tables for the RC.
#


#+------------------------------------------------------------------------------------------------------
#| Ikonboard by Matthew Mecham [ v3.0 ]
#| 
#| Script author: Nurlan Mukhanov (Infection)
#|
#| No parts of this script can be used outside Ikonboard without prior consent.
#| You must keep this header intact and all copyright links visable.
#| (c)2001 Ikonboard.com <http://www.ikonboard.com>
#|
#| Please Read the licence for more information.
#+------------------------------------------------------------------------------------------------------

use strict;

BEGIN {

    $iB::PTH = '.';
    
    #### Getting errors? Enter your path below!
    # Remeber to remove the comment first (# is a comment)
    
    
    #$iB::PTH = 'E:\inent\wwww\htdocs\ikonboard';
    
    
    unshift (@INC, "$iB::PTH");
    unshift (@INC, "$iB::PTH/Data");
    unshift (@INC, "$iB::PTH/Sources");
    unshift (@INC, "$iB::PTH/Skin");
    unshift (@INC, "$iB::PTH/Languages");
    unshift (@INC, "$iB::PTH/Sources/Lib");
    
}
#+------------------------------------------------------------------------------------------------------
use CGI;
use CGI::Carp "fatalsToBrowser";
$iB::Q = new CGI;
use DBI;
use Boardinfo;
$iB::INFO = Boardinfo->new();

### What are we doing?

if ($iB::Q->param('act') eq 'run') {
    iB::run();
} else {
    iB::show();
}




sub show {
    print $iB::Q->header();
    print $iB::Q->start_html();

    print qq~<b><font size=4>Alter Tables</font></b>
             <br><br><font size='3'>This convertor will update your PostgreSQL tables to the new format.</font>
             <a href='alter_table.cgi?act=run'>Run the upgrader</a>
            ~;
    print $iB::Q->end_html();
}


sub run {
    # Get the board info file.
    my $info = Boardinfo->new();
    
    # Get a DB connection
    
    $ENV{PGHOST} = $info->{'IP'} if($info->{'DB_IP'});
    $ENV{PGPORT} = $info->{'PORT'} if($info->{'DB_PORT'});

    my $dsn  = "dbi:Pg:dbname=$info->{'DB_NAME'}";

    my $dbh = DBI->connect($dsn, $info->{'DB_USER'}, $info->{'DB_PASS'},{});



    if ($DBI::errstr) {
        &errors("PostgreSQL connection error: $DBI::errstr");
    }
    
    my $pre = $info->{DB_PREFIX};
    
    print $iB::Q->header();
    print $iB::Q->start_html("Alter Table Output");

#    $dbh->{AutoCommit}=0;
#    $dbh->commit;


#---------------------------------------------------------------
#
# Altering table active_sessions
#
#---------------------------------------------------------------
            
    print "<b>Altering Table: ".$pre."member_profiles...</b><br><br>";

    $dbh->do("create table member_profiles_temp (
                                                  member_id              character varying(32)       not null default '0',
                                                  member_name            character varying(32)       not null,
                                                  member_group           integer                     not null default '0',
                                                  member_password        character varying(32)       not null,
                                                  member_email           character varying(64),
                                                  member_joined          integer                     not null default '0',
                                                  member_level           integer,
                                                  member_ip              character varying(16)       default '',
                                                  member_avatar          character varying(256),
                                                  avatar_dims            character varying(16),
                                                  member_posts           integer                     default '0',
                                                  photo                  character varying(72),
                                                  cancel_subs            integer,
                                                  aolname                character varying(40),
                                                  icqnumber              character varying(16),
                                                  location               character varying(512),
                                                  signature              text,
                                                  website                character varying(72),
                                                  yahooname              character varying(32),
                                                  member_title           character varying(64),
                                                  last_update            integer,
                                                  allow_admin_emails     integer,
                                                  time_adjust            character varying(8),
                                                  interests              character varying(512),
                                                  hide_email             character varying(8),
                                                  pm_reminder            character varying(8),
                                                  email_full_post        integer,
                                                  member_skin            character varying(32),
                                                  warn_level             integer,
                                                  language               character varying(32),
                                                  msnname                character varying(32),
                                                  last_post              character varying(32),
                                                  allow_post             integer,
                                                  view_sigs              integer,
                                                  view_img               integer,
                                                  view_avs               integer)"
                                                 );

    $dbh->do("insert into member_profiles_temp select * from ".$pre."member_profiles");
    $dbh->do("drop table ".$pre."member_profiles");
    $dbh->do("alter table member_profiles_temp rename to ".$pre."member_profiles");
    $dbh->do("create index ".$pre."member_profiles_pkey on ".$pre."member_profiles(member_id)");

    &errors("PostgreSQL error: $DBI::errstr") if $DBI::errstr;
    print "Column member_avatar changed from character varying(72) to character varying(256)<br>Column location changed from character varying(128) to character varying(512)";


#    $dbh->{AutoCommit}=0;
    $dbh->disconnect;
    
    print "<br><b>All done, you may now remove this script</b>";   
                
    print $iB::Q->end_html();
    exit;
}



sub errors {
    my $error = shift;
    print $iB::Q->header();
    print $iB::Q->start_html("Fatal Errors");
    print "ERROR: $error";
    print $iB::Q->end_html();
    exit;
}



