########################################
# Ikonboard mod_perl pre-loader
# by: Matthew Mecham
#
#
# WARNING: Only use this script after
# you have set up your board and you
# know that it works properly!
# If not, your server may not restart...
########################################

package iPerl::mod_perl;
use strict;

use vars qw/$URL $PATH $EXT $MOD_PERL/;

# Are we sure about the mod_perl? It's not fast_cgi is it?
$MOD_PERL  = (exists $ENV{GATEWAY_INTERFACE} and ($ENV{GATEWAY_INTERFACE} =~ /^CGI-Perl/)) ? 1 : 0;
BEGIN { if ($MOD_PERL) { require Apache::DBI; } }

# First thing to do is to add in any custom @INC paths.
# Swop what we have here for your own paths - or it will fail!

use lib ('/home/ikonboar/public_html/z_test',
         '/home/ikonboar/public_html/z_test/Data',
         '/home/ikonboar/public_html/z_test/Sources',
         '/home/ikonboar/public_html/z_test/Languages',
         '/home/ikonboar/public_html/z_test/Skin'
        );
        
# Other stuff to set up:

#1) What is your URL to the board?
$URL = 'http://www.ikonboard.com/z_test';

#2) What is the full path to your board?
$PATH = '/home/ikonboar/public_html/z_test';

#3) What CGI extension are you using for the ikonboard scripts?
$EXT  = '.cgi';

print STDERR "Ikonboard 3 Preloader: Preloading commonly used modules\t\t";

# Preload common modules
use Boards;
use Forum;
use Post;
use Register;
use Search;
use Sessions;
use Topic;
use iTextparser;
use iDatabase::SQL;
use UserCP::Lostpass;
use UserCP::Menu;
use UserCP::Messenger;


print STDERR " (OK)\n";

# Preload the ikonboard.cgi script.

do_load() if ($MOD_PERL and ($Apache::ServerStarting == 1));

sub do_load {
    # Uses the Apache::RegistryLoader
    require Apache::RegistryLoader;
    my $r = Apache::RegistryLoader->new;
    $^W = 1;  # Turn on warnings
    print STDERR "Ikonboard 3 Preloader: Preloading ikonboard.cgi\t\t";
    $r->handler("$URL", "$PATH/ikonboard$EXT");
    print STDERR " (OK)\n\n Ikonboard preloading complete....\n\n";
}

1;


