package UserCP::Menu;
use strict;
#+------------------------------------------------------------------------------------------------------
#| Ikonboard by Matthew Mecham [ v3.0 ]
#|
#| No parts of this script can be used outside Ikonboard without prior consent.
#| You must keep this header intact and all copyright links visable.
#| (c)2001 Ikonboard.com <http://www.ikonboard.com>
#|
#| Please Read the licence for more information.
#+------------------------------------------------------------------------------------------------------
BEGIN {
    require 'Lib/FUNC.pm';
    require 'iTextparser.pm';
}
my $std       = FUNC::STD->new();
my $mem       = FUNC::Member->new();
my $output    = FUNC::Output->new();
my $txt       = iTextparser->new();
$UserCP::lang = $std->LoadLanguage('UserCPWords');


sub new {
    my $pkg = shift;
    my $obj = { '.html' => undef };
    bless $obj, $pkg;
    return $obj;
}

#+------------------------------------------------------------------------------------------------------

sub Splash ($) {
    my ($obj, $db) = @_;
    $iB::MEMBER->{'DATE_REGISTERED'} = $std->get_date(  TIME   => $iB::MEMBER->{'MEMBER_JOINED'},
                                                        METHOD => 'LONG',
                                                     );

    $iB::MEMBER->{'DAILY_AVERAGE'}  = $iB::MEMBER->{'MEMBER_POSTS'} > 0
                                    ? $obj->get_daily()
                                    : $UserCP::lang->{'no_posts'};

    $obj->{'.html'} .= MenuView::splash($iB::MEMBER);

    $obj->{'.html'} .= MenuView::CP_end();
}


sub get_daily ($) {
   my $obj = shift;
   return unless $iB::MEMBER->{'MEMBER_POSTS'};
   my $diff = time - $iB::MEMBER->{'MEMBER_JOINED'};
   my $days = ($diff / 3600) / 24;
   $days = 1 if $days < 1;
   return sprintf '%.2f', $iB::MEMBER->{'MEMBER_POSTS'} / $days;
}
   


sub Personal ($) {
    my ($obj, $db) = @_;
    # Can we edit our profile?
    unless ($iB::MEMBER_GROUP->{'EDIT_PROFILE'}) {
        $std->Error( LEVEL => 1, DB => $db, MESSAGE => 'cant_use_feature');
    }
    $obj->_personal_splash($db) unless $std->IsNumber($iB::IN{'MODE'});
    $obj->_personal_avatar($db) if $std->IsNumber($iB::IN{'MODE'}) == 1;
    $obj->_personal_panel($db)  if $std->IsNumber($iB::IN{'MODE'}) == 2;
    $obj->{'.html'} .= MenuView::CP_end();
}

sub _personal_splash ($) {
    my $obj = shift;
    $obj->{'.html'} .= MenuView::personal_splash(); 
    $obj->{'.html'} .= MenuView::personal_splash_av() if $iB::INFO->{'AVATARS'};
}


sub _personal_avatar ($) {
    my ($obj, $db) = @_;
    $std->Error(DB => $db, STD => $std, LEVEL=>1,MESSAGE=>'no_avatar') unless $iB::INFO->{'AVATARS'};
    #+-------------------------------------------------------------------------------
    opendir AVATARS, $iB::INFO->{'HTML_DIR'} . 'avatars' or die $!;
    my @avatars = map   {       $_     }
                  sort  {   $a cmp $b  }
                  grep  {     !/^\./   } readdir AVATARS;
    closedir AVATARS;
    #+-------------------------------------------------------------------------------
    my $current_avatar;
    $current_avatar = $iB::MEMBER->{'MEMBER_AVATAR'};
    $current_avatar = 'noavatar' unless $current_avatar;
    $current_avatar = 'noavatar' if $iB::MEMBER->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i;

    my $avatars = qq!<select name="useravatar" size='10' onChange="showavatar('$iB::INFO->{'AVATARS_URL'}/')" class='forminput'><option value='*'>* Remove all avatars *</option>!;
    for (@avatars) {
        next if /^index/i;
        my $view = $_;
        $view =~ s!\.\S+$!!g;
        $avatars .= $_ eq $current_avatar  ? qq!<option value='$_' selected>$view</option>\n!
                                           : qq!<option value='$_'>$view</option>\n!;
    }
    $avatars .= qq!</select>\n!;
    #+-------------------------------------------------------------------------------
    # Get the real avatar to display
    my $the_current_avatar = $obj->get_avatar;
    # Sort out the text
    $UserCP::lang->{'this_avatar'} = $UserCP::lang->{'av_none_selected'};
    if ($iB::MEMBER->{'MEMBER_AVATAR'} =~ /\./) {
        $UserCP::lang->{'this_avatar'} = $UserCP::lang->{'av_preset'};
    }
    if ($iB::MEMBER->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i) {
        $UserCP::lang->{'this_avatar'} = $UserCP::lang->{'av_personal'};
    }
    # Set up the preset avatars stuff
    ($iB::INFO->{'AV_WIDTH'}, $iB::INFO->{'AV_HEIGHT'}) = split "x", $iB::INFO->{'AV_DIMS'};
    my ($d_a_width, $d_a_height) = split "x", $iB::INFO->{'DEF_AV_DIMS'};
    my $show_avatar    = qq!<img src="$iB::INFO->{'AVATARS_URL'}/$current_avatar" name='useravatars' width='$d_a_width' height='$d_a_height' border='0' hspace='15'>\n!;
    $obj->{'.html'} .= MenuView::personal_avatar( { MEMBER => $iB::MEMBER, AVATARS => $avatars, SHOW_AVS => $show_avatar, CUR_AV => $the_current_avatar });
    #+-------------------------------------------------------------------------------
    my $url_avatar;
    $url_avatar = $iB::MEMBER->{'MEMBER_AVATAR'} if $iB::MEMBER->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i;
    $url_avatar = 'http://' unless $url_avatar;
    my $allowed_ext = '.' . join ' .', (split /\|/,$iB::INFO->{'AV_EXT'});
    ($iB::MEMBER->{'AVATAR_WIDTH'}, $iB::MEMBER->{'AVATAR_HEIGHT'}) = split("x", $iB::MEMBER->{'AVATAR_DIMS'});
    $obj->{'.html'} .= MenuView::personal_avatar_URL($iB::MEMBER,$url_avatar, $allowed_ext) if $iB::INFO->{'AV_ALLOW_URL'};

    
}
sub get_avatar {
    my $obj = shift;
    return unless $iB::MEMBER->{'MEMBER_AVATAR'};
    return if $iB::MEMBER->{'MEMBER_AVATAR'} eq 'noavatar';
    my ($a_width, $a_height) = split "x", $iB::INFO->{'AV_DIMS'};
    my ($d_a_width, $d_a_height) = split "x", $iB::INFO->{'DEF_AV_DIMS'};
    if ($iB::MEMBER->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i) {
        if ($iB::INFO->{'AV_ALLOW_URL'}) {
            my ($width  , $height)   = split "x", $iB::MEMBER->{'AVATAR_DIMS'};
            $height ||= $a_height;
            $width  ||= $a_width;           
            return $iB::MEMBER->{'MEMBER_AVATAR'} =~ m#\.swf\Z#i ? qq|<OBJECT CLASSID="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" WIDTH=$width HEIGHT=$height><PARAM NAME=MOVIE VALUE=$iB::MEMBER->{'MEMBER_AVATAR'}><PARAM NAME=PLAY VALUE=TRUE><PARAM NAME=LOOP VALUE=TRUE><PARAM NAME=QUALITY VALUE=HIGH><EMBED SRC=$iB::MEMBER->{'MEMBER_AVATAR'} WIDTH=$width HEIGHT=$height PLAY=TRUE LOOP=TRUE QUALITY=HIGH></EMBED></OBJECT>|
                                                                 : qq|<img src='$iB::MEMBER->{'MEMBER_AVATAR'}' border='0' width='$width' height='$height' alt=''>|;
        }
    }
    return qq|<img src='$iB::INFO->{'AVATARS_URL'}/$iB::MEMBER->{'MEMBER_AVATAR'}' border='0' width='$d_a_width' height='$d_a_height' alt=''>| unless $iB::MEMBER->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i;
}

sub _personal_panel ($) {
    my $obj = shift;

    # added by Infection


    my $db = shift;
    my $i;
    my @dat = localtime;

    my $birthday = $db->select( TABLE     => 'calendar',
                                KEY       => $iB::MEMBER->{'MEMBER_ID'},
                                MEMBER_ID => $iB::MEMBER->{'MEMBER_ID'},
                              );

    $iB::MEMBER->{'DAY'}="<option value='0'>--</option>";
    for ($i=1;$i<32;$i++) {
        if ($i==$birthday->{'DAY'}) {
           $iB::MEMBER->{'DAY'}.="<option value=\"$i\" selected>$i</option>";
        } else {
           $iB::MEMBER->{'DAY'}.="<option value=\"$i\">$i</option>";
        }
    }

    $iB::MEMBER->{'MONTH'}="<option value='0'>--</option>";
    for ($i=1;$i<13;$i++) {
        if ($i==$birthday->{'MONTH'}) {
           $iB::MEMBER->{'MONTH'}.="<option value=\"$i\" selected>".$UserCP::lang->{"month$i"}."</option>";
        } else {
           $iB::MEMBER->{'MONTH'}.="<option value=\"$i\">".$UserCP::lang->{"month$i"}."</option>";
        };
    }

    my $year = $dat[5]+1900;
    $i    = $year-1;
    my $j = $year-100;

    $iB::MEMBER->{'YEAR'}="<option value='0'>--</option>";
    for ($i;$j<$i;$i--) {
        if ($i==$birthday->{'YEAR'}) {
           $iB::MEMBER->{'YEAR'}.="<option value=\"$i\" selected>$i</option>";
        } else {
           $iB::MEMBER->{'YEAR'}.="<option value=\"$i\">$i</option>";
        };
    }

    if ($iB::INFO->{'SIG_ALLOW_HTML'}) {
        $iB::MEMBER->{SIGNATURE} = $std->doHTML($iB::MEMBER->{SIGNATURE});
        $iB::MEMBER->{SIGNATURE} =~ s/<br>/\n/g;
    } else {
        $iB::MEMBER->{'SIGNATURE'} = $txt->Convert_for_textfield($iB::MEMBER->{'SIGNATURE'});
    }
    $iB::MEMBER->{'LOCATION'}  = $txt->Convert_for_textfield($iB::MEMBER->{'LOCATION'});
    $iB::MEMBER->{'INTERESTS'} = $txt->Convert_for_textfield($iB::MEMBER->{'INTERESTS'});
   
    $obj->{'.html'} .= MenuView::personal_panel($iB::MEMBER);
    if ( ($iB::INFO->{POST_TITLECHANGE}) and ($iB::MEMBER->{'MEMBER_POSTS'} > $iB::INFO->{POST_TITLECHANGE}) ) {
        my $this = MenuView::member_title();
        $obj->{'.html'} =~ s/<!--\{MEMBERTITLE\}-->/$this/;
    }
    my $bday_html = MenuView::birthday();
    $obj->{'.html'} =~ s/<!--\{BIRTHDAY\}-->/$bday_html/;
}



sub Email ($) {
    my ($obj, $db) = @_;

    # PM_REMINDER is a little special.
    # It has three characters, typically 1&1, 0&0, 1&0, 0&1
    # The first byte is set to 1 if we want a PM reminder
    # The last byte is set to 1 if we want a JS pop up window telling us
    # We have a new message.
    $iB::MEMBER->{'PM_REMINDER'} = (split/&/, $iB::MEMBER->{'PM_REMINDER'})[0]; #Get the first byte

    for (qw[HIDE_EMAIL ALLOW_ADMIN_EMAILS EMAIL_FULL_POST PM_REMINDER]) { 
        $iB::MEMBER->{$_} = 'checked' if $iB::MEMBER->{$_};
    }
    $iB::MEMBER->{'CANCEL_SUBS'} = '30' unless $iB::MEMBER->{'CANCEL_SUBS'};
    $obj->{'.html'} .= MenuView::email($iB::MEMBER);
    $obj->{'.html'} .= MenuView::CP_end();
}

sub Subs ($) {
    my ($obj, $db) = @_;
    $obj->{'.html'} .= MenuView::subs_header();

    #Get the subscriptions

    my $subs = $db->query( TABLE    => 'forum_subscriptions',
                           WHERE    => "MEMBER_ID eq '$iB::MEMBER->{'MEMBER_ID'}'",
                           SORT_KEY => 'DATE_STARTED',
                           SORT_BY  => 'A-Z',
                         );

    my @delete_keys;

    for my $s (@{$subs}) {
        #Is the sub out of date?
        if ($s->{'DATE_STARTED'} < time - ($s->{'PRUNE'} * 3600 * 7)) {
            push @delete_keys, $s->{'ID'};
            next;
        }

        my $data = $db->select( TABLE  => 'forum_topics',
                                ID     => $s->{'FORUM_ID'},
                                KEY    => $s->{'TOPIC_ID'}
                              );

        $data->{'DAYS_LEFT'}       = sprintf '%2.0f', $s->{'PRUNE'} - ((time - $s->{'DATE_STARTED'}) / 86400);
        $data->{'DATE_START'}      = $std->get_date( TIME => $s->{'DATE_STARTED'}, METHOD => 'LONG' );
        $data->{'ID'}              = $s->{'ID'};
        $data->{'TOPIC_ICON'}      = $data->{'TOPIC_ICON'} ? $iB::INFO->{'IMAGES_URL'} . '/PostIcons/icon' . $data->{'TOPIC_ICON'} . '.gif'
                                                           : $iB::INFO->{'IMAGES_URL'} . '/PostIcons/icon0.gif';
        $data->{'TOPIC_LAST_DATE'} = $std->get_date( TIME => $data->{'TOPIC_LAST_DATE'}, METHOD => "LONG" );
        $data->{'LAST_POSTER'}     = ($data->{'TOPIC_LAST_POSTER'} != 0)  ? qq[<b><a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Profile;CODE=03;MID=$data->{'TOPIC_LAST_POSTER'}' class='misc'>$data->{'TOPIC_LASTP_N'}</a></b>]
                                                                          : qq[<font class='misc'>-$data->{'TOPIC_LASTP_N'}-</font>];


        $obj->{'.html'} .= MenuView::subs_row( $data );
    }

    if (scalar @delete_keys > 0) {
        $db->delete( TABLE => 'forum_subscriptions',
                     KEY   => \@delete_keys,
                   );
    }
   
    $obj->{'.html'} .= MenuView::subs_end();
    $obj->{'.html'} .= MenuView::CP_end();
}


sub Cancelsub {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'no_sub_id'
               ) unless $iB::IN{'ID'};

    my $sub = $db->select( TABLE  => 'forum_subscriptions',
                           KEY    => $iB::IN{'ID'}
                         );

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'no_sub_id'
               ) unless $sub->{'MEMBER_ID'} eq $iB::MEMBER->{'MEMBER_ID'};

    $db->delete( TABLE => 'forum_subscriptions',
                 KEY   => $iB::IN{'ID'}
               );

    $output->redirect_screen( TEXT => $UserCP::lang->{'subs_deleted'}, URL => "act=UserCP;CODE=03");

}





sub Settings ($) {
    my ($obj, $db) = @_;

    my $time_select = qq|<select name="u_timezone" class='forminput'><option value="-23">- 23<option value="-22">- 22<option value="-21">- 21<option value="-20">- 20<option value="-19">- 19<option value="-18">- 18<option value="-17">- 17<option value="-16">- 16<option value="-15">- 15<option value="-14">- 14<option value="-13">- 13<option value="-12">- 12<option value="-11">- 11<option value="-10">- 10<option value="-9">- 9<option value="-8">- 8<option value="-7">- 7<option value="-6">- 6<option value="-5">- 5<option value="-4">- 4<option value="-3">- 3<option value="-2">- 2<option value="-1">- 1<option value="0">0<option value="1">+ 1<option value="2">+ 2<option value="3">+ 3<option value="4">+ 4<option value="5">+ 5<option value="6">+ 6<option value="7">+ 7<option value="8">+ 8<option value="9">+ 9<option value="10">+ 10<option value="11">+ 11<option value="12">+ 12<option value="13">+ 13<option value="14">+ 14<option value="15">+ 15<option value="16">+ 16<option value="17">+ 17<option value="18">+ 18<option value="19">+ 19<option value="20">+ 20<option value="21">+ 21<option value="22">+ 22<option value="23">+ 23</select>|;
    $time_select =~ s!value="$iB::MEMBER->{'TIME_ADJUST'}">!value="$iB::MEMBER->{'TIME_ADJUST'}" selected>!;

    my $time        = $std->get_date( TIME => time, METHOD => 'LONG');
    my $lang_select = "<select name='u_language' class='forminput'>";

    my @languages = split( /\|\&\|/, $iB::INFO->{'LANGUAGES'} );

    for my $l (@languages) {
        @_ = split /\:/, $l;
        $lang_select .= $_[0] eq $iB::MEMBER->{'LANGUAGE'}
                      ? qq[<option value='$_[0]' selected>$_[1]\n]
                      : qq[<option value='$_[0]'>$_[1]\n];
    }
    $lang_select .= "</select>";
    $obj->{'.html'} .= MenuView::settings_header($iB::MEMBER, $time_select, $time, $lang_select);
    #+-------------------------------------------------------------------------------
    if ($iB::INFO->{'ALLOW_SKINS'} == 1) {
        my @skins = split( /\|\&\|/, $iB::INFO->{'SKINS'} );
        my $skin_select = "<select name='u_skin' class='forminput'>";
        $iB::MEMBER->{'MEMBER_SKIN'} ||= $iB::INFO->{DEFAULT_SKIN};
        for my $s (@skins) {
            @_ = split /\:/, $s;
            $skin_select .= $_[0] eq $iB::MEMBER->{'MEMBER_SKIN'}
                          ? qq[<option value='$_[0]' selected>$_[2]\n]
                          : qq[<option value='$_[0]'>$_[2]\n];
        }
        $skin_select .= "</select>";
        $obj->{'.html'} .= MenuView::settings_skin($skin_select);
    }
    #+-------------------------------------------------------------------------------
    my $view_ava = qq!<select name='VIEW_AVS' class='forminput'>
                      <option value='1'>$UserCP::lang->{'yes'}</option>
                      <option value='0'>$UserCP::lang->{'no'}</option>
                     !;
    $view_ava =~ s!value='$iB::MEMBER->{'VIEW_AVS'}'>!value='$iB::MEMBER->{'VIEW_AVS'}' selected>!;

    my $view_sig = qq!<select name='VIEW_SIGS' class='forminput'>
                      <option value='1'>$UserCP::lang->{'yes'}</option>
                      <option value='0'>$UserCP::lang->{'no'}</option>
                     !;
    $view_sig =~ s!value='$iB::MEMBER->{'VIEW_SIGS'}'>!value='$iB::MEMBER->{'VIEW_SIGS'}' selected>!;

    my $view_img = qq!<select name='VIEW_IMG' class='forminput'>
                      <option value='1'>$UserCP::lang->{'yes'}</option>
                      <option value='0'>$UserCP::lang->{'no'}</option>
                     !;
    $view_img =~ s!value='$iB::MEMBER->{'VIEW_IMG'}'>!value='$iB::MEMBER->{'VIEW_IMG'}' selected>!;

    # PM_REMINDER is a little special.
    # It has three characters, typically 1&1, 0&0, 1&0, 0&1
    # The first byte is set to 1 if we want a PM reminder
    # The last byte is set to 1 if we want a JS pop up window telling us
    # We have a new message.

    $iB::MEMBER->{'PM_REMINDER'} = (split/&/, $iB::MEMBER->{'PM_REMINDER'})[1]; #Get the last byte

    my $do_pop   = qq!<select name='DO_POPUP' class='forminput'>
                      <option value='1'>$UserCP::lang->{'yes'}</option>
                      <option value='0'>$UserCP::lang->{'no'}</option>
                     !;
    $do_pop      =~ s!value='$iB::MEMBER->{'PM_REMINDER'}'>!value='$iB::MEMBER->{'PM_REMINDER'}' selected>!;


    $obj->{'.html'} .= MenuView::settings_end( { IMG => $view_img."</select>",
                                                 SIG => $view_sig."</select>",
                                                 AVA => $view_ava."</select>",
                                                 POP => $do_pop  ."</select>",
                                               }
                                             );
    $obj->{'.html'} .= MenuView::CP_end();
}





sub Account ($) {
    my ($obj, $db) = @_;
    $obj->{'.html'} .= MenuView::account($iB::MEMBER);
    $obj->{'.html'} .= MenuView::CP_end();
}


sub Show_menu ($) {
    my $obj = shift;
    my $Nav_tabs = { '00' => 'splash', '01' => 'personal', '02' => 'email', '03' => 'subs', '04' => 'settings', '05' => 'account' };
    my $Nav_color = { };
    for (qw[splash personal email subs settings account]) { $Nav_color->{$_} = $iB::SKIN->{'USERNAV_OFF'} }
    $Nav_color->{ $Nav_tabs->{ $iB::IN{'CODE'} } } = $iB::SKIN->{'USERNAV_ON'};
    $obj->{'.html'} .= MenuView::Menu_bar($Nav_color);
}
   
 

sub Process {
    my ($obj, $db) = @_;
    $obj->SetSession($db);
    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    my %Mode = ( '00'     => \&Splash,
                 '01'     => \&Personal,
                 '02'     => \&Email,
                 '03'     => \&Subs,
                 '04'     => \&Settings,
                 '05'     => \&Account,
                 '06'     => \&Cancelsub,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : UserCPError($obj, $db);

    $output->print_ikonboard( DB         => $db,
                              STD        => $std,
                              OUTPUT     => $obj->{'.html'},
                              JAVASCRIPT => 1,
                              TITLE      => "iB::$UserCP::lang->{'t_welcome'} $iB::MEMBER->{'MEMBER_NAME'}",
                              NAV        => [ 
                                              qq|<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=UserCP;CODE=00">$UserCP::lang->{'t_title'}</a>|
                                            ]
                            );
} 

#+------------------------------------------------------------------------------------------------------
#+------------------------------------------------------------------------------------------------------

sub LoadForum {
    my ($obj, $db, $forum) = @_;
    $obj->{'.forum_id'} = $forum;
    $obj->{'FORUM'} = $db->select( TABLE   => 'forum_info',
                                   KEY     => $obj->{'.forum_id'},
                                 ) || die $db->{'error'};

}

#+------------------------------------------------------------------------------------------------------

sub LoadTopic {
    my ($obj, $db, $forum, $topic) = @_;

    $obj->{'TOPIC'} = $db->select( TABLE  => 'forum_topics',
                                   ID     => $forum,
                                   KEY    => $topic,
                                 ) || die $db->{'error'};
}

#+------------------------------------------------------------------------------------------------------
sub SetSession {
    my ($obj, $db) = @_;
    require $iB::SKIN->{'DIR'} . '/MenuView.pm' or die $!;
    $std->Error(DB=>$db, LEVEL=>'1',MESSAGE=>'no_guest_posting')  unless $iB::MEMBER->{'MEMBER_ID'};
    $obj->Show_menu();
}

#+------------------------------------------------------------------------------------------------------

sub UserCPError  { my ($obj, $db) = @_; $std->Error(DB=>$db,STD=>$std,LEVEL=>'1',MESSAGE=>'incorrect_use') }


#+------------------------------------------------------------------------------------------------------
#+------------------------------------------------------------------------------------------------------

1;