package UserCP::Lostpass;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Lostpass: Function for retrieving forgotten passwords.
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $output = FUNC::Output->new();
my $mem    = FUNC::Member->new();
my $std    = FUNC::STD->new();
my $SEND   = FUNC::Mailer->new();
$Lostpass::lang = $std->LoadLanguage('LostpassWords');


sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

#+------------------------------------------------------------------------------------------------------

sub Splash {
    my ($obj, $db) = @_;

    my $print = &LostpassView::splash();

    $output->print_ikonboard( DB           => $db,
                              STD          => $std,
                              NAV_ONE      => $Lostpass::lang->{'nav_title'},
                              OUTPUT       => $print,
                              JAVASCRIPT   => '1',
                              TITLE        => "iB::" . $Lostpass::lang->{'nav_title'}
                            );
}


sub step_b ($) {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   =>'1',
                 MESSAGE =>'no_username'
               ) unless $iB::IN{'u_membername'};

    my $name_check  = $mem->CheckName( DB =>$db, NAME =>$iB::IN{'u_membername'} );

    $std->Error( DB      => $db,
                 LEVEL   =>'1',
                 MESSAGE =>'membername_none'
               ) unless $name_check->{'MEMBER_NAME'};


    $obj->{'MEMBER'} = $db->select( TABLE => 'member_profiles',
                                    KEY   => $name_check->{'MEMBER_ID'},
                                  );


    $std->Error( DB      => $db,
                 LEVEL   =>'1',
                 MESSAGE =>'membername_none'
               ) unless $obj->{'MEMBER'}->{'MEMBER_ID'};


    my $unique_id = $SEND->my_gen_id();
    my $time      = time;

    my $new_id = $db->insert( TABLE   => 'authorisation',
                              VALUES  => {  UNIQUE_CODE   =>  $unique_id,
                                            DATE_ENTERED  =>  $time,
                                            MEMBER_ID     =>  $obj->{'MEMBER'}->{'MEMBER_ID'},
                                            MEMBER_NAME   =>  $obj->{'MEMBER'}->{'MEMBER_NAME'},
                                            THIS_IP       =>  $ENV{'REMOTE_ADDR'},
                                            MEMBER_EMAIL  =>  $obj->{'MEMBER'}->{'MEMBER_EMAIL'},
                                            '_WHERE'      =>  'lostpass',
                                          },
                                );

    my $message = $SEND->parse_template( ID     => 'LOST_PASS_ONE',
                                         DB     => $db,
                                         VALUES =>  { THE_LINK    =>  "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=LostPass&CODE=03",
                                                      MEMBER_NAME =>  $obj->{'MEMBER'}->{'MEMBER_NAME'},
                                                      CODE        =>  $unique_id
                                                    }
                                            );

    $SEND->Send( TO      => $obj->{'MEMBER'}->{'MEMBER_EMAIL'},
                 FROM    => '',
                 SUBJECT => "$Lostpass::lang->{email_text_lp} at $iB::INFO->{'BOARDNAME'}",
                 MESSAGE => $message
               );


    $output->redirect_screen( TEXT => "$Lostpass::lang->{lp_redirect}", URL => "act=LostPass;CODE=03");

}


sub step_c ($) {
    my ($obj, $db) = @_;

   

    $std->Error( DB      => $db,
                 LEVEL   =>'1',
                 MESSAGE =>'data_incorrect'
               ) unless $iB::IN{'SID'};


    my $time = (time - ($iB::INFO->{'AUTHORISE_PRUNE'} * 60 * 60 * 24));

    my $db_entry = $db->query( TABLE   => 'authorisation',
                               MATCH   => 'ONE',
                               WHERE   => "UNIQUE_CODE eq \"$iB::IN{'SID'}\"",
                              );

    $std->Error( DB      => $db,
                 LEVEL   => '1',
                 MESSAGE => 'request_error'
               ) unless $db_entry->{'MEMBER_ID'};

    $std->Error( DB      => $db,
                 LEVEL   => '1',
                 MESSAGE =>'request_error'
               ) unless $db_entry->{'_WHERE'} eq 'lostpass';

    $std->Error( DB      => $db,
                 LEVEL   => '1',
                 MESSAGE =>'request_error'
               ) unless $db_entry->{'UNIQUE_CODE'} eq $iB::IN{'SID'};



    my $member = $db->select( TABLE    => 'member_profiles',
                              KEY      => $db_entry->{'MEMBER_ID'},
                              ID       => $db_entry->{'MEMBER_ID'},
                            );


    $std->Error( DB      => $db,
                 LEVEL   => '1',
                 MESSAGE =>'request_error'
               ) unless $member->{'MEMBER_NAME'};



    my $new_pass   = $mem->RandomPassword();
    my $c_new_pass = $mem->Crypt($member->{'MEMBER_NAME'},$new_pass);

    $db->update(              TABLE    => 'member_profiles',
                              KEY      => $db_entry->{'MEMBER_ID'},
                              ID       => $db_entry->{'MEMBER_ID'},
                              VALUES   => { MEMBER_PASSWORD => $c_new_pass }
               );


    $db->delete(             TABLE     => 'authorisation',
                             KEY       => $db_entry->{'ID'},
               );



    my $message = $SEND->parse_template( ID     => 'LOST_PASS_TWO',
                                         DB     => $db,
                                         VALUES => { U_NAME      =>  $member->{'MEMBER_NAME'},
                                                     U_PASS      =>  $new_pass,
                                                   }
                                       );

    $SEND->Send( TO      => $member->{'MEMBER_EMAIL'},
                 FROM    => '',
                 SUBJECT => $Lostpass::lang->{'email_subject_b'},
                 MESSAGE => $message
               );

    $output->print_ikonboard( DB           => $db,
                              STD          => $std,
                              NAV_ONE      => $Lostpass::lang->{'nav_title'},
                              OUTPUT       => &LostpassView::email_sent($Lostpass::lang->{'second_email'},$Lostpass::lang->{'second_email_txt'}),
                              JAVASCRIPT   => 1,
                              TITLE        => 'iB::'.$Lostpass::lang->{'nav_title'}
                            );

}


sub unlock_box {
    my ($obj, $db) = @_;

    $output->print_ikonboard( DB           => $db,
                              STD          => $std,
                              NAV_ONE      => $Lostpass::lang->{'nav_title'},
                              OUTPUT       => &LostpassView::unlock_box(),
                              JAVASCRIPT   => 1,
                              TITLE        => 'iB::'.$Lostpass::lang->{'nav_title'}
                            );

}


sub Process {
    my ($obj, $db) = @_;
    $std->Error(LEVEL=>'1',MESSAGE=>'Wha.....?') unless (defined $iB::IN{'CODE'});
    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    require $iB::SKIN->{'DIR'} . '/LostpassView.pm' or die $!;
    my %Mode = ( '00'     => \&Splash,
                 '01'     => \&step_b,
                 '02'     => \&step_c,
                 '03'     => \&unlock_box,

               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : UserCPError();
} 



#+------------------------------------------------------------------------------------------------------

sub UserCPError  { my ($obj, $db) = @_; $std->Error( DB => $db, LEVEL=>'1',MESSAGE=>'incorrect_use') }


#+------------------------------------------------------------------------------------------------------
#+------------------------------------------------------------------------------------------------------

1;

__END__
