package Topic;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# TOPIC: Display the topic.
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'iTextparser.pm';
    require 'iPoll.pm';
    require 'MimeTypes.cfg';
}

my $std      = FUNC::STD->new();
my $mime     = MimeTypes->new();
my $mem      = FUNC::Member->new();
my $output   = FUNC::Output->new();
my $poll     = iPoll->new();
my $psr      = iTextparser->new();
$Topic::lang = $std->LoadLanguage('TopicWords');
 

sub new {
    my $pkg = shift;
    my $obj = { '.can_warn' => 0 };
    bless $obj, $pkg;
    return $obj;
}


#+------------------------------------------------------------------------------------------------------


sub ShowTopic {
    my ($obj, $db) = @_;
    
    return unless ((defined $iB::IN{'t'}) and (defined $iB::IN{'f'}));

    my $First = $iB::IN{'st'} || 0;

    require $iB::SKIN->{'DIR'} . '/TopicView.pm' or die $!;
    $iB::INFO->{'AVATAR_URL'} = $iB::INFO->{'IMAGES_URL'};

    $obj->{'.forum_id'} = $std->IsNumber($iB::IN{'f'}) || 0;
    $obj->{'.topic_id'} = $std->IsNumber($iB::IN{'t'}) || 0;

    #+---------------------------------------------------------
    # Are we looking for an older/newthread?
    #+---------------------------------------------------------
   
    if ($iB::IN{'view'}) {
        my $get_topic = [ {} ];

        my $cur_topic = $db->select( TABLE  => 'forum_topics',
                                     ID     => $obj->{'.forum_id'},
                                     KEY    => $obj->{'.topic_id'}
                                   );

        if ($iB::IN{'view'} eq 'new') {
            $get_topic = $db->query( TABLE    => 'forum_topics',
                                     ID       => $obj->{'.forum_id'},
                                     WHERE    => "FORUM_ID == '$obj->{'.forum_id'}' and APPROVED == 1 and TOPIC_LAST_DATE > '$cur_topic->{'TOPIC_LAST_DATE'}'",
                                     RANGE    => "0 to 1",
                                     SORT_KEY => 'TOPIC_LAST_DATE',
                                     SORT_BY  => 'A-Z'
                                    );
                
            $get_topic->[0]->{'TOPIC_ID'} ? $obj->{'.topic_id'} = $get_topic->[0]->{'TOPIC_ID'}
                                          : $std->Error( DB => $db, LEVEL => 1, MESSAGE => "no_newer");
            # Make sure the rest of the scripts catch up..
            $iB::IN{'t'} = $obj->{'.topic_id'};
               
        }

        if ($iB::IN{'view'} eq 'old') {
            $get_topic = $db->query( TABLE    => 'forum_topics',
                                     ID       => $obj->{'.forum_id'},
                                     WHERE    => "FORUM_ID == '$obj->{'.forum_id'}' and APPROVED == 1 and TOPIC_LAST_DATE < '$cur_topic->{'TOPIC_LAST_DATE'}'",
                                     RANGE    => "0 to 1",
                                     SORT_KEY => 'TOPIC_LAST_DATE',
                                     SORT_BY  => 'Z-A'
                                   );
            $get_topic->[0]->{'TOPIC_ID'} ? $obj->{'.topic_id'} = $get_topic->[0]->{'TOPIC_ID'}
                                          : $std->Error( DB => $db, LEVEL => 1, MESSAGE => "no_older");
            # Make sure the rest of the scripts catch up..
            $iB::IN{'t'} = $obj->{'.topic_id'};
        }

    }

    #+---------------------------------------------------------
    # Load the relevant forum/topic info
    #+----------------------------------------------------------

    $obj->{'FORUM'} = $db->select( TABLE => 'forum_info',
                                   KEY   => $obj->{'.forum_id'},
                                 );

    $obj->{'TOPIC'} = $db->select( TABLE => 'forum_topics',
                                   ID    => $obj->{'.forum_id'},
                                   KEY   => $obj->{'.topic_id'}
                                 );

    #+---------------------------------------------------------
    # Assume nothing, confirm everything.
    #+---------------------------------------------------------

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'missing_files',
               ) unless defined $obj->{'FORUM'}->{'FORUM_ID'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'missing_files',
               ) unless defined $obj->{'TOPIC'}->{'TOPIC_ID'};

    # If someone has bookmarked this topic either via the topic tracker
    # or via their web browser, we'll need to redirect them.
    # The same is true is they surf on it from the last post link in forum
    # view.

    if ($obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'link') {
        my ($forum, $topic_id) = split "&", $obj->{'TOPIC'}->{'MOVED_TO'};
        $output->redirect_screen( URL => "act=ST&f=$forum&t=$topic_id", TEXT => $Topic::lang->{topic_moved} );
    }


    #+---------------------------------------------------------
    # Check Viewing Permissions
    #+---------------------------------------------------------

    unless ($obj->{'TOPIC'}->{'PIN_STATE'} or $iB::MEMBER_GROUP->{'OTHER_TOPICS'}) {
        $std->Error( DB      => $db,
                     LEVEL   => 1,
                     MESSAGE =>'no_view_topic'
                   ) unless $obj->{'TOPIC'}->{'TOPIC_STARTER'} eq $iB::MEMBER->{'MEMBER_ID'};
    }

    #+---------------------------------------------------------
    # Check for viewing access
    #+---------------------------------------------------------

    my $check = $obj->Check_access($db);
    return if $check == 1;

    #+---------------------------------------------------------
    # Update topic views
    #+---------------------------------------------------------

    ++$obj->{'TOPIC'}->{'TOPIC_VIEWS'};

    $db->update( TABLE  => 'forum_topics',
                 ID     => $obj->{'.forum_id'},
                 KEY    => $obj->{'.topic_id'},
                 VALUES => { TOPIC_VIEWS => $obj->{'TOPIC'}->{'TOPIC_VIEWS'} },
               );


    $obj->{'FORUM'}->{'JUMP'} = $std->ForumJump();
    $obj->{'FORUM'}->{'JUMP'} =~ s!#Forum Jump#!$Topic::lang->{'forum_jump'}!;

    #+---------------------------------------------------------
    # Grab the member groups and push into a hash
    #+---------------------------------------------------------

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'TEAM_ICON'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my %temp_table = map { $_->{'ID'} => { TITLE  => $_->{'TITLE'},
                                           ICON   => $_->{'TEAM_ICON'}
                                         }
                         } @{$mem_groups};
    $obj->{'group_table'} = \%temp_table;

    #+---------------------------------------------------------
    # Grab the member titles and push into a hash
    #+---------------------------------------------------------

    my $mem_titles = $db->query( TABLE      => 'member_titles',
                                 COLUMNS    => ['ID', 'TITLE', 'PIPS'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my %temp_titles = map { $_->{'ID'} => { TITLE => $_->{'TITLE'},
                                            PIPS  => $_->{'PIPS'}
                                          }
                          } @{$mem_titles};
    $obj->{'title_table'} = \%temp_titles;

    #+---------------------------------------------------------
    # Load the moderator if needed
    #+---------------------------------------------------------

    unless( (!$iB::MEMBER->{'MEMBER_ID'}) or ($iB::MEMBER_GROUP->{'IS_SUPMOD'}) ) {
        $obj->{'moderator'} = { };

        $obj->{'moderator'} = $db->query( TABLE      => 'forum_moderators',
                                          MATCH      => 'ONE',
                                          WHERE      => qq!FORUM_ID == "$obj->{'.forum_id'}" and MEMBER_ID eq "$iB::MEMBER->{'MEMBER_ID'}"!
                                        );
    }
    
    #+---------------------------------------------------------
    # How are we sorting this topic?
    #+---------------------------------------------------------

    my $sort_by      = $iB::IN{'sort_by'} || $iB::INFO->{'TOPIC_SORT_ORDER'} || "Z-A";

    my $sort_by_keys = { 'Z-A'  => 'descending_order',
                         'A-Z'  => 'ascending_order',
                       };

    $std->Error( DB      => $db,
                 LEVEL   => 5,
                 MESSAGE =>'illegal_sort_use'
               ) unless (exists $sort_by_keys->{$sort_by});

    #+---------------------------------------------------------
    # Get the posting buttons
    #+---------------------------------------------------------

 
    $obj->{'TOPIC'}->{'REPLY_BUTTON'}
        = $obj->get_t_button();

    $obj->{'TOPIC'}->{'POLL_BUTTON'}
        = $iB::INFO->{'ALLOW_POLLS'} ? qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Poll;CODE=01;f=$iB::IN{'f'}' title="$Topic::lang->{'start_new_poll'}">$iB::SKIN->{'A_POLL'}</a>]
                                     : '';

    $obj->{'TOPIC'}->{'TOPIC_START_DATE'} = $std->get_date( TIME => $obj->{'TOPIC'}->{'TOPIC_START_DATE'}, METHOD => 'LONG' );

    ####################################
    # Generate the forum page span links
    ####################################
    $obj->{'TOPIC'}->{'SHOW_PAGES'}
        = $std->build_pagelinks( TOTAL_POSS  => ($obj->{'TOPIC'}->{'TOPIC_POSTS'}+1),
                                 PER_PAGE    => $iB::INFO->{'DISPLAY_MAX_POSTS'},
                                 CUR_ST_VAL  => $iB::IN{'st'},
                                 L_SINGLE    => $Topic::lang->{'single_page_topic'},
                                 L_MULTI     => $Topic::lang->{'multi_page_topic'},
                                 BASE_URL    => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=ST;f=$obj->{'FORUM'}->{'FORUM_ID'};t=$obj->{'TOPIC'}->{'TOPIC_ID'}",
                               );

    #+---------------------------------------------------------
    # Do we have a poll to view?
    #+---------------------------------------------------------

    my $Print =  $poll->display_poll(  DB          => $db,
                                       FORUM_ID    => $obj->{'.forum_id'},
                                       TOPIC_ID    => $obj->{'.topic_id'}
                                    );

    #+---------------------------------------------------------
    # Mash the language pack entries
    #+---------------------------------------------------------

    $Topic::lang->{'topic_stats'}   =~ s!<#START#>!$obj->{'TOPIC'}->{'TOPIC_START_DATE'}!;
    $Topic::lang->{'topic_stats'}   =~ s!<#POSTS#>!$obj->{'TOPIC'}->{'TOPIC_POSTS'}!;
    $obj->{'TOPIC'}->{'TOPIC_DESC'} = ', '.$obj->{'TOPIC'}->{'TOPIC_DESC'} if $obj->{'TOPIC'}->{'TOPIC_DESC'};

    #+---------------------------------------------------------
    # Render the page top
    #+---------------------------------------------------------


    $Print .= TopicView::PageTop({ 
                                  TOPIC => $obj->{'TOPIC'},
                                  FORUM => $obj->{'FORUM'}
                                 }
                                );

    #+---------------------------------------------------------
    # Grab the posts to show.
    #+---------------------------------------------------------


    my $total_posts = $db->query( TABLE    => 'forum_posts',
                                  DBID     => 'f'.$obj->{'.forum_id'},
                                  ID       => $obj->{'.topic_id'},
                                  WHERE    => "TOPIC_ID == '$obj->{'.topic_id'}' and QUEUED != '1'",
                                  RANGE    => $First.' to '.($iB::INFO->{'DISPLAY_MAX_POSTS'} + ($First - 1)),
                                  SORT_KEY => 'POST_DATE',
                                  SORT_BY  => $sort_by
                                 );

    my $Cnt = 0;

    my $member_hash = {};

    #+---------------------------------------------------------
    # Bash, smash and thrash the data
    #+---------------------------------------------------------

    for my $Row (@{$total_posts}) {

        # We want to internally cache the loaded member data. There seems little point in spinning up
        # the server everytime we need the member details if that member has posted 3 or 4 times in the
        # topic - as is often the case. We can make good savings here.
       
        $obj->{POSTER} = undef;

        if ($Row->{AUTHOR_TYPE} == 1) {
            # Is it in our hash?
            if (exists $member_hash->{ $Row->{AUTHOR} }) {
                # Ok, lets read from the hash
                $obj->{POSTER} = $member_hash->{ $Row->{AUTHOR} };
                $Row->{'NAME_CSS'} = 'normalname';
            }
            else {
                $obj->{POSTER} = $mem->LoadMember( DB => $db, KEY => $Row->{AUTHOR}, METHOD => 'by id');
                # Do we have a geniune member to use?
                if ($obj->{POSTER}->{MEMBER_ID}) {
                    # Parse the member...
                    $obj->do_member($Row);
                    $Row->{'NAME_CSS'} = 'normalname';
                    # Set the hash.
                    $member_hash->{ $Row->{AUTHOR} } = $obj->{POSTER};
                } else {
                    # It's probably a deleted member, so..
                    $mem->SetUpGuest($Row->{AUTHOR});
                    $Row->{'NAME_CSS'} = 'unreg';
                }
            }
        } else {
            # Else, it must be a guest, so do nothing but
            # set up the default data.
            $obj->{POSTER} = $mem->SetUpGuest($Row->{AUTHOR});
            $obj->do_guest();
            $Row->{'NAME_CSS'} = 'unreg';
        }

        $Cnt == 0 ? eval { $Row->{'POST_BACK_COL'} = $iB::SKIN->{'POST_COL_ONE'}; ++$Cnt;   }
                  : eval { $Row->{'POST_BACK_COL'} = $iB::SKIN->{'POST_COL_TWO'}; $Cnt = 0; };

        if ($iB::IN{'hl'}) {
            $Row->{'POST'} =~ s!(\s{1,3}|\A|<br>|\(|"|')($iB::IN{'hl'})(\s{1,3}|\Z|<br>|,|\.|\!|\?|\)|"|')!$1<span style='color:#FF0000'><b>$2</b></span>$3!ig;
        }
        $iB::SKIN->{'EDIT_FONT_SIZE'} ||= 7;
        $Row->{'POST'}     =~ s#<!--EDIT\|(.+?)\|(.+?)-->#<span style='font-size:$iB::SKIN->{'EDIT_FONT_SIZE'}pt'>Edited by $1 on $2</span>#ig;

        unless ($iB::MEMBER->{'VIEW_IMG'}) {
            $Row->{'POST'} =~ s#<img src=["'](?!$iB::INFO->{'EMOTICONS_URL'})(\S+)["'].+?>#\(IMG:<a href="$1" target="_blank">$1</a>\)#isg; 
        } 
        
        $Row->{'DELETE_ICON'} = $obj->delete_button($Row->{'POST_ID'});        
        $Row->{'EDIT_ICON'}   = $obj->edit_button($Row->{'POST_ID'});
        $Row->{'POST_DATE'}   = $std->get_date( TIME => $Row->{'POST_DATE'}, METHOD => 'LONG');
        $Row->{'POST_ICON'}   = $Row->{'POST_ICON'} 
                              ? $iB::INFO->{'IMAGES_URL'}.'/PostIcons/icon'.$Row->{'POST_ICON'}.'.gif'
                              : $iB::INFO->{'IMAGES_URL'}.'/PostIcons/icon0.gif';

        $Row->{'USER_IP'}     = $obj->view_ip($Row);

        $Row->{REPORT_POST}   = $iB::INFO->{REPORT_POST_ENABLED} && $iB::MEMBER->{'MEMBER_ID'} ? TopicView::report_link($Row) : '';

        if ($Row->{'ATTACH_ID'} and $obj->{'FORUM'}->{'ALLOW_ATTACH'}) {
            # Let there be attachments!
            # Is it an image, and are we just adding it to the post?
            if (($iB::INFO->{'IMG_ATT_SHOW'}) and
               ($Row->{'ATTACH_TYPE'} eq "image/gif" or $Row->{'ATTACH_TYPE'} eq "image/jpeg" or $Row->{'ATTACH_TYPE'} eq "image/x-png" or $Row->{'ATTACH_TYPE'} eq "image/pjpeg") ) {
               my $at = $db->select( TABLE => 'attachments',
                                     KEY   => $Row->{'ATTACH_ID'},
                                   );
               $Row->{'RENDER_ATTACHMENT'} = TopicView::Show_attachments_img( { NAME => $at->{'FILE_NAME'} } );
            } else {
                $Row->{'RENDER_ATTACHMENT'} = TopicView::Show_attachments( { 
                                                                             ID    => $Row->{'ATTACH_ID'},
                                                                             HITS  => $Row->{'ATTACH_HITS'}, 
                                                                             IMG   => $mime->{ $Row->{'ATTACH_TYPE'} }[1],
                                                                             NAME  => $mime->{ $Row->{'ATTACH_TYPE'} }[2],
                                                                             POST  => $Row->{'POST_ID'},
                                                                             TOPIC => $obj->{'TOPIC'}->{'TOPIC_ID'},
                                                                             FORUM => $obj->{'FORUM'}->{'FORUM_ID'},
                                                                         } );
            }
        }

        # Do we have a signature to add?
    
        $iB::INFO->{'SIG_SEP'} ||= '<br><br>--------------<br>';

        if ($obj->{'POSTER'}->{'SIGNATURE'} and $iB::MEMBER->{'VIEW_SIGS'}) {
            $Row->{'SIGNATURE'} = $Row->{'ENABLE_SIG'}
                                  ?  qq[<!--Signature-->$iB::INFO->{'SIG_SEP'}<span id='signature'>$obj->{'POSTER'}->{'SIGNATURE'}</span><!--E Signature-->]
                                  : ();
        }


        $Print .= TopicView::RenderRow( { POST => $Row, POSTER => $obj->{'POSTER'} } );
        $obj->{'POSTER'} = undef;
    }

    #+---------------------------------------------------------
    # Do the table footer
    #+---------------------------------------------------------

    $Print .= TopicView::TableFooter({ 
                                        TOPIC => $obj->{'TOPIC'},
                                        FORUM => $obj->{'FORUM'}
                                     }
                                    );

    #+---------------------------------------------------------
    # Slide all the info to the output routines
    #+---------------------------------------------------------

    $Print .= $obj->Moderation_panel($db);   

    my $cat = $db->select( TABLE   => 'categories',
                           KEY     => $obj->{'FORUM'}->{'CATEGORY'},
                           COLUMNS => ['CAT_ID', 'CAT_NAME']
                         );

    # Fix up the javascript.

    $output->print_ikonboard( DB         => $db,
                              STD        => $std,
                              OUTPUT     => $Print,
                              JAVASCRIPT => 1,
                              TITLE      => "iB::".$Topic::lang->{topic_page_h}."::$obj->{'TOPIC'}->{'TOPIC_TITLE'}",
                              NAV        => [ 
                                              qq|<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SC;c=$cat->{'CAT_ID'}" class='nav'>$cat->{'CAT_NAME'}</a>|,
                                              qq|<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SF;f=$obj->{'FORUM'}->{'FORUM_ID'}" class='nav'>$obj->{'FORUM'}->{'FORUM_NAME'}</a>|,
                                              qq|$obj->{'TOPIC'}->{'TOPIC_TITLE'}|
                                            ]
                            );
}



    #+---------------------------------------------------------
    # Done...
    #+---------------------------------------------------------






#+------------------------------------------------------------------------------------------------------

sub do_member ($$) {
    my ($obj, $Row) = @_;

    $obj->{'POSTER'}->{'MEMBER_AVATAR'}
        = $obj->get_avatar();

    $obj->{'POSTER'}->{'MEMBER_TITLE'}
        = $obj->{'POSTER'}->{'MEMBER_TITLE'} ? $obj->{'POSTER'}->{'MEMBER_TITLE'}
                                             : $obj->{'title_table'}->{  $obj->{'POSTER'}->{'MEMBER_LEVEL'}  }->{'TITLE'};

    $obj->{'POSTER'}->{'MEMBER_JOINED'}
        = $Topic::lang->{'m_joined'}.' '.$std->get_date( TIME => $obj->{'POSTER'}->{'MEMBER_JOINED'}, METHOD => 'JOINED'); 
  

    unless( $obj->{'group_table'}->{ $obj->{'POSTER'}->{'MEMBER_GROUP'} }->{'ICON'} ) {
        $obj->{'POSTER'}->{'MEMBER_PIPS'} = $obj->{'title_table'}->{  $obj->{'POSTER'}->{'MEMBER_LEVEL'}  }->{'PIPS'};
        if (defined $obj->{'POSTER'}->{'MEMBER_PIPS'}) {
            if ($obj->{'POSTER'}->{'MEMBER_PIPS'} !~ /^\d+$/) {
                 $obj->{'POSTER'}->{'MEMBER_PIPS_IMG'} = qq!<img src="$iB::INFO->{'TEAM_ICON_URL'}/$obj->{'POSTER'}->{'MEMBER_PIPS'}" border='0'>!;
            } else {
                 $obj->{'POSTER'}->{'MEMBER_PIPS_IMG'} = qq!$iB::SKIN->{'A_STAR'}! x $obj->{'POSTER'}->{'MEMBER_PIPS'};
            }
        }
    } else {
        $obj->{'POSTER'}->{'MEMBER_PIPS_IMG'} = qq!<img src="$iB::INFO->{'TEAM_ICON_URL'}/$obj->{'group_table'}->{ $obj->{'POSTER'}->{'MEMBER_GROUP'} }->{'ICON'}" border='0'>!
    }


    $obj->{'POSTER'}->{'MEMBER_GROUP'}
        = $Topic::lang->{'m_group'}.' '.$obj->{'group_table'}->{ $obj->{'POSTER'}->{'MEMBER_GROUP'} }->{'TITLE'};
    $obj->{'POSTER'}->{'MEMBER_POSTS'}
        = $Topic::lang->{'m_posts'}.' '.$obj->{'POSTER'}->{'MEMBER_POSTS'};

    $obj->{'POSTER'}->{'PROFILE_ICON'}
        = qq!<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Profile;CODE=03;MID=$obj->{'POSTER'}->{'MEMBER_ID'}">$iB::SKIN->{'P_PROFILE'}</a>&nbsp;!;

    $obj->{'POSTER'}->{'MESSAGE_ICON'}
        = qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Msg;CODE=04;MID=$obj->{'POSTER'}->{'MEMBER_ID'}'>$iB::SKIN->{'P_MSG'}</a>&nbsp;];

    if ($iB::MEMBER->{MEMBER_ID}) {
        $obj->{'POSTER'}->{'EMAIL_ICON'}
            = $obj->{'MEMBER'}->{'HIDE_EMAIL'} ? ''
                                               : qq[<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Mail;CODE=00;MID=$obj->{'POSTER'}->{'MEMBER_ID'}">$iB::SKIN->{'P_EMAIL'}</a>&nbsp;];
    }

    $obj->{'POSTER'}->{'WEBSITE_ICON'}
        = ($obj->{'POSTER'}->{'WEBSITE'} and $obj->{'POSTER'}->{'WEBSITE'} =~ m#^http://.+?\S$#i)
                                           ? (qq[<a href='$obj->{'POSTER'}->{'WEBSITE'}' target='_blank'>$iB::SKIN->{'P_WEBSITE'}</a>&nbsp;])
                                           : ('');

    $obj->{'POSTER'}->{'ICQ_ICON'}
        = !$obj->{'POSTER'}->{'ICQNUMBER'}  ? ''
                                           : qq[<a href="javascript:PopUp('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=ICQ&MID=$obj->{'POSTER'}->{'MEMBER_ID'}','Pager','450','330','0','1','1','1')">$iB::SKIN->{'P_ICQ'}</a>&nbsp;];
    $obj->{'POSTER'}->{'AOL_ICON'}
        = $obj->{'POSTER'}->{'AOLNAME'}   eq '' ? ''
                                                : qq[<a href="javascript:PopUp('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=AOL&MID=$obj->{'POSTER'}->{'MEMBER_ID'}','Pager','450','330','0','1','1','1')">$iB::SKIN->{'P_AOL'}</a>&nbsp;];

    # Get the member warn GFX
    $obj->{'POSTER'}->{'WARN_GFX'} = '';

    # Does the member have a warn value?
    if ($obj->{'POSTER'}->{'WARN_LEVEL'} and length($obj->{'POSTER'}->{'WARN_LEVEL'}) == 1) {
        # Do we have permission to view the level?
        if ( $iB::MEMBER->{'MEMBER_ID'} and ($iB::MEMBER_GROUP->{'IS_SUPMOD'} or $obj->{'moderator'}->{'ALLOW_WARN'}) ) {
            # ..apparently so..
            $obj->{'POSTER'}->{'WARN_GFX'} = $iB::SKIN->{ 'WARN_'.$obj->{'POSTER'}->{'WARN_LEVEL'} };
            # Set it so the viewing member can adjust the level..
            $obj->{'.can_warn'} = 1;
        }
    }

    # Sort out the members siggy
    if ($obj->{POSTER}->{SIGNATURE}) {
        $obj->{POSTER}->{SIGNATURE} = $psr->Convert_for_db( TEXT    => $obj->{POSTER}->{SIGNATURE},
                                                            SMILIES => $iB::INFO->{'SIG_ALLOW_EMOTICONS'},                                                              SMILIES => 0,
                                                            IB_CODE => $iB::INFO->{'SIG_ALLOW_IBC'},
                                                            HTML    => $iB::INFO->{'SIG_ALLOW_HTML'},
                                                            SIG     => 1
                                                          );
    }

}

sub do_guest ($) {
    my $obj = shift;

    $obj->{'POSTER'}->{'MEMBER_AVATAR'} = undef;
    $obj->{'POSTER'}->{'MEMBER_TITLE'}  = 'Unregistered';
    $obj->{'POSTER'}->{'MEMBER_PIPS'}   = undef;
    $obj->{'POSTER'}->{'MEMBER_JOINED'} = undef;
    $obj->{'POSTER'}->{'SIGNATURE'}     = undef;
    $obj->{'POSTER'}->{'PROFILE'}       = undef;
    $obj->{'POSTER'}->{'MEMBER_POSTS'}  = undef;
    $obj->{'POSTER'}->{'MEMBER_GROUP'}  = undef;
    $obj->{'POSTER'}->{'MEMBER_JOINED'} = undef;
}

sub Check_access ($) {
    my ($obj, $db) = @_;

    if ($obj->{'FORUM'}->{'FORUM_PROTECT'}) {
        if (exists $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $obj->{'FORUM'}->{'FORUM_ID'} }) {
            return if $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $obj->{'FORUM'}->{'FORUM_ID'} } eq $obj->{'FORUM'}->{'FORUM_PROTECT'};
        }
        $output->redirect_screen( TEXT => "$Topic::lang->{'please_log_in'}", URL => "?act=SF;f=$iB::IN{'f'}");
        return 1;
    }

    if ($obj->{'FORUM'}->{'FORUM_VIEW_THREADS'} ne '*') {
        unless (grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split /,/,$obj->{'FORUM'}->{'FORUM_VIEW_THREADS'}) ) {
            $std->Error(     DB      => $db,
                             LEVEL   => '2',
                             MESSAGE =>'forum_no_access'
                       );
        }
    }
    return 0;
}



#+------------------------------------------------------------------------------------------------------

sub view_ip {
    my ($obj,$Row) = @_;
    if ($iB::MEMBER_GROUP->{'IS_SUPMOD'} or $obj->{'moderator'}->{'VIEW_IP'}) {

        $Row->{'IP_ADDR'} = $obj->{'POSTER'}->{'MEMBER_GROUP'} == $iB::INFO->{'SUPAD_GROUP'}
                          ? qq~[ -------- ]~
                          : qq~[ <a href='http://www.nic.com/cgi-bin/whois.cgi?query=$Row->{'IP_ADDR'}' target='_blank'>$Row->{'IP_ADDR'}</a> ]~;

        return TopicView::ip_show($Row->{'IP_ADDR'});
    } else {
        return undef;
    }
}

#+------------------------------------------------------------------------------------------------------
my $action = { 'CLOSE_TOPIC'  => '00',
               'OPEN_TOPIC'   => '01',
               'MOVE_TOPIC'   => '02',
               'DELETE_TOPIC' => '03',
               'EDIT_TOPIC'   => '05',
               'PIN_TOPIC'    => 15,
               'UNPIN_TOPIC'  => 16,
               'RECOUNT'      => 17,
             };

sub Moderation_panel {
    my ($obj, $db) = @_;
    # Not a member? Sod off then..
    return unless $iB::MEMBER->{'MEMBER_ID'};

    return unless (
                    ($iB::MEMBER->{'MEMBER_ID'} eq $obj->{'TOPIC'}->{'TOPIC_STARTER'})
                      or ($iB::MEMBER_GROUP->{'IS_SUPMOD'})
                      or ($obj->{'moderator'}->{'MODERATOR_ID'})
                  );
               
    for my $key (qw[MOVE_TOPIC CLOSE_TOPIC OPEN_TOPIC DELETE_TOPIC EDIT_TOPIC PIN_TOPIC UNPIN_TOPIC RECOUNT]) {
        if    ($iB::MEMBER_GROUP->{'IS_SUPMOD'}) {
            $obj->{'.can_do'} .= $obj->_append($key);
        }
        elsif ($obj->{'moderator'}->{'MODERATOR_ID'}) {
            if ($key eq 'RECOUNT') {
                $obj->{'.can_do'} .= $obj->_append($key);
            } else {
                $obj->{'.can_do'} .= $obj->_append($key) if $obj->{'moderator'}->{ $key };
            }
        }
        elsif ($key eq 'OPEN_TOPIC' or $key eq 'CLOSE_TOPIC') {
            $obj->{'.can_do'} .= $obj->_append($key) if ($iB::MEMBER_GROUP->{'OPEN_CLOSE_TOPICS'});
        }
        elsif ($key eq 'EDIT_TOPIC') {
            if ($iB::MEMBER_GROUP->{'EDIT_OWN_TOPICS'}) {
                $obj->{'.can_do'} .= $obj->_append($key);
            }
        }
        elsif ($key eq 'DELETE_TOPIC') {
            $obj->{'.can_do'} .= $obj->_append($key) if ($iB::MEMBER_GROUP->{'DELETE_OWN_TOPICS'});
        }
    }

    # Do we have the link to the moderators control panel to show?
    if ($iB::MEMBER_GROUP->{'IS_SUPMOD'} or $obj->{'moderator'}->{'MODERATOR_ID'}) {
        $obj->{'.can_do'} .= TopicView::mod_cp_link( $iB::IN{'f'} );
    }

    return TopicView::Mod_Panel($obj->{'.can_do'}) if $obj->{'.can_do'};
}


sub _append {
    my ($obj, $moderate) = @_;
    return if $obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'open'   and $moderate eq 'OPEN_TOPIC';
    return if $obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'closed' and $moderate eq 'CLOSE_TOPIC';
    return if $obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'moved'  and ($moderate eq 'CLOSE_TOPIC' or $moderate eq 'MOVE_TOPIC');
    return if $obj->{'TOPIC'}->{'PIN_STATE'}   and $moderate eq 'PIN_TOPIC';
    return if $obj->{'TOPIC'}->{'PIN_STATE'} < 1  and $moderate eq 'UNPIN_TOPIC';
    return  qq{[ <a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Mod;CODE=$action->{$moderate};f=$iB::IN{'f'};t=$iB::IN{'t'};st=$iB::IN{'st'}'>$Topic::lang->{ $moderate }</a> ] };
}

#+------------------------------------------------------------------------------------------------------

sub get_avatar {
    my $obj = shift;
    return unless $iB::INFO->{'AVATARS'}
              and $obj->{'POSTER'}->{'MEMBER_AVATAR'}
              and $iB::MEMBER->{'VIEW_AVS'};

    return if $obj->{'POSTER'}->{'MEMBER_AVATAR'} eq 'noavatar';
    return '' if $obj->{'POSTER'}->{'MEMBER_AVATAR'} =~ m#\.swf#i and $iB::INFO->{'ALLOW_FLASH'} != 1;
    my ($a_width   , $a_height)  = split "x", $iB::INFO->{'AV_DIMS'};
    my ($d_a_width, $d_a_height) = split "x", $iB::INFO->{'DEF_AV_DIMS'};
    if ($obj->{'POSTER'}->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i) {
        if ($iB::INFO->{'AV_ALLOW_URL'}) {
            my ($width  , $height)   = split "x", $obj->{'POSTER'}->{'AVATAR_DIMS'};
            $height ||= $a_height;
            $width  ||= $a_width;           
            return $obj->{'POSTER'}->{'MEMBER_AVATAR'} =~ m#\.swf\Z#i ? qq|<OBJECT CLASSID="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" WIDTH=$width HEIGHT=$height><PARAM NAME=MOVIE VALUE=$obj->{'POSTER'}->{'MEMBER_AVATAR'}><PARAM NAME=PLAY VALUE=TRUE><PARAM NAME=LOOP VALUE=TRUE><PARAM NAME=QUALITY VALUE=HIGH><EMBED SRC=$obj->{'POSTER'}->{'MEMBER_AVATAR'} WIDTH=$width HEIGHT=$height PLAY=TRUE LOOP=TRUE QUALITY=HIGH></EMBED></OBJECT>|
                                                                      : qq|<img src='$obj->{'POSTER'}->{'MEMBER_AVATAR'}' border='0' width='$width' height='$height' alt=''>|;
        }
    }
    return qq|<img src='$iB::INFO->{'AVATARS_URL'}/$obj->{'POSTER'}->{'MEMBER_AVATAR'}' border='0' width='$d_a_width' height='$d_a_height' alt=''>| unless $obj->{'POSTER'}->{'MEMBER_AVATAR'} =~ m#\Ahttp\://#i;
}



#+------------------------------------------------------------------------------------------------------

sub edit_button {
    my ($obj, $post_number) = @_;
    return unless $iB::MEMBER->{'MEMBER_ID'};
    my $edit_button =  qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Post;CODE=08;f=$iB::IN{'f'};t=$iB::IN{'t'};p=$post_number;st=$iB::IN{'st'}'>$iB::SKIN->{'P_EDIT'}</a>];
    return $edit_button if $iB::MEMBER_GROUP->{'IS_SUPMOD'};
    return $edit_button if $obj->{'moderator'}->{'EDIT_POST'};
    return $edit_button if $obj->{'POSTER'}->{'MEMBER_ID'} eq $iB::MEMBER->{'MEMBER_ID'} and $iB::MEMBER_GROUP->{'EDIT_OWN_POSTS'};
    return;
}



#+------------------------------------------------------------------------------------------------------



sub delete_button {
    my ($obj, $post_number) = @_;
    return unless $iB::MEMBER->{'MEMBER_ID'};
    return if $post_number == 1;
    my $button = qq[<a href="javascript:delete_post('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Mod;CODE=04;f=$iB::IN{'f'};t=$iB::IN{'t'};p=$post_number;st=$iB::IN{'st'}')">$iB::SKIN->{'P_DELETE'}</a>];
    return $button if $iB::MEMBER_GROUP->{'IS_SUPMOD'};
    return $button if $obj->{'moderator'}->{'DELETE_POST'};
    return $button if $obj->{'POSTER'}->{'MEMBER_ID'} eq $iB::MEMBER->{'MEMBER_ID'} and $iB::MEMBER_GROUP->{'DELETE_OWN_POSTS'};
    return;

}

#+------------------------------------------------------------------------------------------------------

sub get_t_button ($) {
    my $obj = shift;
    return $iB::SKIN->{'A_LOCKED_B'}      if $obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'closed';
    return $iB::SKIN->{'A_MOVED_B'}       if $obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'moved';
    return $iB::SKIN->{'A_POLLONLY_B'}   if $obj->{'TOPIC'}->{'POLL_STATE'} eq 'closed';
    return qq!<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Post;CODE=02;f=$obj->{'FORUM'}->{'FORUM_ID'};t=$obj->{'TOPIC'}->{'TOPIC_ID'}" title='$Topic::lang->{'reply_to_topic'}'>$iB::SKIN->{'A_REPLY'}</a>! if $obj->{'TOPIC'}->{'TOPIC_STATE'} eq 'open';
}


1;
