package Search::api;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Search: Search Functions.
#
#################################################################################

# Suck in the universal libraries
BEGIN {  require 'Lib/FUNC.pm';  }

# Set us up some contructors
my $output    = FUNC::Output->new();
my $std       = FUNC::STD->new();
$Search::lang = $std->LoadLanguage('SearchWords');

# Get the correct DB_DRIVER api
require "Search/API/api_".$iB::INFO->{DB_DRIVER}.".pm";
require Search::API::api_global;

sub new {
     my $pkg = shift;
     my $obj = {};
     bless $obj, $pkg;
     return $obj;
}


# Search Form
# -----------
# Grabs the forums the viewer is allowed to search in and displays the form

sub SearchForm {
    my ($obj, $db) = @_;

    my $html;

    # Have we a search still in the DB?
    if (exists $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'lsearch' }) {
        my $id = $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'lsearch' };
        # Make sure we're not being naughty with our cookies
        $std->Error( LEVEL => 1, DB => $db, MESSAGE => 'incorrect_use') unless $id =~ m!^(?:[\w\d]+)$!;
        if (-e $iB::INFO->{'DB_DIR'}.'Temp/Searches'."/$id") {
            # Open the file
            open SEARCH, $iB::INFO->{'DB_DIR'}.'Temp/Searches'."/$id" or die $!;
            my @search_results = <SEARCH>;
            close SEARCH;
            # Unshift the needed variables
            my $date        = shift @search_results;
            my $keywords    = shift @search_results;
            my $search_in   = shift @search_results;
            my $search_type = shift @search_results;
            chomp($date); chomp($keywords); chomp($search_in); chomp($search_type);
            my $matches     = scalar (@search_results);
            # Swop placeholders for the vars...
            $date = $std->get_date( TIME => $date, METHOD => 'SHORT');
            $Search::lang->{'search_string'} =~ s!<#DATE#>!$date!;
            $Search::lang->{'search_string'} =~ s!<#TYPE#>!$Search::lang->{'ll_'.$search_type}!;
            $Search::lang->{'search_string'} =~ s!<#IN#>!$Search::lang->{'ll_'.$search_in}!;
            $Search::lang->{'search_string'} =~ s!<#WORDS#>!$keywords!;
            $Search::lang->{'search_string'} =~ s!<#MATCHES#>!$matches!;
            # Print it out..
            $html = SearchView::redo_search( { ID => $id } );
        }
    }

    # Pretty self explanatory
    my $select_html = qq[\t<select name='forums' multiple size='10'  class='textinput' style='width:100%;' onChange='addForum()'>\n
                           <option value='all'>&gt;&gt;All open forums
                           <option value='-'>--------------------\n];

    # Get the categoies...
    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        WHERE     => 'CAT_STATE ne "off"',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    # Get the forums...
    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};


    # Start looping through to gather the viewable forums for this member.
    for my $this_cat (@{ $obj->{'TOTAL_CATS'} }) {

        my @these_cat_forums = grep { $_->{'CATEGORY'} == $this_cat->{'CAT_ID'} } @{ $obj->{'TOTAL_FORUMS'} };

        $select_html .= qq[\t\t<option value='-'>&gt;&gt;$this_cat->{'CAT_NAME'}];


        for my $this_forum (@these_cat_forums) {

            if ($this_forum->{'FORUM_PROTECT'}) {
                next unless $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $this_forum->{'FORUM_ID'} } eq $this_forum->{'FORUM_PROTECT'};
            }
            
            if ($this_forum->{'FORUM_VIEW_THREADS'} ne '*') {
                next unless grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split /,/,$this_forum->{'FORUM_VIEW_THREADS'});
            }
            
            $select_html .= (defined $iB::IN{'f'} and $iB::IN{'f'} == $this_forum->{'FORUM_ID'})
                            ? (qq[\t\t\t<option value='$this_forum->{'FORUM_ID'}' selected>&nbsp;-$this_forum->{'FORUM_NAME'}\n])
                            : (qq[\t\t\t<option value='$this_forum->{'FORUM_ID'}'>&nbsp;-$this_forum->{'FORUM_NAME'}\n]);

        }
    }
    
    $select_html .= "\t</select>";

    $html .= &SearchView::Form($select_html);

    # Done, just print the form...
    $output->print_ikonboard( DB           => $db,
                              STD          => $std,
                              NAV          => [$Search::lang->{'search_title'}],
                              OUTPUT       => $html,
                              JAVASCRIPT   => '1',
                              TITLE        => "iB::" . $Search::lang->{'search_form'}
                            );
}


sub get_new {
    my ($obj, $db) = @_;

    $iB::last_visit ||= time;
    $iB::last_visit =~ s![^\d]!!g;   #Ensure it's a pure number

    # Lets make sure that we have a /Temp/Searches/ directory.

    unless (-e $iB::INFO->{'DB_DIR'}.'Temp/Searches' ) {
        mkdir ($iB::INFO->{'DB_DIR'}.'Temp/Searches', 0777);
    }

    my $key   = Search::API::api_global::my_gen_id();

    my $forums = $db->query( TABLE     => 'forum_info',
                             SORT_KEY  => 'FORUM_POSITION',
                             SORT_BY   => 'A-Z',
                             MATCH     => 'ALL',
                             COLUMNS   => ['FORUM_ID', 'FORUM_PROTECT', 'FORUM_VIEW_THREADS'],
                           ) || die $db->{'error'};

    my (@search);

    for my $f (@{$forums}) {

        if ($f->{'FORUM_PROTECT'}) {
            next unless $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $f->{'FORUM_ID'} } eq $f->{'FORUM_PROTECT'};
        }
        if ($f->{'FORUM_VIEW_THREADS'} ne '*') {
            next unless grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split /,/,$f->{'FORUM_VIEW_THREADS'});
        }
        # Append to our forums count
        push @search, $f->{'FORUM_ID'};
    }

    my $got_results = Search::API::api_functions::get_new(  DB       => $db,
                                                            DATE     => $iB::last_visit,
                                                            FORUMS   => \@search,
                                                            LIMIT    => 200,
                                                            FILE_KEY => $key,
                                                         );
    
    $output->redirect_screen(  TEXT => "$Search::lang->{'search_completed'}", URL => "act=Search&CODE=02&SID=$key");     

}


# Do Search
# ---------

# Search the search log database for matches to our keywords and selected forums


sub do_search {
    my ($obj, $db) = @_;

    # Clean up the temp searches dir

    Search::API::api_global::clean_up();


    # Are we stupid?
    $std->Error( LEVEL => 1, DB => $db, MESSAGE => 'no_search_words') unless $iB::IN{'keywords'};
  
    # Get the searchable forum_ids

    my $s_forums = Search::API::api_global::get_searchable_forums($db);

    # Do we have any forums to actually search in?
    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_search_forum') unless @$s_forums > 0;


    # Prepare the keywords for searching
    my $words = Search::API::api_global::keyword_filter($iB::IN{'keywords'});

    my $key   = Search::API::api_global::my_gen_id();

    # search, store and query success in one sub.
    # Can you FEEL THE BURN BABY!

    my $got_results = Search::API::api_functions::run_query(   DB          => $db,
                                                               KEYWORDS    => $words,
                                                               PRUNE       => $iB::IN{'prune'},
                                                               PRUNE_TYPE  => $iB::IN{prune_type},
                                                               FORUMS      => $s_forums,
                                                               SEARCH_IN   => $iB::IN{search_in},
                                                               SEARCH_TYPE => $iB::IN{'type'},
                                                               LIMIT       => 200,
                                                               FILE_KEY    => $key,
                                                               );

    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_search_results') unless $got_results;

    # Print a cookie for the "you last searched..." thingy
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'lsearch',  -value => $key,  -expires => '+30d', -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'} );

    $output->redirect_screen(  TEXT => "$Search::lang->{'search_completed'}", URL => "act=Search&CODE=02&SID=$key");    

}


sub show_results {
    my ($obj, $db) = @_;

    my $per_page = 20;
    my $start    = $iB::IN{st}|| 0;
    my $end      = $per_page + ($start - 1);

    # Make sure the search file is there..
    unless (-e $iB::INFO->{'DB_DIR'}.'Temp/Searches'."/$iB::IN{'SID'}") {
        $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_search_results');
    }

    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_search_results') unless $iB::IN{'SID'};

    # Get the search results
    open SEARCH, $iB::INFO->{'DB_DIR'}.'Temp/Searches'."/$iB::IN{'SID'}" or die $!;
    my @search_results = <SEARCH>;
    close SEARCH;

    # Unshift the needed variables
    my $date        = shift @search_results;
    my $keywords    = shift @search_results;
    my $search_in   = shift @search_results;
    my $search_type = shift @search_results;
    my $topic_keys  = shift @search_results;
    my $results     = shift @search_results;

    chomp($topic_keys);
    $topic_keys =~ s/,$//;

    #Double check that there are results to view:

    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_search_results') unless $results > 0;
    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_search_results') unless $topic_keys;

    # Show pages SHOW_PAGES
    my $data = {};
    $data->{SHOW_PAGES} = $std->build_pagelinks( TOTAL_POSS  => $results,
                                                 PER_PAGE    => $per_page,
                                                 CUR_ST_VAL  => $iB::IN{'st'},
                                                 L_SINGLE    => "",
                                                 L_MULTI     => "",
                                                 BASE_URL    => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Search;CODE=02;SID=$iB::IN{SID}",
                                               );

    my $print = SearchView::start($data);

    my $topic_hash = {};
    my $forum_hash = {};


    $print .= Search::API::api_functions::parse_results(   DB           => $db        ,
                                                           START        => $start     ,
                                                           END          => $end       ,
                                                           TOPIC_STRING => $topic_keys,
                                                           KEYWORDS     => $keywords  ,
                                                       );

    $print .= SearchView::end();

    $output->print_ikonboard( DB           => $db,
                              STD          => $std,
                              NAV          => [
                                                qq!<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Search&CODE=00'>$Search::lang->{'search_form'}</a>!,
                                                $Search::lang->{'search_title'}
                                              ],
                              OUTPUT       => $print,
                              JAVASCRIPT   => '1',
                              TITLE        => "iB::" . $Search::lang->{'search_results'}
                            );
    
        
}


        


sub Process {
    my ($obj,$db) = @_;
    $std->Error(LEVEL=>'1',MESSAGE=>'poss_hack_attempt') unless (defined $iB::IN{'CODE'});

    # Can we search?
    unless ($iB::MEMBER_GROUP->{'USE_SEARCH'}) {
        $std->Error( LEVEL => 1, DB => $db, MESSAGE => 'cant_use_feature');
    }

    require $iB::SKIN->{'DIR'} . '/SearchView.pm' or die $!;

    $obj->{'.forum_id'} = $std->IsNumber($iB::IN{'f'});

    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    my %Mode = ( '00'     => \&SearchForm,
                 '01'     => \&do_search,
                 '02'     => \&show_results,

                 '03'     => \&get_new,
               );

  $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : SearchError();
} 




sub my_gen_id {
    my $obj = shift;
    srand($$|time);
    my $session = int(rand(60000000));
    return unpack("H*", pack("Nnn", time, $$, $session));

}
#+------------------------------------------------------------------------------------------------------

1;