package SSI::Parser;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#
#
# Trivial SSI file creator
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $std       = FUNC::STD->new();

$SSI::Parser::Error = undef;

sub parse {

    my %args = ( 
                 VALUES   => {},
                 DB       => "",
                 TEMPLATE => "",
                 EXTRA    => {},
                 @_,
               );

    my $db = $args{'DB'};

    #Lets load the template, or return upon failure

    my $template = $db->select( TABLE    => 'ssi_templates',
                                KEY      => $args{'TEMPLATE'}
                              );

    return if $db->{'error'};


    if ($args{'TEMPLATE'} eq 'news') {
        return unless defined $iB::INFO->{'NEWS_FORUM'} and $iB::INFO->{'NEWS_TOPICS'};

        my $that;

        my $topics = $db->query( TABLE    => 'forum_topics',
                                 ID       => $iB::INFO->{'NEWS_FORUM'},
                                 WHERE    => "FORUM_ID == $iB::INFO->{'NEWS_FORUM'}",
                                 RANGE    => "0 to $iB::INFO->{'NEWS_TOPICS'}",
                                 SORT_BY  => 'Z-A',
                                 SORT_KEY => 'TOPIC_START_DATE'
                               );

        return unless scalar @{$topics} > 0;
        
        my $count = 0;

        for my $t (@{$topics}) {
            $count++;
            my $temp_output = $template->{'TEMPLATE'};
            my $post = $db->query(  TABLE    => 'forum_posts',
                                    DBID     => 'f'.$iB::INFO->{'NEWS_FORUM'},
                                    ID       => $t->{'TOPIC_ID'},
                                    WHERE    => "FORUM_ID == $iB::INFO->{'NEWS_FORUM'} and TOPIC_ID == $t->{'TOPIC_ID'}",
                                    SORT_KEY => 'POST_DATE',
                                    SORT_BY  => 'A-Z',
                                    RANGE    => '0 to 1',
                                 );

            if ($iB::INFO->{'NEWS_LIMIT'}) {
                if (length($post->[0]->{'POST'}) > $iB::INFO->{'NEWS_LIMIT'}) {
                     $post->[0]->{'POST'} = substr($post->[0]->{'POST'}, 0, $iB::INFO->{'NEWS_LIMIT'}) . '....';
                }
            }                

            $temp_output =~ s!<#TITLE#>!$t->{'TOPIC_TITLE'}!g;
            $temp_output =~ s!<#POST_DATE#>!$std->get_date( TIME => $t->{'TOPIC_START_DATE'}, METHOD => 'LONG' )!eg;
            $temp_output =~ s!<#POSTER_NAME#>!$t->{'TOPIC_STARTER_N'}!g;
			$temp_output =~ s!<#NUMBER_COMMENTS#>!$t->{'TOPIC_POSTS'}!g; 
            $temp_output =~ s!<#PROFILE_LINK#>!$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Profile&CODE=03&MID=$t->{'TOPIC_STARTER'}!g;
            $temp_output =~ s!<#THE_POST#>!$post->[0]->{'POST'}!g;
            $temp_output =~ s!<#POST_LINK#>!$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=ST&f=$t->{'FORUM_ID'}&t=$t->{'TOPIC_ID'}!g;
            $temp_output =~ s!<#PRINT_LINK#>!$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Print&f=$t->{'FORUM_ID'}&t=$t->{'TOPIC_ID'}!g;
            $temp_output =~ s!<#NEWS_FORUM_LINK#>!$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=SF&f=$t->{'FORUM_ID'}!g;

            $that .= $temp_output;
            last if $count == $iB::INFO->{'NEWS_TOPICS'};
        }

        $template->{'TEMPLATE'} = $that;

        goto 'OUTPUT';
    }


    if ($args{'TEMPLATE'} eq 'ONLINE_LIST') {
        my $that;
        my $ext = $db->select( TABLE    => 'ssi_templates',
                               KEY      => 'ONLINE_FORMAT'
                             );
        
        for my $v (keys %{$args{'EXTRA'}}) {
            my $this = $ext->{'TEMPLATE'};
            $this =~ s!<%member name%>!$v!g;
            $this =~ s!<%url to profile%>!$args{'EXTRA'}->{$v}!g;
            $that .= $this;
        }

        $args{'VALUES'}->{"list members"} = $that;
        
    }

    for (keys %{$args{'VALUES'}}) {

        $template->{'TEMPLATE'} =~ s!<%$_%>!$args{'VALUES'}->{$_}!g;
    
    }


OUTPUT:

    #Print it to the file...

    open  SSIOUT, ">".$iB::INFO->{'HTML_DIR'}."ssi/$template->{'EXPORT_FILENAME'}" or ($SSI::Parser::Error = "Cannot open file: $!" and return);
    print SSIOUT $template->{'TEMPLATE'};
    close SSIOUT;

    chmod(0777, $iB::INFO->{'HTML_DIR'}."ssi/$template->{'EXPORT_FILENAME'}");

    return "0 but true";
}


1;
