package Register;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Register: Registration Fucntions.
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $mail        = FUNC::Mailer->new();
my $mem         = FUNC::Member->new();
my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
$Register::lang = $std->LoadLanguage('RegisterWords');


sub new {
  my $pkg = shift;
  my $obj = {};
  bless $obj, $pkg;
  return $obj;
}



sub CreateAccount {
    my ($obj, $db) = @_;
    
    # Check to make sure the form was filled in correctly
    
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'no_username')     unless $iB::IN{'UserName'};
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'username_short')  unless length($iB::IN{'UserName'}) >= 3;
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'username_long')   unless length($iB::IN{'UserName'}) <= 32;
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'pass_blank')      unless $iB::IN{'PassWord'};
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'pass_blank')      unless $iB::IN{'PassWord_Check'};
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'pass_no_match')   unless $iB::IN{'PassWord_Check'} eq $iB::IN{'PassWord'};
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'pass_too_short')  unless length($iB::IN{'PassWord'}) >= 3;
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'pass_too_long')   unless length($iB::IN{'PassWord'}) <= 32;
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'invalid_email')   unless $iB::IN{'EmailAddress'};

    # Make sure that there are no leading or trailing spaces in the username and password.

    $iB::IN{'UserName'} =~ s!^\s+!!g;
    $iB::IN{'UserName'} =~ s!\s+$!!g;
    $iB::IN{'PassWord'} =~ s!^\s+!!g;
    $iB::IN{'PassWord'} =~ s!\s+$!!g;
    
    # Do a case insensitive search to make sure that the name we want to register
    # with isn't already taken.

    my $name_check  = $mem->CheckName( DB =>$db, NAME =>$iB::IN{'UserName'} );
    $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>"user_exists")   if $name_check->{'MEMBER_NAME'};
    
    # Check to make sure that the email address is of a valid format
    
    my $validate_e  = $std->CheckEmail($iB::IN{'EmailAddress'});
    $std->Error(DB=>$db,LEVEL=>'2',MESSAGE=>'invalid_email') if $validate_e != 1;

    # If we are only allowing one email addy per registree, do a check now

    unless ($iB::INFO->{'ALLOW_MULT_EMAIL'}) {
        my $email_check = $mem->Check_Mem_Email( DB =>$db, EMAIL =>$iB::IN{'EmailAddress'} );
        $std->Error( DB      => $db,
                     LEVEL   => 1,
                     MESSAGE =>'email_exists'
                   )  if $email_check->{'MEMBER_EMAIL'};
    }

    # Check for reserved names..
    
    if ($iB::INFO->{'SAVED_NAMES'}) {
        for my $n (split(/\|/, $iB::INFO->{'SAVED_NAMES'})) {
            if ($iB::IN{'UserName'} =~ /$n/i) {
                $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>"user_exists");
                last;
            }
        }
    }
    
    #XXX Are they banned?
    if ($iB::INFO->{'IP_FILTER'}) {
        for my $ip (split /\|&\|/,$iB::INFO->{'IP_FILTER'}) {
            $ip =~ s/\\\*/.*/g;
            $std->Error( DB       => $db,
                         LEVEL    => 5,
                         MESSAGE  => 'you_are_banned'
                       ) if $iB::IN{'IP_ADDRESS'} =~ m#^$ip$#;
        }
    }
    
    # Build up a member has
    
    my %Member;
    $Member{'MEMBER_NAME'}     = $iB::IN{'UserName'};
    $Member{'MEMBER_PASSWORD'} = $iB::IN{'PassWord'};
    $Member{'MEMBER_GROUP'}    = $iB::INFO->{'VALIDATE_REGISTER'} || $iB::INFO->{PREVIEW_REG} ? $iB::INFO->{'AUTHORISE_GROUP'} : $iB::INFO->{'MEMBER_GROUP'};
    $Member{'MEMBER_POSTS'}    = 0;
    $Member{'MEMBER_EMAIL'}    = $iB::IN{'EmailAddress'};
    $Member{'MEMBER_AVATAR'}   = 'noavatar';
    $Member{'MEMBER_LEVEL'}    = 1;
    $Member{'MEMBER_JOINED'}   = time;
    $Member{'MEMBER_IP'}       = $iB::IN{'IP_ADDRESS'};
    $Member{'TIME_ADJUST'}     = 0;
    $Member{'VIEW_SIGS'}       = 1;
    $Member{'PM_REMINDER'}     = '1&1';
    $Member{'VIEW_IMG'}        = 1;
    $Member{'VIEW_AVS'}        = 1;
    $Member{'ALLOW_POST'}      = 1;
    
    # Add the member to the database.
    # RULE 1: If we are previewing registrations via the adminCP, then lets
    #         add the member to the "authorise" group. Add in an entry to the
    #         authorise table "authorise" to denote that they have to be previewed
    #         first. The newly registered member will be in the authorise group
    #
    # RULE 2: If we are validating via an email, lets put the member into the
    #         authorise group and add an entry into the authorise table as "register"
    #         to denote that they have to validate the email.
    #
    # CHOICE: If we want to validate via email and preview all registrations, the member
    #         will be put in the authorise group, and the entry in the authorise table will
    #         be "register" once they've validated the email, then the entry in the authorise
    #         table will be changed to "authorise" so that an admin can preview the registration
    # CHOICE: If we want to validate via email, but don't want to preview registrations, the member
    #         group will be the authorise group. The authorise table entry will be 'register'. Upon
    #         successful email validation, they will be put into the member group, and the authorise
    #         table entry removed.
    # CHOICE: If we want to preview all registrations, but don't want to validate via email, the member
    #         group will be authorise group, the authorise table entry will be "authorise" to allow an
    #         admin to preview all registrations.
    # CHOICE: If we don't want to validate via email and we don't want to preview the registrations, then
    #         we put the member in the member group and don't write an entry into the authorise table.
    
    my $member_id = $mem->AddMember(DB => $db, STD=> $std, MEMBER=>\%Member);

    # added by Infection

    my $birthday = $db->insert( TABLE  => 'calendar',
                                VALUES => {
                                             MEMBER_ID    => $member_id,
                                             MEMBER_NAME  => $iB::IN{'UserName'},
                                             DAY          => '0',
                                             MONTH        => '0',
                                             YEAR         => '0',
                                          },
                              );
  
    # Take the time to clean out all expired account requests
    
    $obj->clean_registrations($db);
    
    # If we are validating via an email, add the member to the database
    
    my $unique_id = $mail->my_gen_id();
    my $time      = time;

    if ($iB::INFO->{'VALIDATE_REGISTER'}) {
        # We want to validate all regigistrations via email. If we then want to preview these registrations
        # we'll change the authorise table entry to "authorise" upon successful validation

        my $new_id = $db->insert( TABLE   => 'authorisation',
                                  VALUES  => {  UNIQUE_CODE   =>  $unique_id,
                                                DATE_ENTERED  =>  $time,
                                                MEMBER_ID     =>  $member_id,
                                                MEMBER_NAME   =>  $Member{'MEMBER_NAME'},
                                                THIS_IP       =>  $iB::IN{'IP_ADDRESS'},
                                                MEMBER_EMAIL  =>  $iB::IN{'EmailAddress'},
                                                '_WHERE'      =>  'register',
                                              },
                                );

        my $message = $mail->parse_template( ID     => 'REG',
                                             DB     => $db,
                                             VALUES => { THE_LINK    =>  "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Reg&CODE=03&SID=$unique_id",
                                                         MEMBER_NAME =>  $Member{'MEMBER_NAME'},
                                                         PASSWORD    =>  $iB::IN{'PassWord'},
                                                         UNTIL       =>  $iB::INFO->{'AUTHORISE_PRUNE'},
                                                         MAN_LINK    =>  "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Reg&CODE=05",
                                                         EMAIL       =>  $iB::IN{'EmailAddress'},
                                                         CODE        =>  $unique_id,
                                                       }
                                            );

        $mail->Send( TO      => $iB::IN{'EmailAddress'},
                     FROM    => '',
                     SUBJECT => "Registration at $iB::INFO->{'BOARDNAME'}",
                     MESSAGE => $message
                  );

        my $print = RegisterView::show_authorise(\%Member);

        $output->print_ikonboard( DB      => $db,
                                  STD     => $std,
                                  TITLE   => "iB::".$Register::lang->{reg_success},
                                  NAV_ONE => $Register::lang->{nav_reg},
                                  OUTPUT  => $print,
                                );


    } elsif ($iB::INFO->{PREVIEW_REG}) {
        # We want to preview all registrations, but we don't want to get the member to validate via email,
        # so we put them in the 'authorise' group.

        my $new_id = $db->insert( TABLE   => 'authorisation',
                                  VALUES  => {  UNIQUE_CODE   =>  $unique_id,
                                                DATE_ENTERED  =>  $time,
                                                MEMBER_ID     =>  $member_id,
                                                MEMBER_NAME   =>  $Member{'MEMBER_NAME'},
                                                THIS_IP       =>  $iB::IN{'IP_ADDRESS'},
                                                MEMBER_EMAIL  =>  $iB::IN{'EmailAddress'},
                                                '_WHERE'      =>  'authorise',
                                              },
                                );
                                
        my $print = RegisterView::show_preview(\%Member);

        $output->print_ikonboard( DB      => $db,
                                  STD     => $std,
                                  TITLE   => "iB::".$Register::lang->{reg_success},
                                  NAV_ONE => $Register::lang->{nav_reg},
                                  OUTPUT  => $print,
                                );

    } else {
        # We don't want to preview and we don't want to validate via email

        my $stats = {};
        $stats->{'TOTAL_MEMBERS'}      = '+1';
        $stats->{'LAST_REG_MEMBER_N'}  = $Member{'MEMBER_NAME'};
        $stats->{'LAST_REG_MEMBER_ID'} = $member_id;

        $std->ib_stats($stats);

        my $time = $std->get_date( TIME => time, METHOD => 'LONG');

        if ($iB::INFO->{'USER_NOTIFY'}) {

            my $message = $mail->parse_template( ID     => 'USER_NOTIFY',
                                                 DB     => $db,
                                                 VALUES => { 
                                                             MEMBER_NAME =>  $Member{'MEMBER_NAME'},
                                                             DATE        =>  $time,
                                                           }
                                               );

            $mail->Send( TO      => $iB::INFO->{'ADMIN_EMAIL_IN'},
                         FROM    => '',
                         SUBJECT => "New Registration at $iB::INFO->{'BOARDNAME'}",
                         MESSAGE => $message
                      );
        }

        my $text = $iB::INFO->{'SHOW_BOARD_RULES'} ? $Register::lang->{done_reg_1}
                                                   : $Register::lang->{done_reg_2};

        my $url  = $iB::INFO->{'SHOW_BOARD_RULES'} ? 'act=Reg;CODE=04' : 'act=Login;CODE=00';


        $output->redirect_screen( TEXT      => $text,
                                  URL       => $url
                                );
    }
}


sub clean_registrations {
    my ($obj, $db) = @_;

    $iB::INFO->{'AUTHORISE_PRUNE'} ||= 30;

    my $t_q = time - $iB::INFO->{'AUTHORISE_PRUNE'} * 60 * 60 * 24;

    my $old_reg = $db->query( TABLE   => 'authorisation',
                              WHERE   => qq[DATE_ENTERED < "$t_q"],
                              COLUMNS => ['ID', 'MEMBER_ID', 'MEMBER_NAME', 'MEMBER_EMAIL', '_WHERE'],
                            );

    return unless scalar @{$old_reg} > 0;

    for my $i (@{$old_reg}) {
        if ($i->{'_WHERE'} eq 'register') {
            $db->delete( TABLE  => 'member_profiles',
                         ID     => $i->{'MEMBER_ID'},
                         KEY    => $i->{'MEMBER_ID'}
                       );
        

            #Delete from Name index

            $db->update_index(  TABLE     => 'member_profiles',
                                INDEX_KEY => 'MEMBER_NAME',
                                R_KEY     => $i->{'MEMBER_NAME'},
                                REMOVE    => 1
                             );

            #Delete from Email index

            $db->update_index(  TABLE     => 'member_profiles',
                                INDEX_KEY => 'MEMBER_EMAIL',
                                R_KEY     => $i->{'MEMBER_EMAIL'},
                                REMOVE    => 1
                            );

            $db->delete( TABLE  => 'authorisation',
                         KEY    => $i->{'ID'},
                       );
        }
    }
}


sub validate_user {
    my ($obj, $db) = @_;


    $std->Error( DB      => $db,
                 LEVEL   =>'1',
                 MESSAGE =>'data_incorrect'
               ) unless $iB::IN{'SID'} =~ /[\d\w]/;


    my $time = time - ($iB::INFO->{'AUTHORISE_PRUNE'} * 60 * 60 * 24);

    my $db_entry = $db->query( TABLE   => 'authorisation',
                               MATCH   => 'ONE',
                               WHERE   => qq[_WHERE eq "register" and UNIQUE_CODE eq "$iB::IN{'SID'}"],
                             );          

    $std->Error(DB=>$db,LEVEL=>'1', MESSAGE=>'request_error') unless $db_entry->{'MEMBER_ID'};

    my $member = $db->select( TABLE    => 'member_profiles',
                              KEY      => $db_entry->{'MEMBER_ID'},
                              ID       => $db_entry->{'MEMBER_ID'},
                            );

    $std->Error(DB=>$db,LEVEL=>'1', MESSAGE=>'request_error') unless $member->{'MEMBER_ID'};
    
    # Do we want to get the admin to preview this reg?

    $member->{'MEMBER_GROUP'} = $iB::INFO->{PREVIEW_REG} ? $iB::INFO->{'AUTHORISE_GROUP'} : $iB::INFO->{'MEMBER_GROUP'};

    $db->update(              TABLE    => 'member_profiles',
                              KEY      => $db_entry->{'MEMBER_ID'},
                              ID       => $db_entry->{'MEMBER_ID'},
                              VALUES   => $member
               );

    # Delete or update the authorisation table entry for this member
    
    if ($iB::INFO->{PREVIEW_REG}) {
    
        # Update the authorisation table entry and print out the "the admin is hardcore and
        # wants to preview yo' ass" screen. *Actual words may differ from those advertised
        # here.
        
        $db->update(         TABLE     => 'authorisation',
                             KEY       => $db_entry->{'ID'},
                             VALUES    => { "_WHERE" => 'authorise' },
                   );
                   
        my $print = RegisterView::show_preview($member);

        $output->print_ikonboard( DB      => $db,
                                  STD     => $std,
                                  TITLE   => "iB::".$Register::lang->{reg_success},
                                  NAV_ONE => $Register::lang->{nav_reg},
                                  OUTPUT  => $print,
                                );
    } else {

        # Delete the table entry, and the new member to the total members tally
        # Send the admin notification (if switched on) and send the member on
        # their merry way.

        $db->delete(             TABLE     => 'authorisation',
                                 KEY       => $db_entry->{'ID'},
                   );

        my $stats = {};
        $stats->{'TOTAL_MEMBERS'}      = '+1';
        $stats->{'LAST_REG_MEMBER_N'}  = $db_entry->{'MEMBER_NAME'};
        $stats->{'LAST_REG_MEMBER_ID'} = $db_entry->{'MEMBER_ID'};
     
        $std->ib_stats($stats);
    
        if ($iB::INFO->{'USER_NOTIFY'}) {
    
            my $time = $std->get_date( TIME => time, METHOD => 'LONG');
    
            my $message = $mail->parse_template( ID     => 'USER_NOTIFY',
                                                 DB     => $db,
                                                 VALUES => { 
                                                             MEMBER_NAME =>  $db_entry->{'MEMBER_NAME'},
                                                             DATE        =>  $time,
                                                            }
                                                );
    
            $mail->Send( TO      => $iB::INFO->{'ADMIN_EMAIL_IN'},
                         FROM    => '',
                         SUBJECT => "New Registration at $iB::INFO->{'BOARDNAME'}",
                         MESSAGE => $message
                       );
        }
    
        my $text = $iB::INFO->{'SHOW_BOARD_RULES'} ? $Register::lang->{done_reg_1}
                                                   : $Register::lang->{done_reg_2};
    
        my $url  = $iB::INFO->{'SHOW_BOARD_RULES'} ? 'act=Reg;CODE=04' : 'act=Login;CODE=00';
    
    
        $output->redirect_screen( TEXT      => $text,
                                  URL       => $url
                                );
    }
}




sub ShowForm {
    my ($obj, $db) = @_;
    my $text = $Register::lang->{'std_text'};

    $text .= "<br>". $Register::lang->{'email_validate_text'} if $iB::INFO->{'VALIDATE_REGISTER'};
   
    # Get the pre-registration rules
    my $rules = $db->select( TABLE => 'templates',
                             KEY   => 'register',
                           );

    $rules->{'TEMPLATE'} =~ s!</?(?:b|p|br|i|u|s)>!!ig;

    my $print = RegisterView::ShowForm( { TEXT => $text, RULES => $rules->{'TEMPLATE'} } );

    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => $print,
                              TITLE   => $Register::lang->{'registration_form'},
                              NAV     => [$Register::lang->{'registration_form'}]
                            );
}

sub show_dumb_form {
    my ($obj, $db) = @_;

    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => &RegisterView::show_dumb_form(),
                              TITLE   => $Register::lang->{'registration_form'},
                              NAV     => [$Register::lang->{'registration_form'}]
                           );
}

sub show_board_rules {
    my ($obj, $db) = @_;
    my $rules = $db->select(  TABLE  => 'forum_rules',
                              KEY    => '00',
                           );
    return unless $rules;

    $rules->{'RULES_TEXT'} = $std->TextTidy($rules->{'RULES_TEXT'});

    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => &RegisterView::show_rules($rules),
                              TITLE   => $Register::lang->{'board_rules'},
                              NAV     => [$Register::lang->{'board_rules'}]
                           );
}



sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    $std->Error(DB => $db, LEVEL=>'1', MESSAGE=>'no_register') unless $iB::INFO->{'ALLOW_REGISTER'};
    require $iB::SKIN->{'DIR'} . '/RegisterView.pm' or die $!;
    my %Mode = ( '02'     => \&CreateAccount,
                 '00'     => \&ShowForm,
                 '03'     => \&validate_user,
                 '04'     => \&show_board_rules,
                 '05'     => \&show_dumb_form,
                 '06'     => \&check_dumb_form,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : RegisterError($obj, $db);   
} 

sub RegisterError  { my ($obj, $db) = @_; $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'no_action'); }

1;