package Profile;
use strict;
use Time::Local;

BEGIN {
    require 'Lib/FUNC.pm';
    require 'iTextparser.pm';
}

#BENDER: "I used to be a star, I can bend girders to any angle, you name it...
#        "30 degrees, 32 degrees.....   31 degrees"

my $std       = FUNC::STD->new();
my $mem       = FUNC::Member->new();
my $output    = FUNC::Output->new();
my $txt       = iTextparser->new();
my $mail      = FUNC::Mailer->new();
$Profile::lang = $std->LoadLanguage('ProfileWords');

require $iB::SKIN->{'DIR'} . '/ProfileView.pm' or die $!;

sub new {
    my $pkg = shift;
    my $obj = { 'MEMBER' => $iB::MEMBER };
    bless $obj, $pkg;
    return $obj;
}



sub DoProfile {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'sig_too_long'
               ) if length($iB::CGI->param('Signature')) > $iB::INFO->{'MAX_SIG_LENGTH'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'int_too_long'
               ) if length($iB::CGI->param('Interests')) > $iB::INFO->{'MAX_INTEREST_LENGTH'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'loc_too_long'
               ) if length($iB::CGI->param('Location')) > $iB::INFO->{'MAX_LOCATION_LENGTH'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'web_too_long'
               ) if length($iB::IN{'WebSite'}) > 120;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'photo_too_long'
               ) if length($iB::IN{'Photo'}) > 120;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'not_icq_number'
               ) if  $iB::IN{'ICQNumber'} && $iB::IN{'ICQNumber'} !~ m#\A\d{1,25}\Z#;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'not_aol_name'
               ) if $iB::IN{'AOLName'} && $iB::IN{'AOLName'} !~ m#\A[\d\w\_\-\s]+\Z#;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'not_yahoo_name'
               ) if $iB::IN{'YahooName'} && $iB::IN{'YahooName'} !~ m#\A[\d\w\_\-\s]+\Z#;

    unless ($iB::INFO->{'ALLOW_DYNAMIC_IMG'}) {
        $std->Error( DB      => $db,
                     LEVEL   => 1,
                     STD     => $std,
                     MESSAGE => 'not_url_photo'
                    ) if $iB::IN{'Photo'} =~ /([\?\&\;])/;
    }
    
    # Calendar checker, force users to add all birthday attr. or none.
    
    my $c_count;
    
    for (qw/day month year/) {
        ++$c_count if $iB::IN{$_};
    }
    
    if ($c_count and $c_count != 3) {
        $std->Error( DB      => $db,
                     LEVEL   => 1,
                     STD     => $std,
                     MESSAGE => 'calendar_not_all'
                    );
    }        

    
    $obj->{'MEMBER'}->{'WEBSITE'}      = $iB::IN{'WebSite'};
    $obj->{'MEMBER'}->{'ICQNUMBER'}    = $iB::IN{'ICQNumber'};
    $obj->{'MEMBER'}->{'AOLNAME'}      = $iB::IN{'AOLName'};
    $obj->{'MEMBER'}->{'YAHOONAME'}    = $iB::IN{'YahooName'};
    $obj->{'MEMBER'}->{'MSNNAME'}      = $iB::IN{'MSNName'};
    $obj->{'MEMBER'}->{'LOCATION'}     = $txt->Convert_for_db( TEXT    => $iB::IN{'Location'},
                                                               SMILIES => 0,
                                                               IB_CODE => 0,
                                                               HTML    => 0,
                                                             );
    $obj->{'MEMBER'}->{'INTERESTS'}    = $txt->Convert_for_db( TEXT    => $iB::IN{'Interests'},
                                                               SMILIES => 0,
                                                               IB_CODE => 0,
                                                               HTML    => 0,
                                                             );

    # Although we don't want to convert the signature to pure iBCode using iTextparser,
    # we do want to check for errors, so we simply use a dummy value with the signatures
    # information to collect any errors.
    $txt->{ERROR} = undef;
    my $test = $txt->Convert_for_db( TEXT    => $iB::IN{'Signature'},
                                     SMILIES => $iB::INFO->{'SIG_ALLOW_EMOTICONS'},
                                     IB_CODE => $iB::INFO->{'SIG_ALLOW_IBC'},
                                     HTML    => $iB::INFO->{'SIG_ALLOW_HTML'},
                                     SIG     => 1
                                   );

    # If there are any errors, print them.
    if ($txt->{ERROR}) {
        $std->Error( DB      => $db,
                     LEVEL   => 1,
                     STD     => $std,
                     MESSAGE => $txt->{ERROR}
                   );
    }


    $obj->{'MEMBER'}->{'SIGNATURE'}     = $iB::IN{'Signature'};
    $obj->{'MEMBER'}->{'PHOTO'}         = $iB::IN{'Photo'};
    $obj->{'MEMBER'}->{'LAST_UPDATE'}   = time;

    # Member title stuff

    if ( 
           ( ($iB::INFO->{POST_TITLECHANGE}) and ($obj->{'MEMBER'}->{'MEMBER_POSTS'} > $iB::INFO->{POST_TITLECHANGE}) )
              and
           ( $iB::IN{'member_title'} )
       )
    {
        $obj->{'MEMBER'}->{'MEMBER_TITLE'} = $iB::IN{'member_title'};
    } 

    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { WEBSITE      => $obj->{'MEMBER'}->{'WEBSITE'},
                               ICQNUMBER    => $obj->{'MEMBER'}->{'ICQNUMBER'},
                               AOLNAME      => $obj->{'MEMBER'}->{'AOLNAME'},
                               YAHOONAME    => $obj->{'MEMBER'}->{'YAHOONAME'},
                               MSNNAME      => $obj->{'MEMBER'}->{'MSNNAME'},
                               LOCATION     => $obj->{'MEMBER'}->{'LOCATION'},
                               INTERESTS    => $obj->{'MEMBER'}->{'INTERESTS'},
                               SIGNATURE    => $obj->{'MEMBER'}->{'SIGNATURE'},
                               PHOTO        => $obj->{'MEMBER'}->{'PHOTO'},
                               LAST_UPDATE  => $obj->{'MEMBER'}->{'LAST_UPDATE'},
                               MEMBER_TITLE => $obj->{'MEMBER'}->{'MEMBER_TITLE'},
                             }
                );

    # Added by Infection
    # Look for entry..
    my $calendar_info = $db->select( TABLE  => 'calendar',
                                     KEY    => $obj->{'MEMBER'}->{'MEMBER_ID'},
                                   );
                                   
    if ($calendar_info->{MEMBER_ID}) {
        #Update existing
        $db->update( TABLE  => 'calendar',
                     KEY    => $obj->{'MEMBER'}->{'MEMBER_ID'},
                     VALUES => {
                                 DAY          => $iB::IN{'day'},
                                 MONTH        => $iB::IN{'month'},
                                 YEAR         => $iB::IN{'year'},
                               }
                   );
    } else {
        #Create new entry
        $db->insert( TABLE  => 'calendar',
                     VALUES => {
                                 MEMBER_ID    => $obj->{'MEMBER'}->{'MEMBER_ID'},
                                 MEMBER_NAME  => $obj->{'MEMBER'}->{'MEMBER_NAME'},
                                 DAY          => $iB::IN{'day'},
                                 MONTH        => $iB::IN{'month'},
                                 YEAR         => $iB::IN{'year'},
                                 TIME_ADJUST  => "",
                                },
                   );                    
    }


    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=01');
}



sub AddAvatar_installed {
    my ($obj, $db) = @_;

    $obj->AddAvatar_url($db) if defined $iB::IN{'URL'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE =>'no_avatar_selected'
               ) unless $iB::IN{'useravatar'};

    opendir AVATARS, $iB::INFO->{'HTML_DIR'} . 'avatars' or die $!;
    my %avatars =  map   {   $_ => 1  }
                   grep  {   !/^\./   } readdir AVATARS;
    closedir AVATARS;

    $iB::IN{'useravatar'} = 'noavatar' if $iB::IN{'useravatar'} eq '*';
    
    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE =>'no_avatar_selected'
               ) unless exists $avatars{ $iB::IN{'useravatar'} } or $iB::IN{'useravatar'} eq 'noavatar';
    
    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { MEMBER_AVATAR  => $iB::IN{'useravatar'} }
                );

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=01');
    
}    


sub AddAvatar_url {
    my ($obj, $db) = @_;

    $obj->AddAvatar_installed($db) unless defined $iB::IN{'URL'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE =>'no_avatar_selected'
               ) unless $iB::IN{'useravatar'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE => 'avatar_invalid_url'
               ) unless $iB::IN{'useravatar'} =~ m#\Ahttp\://#i;

    my @valid_ext   = split /\|/, $iB::INFO->{'AV_EXT'};
    my @avatar_url  = split /\//, $iB::IN{'useravatar'};
    my $avatar_name = $avatar_url[$#avatar_url];

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE => 'avatar_invalid_ext'
               ) unless $avatar_name =~ m#\.{1,1}($iB::INFO->{'AV_EXT'})$#ig;

    my $entered_ext = (split /\./, $avatar_name)[1];

    my $check;
    for (@valid_ext) {
        $check = 1 if $_ eq $entered_ext;
    }

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE => 'avatar_invalid_ext'
               ) unless $check == 1;

    ($iB::INFO->{'AV_WIDTH'},$iB::INFO->{'AV_HEIGHT'}) = split ("x", $iB::INFO->{'AV_DIMS'});

    $iB::IN{'Avatar_width'}   = $iB::IN{'Avatar_width'}  > $iB::INFO->{'AV_WIDTH'}  ? $iB::INFO->{'AV_WIDTH'}  : $iB::IN{'Avatar_width'};
    $iB::IN{'Avatar_height'}  = $iB::IN{'Avatar_height'} > $iB::INFO->{'AV_HEIGHT'} ? $iB::INFO->{'AV_HEIGHT'} : $iB::IN{'Avatar_height'};
    $iB::IN{'Avatar_width'}   = $iB::INFO->{'AV_WIDTH'}   unless $iB::IN{'Avatar_width'};
    $iB::IN{'Avatar_height'}  = $iB::INFO->{'AV_HEIGHT'}  unless $iB::IN{'Avatar_height'};  
    
    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { MEMBER_AVATAR  => $iB::IN{'useravatar'},
                               AVATAR_DIMS    => $iB::IN{'Avatar_width'}."x".$iB::IN{'Avatar_height'},
                             }
                );

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=01');
}    


sub DoEmail {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE => 'end_subs_value'
               ) unless $iB::IN{'end_subs'};

    for (qw[hide_email admin_send send_full_msg pm_reminder]) {
        $iB::IN{$_} = 0 unless $iB::IN{$_};
    }
    

    $iB::IN{'hide_email'}    = $std->IsNumber($iB::IN{'hide_email'});
    $iB::IN{'admin_send'}    = $std->IsNumber($iB::IN{'admin_send'});
    $iB::IN{'send_full_msg'} = $std->IsNumber($iB::IN{'send_full_msg'});
    $iB::IN{'pm_reminder'}   = $std->IsNumber($iB::IN{'pm_reminder'});
    $iB::IN{'end_subs'}      = $std->IsNumber($iB::IN{'end_subs'});

    # PM_REMINDER is a little special.
    # It has three characters, typically 1&1, 0&0, 1&0, 0&1
    # The first byte is set to 1 if we want a PM reminder
    # The last byte is set to 1 if we want a JS pop up window telling us
    # We have a new message.

    my $js_toggle = (split/&/,$obj->{'MEMBER'}->{'PM_REMINDER'})[1]; #Get the JS toggle byte

    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { HIDE_EMAIL         => $iB::IN{'hide_email'},
                               EMAIL_FULL_POST    => $iB::IN{'send_full_msg'},
                               PM_REMINDER        => $iB::IN{'pm_reminder'}.'&'.$js_toggle,
                               CANCEL_SUBS        => $iB::IN{'end_subs'},
                               ALLOW_ADMIN_EMAILS => $iB::IN{'admin_send'},
                             }
                );

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=00');
}    



sub DoSettings {    
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'poss_hack_attempt'
               ) unless $iB::IN{'u_timezone'} =~ /[\-\d]/;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'poss_hack_attempt'
               ) if $iB::IN{'u_language'} =~ /\.\./;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'poss_hack_attempt'
               ) if $iB::IN{'u_skin'} =~ /\.\./;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'poss_hack_attempt'
               ) unless $iB::IN{'VIEW_IMG'} =~ /\d{1}/;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'poss_hack_attempt'
               ) unless $iB::IN{'VIEW_SIGS'} =~ /\d{1}/;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'poss_hack_attempt'
               ) unless $iB::IN{'VIEW_AVS'} =~ /\d{1}/;

    # PM_REMINDER is a little special.
    # It has three characters, typically 1&1, 0&0, 1&0, 0&1
    # The first byte is set to 1 if we want a PM reminder
    # The last byte is set to 1 if we want a JS pop up window telling us
    # We have a new message.

    my $email_pm = (split/&/,$obj->{'MEMBER'}->{'PM_REMINDER'})[0]; #Get the email setting


    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { TIME_ADJUST      => $iB::IN{'u_timezone'},
                               LANGUAGE         => $iB::IN{'u_language'},
                               MEMBER_SKIN      => $iB::IN{'u_skin'},
                               VIEW_AVS         => $iB::IN{'VIEW_AVS'},
                               VIEW_SIGS        => $iB::IN{'VIEW_SIGS'},
                               VIEW_IMG         => $iB::IN{'VIEW_IMG'},
                               PM_REMINDER      => $email_pm.'&'.$iB::IN{'DO_POPUP'}
                             }
                );
    # Added by Infection
    # Look for entry..
    my $calendar_info = $db->select( TABLE  => 'calendar',
                                     KEY    => $obj->{'MEMBER'}->{'MEMBER_ID'},
                                   );
                                   
    if ($calendar_info->{MEMBER_ID}) {
        #Update existing
        $db->update( TABLE  => 'calendar',
                     KEY    => $obj->{'MEMBER'}->{'MEMBER_ID'},
                     VALUES => { TIME_ADJUST  => $iB::IN{'u_timezone'}, }
                   );
    } else {
        #Create new entry
        $db->insert( TABLE  => 'calendar',
                     VALUES => {
                                 MEMBER_ID    => $obj->{'MEMBER'}->{'MEMBER_ID'},
                                 MEMBER_NAME  => $obj->{'MEMBER'}->{'MEMBER_NAME'},
                                 DAY          => 0,
                                 MONTH        => 0,
                                 YEAR         => 0,
                                 TIME_ADJUST  => $iB::IN{'u_timezone'},
                                },
                   );                    
    }
    # Set the skin cookie..
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'skin', -value => $iB::IN{'u_skin'}, -expires => '+1y', -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'} );
    # Set the language cookie..
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'lang', -value => $iB::IN{'u_language'}, -expires => '+1y', -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'} );

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=04');
}    




sub DoChangeAccount {
    my ($obj, $db) = @_;
    $iB::IN{'s_email'} ? $obj->do_email_change($db) : $obj->change_pass($db);
}



sub do_email_change ($) {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'invalid_email'
               ) unless length($iB::IN{'u_email'}) > 5;

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'invalid_email'
               ) unless $std->CheckEmail($iB::IN{'u_email'});

    unless ($iB::INFO->{'ALLOW_MULT_EMAIL'}) {
        my $email_check = $mem->Check_Mem_Email( DB =>$db, EMAIL =>$iB::IN{'u_email'} );
        $std->Error( DB      => $db,
                     STD     => $std,
                     LEVEL   => 1,
                     MESSAGE => "email_exists"
                   ) if $email_check->{'MEMBER_EMAIL'};
    }

    $iB::INFO->{'VALIDATE_REGISTER'} ? $obj->_verify_mail($db, $iB::IN{'u_email'})
                                     : $obj->_reset_email($db, $iB::IN{'u_email'});
}
   
sub _verify_mail {
    my ($obj, $db, $new_mail) = @_;
    my $unique_id = $mail->my_gen_id();
    my $time      = time;

    my $new_id = $db->insert( TABLE   => 'authorisation',
                              VALUES  => {  UNIQUE_CODE   =>  $unique_id,
                                            DATE_ENTERED  =>  $time,
                                            MEMBER_ID     =>  $iB::MEMBER->{'MEMBER_ID'},
                                            MEMBER_NAME   =>  $iB::MEMBER->{'MEMBER_NAME'},
                                            THIS_IP       =>  $iB::IN{'IP_ADDRESS'},
                                            MEMBER_EMAIL  =>  $new_mail,
                                            '_WHERE'      =>  'email_change',
                                            MEMBER_GROUP  =>  $iB::MEMBER->{'MEMBER_GROUP'},
                                         },
                           );

    my $message = $mail->parse_template( ID     => 'E_CH',
                                         DB     => $db,
                                         VALUES => { THE_LINK    =>  "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Profile&CODE=01&ID=$time&SID=$unique_id&EM=$new_mail",
                                                     MEMBER_NAME =>  $iB::MEMBER->{'MEMBER_NAME'},
                                                     UNTIL       =>  $iB::INFO->{'AUTHORISE_PRUNE'}
                                                   }
                                       );

    $mail->Send( TO      => $new_mail,
                 FROM    => '',
                 SUBJECT => $Profile::lang->{'change_email'},
                 MESSAGE => $message
               );

    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { MEMBER_GROUP  => $iB::INFO->{'AUTHORISE_GROUP'} }
                );

    my $print = ProfileView::show_authorise($iB::MEMBER, $new_mail);

    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              TITLE   => "iB::".$Profile::lang->{'change_email'},
                              NAV_ONE => "$Profile::lang->{'change_email'}",
                              OUTPUT  => $print,
                            );

}

sub _reset_email {
    my ($obj, $db, $new_mail) = @_;
    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { MEMBER_EMAIL  => $new_mail }
                );

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=05');
}


sub validate {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   =>'1',
                 MESSAGE =>'data_incorrect'
               ) unless $iB::IN{'SID'}=~ /[\d\w]/;


    my $time = time;
    my $oldtime = $iB::INFO->{'AUTHORISE_PRUNE'} * 60 * 60 * 24;

    my $db_entry = $db->query( TABLE   => 'authorisation',
                               MATCH   => 'ONE',
                               WHERE   => qq[_WHERE eq "email_change" and UNIQUE_CODE eq "$iB::IN{'SID'}"],
                             );          

    $std->Error(DB=>$db,LEVEL=>'1', MESSAGE=>'request_passed') unless $db_entry;

    my $member = $db->select( TABLE    => 'member_profiles',
                              KEY      => $db_entry->{'MEMBER_ID'},
                              ID       => $db_entry->{'MEMBER_ID'},
                            );

    $std->Error(DB=>$db,LEVEL=>'1', MESSAGE=>'request_error') unless $member->{'MEMBER_NAME'};

    $db->update(              TABLE    => 'member_profiles',
                              KEY      => $db_entry->{'MEMBER_ID'},
                              ID       => $db_entry->{'MEMBER_ID'},
                              VALUES   => { MEMBER_GROUP  => $db_entry->{'MEMBER_GROUP'},
                                            MEMBER_EMAIL  => $db_entry->{'MEMBER_EMAIL'},
                                          }
               );

    $db->delete(             TABLE     => 'authorisation',
                             KEY       => $db_entry->{'ID'},
               );

    #Update the index

    #Delete the old

    $db->update_index(  TABLE     => 'member_profiles',
                        INDEX_KEY => 'MEMBER_EMAIL',
                        R_KEY     => $member->{'MEMBER_EMAIL'},
                        REMOVE    => 1
                     );

    #Insert the new

    $db_entry->{'MEMBER_EMAIL'} = lc($db_entry->{'MEMBER_EMAIL'});

    $db->update_index(  TABLE     => 'member_profiles',
                        INDEX_KEY => 'MEMBER_EMAIL',
                        R_KEY     => $db_entry->{'MEMBER_EMAIL'},
                        R_VALUE   => $db_entry->{'MEMBER_ID'}
                     );

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=05');
}





sub change_pass ($) {
    my ($obj, $db) = @_;

    my $new_pass = $mem->Crypt($obj->{'MEMBER'}->{'MEMBER_NAME'}, $iB::IN{'u_new_pass_1'});

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'pass_blank'
               ) unless $iB::IN{'u_o_pass'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'pass_blank'
               ) unless $iB::IN{'u_new_pass_1'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'pass_blank'
               ) unless $iB::IN{'u_new_pass_2'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'pass_no_match'
               ) unless $iB::IN{'u_new_pass_1'} eq $iB::IN{'u_new_pass_2'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'wrong_pass'
               ) unless $mem->Crypt($obj->{'MEMBER'}->{'MEMBER_NAME'},$iB::IN{'u_o_pass'}) eq $obj->{'MEMBER'}->{'MEMBER_PASSWORD'};

    $db->update( TABLE    => 'member_profiles',
                 ID       => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 KEY      => $obj->{'MEMBER'}->{'MEMBER_ID'},
                 VALUES   => { MEMBER_PASSWORD  => $new_pass }
                );

    $db->update( TABLE  => 'active_sessions',
                 KEY    => $iB::SESSION,
                 VALUES => { MEMBER_PASSWORD  => $new_pass  }
               );

    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( NAME => $iB::INFO->{'COOKIE_ID'}.'iBPassWord', VALUE => $new_pass, EXPIRES => '+30d', PATH => $iB::INFO->{'COOKIE_PATH'});

    $output->redirect_screen( TEXT => $Profile::lang->{'profile_edited'}, URL => 'act=UserCP;CODE=05');
}



sub get_daily ($) {
   my ($obj, $member) = @_;
   return unless $member->{'MEMBER_POSTS'};
   my $diff = time - $member->{'MEMBER_JOINED'};
   my $days = ($diff / 3600) / 24;
   $days = 1 if $days < 1;
   return sprintf '%.2f', $member->{'MEMBER_POSTS'} / $days;
}


sub ShowProfile {
    my ($obj, $db) = @_;


    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE =>'no_user'
               ) unless $iB::IN{'MID'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE =>'incorrect_use'
               ) unless $iB::IN{'MID'} =~ /^(?:[\d\-\_]+)$/;

    # Can we view others profile information??
    if ($iB::IN{'MID'} ne $iB::MEMBER->{'MEMBER_ID'}) {
        unless ($iB::MEMBER_GROUP->{'MEM_INFO'}) {
            $std->Error( LEVEL => 1, DB => $db, MESSAGE => 'cant_use_feature');
        }
    }

    my $member = $db->select( TABLE  => 'member_profiles',
                              ID     => $iB::IN{'MID'},
                              KEY    => $iB::IN{'MID'},
                            );

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 1,
                 MESSAGE =>'profile_guest'
               ) unless $member->{'MEMBER_ID'};

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my %temp_table = map { $_->{'ID'} => $_->{'TITLE'} } @{$mem_groups};
    $obj->{'group_table'} = \%temp_table;
 

    $member->{'MEMBER_TITLE'} = $member->{'MEMBER_TITLE'};

    for (qw[personal_header send_pm add_book hidden_email send_email]) {
        $Profile::lang->{$_} =~ s!<# NAME #>!$member->{'MEMBER_NAME'}!g;
    }
   
    $member->{'MEMBER_PASSWORD'} = undef;

    $member->{'PHOTO'}        = $member->{'PHOTO'}
                              ? qq!<img src='$member->{'PHOTO'}' border='1' alt=''>!
                              : "$Profile::lang->{no_photo}";

    $member->{'MEMBER_EMAIL'}
        =  $member->{'HIDE_EMAIL'} ? $Profile::lang->{'hidden_email'}
                                   : qq[<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Mail;CODE=00;MID=$member->{'MEMBER_ID'}">$Profile::lang->{'send_email'}</a>];

 
    $member->{'WEBSITE'}      = ($member->{'WEBSITE'} and $member->{'WEBSITE'} =~ m#\Ahttp://.+?\S\Z#i)
                              ? (qq[<a href='$member->{'WEBSITE'}'>$member->{'WEBSITE'}</a>])
                              : ('');

    if ($member->{SIGNATURE}) {
        my $html = iTextparser::do_wrapper({STYLE=>'QUOTE'});
        $member->{SIGNATURE} = $txt->Convert_for_db( TEXT    => $member->{SIGNATURE},
                                                     SMILIES => $iB::INFO->{'SIG_ALLOW_EMOTICONS'},                                                              SMILIES => 0,
                                                     IB_CODE => $iB::INFO->{'SIG_ALLOW_IBC'},
                                                     HTML    => $iB::INFO->{'SIG_ALLOW_HTML'},
                                                     SIG     => 1
                                                   );
        $member->{'SIGNATURE'}    = qq[$html->{START}$member->{'SIGNATURE'}$html->{END}];
    }

    $member->{'POST_AVERAGE'} = $member->{'MEMBER_POSTS'} > 0
                              ? $obj->get_daily($member)
                              : $Profile::lang->{'no_posts'};

    $member->{'MEMBER_POSTS'} = $Profile::lang->{'no_posts'} unless $member->{'MEMBER_POSTS'};

    $member->{'LAST_UPDATE'} = $member->{'MEMBER_JOINED'} unless $member->{'LAST_UPDATE'};

    $member->{'MEMBER_JOINED'}= $std->get_date( TIME  => $member->{'MEMBER_JOINED'},
                                                METHOD => 'LONG'
                                              );

    $member->{'LAST_UPDATE'}  = $std->get_date( TIME   => $member->{'LAST_UPDATE'},
                                                METHOD => 'LONG'
                                              );

    $member->{'MEMBER_GROUP'} = $obj->{'group_table'}->{ $member->{'MEMBER_GROUP'} };


    for (keys %{$member}) {
        $member->{$_} = $Profile::lang->{'no_information'} unless $member->{$_}
    }
########################
#
# Added by Infection
#
    if ($iB::INFO->{'CALENDAR'}) {
    my $bd = $db->select( TABLE  => 'calendar',
                          ID     => $member->{'MEMBER_ID'},
                          KEY    => $member->{'MEMBER_ID'},
                        );
       if ($bd->{'DAY'} and $bd->{'MONTH'} and $bd->{'YEAR'}) {
           $member->{'MEMBER_BD'} = "$bd->{DAY} $Profile::lang->{'M_'.$bd->{'MONTH'} } $bd->{'YEAR'}"; 
           $member->{'BIRTHDAY'}.= "                <tr>\n";
           $member->{'BIRTHDAY'}.= "                <td bgcolor='$iB::SKIN->{'MISCBACK_ONE'}' width='50%'><b>$Profile::lang->{'b_date'}</b></td>\n";
           $member->{'BIRTHDAY'}.= "                <td bgcolor='$iB::SKIN->{'MISCBACK_ONE'}' align='left' width='50%'>$member->{'MEMBER_BD'}</td>\n";
           $member->{'BIRTHDAY'}.= "                </tr>\n";
  
       } else {
           $member->{'BIRTHDAY'} = "";
       }
    }
#
#
#
#############

    $output->print_ikonboard( DB         => $db,
                              STD        => $std,
                              OUTPUT     => ProfileView::ShowProfile($member),
                              JAVASCRIPT => 1,
                              TITLE      => "iB::".$Profile::lang->{'viewing_profile'},
                              NAV        => [ "iB::".$Profile::lang->{'viewing_profile'} ]
                            );

}


sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    my %Mode = ( '01'     => \&validate,
                 '02'     => \&DoProfile,
                 '03'     => \&ShowProfile,
                 '04'     => \&DoEmail,
                 '05'     => \&DoSettings,
                 '06'     => \&DoChangeAccount,

                 '10'     => \&AddAvatar_installed,
                 '11'     => \&AddAvatar_url,
               
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : ProfileError();
} 

#+----- Internal Stuff ------+


sub ProfileError  { $std->Error(LEVEL=>'1',MESSAGE=>'No Action has been specified') }


1;


__END__
