package PrintPage;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# iPoll: Polling Fucntions.
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
}

#HOMER: "Aw, to think our son is all grown up and going on his first date"
#       "(starts singing)Your time has come, you're all grown up...and the
#       "cats in the cradle and the silver moon, and yes - we have no banana's"
#HOMER: (Starts sobbing)
#MARGE: "Awwww Homer, that's so sweet".
#HOMER: "Didn't you hear Marge! We have no banana's!!  (walks off crying)"

my $output = FUNC::Output->new();
my $std    = FUNC::STD->new();
my $mem    = FUNC::Member->new();
$Print::lang = $std->LoadLanguage('PrintpageWords');
#+------------------------------------------------------------------------------------------------------

sub new {
  my $pkg = shift;
  my $obj = {};
  bless $obj, $pkg;
  return $obj;
}


#+------------------------------------------------------------------------------------------------------


sub Process {
    my ($obj, $db) = @_;

    $obj->{'.topic_id'} = $std->IsNumber($iB::IN{'t'}) || 0;
    $obj->{'.forum_id'} = $std->IsNumber($iB::IN{'f'}) || 0;

    require $iB::SKIN->{'DIR'} . '/PrintPageView.pm' or die $!;



    $obj->{'FORUM'} = $db->select( TABLE   => 'forum_info',
                                   KEY     => $obj->{'.forum_id'},
                                 ) || die $db->{'error'};


    $obj->{'TOPIC'} = $db->select( TABLE  => 'forum_topics',
                                   ID     => $obj->{'.forum_id'},
                                   KEY    => $obj->{'.topic_id'}
                                 ) || die $db->{'error'};



    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE =>'missing_files'
               ) unless ((defined $iB::IN{'t'}) and (defined $iB::IN{'f'}));

    my $check = $obj->Check_access($db);
    return if $check == 1;

    my $print = PrintPageView::pp_header($obj->{'FORUM'}->{'FORUM_NAME'},
                                         $obj->{'TOPIC'}->{'TOPIC_TITLE'},
                                         $obj->{'TOPIC'}->{'TOPIC_LASTP_N'}
                                        );

    
    my $total_posts = $db->query( TABLE    => 'forum_posts',
                                  DBID     => 'f'.$obj->{'.forum_id'},
                                  ID       => $obj->{'.topic_id'},
                                  WHERE    => "QUEUED != 1 and FORUM_ID == '$obj->{'.forum_id'}' and TOPIC_ID == '$obj->{'.topic_id'}'",
                                  SORT_KEY => 'POST_DATE',
                                  SORT_BY  => 'A-Z'
                                 ) or $print = $db->{'error'};
    


    for my $Row (@{$total_posts}) {
       
        $obj->{'POSTER'} = $Row->{'AUTHOR_TYPE'} == 1 ? $mem->LoadMember( DB => $db, KEY => $Row->{'AUTHOR'}, METHOD => 'by id')
                                                      : $mem->SetUpGuest($Row->{'AUTHOR'});

        $Row->{'POST_DATE'} = $std->get_date( TIME => $Row->{'POST_DATE'}, METHOD => 'LONG');

        $Row->{'POST'} =~ s!(<a href=["'])(http|https|ftp|news)://(\S+?)["'].+?>(.+?)</a>!&lt; $4 &gt;!isg;

        $Row->{'POST'} =~ s!<\!--c1-->(.+?)<\!--ec1-->!<br><br>---------------------CODE SAMPLE-------------------<br><i>!isg;
        $Row->{'POST'} =~ s!<\!--c2-->(.+?)<\!--ec2-->!<br></i>---------------------CODE SAMPLE-------------------<br><br>!isg;
        $Row->{'POST'} =~ s!<\!--QuoteBegin-->(.+?)<\!--QuoteEBegin-->!<br><br>---------------------QUOTE-------------------<br><i>!isg;
        $Row->{'POST'} =~ s!<\!--QuoteEnd-->(.+?)<\!--QuoteEEnd-->!<br></i>---------------------QUOTE-------------------<br><br>!isg;

        $print .= PrintPageView::pp_postentry($obj->{'POSTER'}, $Row);

    }

    $print .= PrintPageView::pp_end();

    $print .= qq~
                <br><br>
                <font size='1'>
                <center>Powered by Ikonboard $iB::VERSION
                <br>
                Ikonboard &copy; 2001 Jarvis Entertainment Group, Inc. <http://www.ikonboard.com>
                </font>
                </center>
                </body>
                </html>
                ~;

    print $iB::CGI->header();
    print $print;

    exit(0);
}


#+------------------------------------------------------------------------------------------------------
#+------------------------------------------------------------------------------------------------------

sub Check_access ($) {
    my ($obj, $db) = @_;

    if ($obj->{'FORUM'}->{'FORUM_PROTECT'}) {
        if (exists $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $obj->{'FORUM'}->{'FORUM_ID'} }) {
            return if $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $obj->{'FORUM'}->{'FORUM_ID'} } eq $obj->{'FORUM'}->{'FORUM_PROTECT'};
        }
        $output->redirect_screen( TEXT => "$Topic::lang->{'please_log_in'}", URL => "?act=SF;f=$iB::IN{'f'}");
        return 1;
    }

    if ($obj->{'FORUM'}->{'FORUM_VIEW_THREADS'} ne '*') {
        unless (grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split /,/,$obj->{'FORUM'}->{'FORUM_VIEW_THREADS'}) ) {
            $std->Error(     DB      => $db,
                             LEVEL   => '2',
                             MESSAGE =>'forum_no_access'
                       );
        }
    }
    return 0;
}




1;