package Online;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Online: Display the online users.
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'iTextparser.pm';
}

my $std      = FUNC::STD->new();
my $mem      = FUNC::Member->new();
my $output   = FUNC::Output->new();
my $psr      = iTextparser->new();
$Online::lang = $std->LoadLanguage('OnlineWords');

my $html = undef;


# Get the formatting options
my $format = {};
for (split /\|/, $iB::INFO->{AU_FORMAT}) {
   /^(\d+)\~(.+?),(.+?)$/;
   $format->{$1} = { ST  => $2, END => $3 };
}

sub new {
    my $pkg = shift;
    my $obj = { 'baseURL' => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION" };
    bless $obj, $pkg;
    return $obj;
}

=pod
=HEADER How about this?
sub new { return bless {}, $_[0]; }
=cut


#+------------------------------------------------------------------------------------------------------


sub list_all {
    my ($obj, $db) = @_;
  
    my $First   = $std->IsNumber($iB::IN{'st'}) || 0;
    my $perpage = $std->IsNumber($iB::IN{'pp'}) || 25;

    my $forums         = $db->query( TABLE     => 'forum_info',
                                     SORT_KEY  => 'FORUM_POSITION',
                                     COLUMNS   => ['FORUM_ID', 'FORUM_NAME', 'FORUM_PROTECT', 'FORUM_VIEW_THREADS'],
                                     SORT_BY   => 'A-Z',
                                     MATCH     => 'ALL'
                                   ) || die $db->{'error'};

    my $categories     = $db->query( TABLE     => 'categories',
                                     SORT_KEY  => 'CAT_POS',
                                     SORT_BY   => 'A-Z',
                                     WHERE     => 'CAT_STATE ne "0"',
                                     MATCH     => 'ALL',
                                   ) || die $db->{'error'};


    my $total_sessions = $db->query(  TABLE     => 'active_sessions',
                                      SORT_KEY  => 'RUNNING_TIME',
                                      SORT_BY   => 'Z-A',
                                      WHERE     => "RUNNING_TIME > ".time." - 1800 and LOG_IN_TYPE != 1",
                                      RANGE     => $First." to ".($perpage + ($First-1)),
                                      MATCH     => 'WITH COUNT',
                                    );

    my $total_matches = $db->matched_records;

    #XXX Build hash table index of the forums

    my %all_forums = map {
                           $_->{'FORUM_ID'} => { FORUM_NAME         => $_->{'FORUM_NAME'},
                                                 FORUM_VIEW_THREADS => $_->{'FORUM_VIEW_THREADS'},
                                                 FORUM_PROTECT      => $_->{'FORUM_PROTECT'}
                                               }
                         } @{$forums};

    #XXX Build hash table index of the categories

    my %all_cats   = map {
                           $_->{'CAT_ID'}   => { CAT_NAME         => $_->{'CAT_NAME'},
                                                 VIEW             => $_->{'VIEW'},
                                               }
                         } @{$categories};



    # Work out the page links.

    my $links = $std->build_pagelinks( TOTAL_POSS  => $total_matches,
                                       PER_PAGE    => $perpage,
                                       CUR_ST_VAL  => $First,
                                       L_SINGLE    => '',
                                       L_MULTI     => $Online::lang->{pages},
                                       BASE_URL    => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Online;CODE=listall;pp=$perpage",
                                     );



    $html = OnlineView::Page_header($links);

    my $where = {};

    for my $w (keys %{$Online::lang}) {
        if ($w =~ /^WHERE_(\w+)$/) {
            $where->{$1} = $Online::lang->{$w};
        }
    }

    for my $session (@{$total_sessions}) {
        my $line;
        if ($session->{'LOCATION'}) {
            my ($act, $q_string) = split (/\|&\|/, $session->{'LOCATION'});
            if ($act) {
                $line = exists $where->{ $act } ? $where->{ $act } : $Online::lang->{'board_index'}; 
            }
            my ($sub_act, $number);
            if ( $q_string =~ m{[&;\?](f|c)=(\d+)[&;\|\Z]} ) {
                $sub_act = $1;
                $number  = $2;
                if ($act and $number and $sub_act) {
                    if ($sub_act eq 'f') {
                        $line .= $all_forums{$number}->{'FORUM_VIEW_THREADS'} eq '*'
                                 ? " <a href='$obj->{baseURL};act=SF;f=$number'>$all_forums{$number}->{'FORUM_NAME'}</a>"
                                 : (
                                     (grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split (/,/, $all_forums{$number}->{'FORUM_VIEW_THREADS'})))
                                     ? (" <a href='$obj->{baseURL};act=SF;f=$number'>$all_forums{$number}->{'FORUM_NAME'}</a>")
                                     : ('')
                                   );
                    } elsif
                       ($sub_act eq 'c') {
                        $line .= $all_cats{$number}->{'VIEW'} eq '*'
                                 ? " <a href='$obj->{baseURL};act=SC;c=$number'>$all_cats{$number}->{'CAT_NAME'}</a>"
                                 : (
                                     (grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split (/,/, $all_cats{$number}->{'VIEW'})))
                                     ? (" <a href='$obj->{baseURL};act=SC;c=$number'>$all_cats{$number}->{'CAT_NAME'}</a>")
                                     : ('')
                                   );
                    }
                }
                        
            } else {
                $line = " <a href='$obj->{baseURL}'>$Online::lang->{'board_index'}</a>";
            }
        
        $session->{'WHERE_LINE'} = $line;

        } else {
            $line = " <a href='$obj->{baseURL}'>$Online::lang->{'board_index'}</a>";
        }
            
        if ($session->{'MEMBER_NAME'}) {

            # XXX Remove Dupes (this occurs if a user is on a proxy, and their IP changes).

            next if exists $obj->{'seen_name'}->{ $session->{'MEMBER_NAME'} };
            $obj->{'seen_name'}->{ $session->{'MEMBER_NAME'} } = 1;
        }

        if ($session->{MEMBER_ID}) {
            $session->{MEMBER_NAME} = qq~<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Profile;CODE=03;MID=$session->{'MEMBER_ID'}'>$format->{ $session->{MEMBER_GROUP} }->{ST}$session->{'MEMBER_NAME'}$format->{ $session->{MEMBER_GROUP} }->{END}</a>~;
        }

        $html .= $obj->do_entry(  DB => $db, SESSION => $session);
    }

    $html .= OnlineView::Page_end();

    $output->print_ikonboard( DB         => $db,
                              STD        => $std,
                              OUTPUT     => $html,
                              JAVASCRIPT => 1,
                              TITLE      => "iB::".$Online::lang->{'page_title'},
                              NAV        => [ "$Online::lang->{'page_title'}" ]
                            );
}



#+------------------------------------------------------------------------------------------------------

sub do_entry  {
    my $obj = shift;
    my %IN  = ( DB => "", SESSION => "", @_, );
    my $session = $IN{'SESSION'};

    if ($session->{'MEMBER_NAME'} and $session->{'MEMBER_ID'}) {
        $session->{'MESSAGE_ICON'} = qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Msg;CODE=04;MID=$session->{'MEMBER_ID'}'>$iB::SKIN->{'P_MSG'}</a>&nbsp;];
        $session->{'PROFILE_ICON'} = qq!<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Profile;CODE=03;MID=$session->{'MEMBER_ID'}">$iB::SKIN->{'P_PROFILE'}</a>&nbsp;!;
    }
    else {
        $session->{'MEMBER_NAME'}  = $format->{ $iB::INFO->{GUEST_GROUP} }->{ST}.$Online::lang->{'guest'}.$format->{ $iB::INFO->{GUEST_GROUP} }->{END};
        $session->{'MESSAGE_ICON'} = "&nbsp;";
        $session->{'PROFILE_ICON'} = "&nbsp;";
    }
    $session->{'RUNNING_TIME'} = $std->get_date( TIME => $session->{'RUNNING_TIME'}, METHOD => 'LONG' );

    return OnlineView::show_row($session);
}



sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $iB::IN{'CODE'};
    return unless $iB::INFO->{'ALLOW_ONLINE_LIST'};
    #+-----------------------------------------------------------------------------------
    require $iB::SKIN->{'DIR'} . '/OnlineView.pm' or die $!;
    #+-----------------------------------------------------------------------------------
    my %Mode = ( 'listall'     => \&list_all,
                 'forum'       => \&list_forum,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : OnlineError();
} 

sub OnlineError { }

1;
