package Misc::Track;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# 
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $mem         = FUNC::Member->new();
my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
$Track::lang = $std->LoadLanguage('MailFunctionsWords');


sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


sub Process {
    my ($obj, $db) = @_;

    #Require Valid forum_id
    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'incorrect_use'
               ) unless defined $std->IsNumber($iB::IN{'f'});

    #Require Valid Topic_id
    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'incorrect_use'
               ) unless defined $std->IsNumber($iB::IN{'t'});

    #Require Member ID
    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'not_registered'
               ) unless $iB::MEMBER->{'MEMBER_ID'};


    #Are we already subscribed?

    my $sub = $db->query( TABLE => 'forum_subscriptions',
                          MATCH => 'ONE',
                          WHERE => "FORUM_ID == $iB::IN{'f'} and TOPIC_ID == $iB::IN{'t'} and MEMBER_ID eq '$iB::MEMBER->{'MEMBER_ID'}'"
                        );

    if ($sub->{'ID'}) {
        $std->Error( DB      => $db,
                     LEVEL   => 1,
                     STD     => $std,
                     MESSAGE => 'already_sub'
                   );
    }

    # Do we have permission to subscribe to this thread?

    my $forum = $db->select( TABLE => 'forum_info',
                             KEY   =>  $iB::IN{'f'}
                           );

    if ($forum->{'FORUM_VIEW_THREADS'} ne '*') {
        unless (grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split /,/,$forum->{'FORUM_VIEW_THREADS'}) ) {
            $std->Error(     DB      => $db,
                             LEVEL   => '2',
                             MESSAGE =>'forum_no_access'
                       );
        }
    }

    #Insert the new subscription

    $iB::MEMBER->{'CANCEL_SUBS'} ||= 30;

    $db->insert( TABLE   => 'forum_subscriptions',
                 VALUES  => { MEMBER_ID     => $iB::MEMBER->{'MEMBER_ID'},
                              MEMBER_NAME   => $iB::MEMBER->{'MEMBER_NAME'},
                              EMAIL_ADDRESS => $iB::MEMBER->{'MEMBER_EMAIL'},
                              FORUM_ID      => $iB::IN{'f'},
                              TOPIC_ID      => $iB::IN{'t'},
                              DATE_STARTED  => time,
                              LAST_SENT     => 0,
                              PRUNE         => $iB::MEMBER->{'CANCEL_SUBS'},
                              rFULL         => $iB::MEMBER->{'EMAIL_FULL_POST'},
                            }
                );

      
    $output->redirect_screen( TEXT => $Track::lang->{'sub_added'}, URL => "act=ST&f=$iB::IN{'f'}&t=$iB::IN{'t'}&st=$iB::IN{'st'}");
}


1;
