package Misc::Report;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Register: Registration Fucntions.
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $mail        = FUNC::Mailer->new();
my $mem         = FUNC::Member->new();
my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
$Report::lang = $std->LoadLanguage('ReportWords');


sub new {
    return bless {}, $_[0];
  #my $pkg = shift;
  #my $obj = {};
  #bless $obj, $pkg;
  #return $obj;
}



sub form {
    my ($obj, $db) = @_;

    my $print = ReportView::header({ TOPIC => $obj->{TOPIC}, FORUM => $obj->{FORUM} });

    # Guests cannot use this function (this may change)

    #unless ($iB::MEMBER->{MEMBER_ID}) {
    #    $print .= ReportView::guest();
    #}

    $print .= ReportView::body();

    $print .= ReportView::foot();

    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => $print,
                              TITLE   => $Report::lang->{'title'},
                              NAV     => ["$Report::lang->{'title'}"]
                            );
}

sub send {
    my ($obj, $db) = @_;
    
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'rp_nosmg')  unless $iB::IN{'Post'};

    my $date = $std->get_date( TIME => time, METHOD => 'LONG');

    my $name  = $iB::MEMBER->{MEMBER_NAME};
    my $email = $iB::MEMBER->{MEMBER_EMAIL};
        
    # Get the moderators
    my $mods = [];
    $mods = $db->query(  TABLE   => 'forum_moderators',
                          COLUMNS => ["MEMBER_ID"],
                          WHERE   => "FORUM_ID == '$obj->{FORUM}->{FORUM_ID}'",
                       );

    # Get admins if no mods

    unless (scalar (@{$mods}) > 0) {
        $mods = $db->query( TABLE   => 'member_profiles',
                            COLUMNS => ["MEMBER_ID"],
                            WHERE   => "MEMBER_GROUP == '$iB::INFO->{SUPAD_GROUP}'",
                          );
    }


    my $message = $mail->parse_template( ID      => 'report_post',
                                         DB      => $db,
                                         VALUES  =>
                                          { 
                                            "LINK TO POST" => qq~$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=ST&t=$iB::IN{t}&f=$iB::IN{f}#entry$iB::IN{p}~,
                                            "TOPIC_TITLE"  => $obj->{TOPIC}->{TOPIC_TITLE},
                                            "FORUM"        => $obj->{FORUM}->{FORUM_NAME},
                                            "MEMBER NAME" =>  $name,
                                            "IP ADDRESS"   => $iB::IN{IP_ADDRESS},
                                            "EMAIL"        => $email,
                                            "DATE"         => $date,
                                            "MESSAGE"      => $iB::IN{Post},
                                           }
                                        );

    my $pm_msg = $message;

    # Make the topic linkable

    $pm_msg =~ s#($iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=ST&t=$iB::IN{t}&f=$iB::IN{f}\#entry$iB::IN{p})#\[url\]$1\[/url\]</a>#ig;
    $pm_msg =~ s#\Q$iB::INFO->{EMAIL_HEADER}\E## if $iB::INFO->{EMAIL_HEADER};
    $pm_msg =~ s#\Q$IB::INFO->{EMAIL_FOOTER}\E## if $IB::INFO->{EMAIL_FOOTER};


    # Now loop through the mods and send the mail / message depending on options chosen in the CP

    for my $mem (@{$mods}) {
        my $m = $db->select(  TABLE  => 'member_profiles',
                              KEY    => $mem->{MEMBER_ID},
                           );

        #Fail safe..
        next unless $m->{MEMBER_ID};

        if ($iB::INFO->{REPORT_POST_METHOD} == 1 or $iB::INFO->{REPORT_POST_METHOD} == 2) {
            # If it's not a 1, we are sending an email
            # If it's 2, we are sending both

            $mail->Send( TO      => $m->{'MEMBER_EMAIL'},
                         FROM    => "",
                         SUBJECT => $Report::lang->{subject},
                         MESSAGE => $message
                       );
        }

        if ($iB::INFO->{REPORT_POST_METHOD} == 0 or $iB::INFO->{REPORT_POST_METHOD} == 2) {
            # If it's 0, we are sending a PM
            # If it's 2 we are sending both


            my $show_popup = (split/&/, $m->{'PM_REMINDER'})[1];

            my $new_id = $db->insert( TABLE  => 'message_data',
                                      ID     => $m->{'MEMBER_ID'},
                                      VALUES => { DATE              => time,
                                                  READ_STATE        => 0,
                                                  TITLE             => $Report::lang->{subject},
                                                  MESSAGE           => $pm_msg,
                                                  MESSAGE_ICON      => 10,
                                                  FROM_ID           => $iB::MEMBER->{'MEMBER_ID'},
                                                  FROM_NAME         => $iB::MEMBER->{'MEMBER_NAME'},
                                                  REPLY             => '',
                                                  REPLY_DATE        => '',
                                                  VIRTUAL_DIR       => 'in',
                                                  MEMBER_ID         => $m->{'MEMBER_ID'},
                                                  RECIPIENT_ID      => $m->{'MEMBER_ID'},
                                                  RECIPIENT_NAME    => $m->{'MEMBER_NAME'}
                                                }
                                     );
        
            my $msg_stats = { };
        
            $msg_stats = $db->select( TABLE  => 'message_stats',
                                      ID     => $m->{'MEMBER_ID'},
                                      KEY    => $m->{'MEMBER_ID'},
                                    );
        
            if ($msg_stats->{'MEMBER_ID'}) {
        
                $msg_stats->{'TOTAL_MESSAGES'}++;
                $msg_stats->{'NEW_MESSAGES'}++;
          
                $db->update(  TABLE  => 'message_stats',
                              ID     => $m->{'MEMBER_ID'},
                              KEY    => $m->{'MEMBER_ID'},
                              VALUES => { TOTAL_MESSAGES => $msg_stats->{'TOTAL_MESSAGES'},
                                          NEW_MESSAGES   => $msg_stats->{'NEW_MESSAGES'},
                                          LAST_FROM_NAME => $iB::MEMBER->{'MEMBER_NAME'},
                                          LAST_FROM_ID   => $iB::MEMBER->{'MEMBER_ID'},
                                          LAST_SENT      => time,
                                          LAST_MSG_ID    => $new_id,
                                          LAST_MSG_TITLE => $Report::lang->{subject},
                                          SHOW_POPUP     => $show_popup,
                                        }
                           );
        
            } else {
                $db->insert(  TABLE  => 'message_stats',
                              ID     =>  $m->{'MEMBER_ID'},
                              VALUES => { MEMBER_ID          => $m->{'MEMBER_ID'},
                                          LAST_READ          => '',
                                          NEW_MESSAGES       => 1,
                                          LAST_FROM_NAME     => $iB::MEMBER->{'MEMBER_NAME'},
                                          LAST_FROM_ID       => $iB::MEMBER->{'MEMBER_ID'},
                                          LAST_MSG_ID        => $new_id,
                                          LAST_MSG_TITLE     => $Report::lang->{subject},
                                          LAST_SENT          => time,
                                          TOTAL_MESSAGES     => 1,
                                          VIRTUAL_DIR        => "in:Inbox|sent:Sent Items|",
                                          SHOW_POPUP         => $show_popup,
                                         }
                            );
            }
        }  # end if sending PM

    } # end for each loop

    # Redirect back to the relevant forum and topic

    $output->redirect_screen( TEXT => $Report::lang->{'redirect'}, URL => "act=ST;f=$iB::IN{'f'};t=$iB::IN{'t'}#entry$iB::IN{p}");



}



sub Process {
    my ($obj, $db) = @_;
    require $iB::SKIN->{'DIR'} . '/ReportView.pm' or die $!;

    unless ($iB::MEMBER->{MEMBER_ID}) {
        $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'not_registered ');
    }

    #+---------------------------------------------------------
    # Load the relevant forum/topic info
    #+----------------------------------------------------------

    $obj->{'FORUM'} = $db->select( TABLE => 'forum_info',
                                   KEY   => $iB::IN{f},
                                 );

    $obj->{'TOPIC'} = $db->select( TABLE => 'forum_topics',
                                   ID    => $iB::IN{f},
                                   KEY   => $iB::IN{t},
                                 );

    #+---------------------------------------------------------
    # Assume nothing, confirm everything.
    #+---------------------------------------------------------

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'missing_files',
               ) unless defined $obj->{'FORUM'}->{'FORUM_ID'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'missing_files',
               ) unless defined $obj->{'TOPIC'}->{'TOPIC_ID'};


    # What to do?

    $iB::IN{SEND} ? $obj->send($db) : $obj->form($db);

}





1;