package Misc::MailMember;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Register: Registration Fucntions.
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $mail        = FUNC::Mailer->new();
my $mem         = FUNC::Member->new();
my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
$MailMember::lang = $std->LoadLanguage('MailMemberWords');


sub new {
  my $pkg = shift;
  my $obj = {};
  bless $obj, $pkg;
  return $obj;
}


sub send_mail {
    my ($obj, $db) = @_;

    my $member      = $mem->LoadMember( DB => $db, KEY => $iB::IN{'to'}, METHOD => 'by id');
    
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'no_such_user')  unless $iB::IN{'to'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'no_such_user')  unless $member->{'MEMBER_ID'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'private_email') if $member->{'HIDE_EMAIL'};

    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'no_subject')    unless $iB::IN{'subject'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'no_message')    unless $iB::IN{'message'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'subject_long')  unless length($iB::IN{'subject'}) < 50;


    my $message = $mail->parse_template( ID      => 'MEM_TO_MEM',
                                         DB      => $db,
                                         VALUES  =>
                                          { 
                                            MEMBER_NAME =>  $member->{'MEMBER_NAME'},
                                            FROM_NAME   =>  $iB::MEMBER->{'MEMBER_NAME'},
                                            MESSAGE     =>  $iB::IN{'message'},
                                           }
                                        );

    $mail->Send( TO      => $member->{'MEMBER_EMAIL'},
                 FROM    => $iB::MEMBER->{'MEMBER_EMAIL'},
                 SUBJECT => $iB::IN{'subject'},
                 MESSAGE => $message
                  );


    my $print = MailView::sent_screen($member->{'MEMBER_NAME'});

    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              TITLE   => "iB::".$MailMember::lang->{'email_sent'},
                              NAV     => [$MailMember::lang->{'email_sent'}],
                              OUTPUT  => $print,
                            );
}



sub mail_member {
    my ($obj, $db) = @_;
    return unless $iB::IN{'MID'};
    my $member = $mem->LoadMember( DB => $db, KEY => $iB::IN{'MID'}, METHOD => 'by id');
    
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'no_such_user')  unless $member->{'MEMBER_ID'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'private_email') if $member->{'HIDE_EMAIL'};

    my $print = $iB::INFO->{'USE_MAIL_FORM'} 
              ?  MailView::send_form(   {
                                           NAME    => $member->{'MEMBER_NAME'},
                                           TO      => $member->{'MEMBER_ID'},
                                         }
                                     )
              : MailView::show_address( {
                                           NAME    => $member->{'MEMBER_NAME'},
                                           ADDRESS => $member->{'MEMBER_EMAIL'}
                                        }
                                      );
    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => $print,
                              TITLE   => $MailMember::lang->{'member_address_title'},
                              NAV     => ["$MailMember::lang->{'member_address_title'}"]
                            );
}



sub Process {
    my ($obj, $db) = @_;

    unless ($iB::MEMBER->{MEMBER_ID}) {
        $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'not_registered');
    }

    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    require $iB::SKIN->{'DIR'} . '/MailView.pm' or die $!;
    my %Mode = ( '00'     => \&mail_member,
                 '01'     => \&send_mail,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : MailError($obj, $db);   
} 

sub MailError  { my ($obj, $db) = @_; $std->Error(DB=>$db,LEVEL=>'1',MESSAGE=>'no_action'); }

1;


__END__
