package Misc::Invite;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# 
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $SEND        = FUNC::Mailer->new();
my $mem         = FUNC::Member->new();
my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
$Invite::lang = $std->LoadLanguage('MailFunctionsWords');
require $iB::SKIN->{'DIR'} . '/MailView.pm' or die $!;

my $html = undef;

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


sub Process {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'no_guests'
               ) unless $iB::MEMBER->{'MEMBER_ID'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'invite_no_name'
               ) unless $iB::IN{'SenderName'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'invite_no_email'
               ) unless $iB::IN{'SendersEmail'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'invite_no_email_f'
               ) unless $iB::IN{'RecipientEmail'};

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'invalid_email'
               ) unless $std->CheckEmail( $iB::IN{'RecipientEmail'});

    $std->Error( DB      => $db,
                 STD     => $std,
                 LEVEL   => 5,
                 MESSAGE => 'invalid_email'
               ) unless $std->CheckEmail( $iB::IN{'SendersEmail'});


    my $message = $SEND->parse_template( ID      => 'INVITE_FRIEND',
                                         DB      => $db,
                                         VALUES  =>
                                          { 
                                            SENDER_NAME  =>  $iB::IN{'SenderName'},
                                            MSG_ID       =>  time,
                                            TO_EMAIL     =>  $iB::IN{'RecipientEmail'},
                                            SENDER_EMAIL =>  $iB::IN{'SendersEmail'}
                                           }
                                        );

    $Invite::lang->{'invite_subject'} =~ s!<#MEMBER_NAME#>!$iB::IN{'SenderName'}!;

    $SEND->Send( TO      => $iB::IN{'RecipientEmail'},
                 FROM    => $iB::IN{'SendersEmail'},
                 SUBJECT => $Invite::lang->{'invite_subject'},
                 MESSAGE => $message
               );


    if ($iB::INFO->{'LOG_INVITE'}) {
        #
    }

      
    $output->redirect_screen( TEXT => "$Invite::lang->{'invite_redirect'} $iB::IN{'RecipientEmail'}", URL => '');
}


1;


__END__
