package Misc::Forward;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Register: Registration Fucntions.
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $mail        = FUNC::Mailer->new();
my $mem         = FUNC::Member->new();
my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
$Forward::lang = $std->LoadLanguage('ForwardWords');


sub new {
  my $pkg = shift;
  my $obj = {};
  bless $obj, $pkg;
  return $obj;
}


sub send_mail {
    my ($obj, $db) = @_;
    my $validate_e  = $std->CheckEmail($iB::IN{'to_email'});

    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'stf_no_name')    unless $iB::IN{'to_name'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'stf_no_email')   unless $iB::IN{'to_email'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'stf_no_msg')     unless $iB::IN{'message'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'stf_no_subject') unless $iB::IN{'message'};
    $std->Error( STD => $std, DB => $db, LEVEL => 1, MESSAGE => 'subject_long')   unless length($iB::IN{'subject'}) < 100;
    $std->Error( STD => $std, DB => $db, LEVEL => 2, MESSAGE =>'invalid_email')   if $validate_e != 1;



    my $message = $mail->parse_template( ID      => 'SEND_FRIEND',
                                         DB      => $db,
                                         VALUES  =>
                                          { 
                                            TO_NAME       =>  $iB::IN{'to_name'},
                                            THE_MESSAGE   =>  $iB::IN{'message'},
                                           }
                                        );

    $mail->Send( TO      => $iB::IN{'to_email'},
                 FROM    => $iB::MEMBER->{'MEMBER_EMAIL'},
                 SUBJECT => $iB::IN{'subject'},
                 MESSAGE => $message
               );


    $output->redirect_screen(TEXT => "$Forward::lang->{'redirect'}", URL => "act=ST;f=$obj->{'.forum_id'};t=$obj->{'.topic_id'};st=$iB::IN{'st'}");
}



sub show_form {
    my ($obj, $db) = @_;

    $Forward::lang->{'send_text'} =~ s!<#THE LINK#>!$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=ST&f=$obj->{'.forum_id'}&t=$obj->{'.topic_id'}!;
    $Forward::lang->{'send_text'} =~ s!<#USER NAME#>!$iB::MEMBER->{'MEMBER_NAME'}!;

    my $print = ForwardView::send_form( {
                                           SUBJECT    => $obj->{'.topic'}->{'TOPIC_TITLE'},
                                           BODY_TEXT  => $Forward::lang->{'send_text'},
                                        }
                                     );

    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => $print,
                              TITLE   => $Forward::lang->{'title'},
                              NAV     => [
                                           qq|<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=ST&f=$obj->{'.forum_id'}&t=$obj->{'.topic_id'}" class='nav'>$obj->{'.topic'}->{'TOPIC_TITLE'}</a>|,
                                           qq|$Forward::lang->{'title'}|
                                         ]
                            );
}



sub Process {
    my ($obj, $db) = @_;

    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});

    require $iB::SKIN->{'DIR'} . '/ForwardView.pm';

    $obj->{'.topic_id'} = $std->IsNumber($iB::IN{'t'});
    $obj->{'.forum_id'} = $std->IsNumber($iB::IN{'f'});

    $std->Error( STD     => $std,
                 DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'no_action'
               )  unless defined $obj->{'.topic_id'} and defined $obj->{'.forum_id'};


    $std->Error( STD     => $std,
                 DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'not_registered'
               )  unless $iB::MEMBER->{'MEMBER_ID'};


    $obj->{'.forum'} = $db->select( TABLE  => 'forum_info',
                                    KEY    => $obj->{'.forum_id'}
                                  );

    $obj->{'.topic'} = $db->select( TABLE  => 'forum_topics',
                                    ID     => $obj->{'.forum_id'},
                                    KEY    => $obj->{'.topic_id'}
                                  );


    my %Mode = ( '00'     => \&show_form,
                 '01'     => \&send_mail,
               );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : show_form($obj, $db);   
} 


1;
