package Misc::Cookies;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# 
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();

$Universal::lang = $std->LoadLanguage("UniversalWords");


sub new {
  my $pkg = shift;
  my $obj = {};
  bless $obj, $pkg;
  return $obj;
}


sub Process {
    my ($obj, $db) = @_;
    my $toilets = 'Cookies';

    if ($iB::IN{f}) {
        push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{COOKIE_ID}."forum-$iB::IN{f}", -value => time, -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'}, -expires => '+1y' );
        $output->redirect_screen( TEXT  => $Universal::lang->{forum_read}, URL => "");
    } else { 
        for (keys %{$iB::COOKIES}) {
            next unless /$iB::INFO->{'COOKIE_ID'}/;
            push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $_, -value => '-', -expires=>'+1d', -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'} );
        
        }
    $output->redirect_screen( TEXT  => $Universal::lang->{cookies_flushed}, URL => "");
    }


}

1;


__END__
