package Misc::Attachments;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# 
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
   require 'MimeTypes.cfg';
}

#BENDER: "I'm gonna make my own theme park with hookers and blackjack..
#        "infact, forget the theme park!"

my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();


sub new {
  my $pkg = shift;
  my $obj = {};
  bless $obj, $pkg;
  return $obj;
}


sub Process {
    my ($obj, $db) = @_;
    
    # Check we have all the data we need

    $std->Error( LEVEL   => 1,
                 STD     => $std,
                 DB      => $db,
                 MESSAGE => 'missing_files'
               ) unless $iB::IN{'ID'} && $iB::IN{'f'} && $iB::IN{'t'} && $iB::IN{'p'};

    # Are attachments turned on in this forum?
    
    my $forum = $db->select( TABLE  => 'forum_info',
                             KEY    => $iB::IN{'f'}
                           );

    $std->Error( LEVEL   => 1,
                 STD     => $std,
                 DB      => $db,
                 MESSAGE => 'no_attach'
               ) unless $forum->{'ALLOW_ATTACH'};
    

    # Increase the download count for that post

    my $p = $db->select( TABLE  => 'forum_posts',
                         DBID   => 'f'.$iB::IN{'f'},
                         ID     => $iB::IN{'t'},
                         KEY    => $iB::IN{'p'}
                       );

    $p->{'ATTACH_HITS'}++;

    $db->update(         TABLE  => 'forum_posts',
                         DBID   => 'f'.$iB::IN{'f'},
                         ID     => $iB::IN{'t'},
                         KEY    => $iB::IN{'p'},
                         VALUES => { ATTACH_HITS => $p->{'ATTACH_HITS'} }
                       );

    # Get the attachment

    my $at = $db->select( TABLE => 'attachments',
                          KEY   => $iB::IN{'ID'},
                       );

    # Better check it's there..

    $std->Error( LEVEL   => 1,
                 STD     => $std,
                 DB      => $db,
                 MESSAGE => 'missing_files'
               ) unless $at->{'FILE_NAME'};

    # Redirect..
    # [ I have a feeling I'll be changing this section shortly ]

    print $iB::CGI->redirect( -uri => "$iB::INFO->{'UPLOAD_URL'}/$at->{'FILE_NAME'}" );
    
               

}

1;


__END__
