package Misc::AOL;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# 
#
#################################################################################

BEGIN {
   require 'Lib/FUNC.pm';
}

my $std         = FUNC::STD->new();
my $output      = FUNC::Output->new();
require $iB::SKIN->{'DIR'} . '/PagerView.pm' or die $!;

my $html = undef;

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


sub Process {
    my ($obj, $db) = @_;
    
    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'no_user'
               ) unless $iB::IN{'MID'};


    my $member = $db->select( TABLE  => 'member_profiles',
                              ID     => $iB::IN{'MID'},
                              KEY    => $iB::IN{'MID'},
                             );

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'no_user'
               ) unless $member->{'MEMBER_ID'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 STD     => $std,
                 MESSAGE => 'no_aol'
               ) unless $member->{'AOLNAME'};


    $html  = PagerView::aol_body( { AOLNAME => $member->{'AOLNAME'} } );
 

    $output->print_popup( STD        => $std,
                          OUTPUT     => $html,
                          TITLE      => "iB::".$Pager::lang->{'aol_title'},
                        );

}

1;


__END__
