package Memberlist;
use strict;
#+-----------------------------------------------------------------+
#| Ikonboard v3 by Jarvis Entertainment Group, Inc.
#|
#| No parts of this script can be used outside Ikonboard without prior consent.
#|
#| More information available from <ib-license@jarvisgroup.net>
#| (c)2001 Jarvis Entertainment Group, Inc.
#| 
#| http://www.ikonboard.com
#|
#| Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Memberlist - Displays the memberlist
#
#+-----------------------------------------------------------------+
BEGIN {
    require 'Lib/FUNC.pm';
}

my $std      = FUNC::STD->new();
my $mem      = FUNC::Member->new();
my $output   = FUNC::Output->new();

$Memberlist::lang = $std->LoadLanguage("MemberlistWords");


sub new {
  my $pkg = shift;
  my $obj = { '.html' => undef, 'MEMBER' => $iB::MEMBER };
  bless $obj, $pkg;
  return $obj;
}


sub show_results {
    my ($obj, $db) = @_;

    $obj->check_access_string() if $iB::IN{'httpd'};

    require $iB::SKIN->{'DIR'} . '/MemberlistView.pm' or die $!;

    #+---------------------------------------------------------
    # Grab the member groups and push into a hash
    #+---------------------------------------------------------

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my %temp_table = map { $_->{'ID'} => { TITLE  => $_->{'TITLE'},
                                           ICON   => $_->{'TEAM_ICON'}
                                         }
                         } @{$mem_groups};
    $obj->{'group_table'} = \%temp_table;

    #+---------------------------------------------------------
    # Grab the member titles and push into a hash
    #+---------------------------------------------------------

    my $mem_titles = $db->query( TABLE      => 'member_titles',
                                 COLUMNS    => ['ID', 'TITLE', 'POSTS'],
                                 SORT_KEY   => 'POSTS',
                                 SORT_BY    => 'Z-A',
                               );

    my %temp_titles = map { $_->{'ID'} => { TITLE => $_->{'TITLE'},
                                            POSTS => $_->{'POSTS'},
                                            PIPS  => $_->{'PIPS'}
                                          }
                          } @{$mem_titles};
    $obj->{'title_table'} = \%temp_titles;


    my $print;

    my $First       = $iB::IN{'st'}          || 0;
    my $max_results = $iB::IN{'max_results'} || 10;
    my $sort_key    = $iB::IN{'sort_key'}    || 'MEMBER_NAME';
    my $sort_order  = $iB::IN{'sort_order'}  || 'A-Z';
    my $filter      = $iB::IN{'filter'}      || 'ALL';

    my $the_filter = { 'ALL' => $Memberlist::lang->{'show_all'} };

    for my $g (@{$mem_groups}) {
        next if $g->{'ID'} == $iB::INFO->{'GUEST_GROUP'}
             || $g->{'ID'} == $iB::INFO->{'AUTHORISE_GROUP'}
             || $g->{'ID'} == $iB::INFO->{'BANNED_GROUP'};
        $the_filter->{ $g->{'ID'} } = $g->{'TITLE'};
    }


    my $the_sort_key   =  { MEMBER_NAME       => 'sort_by_name',
                            MEMBER_POSTS      => 'sort_by_posts',
                            MEMBER_JOINED     => 'sort_by_joined',
                            MEMBER_LEVEL      => 'sort_by_level',
                          };

    my $the_max_results = { 10                => '10',
                            20                => '20',
                            30                => '30',
                          };

    my $the_sort_order  = { 'Z-A'  => 'descending_order',
                            'A-Z'  => 'ascending_order',
                          };

    my $sort_key_html     = qq[<select name='sort_key' class='forminput'>\n];
    my $max_results_html  = qq[<select name='max_results' class='forminput'>\n];
    my $sort_order_html   = qq[<select name='sort_order' class='forminput'>\n];
    my $filter_html       = qq[<select name='filter' class='forminput'>\n];

    for ( sort { $a cmp $b } keys %{$the_sort_order}) {
        $sort_order_html .= $_ eq $sort_order  ? qq[<option value='$_' selected>$Memberlist::lang->{ $the_sort_order->{$_} }\n]
                                               : qq[<option value='$_'>$Memberlist::lang->{ $the_sort_order->{$_} }\n];
    }

    for ( sort { $a cmp $b } keys %{$the_sort_key}) {
        $sort_key_html .= $_ eq $sort_key ? qq[<option value='$_' selected>$Memberlist::lang->{ $the_sort_key->{$_} }\n]
                                          : qq[<option value='$_'>$Memberlist::lang->{ $the_sort_key->{$_} }\n];
    }

    for ( sort { $a <=> $b } keys %{$the_filter}) {
        $filter_html .= $_ == $filter     ? qq[<option value='$_' selected>$the_filter->{$_}\n]
                                          : qq[<option value='$_'>$the_filter->{$_}\n];
    }

    for ( sort { $a <=> $b } keys %{$the_max_results}) {
        $max_results_html .= $_ == $max_results ? qq[<option value='$_' selected>$_\n]
                                                : qq[<option value='$_'>$_\n];
    }

    $Memberlist::lang->{'sorting_text'} =~ s!<#FILTER#>!$filter_html</select>!;
    $Memberlist::lang->{'sorting_text'} =~ s!<#SORT_KEY#>!$sort_key_html</select>!;
    $Memberlist::lang->{'sorting_text'} =~ s!<#SORT_ORDER#>!$sort_order_html</select>!;
    $Memberlist::lang->{'sorting_text'} =~ s!<#MAX_RESULTS#>!$max_results_html</select>!;


    $std->Error( LEVEL=>5, MESSAGE => "not a valid q") unless (exists $the_sort_key->{$sort_key} and exists $the_sort_order->{$sort_order} and exists $the_filter->{$filter});
    $std->Error( LEVEL=>5, MESSAGE => "not a letter")  unless (exists $the_max_results->{ $max_results });


    my $group_filter = $filter eq 'ALL' ? '' : "MEMBER_GROUP == $iB::IN{'filter'}";

    my $total_members  = $db->query( TABLE     => 'member_profiles',
                                     COLUMNS   => ['MEMBER_NAME', 'MEMBER_ID', 'MEMBER_POSTS', 'MEMBER_JOINED', 'MEMBER_GROUP', 'MEMBER_EMAIL', 'HIDE_EMAIL', 'MEMBER_LEVEL', 'AOLNAME', 'ICQNUMBER'],
                                     WHERE     => "$group_filter",
                                     MATCH     => "WITH COUNT",
                                     SORT_KEY  => $sort_key,
                                     SORT_BY   => $sort_order,
                                     RANGE     => $First." to ".($max_results+$First),
                                   );


    $print = MemberlistView::start();

    my $total_results = $db->matched_records;

    if ($total_results > 0) {

        $obj->{'.this'}->{'TOTAL_PAGE'} = $std->ib_int($total_results, $max_results);
        $obj->{'.this'}->{'TOTAL_PAGE'} = 1 if $obj->{'.this'}->{'TOTAL_PAGE'} < 1;
        $obj->{'CUR_PAGE'} = $iB::IN{'st'} > 0 ? ($iB::IN{'st'} / $max_results) + 1 : 1;

        if ($obj->{'.this'}->{'TOTAL_PAGE'} > 1) {
            $obj->{'.this'}->{'FIRST_PAGE'} = qq[$Memberlist::lang->{'multi_pages'}:: <a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?max_results=$iB::IN{'max_results'};sort_key=$iB::IN{'sort_key'};sort_order=$iB::IN{'sort_order'};filter=$iB::IN{'filter'};s=$iB::SESSION;act=Members;st=0'>&lt;&lt;</a>];
            my $i = 0;
            my $end_dots;
            my $start_dots;
            for(0 .. $obj->{'.this'}->{'TOTAL_PAGE'}-1) {
                my $RealNo = $i * $max_results;
                my $PageNo = $i+1;
                if ($RealNo == $iB::IN{'st'}) {
                    $obj->{'.this'}->{'PAGE_SPAN'} .= qq!&nbsp;&nbsp;&nbsp;<b>[ $PageNo ]</b>!;
                } else {
                    if ($PageNo < ($obj->{'CUR_PAGE'} - 2) and ($obj->{'CUR_PAGE'} >= 3))  { $start_dots = '&nbsp;&nbsp;&nbsp;...'; ++$i; next; }
                    $obj->{'.this'}->{'PAGE_SPAN'} .= qq[&nbsp;&nbsp;&nbsp;<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?max_results=$iB::IN{'max_results'};sort_key=$iB::IN{'sort_key'};sort_order=$iB::IN{'sort_order'};filter=$iB::IN{'filter'};s=$iB::SESSION;act=Members;st=$RealNo'>$PageNo</a> ];
                    if ($PageNo == ($obj->{'CUR_PAGE'} + 2)) { $end_dots = '...&nbsp;&nbsp;&nbsp;'; last; }
                }
                ++$i;
            }
            $obj->{'.this'}->{'LAST_PAGE'} = qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?max_results=$iB::IN{'max_results'};sort_key=$iB::IN{'sort_key'};sort_order=$iB::IN{'sort_order'};filter=$iB::IN{'filter'};s=$iB::SESSION;act=Members;st=].($obj->{'.this'}->{'TOTAL_PAGE'}-1) * $max_results.qq['>&gt;&gt;</a>];
            $obj->{'.this'}->{'SHOW_PAGES'} = $obj->{'.this'}->{'FIRST_PAGE'} . $start_dots . $obj->{'.this'}->{'PAGE_SPAN'}. '&nbsp;&nbsp;&nbsp;' . $end_dots . $obj->{'.this'}->{'LAST_PAGE'};
        } else {
            $obj->{'.this'}->{'SHOW_PAGES'} = '';
        }

        $print .= MemberlistView::Page_header($obj->{'.this'});

        for my $member (@{$total_members}) {

            $member->{'MEMBER_JOINED'} = $std->get_date( TIME => $member->{'MEMBER_JOINED'}, METHOD => 'JOINED');
            $member->{'MEMBER_GROUP'}  = $obj->{'group_table'}->{  $member->{'MEMBER_GROUP'} }->{'TITLE'};

            $member->{'AOLNAME'}       = $member->{'AOLNAME'} ? qq[<a href="javascript:PopUp('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=AOL&MID=$member->{'MEMBER_ID'}','Pager','450','330','0','1','1','1')">$iB::SKIN->{'P_AOL'}</a>]
                                                              : '&nbsp;';
            $member->{'ICQNUMBER'}     = $member->{ICQNUMBER} ?  qq[<a href="javascript:PopUp('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&act=ICQ&MID=$member->{'MEMBER_ID'}','Pager','450','330','0','1','1','1')">$iB::SKIN->{'P_ICQ'}</a>&nbsp;]
                                                              : '&nbsp;';
            $member->{'MEMBER_EMAIL'}  = $member->{'HIDE_EMAIL'} ? '&nbsp;' : qq[<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Mail;CODE=00;MID=$member->{'MEMBER_ID'}">$iB::SKIN->{'P_EMAIL'}</a>];   

            unless( $obj->{'group_table'}->{ $member->{'MEMBER_GROUP'} }->{'ICON'} ) {
                for my $m (@{$mem_titles}) {
                    if ($member->{MEMBER_POSTS} >= $m->{POSTS}) {
                        $member->{'MEMBER_PIPS_IMG'} = qq!$iB::SKIN->{'A_STAR'}! x $m->{PIPS};
                        last;
                    }
                }
            } else {
                $member->{'MEMBER_PIPS_IMG'} = qq!<img src="$iB::INFO->{'TEAM_ICON_URL'}/$obj->{'group_table'}->{ $member->{'MEMBER_GROUP'} }->{'ICON'}" border='0'>!
            }

            $print .= MemberlistView::show_row($member);
        }

        $print .= MemberlistView::Page_end();

    } else {
    
        $print .= MemberlistView::no_results();

    }

    $print .= MemberlistView::end($obj->{'.this'});


    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              JAVASCRIPT => 1,
                              TITLE   => "iB::".$Memberlist::lang->{'page_title'},
                              NAV_ONE => $Memberlist::lang->{'page_title'},
                              OUTPUT  => $print,
                            );

}
    

sub check_access_string {

    my $check_line = q[,,,,,,,,,,,,,,,,,,,,,,,,____v,,,,,,,,,,,,,,,,,,,,,,o;%;;;;,v,,,,,,,,,,,,,,,,,,,,o;;%;;;].
                     q[;;;;.v,,,,,,,,,,,,,,,,,,,;'-,,,,-:;;;;bv,,,,,,,,,,,,,,,,,,;',,,,,,,,,;;;;v,,,,,,,,,,,,,].
                     q[,,,,d;.-=.,,==-.:;;;bv,,,,,,,,,,,,,,,,,>;,"~",:"~',d;;;;v,,,,,,,,,,,,,,,,,;;,,,,,,,,,,;].
                     q[;;;;v,,,,,,,,,,,,,,,,,;;b.,"-~,,':;;;;;v,,,,,,,,,,,,,,,,,;;;b,~==~,.:;;;;;v,,,,,,,,,,,,].
                     q[,,,,,;;;;;o--:':::;;;;v,,,,,,,,,,,,,,,,,";;;;;|,:::',;;;;bv,,,,,,,,,,,,,,,,,;;;;^^',,,,].
                     q[,,,;;;;b,,,v,,,,,,,,,,,,,,,,,,d;;;,,,,,,,,,,,,%;;;b.v,,,,,,,,,,,,,,,d;;%,,,,,,,,,,,,%%%].
                     q[;--'-.v,,,,,,,,,,,,,,/;;:.__,,,,,,,,,_%-',---,,-v,,,,,,,,,,,,,i,,,,'''::===..-',,,=,,--.,,"v];

    my %config       = ( ';' => '8', '"' => '`', ',' => '&nbsp;', 'v' => '<br>');

    $check_line =~ s:([;",v]):$config{$1}:g;

    if ($check_line) {
        print $iB::CGI->header();
        print $iB::CGI->start_html('Access Denied!');
        print "<font face='Courier, Courier New, Monaco', size='3'><br>$check_line<br><br>SMILE!</font>";
        print $iB::CGI->end_html();
        exit (0);
    }
    return;
}



sub Process {
    my ($obj, $db) = @_;
    show_results($obj, $db);
}


1;


__END__
