package LogInOut;
use strict;
#+------------------------------------------------------------------------------------------------------
BEGIN { require 'Lib/FUNC.pm'; }

my $std    = FUNC::STD->new();
my $mem    = FUNC::Member->new();
my $output = FUNC::Output->new();


$LogInOut::lang = $std->LoadLanguage('LoginWords');
#+------------------------------------------------------------------------------------------------------

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

#+------------------------------------------------------------------------------------------------------

sub LogIn {
    my ($obj, $db) = @_;

    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'no_username') unless $iB::IN{'UserName'};
    $std->Error( DB => $db, LEVEL => 1, MESSAGE => 'pass_blank')  unless $iB::IN{'PassWord'};

    my $url;
    if ($iB::IN{'referer'} and ($iB::IN{'act'} ne 'Reg' or $iB::IN{'act'} ne 'LostPass')) {
        $url = $iB::IN{'referer'};
        $url =~ s!$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}!!i;
        $url =~ s!\?!!g;
        $url =~ s!s=.+?[&;]!!g;
        $url =~ s!act=Login!!ig;
        $url =~ s!act=Reg!!g;
        $url = '' if $url =~ /LostPass/i;
    }

    # Update the anon long in cookie if needed.
    # As we use $iB::IN{Privacy}, we'll use the param
    # returned from CGI. This will only return true if the
    # form field existed and is retuned checked. Otherwise
    # we'll assume that this is a normal session validation.
    
    if ($iB::CGI->param('Privacy') == 1) {
        push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'anonlogin', -value => "1", -expires => '+1y', -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'});
    }

    $output ->redirect_screen( TEXT  => "$LogInOut::lang->{'thanks_for_login'} $iB::MEMBER->{'MEMBER_NAME'}",
                               URL   => $url
                             );
  
}








sub DoLogOut {
    my ($obj, $db) = @_;

    $std->Error(LEVEL=>'1',MESSAGE=>'no_guests') unless $iB::MEMBER->{'MEMBER_ID'};

    $db->update( TABLE  => 'active_sessions',
                 KEY    => $iB::SESSION,
                 VALUES => { ID               =>  $iB::SESSION,
                             MEMBER_NAME      =>  "",
                             MEMBER_PASSWORD  =>  "",
                             MEMBER_ID        =>  "",
                             THIS_IP          =>  $ENV{'REMOTE_ADDR'},
                             LAST_LOG_IN      =>  time,
                             USER_AGENT       =>  $ENV{'HTTP_USER_AGENT'},
                             SESSION_START    =>  time,
                             MEMBER_LOGSTATE  =>  0,
                             LOCATION         =>  $iB::IN{'act'}."|&|".$ENV{'QUERY_STRING'},
                             LOG_IN_TYPE      =>  0,
                           }
                );

    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'iBSessionID', -value => $iB::SESSION, -expires =>'+1d' , -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'});
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'iBMemberID',  -value => '-'         , -expires =>'+1d' , -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'});
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'iBPassWord',  -value => '-'         , -expires =>'+1d' , -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'});
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'skin',        -value => '-'         , -expires =>'+1d' , -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'});
    push @{$iB::COOKIES_OUT}, $iB::CGI->cookie( -name => $iB::INFO->{'COOKIE_ID'}.'anonlogin',   -value => '-'         , -expires =>'+1d' , -path => $iB::INFO->{'COOKIE_PATH'}, -domain => $iB::INFO->{'COOKIE_DOMAIN'});
    
    $output->redirect_screen( TEXT      => "$LogInOut::lang->{'thanks_for_logout'}",
                              URL       => ''
                            );    

}





sub ShowForm  {
    my ($obj, $db, $message) = @_;
    require $iB::SKIN->{'DIR'} . '/LogInView.pm' or die $!;

    my $print;

    if ($message) {

        $message = $LogInOut::lang->{$message};
        $message =~ s!<#NAME#>!<b>$iB::IN{'UserName'}</b>!;

        $print = LogInView::errors($message);
    
    }


    $iB::IN{'REFERER'} = $iB::CGI->referer();
    $print .= &LogInView::ShowForm($LogInOut::lang->{'please_log_in'});

    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => $print,
                              TITLE   => 'iB::'.$LogInOut::lang->{'log_in'},
                              NAV     => [$LogInOut::lang->{'log_in'}]
                            );
    
}

sub ShowLogOut  {
    my ($obj, $db) = @_;
    require $iB::SKIN->{'DIR'} . '/LogInView.pm' or die $!;
    $output->print_ikonboard(
                              DB      => $db,
                              STD     => $std,
                              OUTPUT  => &LogInView::ShowLogOutForm(),
                              TITLE   => 'iB::'.$LogInOut::lang->{'log_out'},
                              NAV     => [$LogInOut::lang->{'log_out'}]
                            );
}



sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    my %Mode = ( '01'     => \&LogIn,
                 '00'     => \&ShowForm,
                 '02'     => \&ShowLogOut,
                 '03'     => \&DoLogOut
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : LogInError($obj, $db);   
} 

sub LogInError  { my ($obj, $db) = @_; $std->Error(LEVEL=>'1',MESSAGE=>'no_action') }

1;


__END__
