package Legends;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Online: Display the online users.
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
}

my $std        = FUNC::STD->new();
my $mem        = FUNC::Member->new();
my $output     = FUNC::Output->new();
$Legends::lang = $std->LoadLanguage('LegendsWords');

my $html = undef;
 

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub ibcode {

    require "iTextparser.pm";
    my $txt = iTextparser->new();

    $html  = LegendsView::card_header( $Legends::lang->{'ibc_title'},
                                       $Legends::lang->{'ibc_text'}
                                     );
    $html .= LegendsView::start_table( $Legends::lang->{'ibc_type'},
                                       $Legends::lang->{'ibc_used'}
                                     );

    my $code = {    B       => [ $Legends::lang->{B}                 , ""             ],
                    U       => [ $Legends::lang->{U}                 , ""             ],
                    I       => [ $Legends::lang->{I}                 , ""             ],
                    S       => [ $Legends::lang->{S}                 , ""             ],
                    CODE    => [ "my \$code = 'true';"               , ""             ],
                    QUOTE   => [ $Legends::lang->{QUOTE}             , ""             ],
                    IMG     => [ "$iB::INFO->{'EMOTICONS_URL'}/smile.gif", ""         ],
                    EMAIL   => [ "name\@domain.com"                  , ""             ],
                    URL     => [ "http:://www.ikonboard.com"         , ""             ],
                    SIZE    => [ "3"                                 , $Legends::lang->{SIZE}     ],
                    COLOR   => [ $Legends::lang->{COLOR}             , $Legends::lang->{COLOR2}   ],
                    ME      => [ $Legends::lang->{ME}                , ""                         ],
                    FONT    => [ "Courier"                           , $Legends::lang->{FONT}     ],
                    SQL     => [ "SELECT * FROM some_tbl", "" ],
                    HTML    => [ "&lt;a href=&quot;/page/index.html&quot;&gt;Page&lt;a&gt;", ""  ],
               };

    for (keys %{$code}) {
        $_ = "EMAIL" if $_ eq "EMAIL1";
        my $text = "[".$_;
        $text .= $code->{$_}[1] ? "=".$code->{$_}[0]."]".$code->{$_}[1] : "]".$code->{$_}[0];
        $text .= "[/".$_."]";
        my $conv = $txt->Convert_for_db( TEXT    => $text,
                                         IB_CODE => 1
                                       );

        $html .= LegendsView::ibc_row( 
                                      { TYPE => $text,
                                        USED => $conv
                                      }
                                     );
    }

    $html .= LegendsView::end_table();


    $output->print_popup( STD        => $std,
                          OUTPUT     => $html,
                          TITLE      => "iB::".$Legends::lang->{'ibc_title'},
                        );
}



sub emoticons {

    $html  = LegendsView::card_header( $Legends::lang->{'emo_title'},
                                       $Legends::lang->{'emo_text'}
                                     );
    $html .= LegendsView::start_table( $Legends::lang->{'emo_type'},
                                       $Legends::lang->{'emo_used'}
                                     );

    for my $e (split (/\|&\|/,$iB::INFO->{'EMOTICONS'}) ) {
        my ($type, $image, $p_inc) = split (/\|/,$e);
        next unless $type and $image;
        $html .= LegendsView::emo_row( 
                                      { TYPE => $type,
                                        USED => $image
                                      }
                                     );
    }

    $html .= LegendsView::end_table();


    $output->print_popup( STD        => $std,
                          OUTPUT     => $html,
                          TITLE      => "iB::".$Legends::lang->{'emo_title'},
                        );
}



sub showavatars {
    my ($obj, $db) = @_;

    opendir AVATARS, $iB::INFO->{'HTML_DIR'} . 'avatars' or die $!;
    my @avatars = map   {       $_     }
                  sort  {   $a cmp $b  }
                  grep  {     !/^\./   } readdir AVATARS;
    closedir AVATARS;

    $html  = LegendsView::card_header( $Legends::lang->{'avatar_title'},
                                       $Legends::lang->{'avatar_text'}
                                     );
    $html .= LegendsView::start_table( $Legends::lang->{'avatar_type'},
                                       $Legends::lang->{'avatar_img'}
                                     );

    for my $a (@avatars) {
        next if $a =~ /^index/;
        my $type = $a;
        $type  =~ s!\.\S+$!!g;
        $html .= LegendsView::ava_row( 
                                      { TYPE => $type,
                                        USED => $a,
                                      }
                                     );
    }

    $output->print_popup( STD        => $std,
                          OUTPUT     => $html,
                          TITLE      => "iB::".$Legends::lang->{'avatar_title'},
                        );

}



sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $iB::IN{'CODE'};
    #+-----------------------------------------------------------------------------------
    require $iB::SKIN->{'DIR'} . '/LegendsView.pm' or die $!;
    #+-----------------------------------------------------------------------------------
    my %Mode = ( 'emoticons'     => \&emoticons,
                 'ibcode'        => \&ibcode,
                 'avatars'       => \&showavatars,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : LegendError();
} 

sub LegendError { die "I'm working on it!" }

1;

__END__
