package Help;
use strict;
#+-----------------------------------------------------------------+
#| Ikonboard v3 by Jarvis Entertainment Group, Inc.
#|
#| No parts of this script can be used outside Ikonboard without prior consent.
#|
#| More information available from <ib-license@jarvisgroup.net>
#| (c)2001 Jarvis Entertainment Group, Inc.
#| 
#| http://www.ikonboard.com
#|
#| Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Help - If you need an explanation, you need help!
#
#+-----------------------------------------------------------------+

BEGIN { require 'Lib/FUNC.pm'; }

my $std      = FUNC::STD->new();
my $output   = FUNC::Output->new();
my $mem      = FUNC::Member->new();

$Help::lang = $std->LoadLanguage("HelpWords");


sub new {
    my $pkg = shift;
    my $obj = { };
    bless $obj, $pkg;
    return $obj;
}


sub Show_titles {
    my ($obj, $db) = @_;

    my $print = HelpView::start($Help::lang->{'page_title'}, $Help::lang->{'help_txt'}, $Help::lang->{'choose_file'});

    my $help_titles = $db->query( TABLE     => 'help',
                                  MATCH     => 'ALL',
                                  COLUMNS   => ['ID', 'TITLE'],
                                  SORT_KEY  => "TITLE",
                                  SORT_BY   => "A-Z",
                                ) || $std->cgi_error($db->{'error'});


    $std->Error( DB      => $db,
                 LEVEL   => '1',
                 MESSAGE => 'missing_files'
               ) unless scalar @{$help_titles} > 0;

    my $cnt = 0;

    for my $title (@{$help_titles}) {

        $title->{cell_colour} = $cnt % 2 ? $iB::SKIN->{MISCBACK_ONE} : $iB::SKIN->{MISCBACK_TWO};

        $print .= HelpView::row($title);

        ++$cnt;
    }

    $print .= HelpView::end();

    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              TITLE   => "iB::".$Help::lang->{'page_title'},
                              NAV_ONE => $Help::lang->{'page_title'},
                              OUTPUT  => $print,
                            );

}


sub do_search {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'search_no_input'
               ) unless $iB::IN{'search_q'};

    $iB::IN{'search_q'} =~ s!\*!%!g;
    $iB::IN{'search_q'} =~ s![<>\!\@\$\^&\+\=\-\(\)\{\}\[\]"':;\.,/]!!g;

    $iB::IN{'search_q'} = lc($iB::IN{'search_q'});

    my $search_results = $db->query( TABLE      => 'help',
                                     MATCH      => 'ALL',
                                     SORT_KEY   => 'TITLE',
                                     COLUMNS    => ['ID', 'TITLE'],
                                     WHERE      => "TITLE LIKE /%$iB::IN{'search_q'}%/ or TEXT LIKE /%$iB::IN{'search_q'}%/",
                                  ) || $std->cgi_error($db->{'error'});

    my $print = HelpView::start($Help::lang->{'search_results'}, $Help::lang->{'results_txt'}, $Help::lang->{'search_results'});

    $print .= HelpView::no_results() unless scalar @{$search_results} > 0;

    my $cnt = 0;

    for my $title (@{$search_results}) {

        $title->{cell_colour} = $cnt % 2 ? $iB::SKIN->{MISCBACK_ONE} : $iB::SKIN->{MISCBACK_TWO};

        $print .= HelpView::row($title);

        ++$cnt;
    }


    $print .= HelpView::end();

    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              TITLE   => "iB::".$Help::lang->{'results_title'},
                              NAV_ONE => qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Help;s=$iB::SESSION;CODE=00' class='nav'>$Help::lang->{'help_topics'}</a>],
                              NAV_TWO => $Help::lang->{'results_title'},
                              OUTPUT  => $print,
                            );

}


sub Show_section {
    my ($obj, $db) = @_;

    my $ID = $iB::IN{'HID'};

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'no_search_id'
               ) unless ($ID and $ID =~ /\A\d{1,3}\Z/);

    my $topic = $db->select( TABLE   => 'help',
                             KEY     => $ID,
                             COLUMNS => ['ID', 'TITLE', 'TEXT'],
                            ) || $std->cgi_error($db->{'error'});

    my $print  = HelpView::start($Help::lang->{'help_topic'}, $Help::lang->{'topic_text'}, $topic->{'TITLE'});
       $print .= HelpView::display( $std->TextTidy($topic->{'TEXT'}) );
       $print .= HelpView::end();

    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              TITLE   => "iB::".$Help::lang->{'help_topic'},
                              NAV_ONE => qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Help;s=$iB::SESSION;CODE=00' class='nav'>$Help::lang->{'help_topics'}</a>],
                              NAV_TWO => $Help::lang->{'help_topic'},
                              OUTPUT  => $print,
                            );
}





sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $std->CheckCodeNo($iB::IN{'CODE'});
    my %Mode = ( '00'     => \&Show_titles,
                 '01'     => \&Show_section,
                 '02'     => \&do_search,
               );
    require $iB::SKIN->{'DIR'} . '/HelpView.pm' or die $!;
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj, $db) : HelpError($obj, $db);   
} 

sub HelpError  { my ($obj, $db) = @_; $std->Error( DB => $db, LEVEL=>'1',MESSAGE=>'no_action') }


1;


__END__
