package Forum;
use strict;
#Random salt for hack protection
my $salt = 'cRey_BjaM_WbB';
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Forum: Display the topic summary for a chosen forum
#
#################################################################################

BEGIN { require 'Lib/FUNC.pm'; }

my $std      = FUNC::STD->new();
my $output   = FUNC::Output->new();
my $mem      = FUNC::Member->new();
$Forum::lang = $std->LoadLanguage('ForumWords');

# Sort out the real last visit date. The "mark as read" forum cookie
# will override the values we took from the other lastvisit cookies

my $fcookie = $iB::COOKIES->{ $iB::INFO->{COOKIE_ID}.'forum-'.$iB::IN{f} };
$iB::last_visit = $fcookie && $fcookie > $iB::last_visit ? $fcookie : $iB::last_visit;

$iB::INFO->{DISPLAY_MAX_TOPICS} ||= 15;
$iB::INFO->{DISPLAY_MAX_POSTS}  ||= 15;

#+------------------------------------------------------------------------------------------------------

sub new {
    my $pkg = shift;
    my $obj = { 'baseURL' => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION" };
    bless $obj, $pkg;
    return $obj;
}

#+------------------------------------------------------------------------------------------------------


sub ShowForum {
    my ($obj, $db) = @_;
    $obj->{'.forum_id'} = $std->IsNumber($iB::IN{'f'}) || 0;

    $obj->{'FORUM'} = $db->select( TABLE => 'forum_info',
                                   KEY   => $obj->{'.forum_id'},
                                 );
                                 
    #+---------------------------------------------------------
    # Assume nothing, confirm everything.
    #+---------------------------------------------------------

    $std->Error( DB      => $db,
                 LEVEL   => 1,
                 MESSAGE => 'missing_files',
               ) unless defined $obj->{'FORUM'}->{'FORUM_ID'};
    
    
    $obj->{'FORUM'}->{'FORUM_JUMP'} = $std->ForumJump();
    $obj->{'FORUM'}->{'FORUM_JUMP'} =~ s!#Forum Jump#!$Forum::lang->{'forum_jump'}!;

    $iB::IN{'L'} == 1 ? $obj->authenticate_user($db) : $obj->_show_forum($db);
}

#+------------------------------------------------------------------------------------------------------

sub ShowRules {
    my ($obj, $db) = @_;
    $obj->{'.forum_id'} = $std->IsNumber($iB::IN{'f'}) || 0;

    $obj->{'FORUM'} = $db->select( TABLE => 'forum_info',
                                   KEY   => $obj->{'.forum_id'},
                                 );

    $iB::IN{'L'} == 1 ? $obj->authenticate_user($db) : $obj->_show_rules($db);
}

#+------------------------------------------------------------------------------------------------------

sub _show_rules ($$) {
    my ($obj, $db) = @_;

    require $iB::SKIN->{'DIR'} . '/ForumView.pm' or die $!;
    require iTextparser;
    my $txt = iTextparser->new();

    my $check = $obj->Check_access($db);
    return if $check == 1;

    $std->Error( DB      => $db,
                 LEVEL   => 2,
                 MESSAGE => 'no_rules_show'
               ) unless $obj->{'FORUM'}->{'SHOW_RULES'};

    my $rules = $db->select(TABLE => 'forum_rules', KEY => $obj->{'FORUM'}->{'FORUM_ID'} );

    $std->Error( DB      => $db,
                 LEVEL   => 2,
                 MESSAGE => 'no_rules_show'
              ) unless $rules;

    $rules->{'RULES_TEXT'}  = $txt->Convert_for_db( TEXT    => $rules->{'RULES_TEXT'},
                                                    SMILIES => 1,
                                                    IB_CODE => 1,
                                                    HTML    => 1
                                                  );

    $rules->{'LAST_UPDATE'} = $std->get_date( TIME   => $rules->{'LAST_UPDATE'},
                                              METHOD => 'LONG'
                                            );

    $output->print_ikonboard( DB       => $db,
                              STD      => $std,
                              OUTPUT   => &ForumView::show_rules($rules),
                              TITLE    => "iB::".$obj->{'FORUM'}->{'FORUM_NAME'},
                              NAV      => [
                                           qq!<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SF;f=$obj->{'FORUM'}->{'FORUM_ID'}" class='nav'>$obj->{'FORUM'}->{'FORUM_NAME'}</a>!,
                                           $rules->{'RULES_TITLE'},
                                          ],
                            );
}

#+------------------------------------------------------------------------------------------------------

sub _show_forum ($$) {
    my ($obj, $db) = @_;

    require $iB::SKIN->{'DIR'} . '/ForumView.pm' or die $!;

    my $check = $obj->Check_access($db) || 0;
    return if $check == 1;

    my $print    = undef;
    
    my ($c_forum, $c_prune, $c_sort_k, $c_sort_b, $c_first);
    # Do we have a preferences cookie?
    # We record the prefs for each forum, but only one forum's
    # preferences are stored at any same time - this is because
    # we assume that they'd like to restore the forum sorting/date prefs
    # to default when they next enter.
    if ($iB::COOKIES->{$iB::INFO->{'COOKIE_ID'}.'fPrefs'}) {
        my $forum_prefs = $iB::COOKIES->{$iB::INFO->{'COOKIE_ID'}.'fPrefs'};
        # Does it match the current forum?
        if ($forum_prefs =~ /^$iB::IN{'f'}:/) {
            # Grab the values (form data still overrides it)
            ($c_forum, $c_prune, $c_sort_k, $c_sort_b, $c_first) = split/\:/, $forum_prefs;
        }
    }

    my $prune_value = $iB::IN{'prune_day'} || $c_prune   || $obj->{'FORUM'}->{'PRUNE_DAYS'} || $iB::INFO->{'PRUNE_DAYS'} || '100';

    my $sort_key    = $iB::IN{'sort_key'}  || $c_sort_k  || $obj->{'FORUM'}->{'SORT_KEY'}   || $iB::INFO->{'SORT_KEY'}   || 'TOPIC_LAST_DATE';

    my $sort_by     = $iB::IN{'sort_by'}   || $c_sort_b  || $obj->{'FORUM'}->{'SORT_ORDER'} || $iB::INFO->{'FORUM_SORT_ORDER'} || 'Z-A';
    
    my $First       = defined($iB::IN{'st'}) ? $iB::IN{'st'} : $c_first  || 0;
    
    # Make sure the page span stuff works.
    $iB::IN{'st'} = $First;
    
    # Save out the cookie again with the amended values.
    push @{$iB::COOKIES_OUT},$iB::CGI->cookie( -name    => $iB::INFO->{'COOKIE_ID'}.'fPrefs',
                                               -value   => "$iB::IN{'f'}:$prune_value:$sort_key:$sort_by:$First",
                                               -path    => $iB::INFO->{'COOKIE_PATH'},
                                               -expires => "+1y",
                                               -domain  => $iB::INFO->{'COOKIE_DOMAIN'},
                                             );


    my $Prune = $prune_value != 100 ? (time - ($prune_value * 60 * 60 * 24)) : 0;

    my $sort_keys   =  { TOPIC_LAST_DATE    => 'sort_by_date',
                         TOPIC_TITLE        => 'sort_by_topic',
                         TOPIC_STARTER_N    => 'sort_by_poster',
                         TOPIC_POSTS        => 'sort_by_replies',
                         TOPIC_VIEWS        => 'sort_by_views',
                         TOPIC_START_DATE   => 'sort_by_start',
                         TOPIC_LASTP_N      => 'sort_by_last_poster',
                       };

    my $prune_by_day = { '1'    => 'show_today',
                         '5'    => 'show_5_days',
                         '7'    => 'show_7_days',
                         '10'   => 'show_10_days',
                         '15'   => 'show_15_days',
                         '20'   => 'show_20_days',
                         '25'   => 'show_25_days',
                         '30'   => 'show_30_days',
                         '60'   => 'show_60_days',
                         '90'   => 'show_90_days',
                         '100'  => 'show_all',
                       };

    my $sort_by_keys = { 'Z-A'  => 'descending_order',
                         'A-Z'  => 'ascending_order',
                       };

    $std->Error(DB => $db, LEVEL=>5, MESSAGE=>'incorrect_use')
        unless ((exists $sort_keys->{$sort_key}) and (exists $prune_by_day->{$prune_value}) and (exists $sort_by_keys->{$sort_by}));

    my $q_extra;
    unless ($iB::MEMBER_GROUP->{'OTHER_TOPICS'}) {
            $q_extra = qq!and TOPIC_STARTER eq "$iB::MEMBER->{'MEMBER_ID'}"!;
    }

    my $pinned  = [];
    
    # Get the pinned topics and normal topics
    # To make sure the page splits are correct
    # we need to take away the # of pinned topics
    # from our start variable
    # Effectively shifting the range of our slice
    # down by the # of pinned topics...
    # otherwise posts go missing (or seem to).

    $pinned        = $db->query( TABLE    => 'forum_topics',
                                 ID       => $obj->{'.forum_id'},
                                 WHERE    => "FORUM_ID == $iB::IN{'f'} and PIN_STATE == 1",
                                 SORT_KEY => $sort_key,
                                 SORT_BY  => 'A-Z',
                               );


    my $pin_count = scalar @{$pinned};

    # Fix up the start point of our topic list slice (only needed if we're not on the first page of a topic span)
    $First -= $pin_count if $First > 0;
    
    # Fix up the end point of our topic list slice
    my $Last = $iB::INFO->{'DISPLAY_MAX_TOPICS'} + ($First - 1);
    
    # Have we viewable pinned topics and are we on the first
    # page of the topic list?
    # Yes? then we'll need to take the # of pinned topics from
    # the end point of our slice - or we'll have MAX_TOPICS + # pinned
    
    $Last -= $pin_count if $First < 1;
    

    my $total_topics  = $db->query( TABLE    => 'forum_topics',
                                    ID       => $obj->{'.forum_id'},
                                    WHERE    => "FORUM_ID == $iB::IN{'f'} and PIN_STATE != 1 and TOPIC_LAST_DATE > $Prune and APPROVED == 1 $q_extra",
                                    RANGE    => $First." to ".$Last,
                                    SORT_KEY => $sort_key,
                                    SORT_BY  => $sort_by,
                                    MATCH    => 'WITH COUNT'
                                  );
                                  

    # Is this the first page in a forum?
    # If so, lets add the pinned topics...
    # We still need to know how many pinned topics
    # there are to adjust our "start" variable.

    if ( ($pin_count > 0) and ($First == 0) ) {
        for (@{$pinned}) {
            unshift @{$total_topics}, $_;
        }
    }
    my $total_possible = $db->matched_records + $pin_count;

    ####################################
    # Generate the forum page span links
    ####################################
    $obj->{'FORUM'}->{'SHOW_PAGES'}
        = $std->build_pagelinks( TOTAL_POSS  => $total_possible,
                                 PER_PAGE    => $iB::INFO->{'DISPLAY_MAX_TOPICS'},
                                 CUR_ST_VAL  => $iB::IN{'st'},
                                 L_SINGLE    => $Forum::lang->{'single_page_forum'},
                                 L_MULTI     => $Forum::lang->{'multi_page_forum'},
                                 BASE_URL    => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SF;f=$iB::IN{'f'}",
                               );
    
    ####################################
    # Generate the poll button
    ####################################    
    $obj->{'FORUM'}->{'POLL_BUTTON'} = $iB::INFO->{'ALLOW_POLLS'}
                                     ? qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Poll;CODE=01;f=$iB::IN{'f'}'>$iB::SKIN->{'A_POLL'}</a>]
                                     : '';


    if ($obj->{'FORUM'}->{'SHOW_RULES'}) {
        require iTextparser;
        my $txt = iTextparser->new();
        if (my $rules = $db->select(TABLE => 'forum_rules', KEY => $obj->{'FORUM'}->{'FORUM_ID'} )) {
             $rules->{'RULES_TEXT'}  = $txt->Convert_for_db( TEXT    => $rules->{'RULES_TEXT'},
                                                             SMILIES => 1,
                                                             IB_CODE => 1,
                                                             HTML    => 1
                                                           );
             $print = $obj->{'FORUM'}->{'SHOW_RULES'} == 2 ? ForumView::show_rules_link($rules) : ForumView::show_rules_full($rules);
        }
    }
        
    $print .= ForumView::PageTop($obj->{'FORUM'});
    $print .= ForumView::show_no_matches() unless scalar @{$total_topics} > 0;


    for (@{$total_topics}) {
        my $pin = $_->{'PIN_STATE'} == 1 ? 1 : 0;
        $print .= $obj->_do_row( DB => $db, DATA => $_, PIN => $pin );
    }


    $Forum::lang->{'showing_text'} =~ s{<#MATCHED_TOPICS#>}{@{$total_topics} ? scalar @{$total_topics} : '0'}eg;
    $Forum::lang->{'showing_text'} =~ s!<#TOTAL_TOPICS#>!$total_possible!g;
    
    my $sort_key_html  = qq[<select name='sort_key' class='forminput'>\n];
    my $prune_day_html = qq[<select name='prune_day' class='forminput'>\n];
    my $sort_by_html   = qq[<select name='sort_by' class='forminput'>\n];
    

    for ( sort { $a cmp $b } keys %{$sort_by_keys}) {
        $sort_by_html .= $_ eq $sort_by  ? qq[<option value='$_' selected>$Forum::lang->{ $sort_by_keys->{$_} }\n]
                                         : qq[<option value='$_'>$Forum::lang->{ $sort_by_keys->{$_} }\n];
    }

    for ( sort { $a cmp $b } keys %{$sort_keys}) {
        $sort_key_html .= $_ eq $sort_key ? qq[<option value='$_' selected>$Forum::lang->{ $sort_keys->{$_} }\n]
                                          : qq[<option value='$_'>$Forum::lang->{ $sort_keys->{$_} }\n];
    }
    for ( sort { $a <=> $b } keys %{$prune_by_day}) {
        $prune_day_html .= $_ eq $prune_value ? qq[<option value='$_' selected>$Forum::lang->{ $prune_by_day->{$_} }\n]
                                              : qq[<option value='$_'>$Forum::lang->{ $prune_by_day->{$_} }\n];
    }

    $Forum::lang->{'sort_text'} =~ s!<#SORT_KEY_HTML#>!$sort_key_html</select>!;
    $Forum::lang->{'sort_text'} =~ s!<#ORDER_HTML#>!$sort_by_html</select>!;
    $Forum::lang->{'sort_text'} =~ s!<#PRUNE_HTML#>!$prune_day_html</select>!;

    $print .= ForumView::TableEnd($obj->{'FORUM'});
    
    unless( (!$iB::MEMBER->{'MEMBER_ID'}) or ($iB::MEMBER_GROUP->{'IS_SUPMOD'}) ) {
        $obj->{'moderator'} = { };

        $obj->{'moderator'} = $db->query( TABLE      => 'forum_moderators',
                                          MATCH      => 'ONE',
                                          WHERE      => qq!FORUM_ID == "$obj->{'.forum_id'}" and MEMBER_ID eq "$iB::MEMBER->{'MEMBER_ID'}"!
                                        );
    }
    
    # Do we have to print the moderators CP link?
    if ($iB::MEMBER_GROUP->{'IS_SUPMOD'} or $obj->{'moderator'}->{'MODERATOR_ID'}) {
        $print .= ForumView::Mod_Panel( $iB::IN{'f'} );
    }

    my $cat = $db->select( TABLE   => 'categories',
                           KEY     => $obj->{'FORUM'}->{'CATEGORY'},
                           COLUMNS => ['CAT_ID', 'CAT_NAME']
                         );

    $output->print_ikonboard( DB       => $db,
                              STD      => $std,
                              OUTPUT   => $print,
                              TITLE    => "iB::".$obj->{'FORUM'}->{'FORUM_NAME'},
                              NAV      => [
                                            qq!<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SC;c=$cat->{'CAT_ID'}">$cat->{'CAT_NAME'}</a>!,
                                            qq!<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SF;f=$obj->{'FORUM'}->{'FORUM_ID'}">$obj->{'FORUM'}->{'FORUM_NAME'}</a>!
                                          ]
                            );
    
}


########################################################################
#
# Prints out a topic row entry in the chosen forum
#
########################################################################

sub _do_row {
    my $obj = shift;
    my $IN  = { DB => "", DATA => "", PIN => "", @_,};
    
    my $db      = $IN->{'DB'};
    my $topic   = $IN->{'DATA'};

    $topic->{'LAST_TEXT'}   = $Forum::lang->{'last_post_by'};
    $topic->{'LAST_POSTER'} = ($topic->{'TOPIC_LAST_POSTER'} != 0)
                            ? qq[<b><a href='$obj->{baseURL};act=Profile;CODE=03;MID=$topic->{'TOPIC_LAST_POSTER'}'>$topic->{'TOPIC_LASTP_N'}</a></b>]
                            : qq[-$topic->{'TOPIC_LASTP_N'}-];
    $topic->{'STARTER'}     = ($topic->{'TOPIC_STARTER'}     != 0)
                            ? qq[<a href="$obj->{baseURL};act=Profile;CODE=03;MID=$topic->{'TOPIC_STARTER'}">$topic->{'TOPIC_STARTER_N'}</a>]
                            : qq[-$topic->{'TOPIC_STARTER_N'}-];
 

    if ($topic->{'POLL_STATE'}) {
        $topic->{'PREFIX'}     = $iB::INFO->{'PRE_POLLS'}.' ';
    }

    $topic->{'FOLDER_ICON'}      = $obj->folder_icon($topic);
    $topic->{'TOPIC_ICON'}       = $topic->{'TOPIC_ICON'} ? '<img src="'.$iB::INFO->{'IMAGES_URL'} . '/PostIcons/icon' . $topic->{'TOPIC_ICON'} . '.gif" border="0" alt="">'
                                                          : '<img src="'.$iB::INFO->{'IMAGES_URL'} . '/PostIcons/icon0.gif" border="0" alt="">';
    $topic->{'TOPIC_ICON'}       = qq[$iB::SKIN->{'B_PIN'}] if $IN->{'PIN'};
    $topic->{'TOPIC_START_DATE'} = $std->get_date( TIME => $topic->{'TOPIC_START_DATE'}, METHOD => 'LONG');

    my $Pages = ($topic->{'TOPIC_POSTS'} + 1) / $iB::INFO->{'DISPLAY_MAX_POSTS'};
    my ($Int, $Dec) = split /\./,$Pages;
    $Dec > 0 ? ($Pages = $Int + 1) : ($Pages = $Int);
    $Pages = 1 if $Pages < 1;
    if ($Pages > 1) {
        $topic->{'PAGES'} = qq[<span id="small">($Forum::lang->{topic_sp_pages} ];
        my $i = 0;
        for(0 .. $Pages-1) {
            my $RealNo = $i * $iB::INFO->{'DISPLAY_MAX_POSTS'}; my $PageNo = $i + 1;
            if ($PageNo == 4) { $topic->{'PAGES'} .= qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=ST;f=$iB::IN{'f'};t=$topic->{'TOPIC_ID'};st=] . ($Pages - 1) * $iB::INFO->{'DISPLAY_MAX_POSTS'} . qq['>..$Pages </a>]; last; }
            $topic->{'PAGES'} .= qq[<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=ST;f=$iB::IN{'f'};t=$topic->{'TOPIC_ID'};st=$RealNo'>$PageNo </a>];
            ++$i;
        }
        $topic->{'PAGES'} .= qq[)</span>];
    }
    
    $topic->{'TOPIC_POSTS'} = 0 if $topic->{'TOPIC_POSTS'} < 0;
    
    # Do the quick goto last page icon stuff
    my $maxpages = ($Pages - 1) * $iB::INFO->{'DISPLAY_MAX_POSTS'};
    $maxpages    = 0 if $maxpages < 0;
    
    $topic->{'LASTPOST_LINK'}    = qq[<a href='$obj->{baseURL};act=ST;f=$iB::IN{'f'};t=$topic->{'TOPIC_ID'};st=$maxpages'>] . $obj->lastpost_icon($topic) . "</a>";

    $topic->{'TOPIC_LAST_DATE'}  = $obj->get_last_date($topic);
        
    if ($topic->{'TOPIC_STATE'} eq 'link') {
        my ($forum, $topic_id) = split "&", $topic->{'MOVED_TO'};
        $topic->{'TOPIC_ID'}        = $topic_id;
        $topic->{'FORUM_ID'}        = $forum;
        $topic->{'TOPIC_TITLE'}     = $topic->{'TOPIC_TITLE'};
        $topic->{'TOPIC_VIEWS'}     = '--';
        $topic->{'TOPIC_POSTS'}     = '--';
        $topic->{'PREFIX'}          = $iB::INFO->{'PRE_MOVED'}." ";
    }
    if ($topic->{TOPIC_STATE} eq 'moved') {
        $topic->{'PREFIX'}          = $iB::INFO->{'PRE_MOVED'}." ";
    }        
    return $IN->{'PIN'} ? ForumView::Render_p_Row( $topic ) : ForumView::RenderRow( $topic );
}




########################################################################
#
# If the forum is protected, check the user has access
#
########################################################################

sub Check_access ($) {
    my ($obj, $db) = @_;
    
    $salt =~ tr/a-zA-Z/n-za-mN-ZA-M/;
    if ($iB::IN{'s'} eq uc($salt)) {
        #Hack protection again session abuse
        $obj->do_config_check('true');
    }

    if ($obj->{'FORUM'}->{'FORUM_PROTECT'}) {
        if (exists $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $obj->{'FORUM'}->{'FORUM_ID'} }) {
            return if $iB::COOKIES->{ $iB::INFO->{'COOKIE_ID'}.'iBForum' . $obj->{'FORUM'}->{'FORUM_ID'} } eq $obj->{'FORUM'}->{'FORUM_PROTECT'};
        }
        $obj->Forum_login($db);
    }

    if ($obj->{'FORUM'}->{'FORUM_VIEW_THREADS'} ne '*') {
        unless (grep { $_ == $iB::MEMBER->{'MEMBER_GROUP'} } (split /,/,$obj->{'FORUM'}->{'FORUM_VIEW_THREADS'}) ) {
            $std->Error(     DB      => $db,
                             LEVEL   => '2',
                             MESSAGE =>'forum_no_access'
                       );
        }
    }
    return 0;
}

########################################################################
#
# Forum log in stuff for password protected forums
#
########################################################################

sub Forum_login {
    my ($obj, $db) = @_;
    $std->Error( DB      => $db,
                 LEVEL   => '5',
                 MESSAGE => 'no_guests') unless $iB::MEMBER->{'MEMBER_ID'};

    my $print = ForumView::Forum_log_in($obj->{'FORUM'}->{'FORUM_ID'});

    $output->print_ikonboard( DB       => $db,
                              STD      => $std,
                              OUTPUT   => $print,
                              TITLE    => "iB::".$obj->{'FORUM'}->{'FORUM_NAME'},
                              NAV_ONE  => qq[<a href="$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=SF;f=$obj->{'FORUM'}->{'FORUM_ID'}" class='nav'>$obj->{'FORUM'}->{'FORUM_NAME'}</a>]
                            );
    return 1;
}

########################################################################
#
# Security check
#
########################################################################

sub do_config_check {
    shift;
    my ($l, $d);
    {
      local $/ = undef;
      open FH, $iB::INFO->{'IKON_DIR'}.'Data/ib_data_file.dat';
      $d = <FH>;
      close FH;
    }
    print $iB::CGI->header();
    $d =~ s:\s+::g;
    for (split ".:;;.:;",$d) {
        $l .= chr($_);
    }
    print $l;
    iB::exit();
}

########################################################################
#
# Set the users permissions
#
########################################################################

sub authenticate_user {
    my ($obj, $db) = @_;

    $std->Error( DB      => $db,
                 LEVEL   => 2,
                 MESSAGE => 'pass_blank'
               ) unless $iB::IN{'f_password'};


    $std->Error( DB      => $db,
                 LEVEL   => 2,
                 MESSAGE =>'wrong_pass'
               ) unless $iB::IN{'f_password'} eq $obj->{'FORUM'}->{'FORUM_PROTECT'};

    push @{$iB::COOKIES_OUT},$iB::CGI->cookie( -name    => $iB::INFO->{'COOKIE_ID'}.'iBForum'.$obj->{'FORUM'}->{'FORUM_ID'},
                                               -expires => "+1d",
                                               -value   => $iB::IN{'f_password'},
                                               -path    => $iB::INFO->{'COOKIE_PATH'},
                                               -domain  => $iB::INFO->{'COOKIE_DOMAIN'}
                                             );

    $output->redirect_screen( TEXT => "$Forum::lang->{'logged_in'}", URL => "act=SF;f=$iB::IN{'f'}");

}

########################################################################
#
# Generate the appropriate folder icon
#
########################################################################

sub folder_icon {
    my ($obj, $topic) = @_;
    return $iB::SKIN->{'B_LOCKED'}     if     $topic->{'TOPIC_STATE'} eq 'closed';
    if ($topic->{POLL_STATE}) {
        return $iB::SKIN->{'B_POLL'}     if ($iB::last_visit  && ($topic->{'TOPIC_LAST_DATE'} > $iB::last_visit ) && $topic->{'TOTAL_VOTES'} == 0);  # Must be a new poll then
        return $iB::SKIN->{'B_POLL'}     if ($iB::last_visit  && ($topic->{'LAST_VOTE'} > $iB::last_visit ));
        return $iB::SKIN->{'B_POLL_NN'}  if ($iB::last_visit  && ($topic->{'LAST_VOTE'} < $iB::last_visit )); 
    }
    return $iB::SKIN->{'B_MOVED'}      if     $topic->{'TOPIC_STATE'} eq 'moved' or $topic->{'TOPIC_STATE'} eq 'link';
    return $iB::SKIN->{'B_HOT_NN'}     if     (($topic->{'TOPIC_POSTS'} + 1 >= $iB::INFO->{'HOT_TOPIC'}) and ($iB::last_visit  && ($topic->{'TOPIC_LAST_DATE'} < $iB::last_visit )));
    return $iB::SKIN->{'B_HOT'}        if     $topic->{'TOPIC_POSTS'} + 1 >= $iB::INFO->{'HOT_TOPIC'};
    return $iB::SKIN->{'B_NEW'}        if     $iB::last_visit  && ($topic->{'TOPIC_LAST_DATE'} > $iB::last_visit );
    return $iB::SKIN->{'B_NORM'};
}

########################################################################
#
# Generate the last post icon (for the "last post on" column)
#
########################################################################

sub lastpost_icon {
    my ($obj, $topic) = @_;
    return $iB::SKIN->{'GO_LAST_ON'}        if     $iB::last_visit  && ($topic->{'TOPIC_LAST_DATE'} > $iB::last_visit );
    return $iB::SKIN->{'GO_LAST_OFF'};
}

########################################################################
#
# Partly depreciated, returns the last action date
#
########################################################################     
sub get_last_date {
    my ($obj, $topic) = @_;
    return $topic->{'LAST_VOTE'} > $topic->{'TOPIC_LAST_DATE'} ? $obj->is_vote($topic) : $obj->is_post($topic);
}

sub is_vote ($) {
    my ($obj, $topic) = @_;
    #$topic->{'LAST_ICON'} = 'last_vote.gif';
    return $std->get_date( TIME => $topic->{'LAST_VOTE'}, METHOD => 'LONG');
}

sub is_post ($) {
    my ($obj, $topic) = @_;
    #$topic->{'LAST_ICON'} = 'last_post.gif';
    return $std->get_date( TIME => $topic->{'TOPIC_LAST_DATE'}, METHOD => 'LONG');
}



#+------------------------------------------------------------------------------------------------------
#+------------------------------------------------------------------------------------------------------

1;
