package Calendar;
use strict;
use Time::Local;

#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# Script author: Nurlan Mukhanov (Infection)
#
# No parts of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com
#
# Please Read the license for more information
#+-----------------------------------------------------------------+
#
# Calendar: Display calendar of user's birthday.
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Sources/iDatabase/SQL.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $output= FUNC::Output->new();
my $INFO  = Boardinfo->new();
my $DB    = iDatabase::SQL->new( DATABASE  => $iB::INFO->{'DB_NAME'},
                                 DB_DIR    => $iB::INFO->{'DB_DIR'},
                                 IP        => $iB::INFO->{'DB_IP'},
                                 PORT      => $iB::INFO->{'DB_PORT'},
                                 USERNAME  => $iB::INFO->{'DB_USER'},
                                 PASSWORD  => $iB::INFO->{'DB_PASS'},
                                 DB_PREFIX => $iB::INFO->{'DB_PREFIX'},
                                 DB_DRIVER => $iB::INFO->{'DB_DRIVER'},
                                );
                                
# Set up some defaults

$iB::SKIN->{'CALENDAR_BLANK'}  ||= qq!#FFFFFF!;
$iB::SKIN->{'CALENDAR_CUR'}    ||= qq!#DEDEDE!;
$iB::SKIN->{'CALENDAR_NON'}    ||= qq!#EFEFEF!;

$Calendar::lang = $std->LoadLanguage('CalendarWords');
$UserCP::lang = $std->LoadLanguage('UserCPWords');

my $html = undef;
my @rd = localtime; #real date! to compare with generation date and hightlight current day

sub new {
    my ($pkg, $db) = @_;
    my $obj = { };

    unless (check_date()){CalendarError();};

    bless $obj, $pkg;
    my $newdata = time + ($iB::INFO->{'TIME_ZONE'} * 3600) + ($iB::MEMBER->{TIME_ADJUST}*3600);

    my @date;
    my @rd = localtime($newdata);

	$iB::IN{'m'}=~s/\D//g;
    $iB::IN{'y'}=~s/\D//g;
    if ($iB::IN{'m'} and $iB::IN{'y'}) {
        @date = localtime(timelocal(0,0,0,1,$iB::IN{'m'}-1,$iB::IN{'y'}));
    } else {
        @date = localtime(timelocal(0,0,0,1,$rd[4],$rd[5]));
    }
	$obj->{date} = \@date;
    $obj->{rd} = \@rd;

	take_months($obj);

	$obj->{skip} = $obj->{date}->[6];
	$obj->{skip}=7 unless($obj->{skip});	
	$obj->{skip}--; 	
	$obj->{cdays} = 1;

    my $Month = $obj->{date}->[4]+1;

    my $birth = $DB->query( TABLE => 'calendar',
                            WHERE => qq[MONTH == '$Month'],
                          );

    my @bd;
    my $year;
    foreach my $w (@{$birth}) {
       if ($bd[$w->{'DAY'}]) {
           $year = $obj->{date}->[5] + 1900 - $w->{'YEAR'};
           $bd[$w->{'DAY'}].= "</font></b><br><span id='highlight'>&gt;</span><a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Profile;CODE=03;MID=$w->{'MEMBER_ID'}'>$w->{'MEMBER_NAME'}</a> (<b>$year</b>)";
       } else {
           $year = $obj->{date}->[5] + 1900 - $w->{'YEAR'};
           $bd[$w->{'DAY'}].= "</font></b><br><span id='highlight'>&gt;</span><a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?act=Profile;CODE=03;MID=$w->{'MEMBER_ID'}'>$w->{'MEMBER_NAME'}</a> (<b>$year</b>)";
       }
    }

    $obj->{bd} = \@bd;

    return $obj;

}


sub take_months{

	my $obj = shift;

	my @months;

	$months[0]  = 31;
	$months[1]  = 28 + leap_year($obj->{date}->[5]);
	$months[2]  = 31;
	$months[3]  = 30;
	$months[4]  = 31;
	$months[5]  = 30;
	$months[6]  = 31;
	$months[7]  = 31;
	$months[8]  = 30;
	$months[9]  = 31;
	$months[10] = 30;
	$months[11] = 31;

	$obj->{months} = \@months;

}

sub next_day {
	my $obj = shift;

	if($obj->{skip}||$obj->{cdays}>$obj->{months}->[$obj->{date}->[4]]) {
		$obj->{skip}--;
		return "&nbsp;";
	}
	my $c = $obj->{cdays}++;
#	return $c;

	return $c unless($obj->{bd}->[$c]);

	return $c.$obj->{bd}->[$c];
}

sub now {

    my ($obj, $db) = @_;

    $html = CalendarView::head();
    my $day;
    my $test;
    my $i = 6;
    while($i){
       $test = $obj->next_day();
       last if($test eq '&nbsp;' and $i<6);
    
       $html .= "        <tr>\n";
       if ($test==0) { 
           $html .= "          <td width='14%' bgcolor='$iB::SKIN->{'CALENDAR_BLANK'}' valign='top'><b><font id='desc'>".$test."<br><br></td>\n";
       } else {
              if ($obj->{rd}->[3] == $test && $obj->{rd}->[4] == $obj->{date}->[4] && $obj->{rd}->[5] == $obj->{date}->[5]) {
                  $html .= "          <td width='14%' bgcolor='$iB::SKIN->{'CALENDAR_CUR'}' valign='top'><b><font id='highlight'>".$test."<br><br></td>\n";
              } else {
                  $html .= "          <td width='14%' bgcolor='$iB::SKIN->{'CALENDAR_NON'}' valign='top'><b><font id='date'>".$test."<br><br></td>\n";
              }
       }

       for (my $j=0;$j<6;$j++) {
           $day = $obj->next_day();
           if ($day==0) {
              $html .= "          <td width='14%' bgcolor='$iB::SKIN->{'CALENDAR_BLANK'}' valign='top'><b><font id='desc'>".$day."<br><br></td>\n";
           } else {
              if ($obj->{rd}->[3] == $day && $obj->{rd}->[4] == $obj->{date}->[4] && $obj->{rd}->[5] == $obj->{date}->[5]) {
                  $html .= "          <td width='14%' bgcolor='$iB::SKIN->{'CALENDAR_CUR'}' valign='top'><b><font id='highlight'>".$day."<br><br></td>\n";
              } else {
                  $html .= "          <td width='14%' bgcolor='$iB::SKIN->{'CALENDAR_NON'}' valign='top'><b><font id='date'>".$day."<br><br></td>\n";
              }
           }
       };

       $html .= "        </tr>\n";
       $i--;
    }

    my $select_m="\n              <option value='0'>--</option>\n";
    for ($i=1;$i<13;$i++) {
        if ($i==$obj->{date}->[4]+1) {
           $select_m.="              <option value=\"$i\" selected>".$UserCP::lang->{"month$i"}."</option>\n";
        } else {
           $select_m.="              <option value=\"$i\">".$UserCP::lang->{"month$i"}."</option>\n";
        };
    }

    my $select_y="\n              <option value='0'>--</option>\n";
    for ($i=2001;$i<2011;$i++) {
        if ($i==$obj->{date}->[5]+1900) {
           $select_y.="              <option value=\"$i\" selected>$i</option>\n";
        } else {
           $select_y.="              <option value=\"$i\">$i</option>\n";
        }
    }

    my $next_m;
    my $next_y;
    my $prev_m;
    my $prev_y;

    if (!$obj->{date}->[4]) {
       $prev_m = 12;
       $prev_y = $obj->{date}->[5]+1899;
    } else {
       $prev_m = $obj->{date}->[4];
       $prev_y = $obj->{date}->[5]+1900;
    };
    
    if ($obj->{date}->[4] == 11) {
       $next_m = 1;
       $next_y = $obj->{date}->[5]+1901;
    } else {
       $next_m = $obj->{date}->[4]+2;
       $next_y = $obj->{date}->[5]+1900;
    }

    $html .= CalendarView::bottom($select_m, $select_y, $next_m, $next_y, $prev_m, $prev_y);

    $output->print_ikonboard( DB      => $db,
                              STD     => $std,
                              OUTPUT  => $html,
                              TITLE      => "iB::".$Calendar::lang->{'page_title'},
                              NAV        => [ "$Calendar::lang->{'page_titles'}" ]
                            );
}


sub Process {
    my ($obj, $db) = @_;
    my $CodeNo = $iB::IN{'CODE'};
    
    
    #+-----------------------------------------------------------------------------------
    require $iB::SKIN->{'DIR'} . '/CalendarView.pm' or die $!;
    #+-----------------------------------------------------------------------------------
    my %Mode = ( '1'        => \&now, );
    
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : CalendarError();

} 

sub CalendarError {


    $std->Error(DB => $DB, LEVEL=>'1',MESSAGE=>'error_date');
}


sub check_date {
  my ($mm,$yy) = ($iB::IN{'m'},$iB::IN{'y'});	
  return 0 if (($mm and $yy) and (($mm>12) or ($yy>2037) or ($yy<1970)));
  return 1;

}


sub leap_year {
	my $god = shift;
	my $t = timelocal(0,59,23,28,1,$god);
	$t+=2*60*60;
	my @t = localtime($t);
	return 1 if($t[3]==29);
	return 0;
}



1;
