package Admin::dbHandler;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

use File::Path;
use File::Copy;

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();



sub new {
    my $pkg = shift;
    my $obj = {  };
    bless $obj, $pkg;
    return $obj;
}


sub splash {
    my ($obj, $db) = @_;


    my $html  = $SKIN->title( TITLE => 'Drop all Database Tables', TEXT => 'This will remove a database installation, populated or empty.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'dbHandler',
                                        CODE  => 'drop'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Drop a Database");


    $html .= $SKIN->td_select( TEXT     => "Which database do you wish to drop?",
                               NAME     => 'DB',
                               REQ      => 1,
                               VALUES   => 'DBM',
                               DATA     => [
                                              { NAME => 'DBM'   , VALUE => 'DBM'    },
                                              { NAME => 'mySQL' , VALUE => 'mySQL'  },
                                              { NAME => 'pgSQL' , VALUE => 'pgSQL'  },
                                             #{ NAME => 'MS-SQL', VALUE => 'MS-SQL' },
                                           ],
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Drop this Database' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'DATABASE', NAV_ONE => "Drop a Database", PRINT => $html);

}


sub drop {
    my ($obj, $db) = @_;

    if ($iB::IN{'DB'} eq $iB::INFO->{DB_DRIVER}) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "You cannot drop the database you are currently using! Well you could, but it'd be beyond stupid.");
    }

    my $html  = $SKIN->title( TITLE => 'Drop all Tables of a Database', TEXT => 'This will remove a database installation, populated or empty.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'dbHandler',
                                        CODE  => 'dodrop',
                                        DB    => $iB::IN{'DB'},
                                      } );

    $html .= $SKIN->section_header( TITLE => "Drop a Database", TEXT => "JUST TO CONFIRM: THIS WILL REMOVE ALL DATA FROM THE DATABASE");


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Drop this Database!' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'DATABASE', NAV_ONE => "Drop a Database", PRINT => $html);

}

sub dodrop {
    my $obj = shift;

    require iDatabase::SQL;
    
    # Get a Database connection
    # Since we don't want to drop
    #and create tables..
    my $create = $iB::INFO->{DB_DRIVER} eq 'DBM' ? 1 : 0;
    my $drop   = $iB::INFO->{DB_DRIVER} eq 'DBM' ? 1 : 0;
    
    my $db    = iDatabase::SQL->new( DATABASE  => $iB::INFO->{$iB::IN{'DB'}.'_DB_NAME'},
                                     DB_DIR    => $iB::INFO->{'DB_DIR'},
                                     IP        => $iB::INFO->{$iB::IN{'DB'}.'_DB_IP'},
                                     PORT      => $iB::INFO->{$iB::IN{'DB'}.'_DB_PORT'},
                                     USERNAME  => $iB::INFO->{$iB::IN{'DB'}.'_DB_USER'},
                                     PASSWORD  => $iB::INFO->{$iB::IN{'DB'}.'_DB_PASS'},
                                     DB_PREFIX => $iB::INFO->{$iB::IN{'DB'}.'_DB_PREFIX'},
                                     DB_DRIVER => $iB::IN{'DB'},
                                     ATTR      => { allow_create => $create,
                                                    allow_drop   => $drop,
                                                  },
                                   );

    my $i = $db->drop_database();

    $ADMIN->static_screen( URL   => "&act=dbHandler",
                           TITLE => "The database table has been emptied ($i tables emptied).",
                         );
}

##########################################################################################
#
# Database set  up stuff, taken from the installer modules.
#
##########################################################################################

sub setup {
    my ($obj, $db) = @_;


    my $html  = $SKIN->title( TITLE => 'Set up a database', TEXT => 'This will set up a new database. PLEASE NOTE: You *MUST* make sure the INSTALL_DATA file is there and contains the up to date installer files' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'dbHandler',
                                        CODE  => 'startsetup'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Set up a Database");


    $html .= $SKIN->td_select( TEXT     => "Which database do you wish to set up?",
                               NAME     => 'DB',
                               REQ      => 1,
                               VALUES   => 'DBM',
                               DATA     => [
                                              { NAME => 'DBM'   , VALUE => 'DBM'    },
                                              { NAME => 'mySQL' , VALUE => 'mySQL'  },
                                              { NAME => 'pgSQL' , VALUE => 'pgSQL'  },
                                             #{ NAME => 'MS-SQL', VALUE => 'MS-SQL' },
                                           ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Do you want Ikonboard to create the tables for you?",
                               NAME     => 'CREATE',
                               REQ      => 1,
                               VALUES   => '1',
                               DATA     => [
                                              { NAME => 'Yes'                                       , VALUE => '1'    },
                                              { NAME => 'No - The tables have already been created' , VALUE => '0'    },
                                           ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Do you want Ikonboard to re-install the default database files for you?",
                               NAME     => 'INSTALL',
                               REQ      => 1,
                               VALUES   => '1',
                               DATA     => [
                                              { NAME => 'Yes - the tables are empty'                  , VALUE => '1'    },
                                              { NAME => 'No - I will be re-installing from a back up' , VALUE => '0'    },
                                           ],
                             );

    $html .= $SKIN->section_header( TITLE => "Needed information for SQL databases", TEXT => "You may leave this if you are setting up a DBM installation");


    $iB::INFO->{'DB_IP'}     ||= 'localhost';
    $iB::INFO->{'DB_PREFIX'} ||= 'ib_';

    # DB User name
    $html .= $SKIN->td_input (   TEXT => 'SQL Username', NAME => 'DB_USER', VALUE=> $iB::INFO->{'DB_USER'});
    # DB Password
    $html .= $SKIN->td_input (   TEXT => 'SQL Password', NAME => 'DB_PASS', VALUE=> "", TYPE => 'password');
    # DB Database name
    $html .= $SKIN->td_input (   TEXT => 'SQL Database name', NAME => 'DB_NAME', VALUE=> $iB::INFO->{'DB_NAME'});
    # DB Database Server
    $html .= $SKIN->td_input (   TEXT => 'SQL Database Server IP', NAME => 'DB_IP', VALUE=> $iB::INFO->{'DB_IP'});
    # DB Database Port
    $html .= $SKIN->td_input (   TEXT => 'SQL Database Server Port', NAME => 'DB_PORT', VALUE=> $iB::INFO->{'DB_PORT'});
    # DB Table Prefix
    $html .= $SKIN->td_input (   TEXT => 'SQL Table Prefix(so you can have multiple IBs in one DB', NAME => 'DB_PREFIX', VALUE=> $iB::INFO->{'DB_PREFIX'});

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Set up this Database' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'DATABASE', NAV_ONE => "Set up a Database", PRINT => $html);

}


sub startsetup {
    my $obj = shift;  #Just get the $obj, not the $db

    ## Check to make sure we have all the info we need.
    
    if ($iB::IN{'DB'} ne 'DBM') {
        $ADMIN->Error( STD=>$std, MSG=>"You need to enter an SQL Username")  unless $iB::IN{'DB_USER'};
        $ADMIN->Error( STD=>$std, MSG=>"You need to enter an SQL Password")  unless $iB::IN{'DB_PASS'};
        $ADMIN->Error( STD=>$std, MSG=>"You need to enter an SQL Database")  unless $iB::IN{'DB_NAME'};
        $ADMIN->Error( STD=>$std, MSG=>"You need to enter an SQL Server IP") unless $iB::IN{'DB_IP'};
    }

    # Get our iDatabase admin driver

    require "iDatabase/Admin/a_$iB::IN{'DB'}.pm";

    my $aDB = iDatabase::Admin::SQL->new();

    # Set up the database..

    $aDB->install_database( schema_dir => $iB::INFO->{'IKON_DIR'}."INSTALL_DATA",
                            return_err => 1,
                            create_tbl => $iB::IN{CREATE},
                            attr       => { DB_NAME   => $iB::IN{'DB_NAME'},
                                            DB_IP     => $iB::IN{'DB_IP'},
                                            DB_PORT   => $iB::IN{'DB_PORT'},
                                            DB_USER   => $iB::IN{'DB_USER'},
                                            DB_PASS   => $iB::IN{'DB_PASS'},
                                            DB_PREFIX => $iB::IN{'DB_PREFIX'},
                                            DB_DRIVER => $iB::IN{'DB'},
                                          },
                          );

    # Check for errors..
    if (scalar @{ $aDB->{errors} } > 0 ) {
        goto 'ERRORS';
    }

    # NO errors? Good, lets write the new boardinfo file..

    my $OLD = Boardinfo->new();
    for my $homer (qw/DB_NAME DB_IP DB_PORT DB_USER DB_PASS DB_PREFIX/) {
        $OLD->{ $iB::IN{'DB'}."_".$homer } = $iB::IN{ $homer };
    }

    $OLD->{$iB::IN{'DB'}."_setup"} = 1;

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    if ($iB::IN{'INSTALL'}) {

        require 'Sources/iDatabase/SQL.pm' or iB::install_error( "Cannot locate the needed iDatabase driver to require" );
    
        my $db    = iDatabase::SQL->new( DATABASE  => $iB::IN{'DB_NAME'},
                                         DB_DIR    => $iB::INFO->{'DB_DIR'},
                                         IP        => $iB::IN{'DB_IP'},
                                         PORT      => $iB::IN{'DB_PORT'},
                                         USERNAME  => $iB::IN{'DB_USER'},
                                         PASSWORD  => $iB::IN{'DB_PASS'},
                                         DB_PREFIX => $iB::IN{'DB_PREFIX'},
                                         DB_DRIVER => $iB::IN{'DB'},
                                         ATTR      => { allow_create => 0,
                                                        allow_drop   => 0,
                                                      },
                                       ); 
    
        my @errors;
        my $limit;
    
        # Database: MemberGroups
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/mem_groups.dat") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/mem_groups.dat" and goto 'ERRORS' );
        my @groups = <FILE>;
        close FILE;
    
        for my $f (@groups) {
            chomp ($f);
            next unless $f;
            my @entry = split (/\|\^\|/, $f);
            next unless defined $entry[0];
            $db->insert( TABLE   => 'mem_groups',
                         VALUES  => {   VIEW_BOARD          =>  1,
                                        MEM_INFO            =>  $entry[1],
                                        OTHER_TOPICS        =>  $entry[2],
                                        USE_SEARCH          =>  $entry[3],
                                        EMAIL_FRIEND        =>  $entry[4],
                                        INVITE_FRIEND       =>  $entry[5],
                                        EDIT_PROFILE        =>  $entry[6],
                                        POST_NEW_TOPICS     =>  $entry[7],
                                        REPLY_OWN_TOPICS    =>  $entry[8],
                                        REPLY_OTHER_TOPICS  =>  $entry[9],
                                        EDIT_OWN_POSTS      =>  $entry[10],
                                        DELETE_OWN_POSTS    =>  $entry[11],
                                        OPEN_CLOSE_TOPICS   =>  $entry[12],
                                        DELETE_OWN_TOPICS   =>  $entry[13],
                                        POST_POLLS          =>  $entry[14],
                                        VOTE_POLLS          =>  $entry[15],
                                        USE_PM              =>  $entry[16],
                                        IS_SUPMOD           =>  $entry[17],
                                        ACCESS_CP           =>  $entry[18],
                                        TITLE               =>  $entry[19],
                                        CAN_REMOVE          =>  0,
                                        READ_AD_LOGS        =>  $entry[21],
                                        DELETE_AD_LOGS      =>  $entry[22],
                                        EDIT_GROUPS         =>  $entry[23],
                                        APPEND_EDIT         =>  $entry[24],
                                        ACCESS_OFFLINE      =>  $entry[25],
                                        AVOID_Q             =>  $entry[26],
                                        AVOID_FLOOD         =>  $entry[27],           
                                  },
                        );
            
        }
    
    
    
        # Database: Email Templates
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/email_template.dat") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/email_template.dat" and goto 'ERRORS' );
        my @templates = <FILE>;
        close FILE;
    
        for my $t (@templates) {
            chomp ($t);
            next unless $t;
            my @entry = split (/\|\^\|/, $t);
            next unless defined $entry[0];
            $db->insert( TABLE   => 'email_templates',
                         VALUES  => {   ID       =>  $entry[0],
                                        TYPE     =>  $entry[1],
                                        TEMPLATE =>  $entry[2],
                                  },
                        );
            push @errors, $db->{'error'} if $db->{'error'};
        }
    
    
    
        # Database: (ikon)Board Rules
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/board_rules.dat") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/board_rules.dat" and goto 'ERRORS' );
        my @templates = <FILE>;
        close FILE;
    
        for my $t (@templates) {
            next unless $t;
            chomp ($t);
            my @entry = split (/\|\^\|/, $t);
            next unless defined $entry[0];
            $db->insert( TABLE   => 'forum_rules',
                         VALUES  => {   ID           =>  $entry[0],
                                        RULES_TITLE  =>  $entry[1],
                                        RULES_TEXT   =>  $entry[2],
                                        LAST_UPDATE  =>  time,
                                  },
                        );
            push @errors, $db->{'error'} if $db->{'error'};
        }
    
        # Database: Board Rules
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/news.html") or(push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/news_html" and goto 'ERRORS' );
        my @news = <FILE>;
        close FILE;
    
        my $text = join '', @news;
    

    
        $db->insert( TABLE  => 'ssi_templates',
                     VALUES => { ID              => 'news',
                                 EXPORT_FILENAME => "newsdata.txt",
                                 TEMPLATE        => $text
                               }
                   );
    
    
        push @errors, $db->{'error'} if $db->{'error'};
    
    
        # Database: SSI Templates
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/ssi_templates.dat") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/ssI_templates.dat" and goto 'ERRORS' );
        my @templates = <FILE>;
        close FILE;
    
    
        for my $t (@templates) {
            chomp ($t);
            next unless $t;
            my @entry = split (/\|\^\|/, $t);
            next unless defined $entry[0];
            $db->insert( TABLE  => 'ssi_templates',
                         VALUES => { ID              =>  $entry[0],
                                     EXPORT_FILENAME =>  $entry[1],
                                     TEMPLATE        =>  $entry[2]
                                   }
                   );
            push @errors, $db->{'error'} if $db->{'error'};
        }
    
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/global_template.html") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/global_template.dat" and goto 'ERRORS' );
        my @news = <FILE>;
        close FILE;
    
        my $text = join '', @news;
    
    
        $db->insert( TABLE  => 'templates',
                     VALUES => { ID              => 'global',
                                 TEMPLATE        => $text
                               }
                   );
    
        push @errors, $db->{'error'} if $db->{'error'};
        
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/register.html") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/register.html" and goto 'ERRORS' );
        my @news = <FILE>;
        close FILE;
    
        my $text = join '', @news;
    
    
        $db->insert( TABLE  => 'templates',
                     VALUES => { ID              => 'register',
                                 TEMPLATE        => $text
                               }
                   );
    
        push @errors, $db->{'error'} if $db->{'error'};
    
    
        open (FILE, "$iB::INFO->{'IKON_DIR'}INSTALL_DATA/help.txt") or (push @{ $aDB->{errors} }, "Cannot open /INSTALL_DATA/help.txt" and goto 'ERRORS' );
        my @help = <FILE>;
        close FILE;
    
        my $help = {};
        my $flag = 0;
        my $cur  = undef;
    
        for my $i (@help) {
            next unless $i;
            if ($i =~ /^\[(.+?)\]$/) {
                $help->{$1} = "";
                $flag = 1;
                $cur  = $1;
                next;
            } else {
                $help->{$cur} .= $i;
            }
        }
    
    
        for my $k (keys %{$help}) {
            $help->{$k} =~ s!\n!<br>!g;
            $db->insert( TABLE  => 'help',
                         VALUES => { TITLE  => $k,
                                     TEXT   => $help->{$k}
                                   }
                       );
        }
    
    } # End install

ERRORS:

    my $html  = $SKIN->title( TITLE => 'Set up a database result' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->section_header( TITLE => "Set up a Database Results");


    if ( scalar @{ $aDB->{errors} } > 0 ) {

        $html .= qq~<tr><td class='t'><b>The following errors were found...</b><br><ul>~;
    
        for (@{ $aDB->{errors} }) {
            $html .= qq~<li>$_\n~;
        }

        $html .= qq~</ul></td></tr>~;
    }
    else {
        $html .= qq~<tr><td class='t'><b>Set up complete</b></td></tr>~;
    }

    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'DATABASE', NAV_ONE => "Set up a Database", PRINT => $html);
}


##########################################################################################
#
# Switch Database drivers. Assumes that you have them already set up
#
##########################################################################################

sub switch {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Switch Database Drivers', TEXT => 'You must have already set up the Database type you wish to switch to' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'dbHandler',
                                        CODE  => 'doswitch'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Switch Database Driver. You are currently using: $iB::INFO->{'DB_DRIVER'}");


    $html .= $SKIN->td_select( TEXT     => "Which database do you wish switch to?<br>(If you are going to import into the database you about to make active, IMPORT FIRST THEN SWITCH DATABASES!)",
                               NAME     => 'DRIVER',
                               REQ      => 1,
                               VALUES   => 'DBM',
                               DATA     => [
                                              { NAME => 'DBM'   , VALUE => 'DBM'    },
                                              { NAME => 'mySQL' , VALUE => 'mySQL'  },
                                              { NAME => 'pgSQL' , VALUE => 'pgSQL'  },
                                             #{ NAME => 'MS-SQL', VALUE => 'MS-SQL' },
                                           ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Do you want add this admin member account to the new database?",
                               NAME     => 'ADMIN',
                               REQ      => 1,
                               VALUES   => '1',
                               DATA     => [
                                              { NAME => 'Yes'                                       , VALUE => '1'    },
                                              { NAME => 'No - I already have one I wish to use'     , VALUE => '0'    },
                                           ],
                             );

    $html .= qq~<tr><td bgcolor='#FFFFFF' colspan='2' class='t'><b>PLEASE NOTE:</b> If you DO NOT choose to add your admin account to the new database
                and you DONT have an admin account in the new database, you WILL NOT be able to get back into the Admin Center again!.<br><br>
                If you choose to add this admin account to the new database, it will also add this admin member group. If a member group already
                exists with this member group ID, it'll create a new one and assign that ID to the copied admin account. You can then chose to 
                remove it after you've assigned a new member group to yourself.<br><br>
                In either case, as soon as you switch database drivers, you may have to re-log in again.<br><br><b>VERY IMPORTANT</b>: After switching
                database drivers, the first thing to do is to edit the "Default Member Groups" - this is vitally important as the ID's stored may no
                longer match those in the database. The last thing you want is new members getting assigned to an Administrators group, etc!~;


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Switch Database Drivers' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'DATABASE', NAV_ONE => "Switch DB drivers", PRINT => $html);

}


sub doswitch {
    my ($obj, $db) = @_;

    if ($iB::IN{'DRIVER'} eq $iB::INFO->{DB_DRIVER}) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "Let me get this straight. You want to switch to the same database you are using. Riiiiight, like that makes perfect sense doesn't it? Oh, yes - I am just a computer - I must do as my master says. Pffft, dude, you suck - sorry, gotta face the facts.");
    }

    my ($admin, $group, $session);

    # Get the current session details.
    $session = $db->select(  TABLE  => "active_sessions",
                             KEY    => $iB::SESSION,
                          );

    if ($iB::IN{ADMIN}) {
        $admin = $db->select( TABLE  => "member_profiles",
                              KEY    => $iB::MEMBER->{'MEMBER_ID'},
                            );

        $group = $db->select( TABLE => "mem_groups",
                              KEY   => $iB::MEMBER->{'MEMBER_GROUP'},
                            );
    }

    # Sort out the boardinfo file.

    my $OLD = Boardinfo->new();

    unless($OLD->{$iB::IN{'DRIVER'}."_setup"} == 1) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "$iB::IN{'DRIVER'} database not set up, please do this first.");
    }

    # Lets make sure the current DB is assigned to the heady status of being set up

    $OLD->{$iB::INFO->{'DB_DRIVER'}."_setup"} = 1;

    my $current = { DB_DRIVER => $iB::INFO->{'DB_DRIVER'},
                    DATABASE  => $iB::INFO->{'DB_NAME'},
                    IP        => $iB::INFO->{'DB_IP'},
                    PORT      => $iB::INFO->{'DB_PORT'},
                    USERNAME  => $iB::INFO->{'DB_USER'},
                    PASSWORD  => $iB::INFO->{'DB_PASS'},
                    DB_PREFIX => $iB::INFO->{'DB_PREFIX'},
                  };
    my $new     = { DB_DRIVER => $iB::IN{'DRIVER'},
                    DATABASE  => $iB::INFO->{$iB::IN{'DRIVER'}.'_DB_NAME'},
                    IP        => $iB::INFO->{$iB::IN{'DRIVER'}.'_DB_IP'},
                    PORT      => $iB::INFO->{$iB::IN{'DRIVER'}.'_DB_PORT'},
                    USERNAME  => $iB::INFO->{$iB::IN{'DRIVER'}.'_DB_USER'},
                    PASSWORD  => $iB::INFO->{$iB::IN{'DRIVER'}.'_DB_PASS'},
                    DB_PREFIX => $iB::INFO->{$iB::IN{'DRIVER'}.'_DB_PREFIX'},
                  };

    # Get a new DB connection, and insert the data we have..

    my $dbi   = iDatabase::SQL->new( DATABASE  => $new->{'DATABASE'},
                                     DB_DIR    => $iB::INFO->{'DB_DIR'},
                                     IP        => $new->{'IP'},
                                     PORT      => $new->{'PORT'},
                                     USERNAME  => $new->{'USERNAME'},
                                     PASSWORD  => $new->{'PASSWORD'},
                                     DB_PREFIX => $new->{'DB_PREFIX'},
                                     DB_DRIVER => $new->{'DB_DRIVER'},
                                     ATTR      => { allow_create => 0,
                                                    allow_drop   => 0,
                                                  },
                                   );

    #$dbi->insert( TABLE  => 'active_sessions',
    #              VALUES => $session,
    #            );

    # Add the admin?

    if ($iB::IN{'ADMIN'}) {
        # Do we have an existing membergroup with the same ID?
        #my $new_g = $dbi->select( TABLE => "mem_groups",
        #                          KEY   => $admin->{MEMBER_GROUP}
        #                        );
        #
        # insert the new id 
        #delete($group->{ID});
        #my $new_id = $dbi->insert( TABLE  => "mem_groups",
        #                           VALUES => $group,
        #                         );
        
        $admin->{'MEMBER_GROUP'} = $iB::INFO->{SUPAD_GROUP};

        $dbi->insert( TABLE  => "member_profiles",
                      VALUES => $admin,
                    );
    }

    # Fix up the boardinfo file..

    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_DRIVER"} = $current->{DB_DRIVER};
    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_NAME"}   = $current->{DATABASE};
    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_IP"}     = $current->{IP};
    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_PORT"}   = $current->{PORT};
    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_USER"}   = $current->{USERNAME};
    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_PASS"}   = $current->{PASSWORD};
    $OLD->{$iB::INFO->{'DB_DRIVER'}."_DB_PREFIX"} = $current->{DB_PREFIX};

    # Change the current DB driver..

    $OLD->{DB_DRIVER} = $new->{DB_DRIVER};
    $OLD->{DB_NAME}   = $new->{DATABASE};
    $OLD->{DB_IP}     = $new->{IP};
    $OLD->{DB_PORT}   = $new->{PORT};
    $OLD->{DB_USER}   = $new->{USERNAME};
    $OLD->{DB_PASS}   = $new->{PASSWORD};
    $OLD->{DB_PREFIX} = $new->{DB_PREFIX};

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $ADMIN->static_screen( URL   => "",
                           TITLE => "Database Driver Changed!",
                           TEXT  => "The changes were successful"
                         );



}



sub process {
    my ($obj, $db) = @_;

    # Only allow super admins access...

    unless ($iB::MEMBER->{'MEMBER_GROUP'} == $iB::INFO->{'SUPAD_GROUP'}) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "Sorry, only the board owners have access to this part");
    }

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'setup'        => \&setup,
                 'dodrop'       => \&dodrop,
                 'drop'         => \&drop,
                 'startsetup'   => \&startsetup,
                 'switch'       => \&switch,
                 'doswitch'     => \&doswitch,
               );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 







1;
