package Admin::Templates;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Template Control');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'template',
                                        CODE  => 'choose'
                                      } );

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Please Choose Which Templates to edit" );

    $html .= $SKIN->td_select( TEXT     => 'Editable Templates',
                               NAME     => 'TYPE',
                               SIZE     => 4,
                               VALUES   => 'GLOBAL',
                               DATA     => [
                                             #{ VALUE => 'GLOBAL'   , NAME => 'Global Board Template'  },
                                             { VALUE => 'SSI'      , NAME => 'Server Side Includes (SSI)' },
                                             { VALUE => 'EMAIL_TXT', NAME => 'Email Templates (TEXT)' },
                                           ]
                             );


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Edit this Template' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Template Control', PRINT => $html);

}

##########################################################################################
#
# Method Jumpers
#
##########################################################################################



sub choose {
    my ($obj, $db) = @_;

    $obj->do_ssi($db) if $iB::IN{'TYPE'} eq 'SSI';
    
    $iB::IN{'TYPE'} eq 'GLOBAL' ? $obj->do_global($db)
                                : (
                                    $iB::IN{'TYPE'} eq 'EMAIL_TXT'
                                    ? $obj->txt_email($db)
                                    : $obj->htm_email($db)
                                  );
}


sub doedit {
    my ($obj, $db) = @_;

    $obj->ssi_save($db) if $iB::IN{'TYPE'} eq 'SSI';
    
    $iB::IN{'TYPE'} eq 'GLOBAL' ? $obj->save_global($db)
                                : (
                                    $iB::IN{'TYPE'} eq 'EMAIL_TXT'
                                    ? $obj->txt_save($db)
                                    : $obj->htm_save($db)
                                  );
}


##########################################################################################
#
# Email (TEXT) Templates
#
##########################################################################################

sub txt_email {
    my ($obj, $db) = @_;

    my $temps = {};

    my $templates = $db->query( TABLE    => 'email_templates',
                                WHERE    => "TYPE eq 't'",
                              );

    for my $t (@{$templates}) {
        $temps->{ $t->{'ID'} } = $t->{'TEMPLATE'};
    }



    my $html  = $SKIN->title( TITLE => 'Email Template Control', TEXT => 'Editing Text Email Templates');

    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( { act   => 'template',
                                     CODE  => 'doedit',
                                     TYPE  => 'EMAIL_TXT',
                                   } );

    $html .= $SKIN->section_header( TITLE => "Email Templates",
                                    TEXT => "Please do not remove, or edit the &lt;# TAG #&gt; tags. You may rearrange, or move them
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;The following tags are always available:
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<#BOARD_ADDRESS#> converts to your boards URL (http://www.domain.com/ikonboard/ikonboard.cgi)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<#WEB_ADDRESS#> converts to your websites URL (http://www.domain.com/)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<#BOARD_NAME#> converts to your board name (\"My Website Forums\")
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<#SIGNATURE#> converts to the signature you defined in Email Options"
                                    );

    $html .= $SKIN->td_textarea( TEXT  => "Invite a Friend Template",
                                 NAME  => 'INVITE_FRIEND',
                                 VALUE => $temps->{'INVITE_FRIEND'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Lost Password: Step 1",
                                 NAME  => 'LOST_PASS_ONE',
                                 VALUE => $temps->{'LOST_PASS_ONE'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Lost Password: Step 2",
                                 NAME  => 'LOST_PASS_TWO',
                                 VALUE => $temps->{'LOST_PASS_TWO'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Member to member emailing<br>&nbsp;&nbsp;&nbsp;&nbsp;(when 'use email form' is switched on)",
                                 NAME  => 'MEM_TO_MEM',
                                 VALUE => $temps->{'MEM_TO_MEM'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Registration Validation",
                                 NAME  => 'REG',
                                 VALUE => $temps->{'REG'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "New Reply Notification",
                                 NAME  => 'SUBS',
                                 VALUE => $temps->{'SUBS'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Email Address Change Request",
                                 NAME  => 'E_CH',
                                 VALUE => $temps->{'E_CH'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Administrators New User Notification",
                                 NAME  => 'USER_NOTIFY',
                                 VALUE => $temps->{'USER_NOTIFY'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_textarea( TEXT  => "Send topic page to a friend",
                                 NAME  => 'SEND_FRIEND',
                                 VALUE => $temps->{'SEND_FRIEND'},
                                 ROWS  => 20
                                );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply the edit to these templates' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Editing Email (TEXT) Templates', PRINT => $html);

}

sub txt_save {
    my ($obj, $db) = @_;
    
    my $templates = $db->query( TABLE => 'email_templates' );
    
    my $email = {};

    for my $k (@{$templates}) {
               
        $email->{ $k->{'ID'} } = $k->{'TEMPLATE'};
    }

    for (qw[INVITE_FRIEND LOST_PASS_ONE LOST_PASS_TWO MEM_TO_MEM REG SUBS E_CH USER_NOTIFY SEND_FRIEND]) {

        #XXX Get the raw input, to ensure that it's not been regexed to death.

        unless ( $iB::CGI->param($_) ) {
            $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must fill in all the templates");
        }

    }


    for (qw[INVITE_FRIEND LOST_PASS_ONE LOST_PASS_TWO MEM_TO_MEM REG SUBS E_CH USER_NOTIFY SEND_FRIEND]) {
    
        if (exists $email->{$_}) {

             $db->update( TABLE  => 'email_templates',
                          KEY    => $_,
                          VALUES => { 
                                      TYPE     => 't',
                                      TEMPLATE => $iB::CGI->param($_)
                                    }
                        );
        } else {
            # Create and insert..
            $db->insert( TABLE  => 'email_templates',
                         VALUES => { ID       =>  $_,
                                     TYPE     => 't',
                                     TEMPLATE => $iB::CGI->param($_),
                                   }
                       );
        }
    }

    #XXX Print log and finish off

    $ADMIN->write_log( TITLE => 'Text Email Templates Edited');

    $ADMIN->static_screen( URL   => "act=template",
                           TITLE => "Email  (TEXT) Templates Edited",
                           TEXT  => "The changes were successful"
                         );
}


    
##########################################################################################
#
# SSI templates
#
##########################################################################################

sub do_ssi {
    my ($obj, $db) = @_;


    my $templates = $db->query( TABLE    => 'ssi_templates' );

    my $ssi  = {};
    my $file = {};
    for my $k (@{$templates}) {
               
        $ssi->{  $k->{'ID'} } = $k->{'TEMPLATE'};
        $file->{ $k->{'ID'} } = $k->{'EXPORT_FILENAME'};
    }


    my $html  = $SKIN->title( TITLE => 'SSI Template Control', TEXT => 'Editing SSI Templates');

    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( { act   => 'template',
                                     CODE  => 'doedit',
                                     TYPE  => 'SSI',
                                   } );

    $html .= $SKIN->section_header( TITLE => "SSI Templates" );

    $html .= $SKIN->section_header( TITLE => "Online User Count",
                                    TEXT  => "Available Tags (You do not need to use all of them)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%number of guests%>  = Number of online guests in numerical format
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%number of members%> = Number of online members in numerical format
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%total online%> = Total number of online users"

                                    );

    $html .= $SKIN->td_textarea( TEXT  => "",
                                 NAME  => 'ONLINE_COUNT',
                                 VALUE => $ssi->{'ONLINE_COUNT'},
                                 ROWS  => 20,
                                 NO_PARSE => 1
                                );
    $html .= $SKIN->td_input ( TEXT => 'Export as:', NAME => 'ONLINE_COUNT_F', VALUE=> $file->{'ONLINE_COUNT'}, REQ => 1 );


    $html .= $SKIN->section_header( TITLE => "User name format in online user list",
                                    TEXT  => "Available Tags (You do not need to use all of them)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%member name%>    = Name of the member
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%url to profile%> = URL to the members profile"
                                    );

    $html .= $SKIN->td_textarea( TEXT  => "",
                                 NAME  => 'ONLINE_FORMAT',
                                 VALUE => $ssi->{'ONLINE_FORMAT'},
                                 ROWS  => 20,
                                 NO_PARSE => 1
                                );

    $html .= $SKIN->td_input ( TEXT => 'Export as:', NAME => 'ONLINE_FORMAT_F', VALUE=> $file->{'ONLINE_FORMAT'}, REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Online user list",
                                    TEXT  => "Available Tags (You do not need to use all of them)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%list members%>    = Creates a list of all online members in the format specified above"
                                    );

    $html .= $SKIN->td_textarea( TEXT  => "",
                                 NAME  => 'ONLINE_LIST',
                                 VALUE => $ssi->{'ONLINE_LIST'},
                                 ROWS  => 20,
                                 NO_PARSE => 1
                                );

    $html .= $SKIN->td_input ( TEXT => 'Export as:', NAME => 'ONLINE_LIST_F', VALUE=> $file->{'ONLINE_LIST'}, REQ => 1 );


    $html .= $SKIN->section_header( TITLE => "Post/Topic Totals",
                                    TEXT  => "Available Tags (You do not need to use all of them)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%total topics%>     = Total Number of topics
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%total replies%>    = Total Number of topic replies
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%total posts%>      = Total Number of posts (topics + replies)"
                                    );

    $html .= $SKIN->td_textarea( TEXT  => "",
                                 NAME  => 'POST_TOTALS',
                                 VALUE => $ssi->{'POST_TOTALS'},
                                 ROWS  => 20,
                                 NO_PARSE => 1
                                );

    $html .= $SKIN->td_input ( TEXT => 'Export as:', NAME => 'POST_TOTALS_F', VALUE=> $file->{'POST_TOTALS'}, REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Last Topic posted",
                                    TEXT  => "Available Tags (You do not need to use all of them)
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%url to topic%>     = URL to the topic
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%topic title%>      = Topic Name
                                             <br>&nbsp;&nbsp;&nbsp;&nbsp;<%topic poster%>     = Name of the topic poster"
                                    );

    $html .= $SKIN->td_textarea( TEXT  => "",
                                 NAME  => 'LAST_POSTED',
                                 VALUE => $ssi->{'LAST_POSTED'},
                                 ROWS  => 20,
                                 NO_PARSE => 1
                                );

    $html .= $SKIN->td_input ( TEXT => 'Export as:', NAME => 'LAST_POSTED_F', VALUE=> $file->{'LAST_POSTED'}, REQ => 1 );





    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply the edit to these templates' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Editing SSI Templates', PRINT => $html);

}


sub ssi_save {
    my ($obj, $db) = @_;

    my $templates = $db->query( TABLE    => 'ssi_templates' );

    my $ssi = {};

    for my $k (@{$templates}) {
               
        $ssi->{ $k->{'ID'} } = $k->{'TEMPLATE'};
    }


    for (qw[ONLINE_COUNT ONLINE_FORMAT ONLINE_LIST POST_TOTALS LAST_POSTED]) {

        if (exists $ssi->{$_}) {

            $db->update( TABLE  => 'ssi_templates',
                         KEY    => $_,
                         VALUES => { EXPORT_FILENAME => $iB::IN{$_.'_F'},
                                     TEMPLATE        => $iB::CGI->param($_)
                                   }
                       );
        } else {

            $db->insert( TABLE  => 'ssi_templates',
                         VALUES => { ID              => $_,
                                     EXPORT_FILENAME => $iB::IN{$_.'_F'},
                                     TEMPLATE        => $iB::CGI->param($_)
                                   }
                       );
        }
    }

    #XXX Print log and finish off

    $ADMIN->write_log( TITLE => 'SSI Templates Edited');

    $ADMIN->static_screen( URL   => "act=template",
                           TITLE => "SSI Templates Edited",
                           TEXT  => "The changes were successful"
                         );
}



##########################################################################################
#
# Global Templates
#
##########################################################################################



sub do_global {
    my ($obj, $db) = @_;

    my $template = $db->select( TABLE => 'templates',
                                KEY   => 'global',
                              );

    my $it = $template->{'TEMPLATE'};

    #XXX We use the ASCII values, so people can use &gt;, &lt; without it being converted when read back

    $it =~ s!<!&#60;!g;
    $it =~ s!>!&#62;!g;

    my $html  = $SKIN->title( TITLE => 'Template Control');

    $html .= qq~<script language='Javascript1.2'>
                <!--
                function Preview() {
                    Template = new String(document.TheForm.TEMPLATE.value);
                    Template.replace(/&#60;/g, "<");
                    Template.replace(/&#62;/g, ">");
                    Template.replace(/<% TITLE %>/g, "Ikonboard 3 Preview");
                    Template.replace(/<% IKONBOARD %>/g, "<table height='300' align='center' border='1'><tr><td align='center' valign='middle'>Ikonboard will be displayed here</td></tr></table>");
                    var newWin = window.open( '', 'PREVIEW', 'width=500,height=500,top=0,left=0,resizable=1,scrollbars=1,location=no,directories=no,status=no,menubar=no,toolbar=no');
                    newWin.document.write(Template);
                }
                //-->
                </script>
               ~;




    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( { act   => 'template',
                                     CODE  => 'doedit',
                                     TYPE  => 'GLOBAL',
                                   } );

    $html .= $SKIN->section_header( TITLE => "Global Template", TEXT => "Please do not remove, or edit the &lt;% TAG %&gt; tags. You may rearrange, or move them" );

    $html .= $SKIN->td_textarea( TEXT  => "Template",
                                 NAME  => 'TEMPLATE',
                                 VALUE => $it,
                                 SPAN  => 1,
                                 ROWS  => 30
                                );

    $html .= qq~<tr>
                <td colspan='2' bgcolor='#FFFFFF' align='center'><input type='button' value='PREVIEW' onClick='javascript:Preview();'></td>
                </tr>
                ~;

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Edit this Template' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Editing Global Template', PRINT => $html);

}

sub save_global {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "I can't save an empty template!") unless length($iB::IN{'TEMPLATE'}) > 1;

    #XXX Grab the raw TEMPLATE param, so we know it's not been regexed to death by CleanValue

    my $template = $iB::CGI->param('TEMPLATE');
    
    #XXX Gimmie back my HTML

    $template =~ s!&#62;!>!g;
    $template =~ s!&#60;!<!g;

    #XXX No doubt someone will remove the <% IKONBOARD %> tag...
    #XXX Then post on the support board that their board has gone 'missing'.

    unless ($template =~ m#<% IKONBOARD %>#) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "You need the &lt;% IKONBOARD %&gt; tag!");
    }
    unless ($template =~ m#<% COPYRIGHT %>#) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "You need the &lt;% COPYRIGHT %&gt; tag!");
    }

    #XXX Here goes nothing...

    $db->update( TABLE  => 'templates',
                 KEY    => 'global',
                 VALUES => { TEMPLATE => $template }
               );

    #XXX Print log and finish off

    $ADMIN->write_log( TITLE => 'Global Template Edited');

    $ADMIN->static_screen( URL   => "act=template",
                           TITLE => "Global Template Edited",
                           TEXT  => "The changes were successful"
                         );
}


sub news {
    my ($obj, $db) = @_;

    my $a_forums = $db->query( TABLE     => 'forum_info',
                               SORT_KEY  => 'FORUM_POSITION',
                               SORT_BY   => 'A-Z',
                               MATCH     => 'ALL'
                             ) || die $db->{'error'};

    my $news     = $db->select(TABLE     => 'ssi_templates',
                               KEY       => 'news',
                              );

    $iB::INFO->{'NEWS_TOPICS'} ||= 10;

    my @forums;
    for my $f (@{ $a_forums } ) {
        push @forums, { NAME => "&gt;--".$f->{'FORUM_NAME'}, VALUE => $f->{'FORUM_ID'} };
    }
    

    my $html  = $SKIN->title( TITLE => "News Manager", TEXT => "The news manager can be applied to any forum, when applied, the first post in each topic is exported into a text file ready for SSI or PHP inclusion. We recommend that you do not allow public posting in the news forum");

    $html .= qq~<script language='Javascript'>
                function Preview() {
                    var Template = document.TheForm.TEMPLATE.value;
                    var newWin = window.open( '', 'PREVIEW', 'width=500,height=500,top=0,left=0,resizable=1,scrollbars=1,location=no,directories=no,status=no,menubar=no,toolbar=no');
                    newWin.document.write(Template);
                }
                </script>
               ~;

    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act   => 'template',
                                        CODE  => 'donews'
                                      } );

    $html .= $SKIN->td_select( TEXT     => 'Which Forum do you wish to export posts from?',
                               NAME     => 'NEWS_FORUM',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'NEWS_FORUM'},
                               DATA     => \@forums,
                             );

    $html .= $SKIN->td_input ( TEXT => 'Export as:', NAME => 'EXPORT_FILENAME', VALUE=> $news->{'EXPORT_FILENAME'}, REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Export how many forum topics<br>For the news page?', NAME => 'NEWS_TOPICS', VALUE=> $iB::INFO->{'NEWS_TOPICS'}, REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Limit News post length? (in characters)<br>Leave blank to export the complete news post', NAME => 'NEWS_LIMIT', VALUE=> $iB::INFO->{'NEWS_LIMIT'}, REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "News Entry Template",
                                    TEXT  => "You may edit the HTML and rearrange the tags."
                                    );

    #XXX We use the ASCII values, so people can use &gt;, &lt; without it being converted when read back

    $news->{'TEMPLATE'} =~ s!<!&#60;!g;
    $news->{'TEMPLATE'} =~ s!>!&#62;!g;

    $html .= $SKIN->td_textarea( TEXT  => "",
                                 NAME  => 'TEMPLATE',
                                 VALUE => $news->{'TEMPLATE'},
                                 ROWS  => 30,
                                 NO_PARSE => 1,
                                 SPAN     => 1
                                );

    $html .= qq~<tr>
                <td colspan='2' bgcolor='#FFFFFF' align='center'><input type='button' value='PREVIEW' onClick='javascript:Preview();'></td>
                </tr>
                ~;

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Edits' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'News Manager', PRINT => $html);

}


sub do_news {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "I can't save an empty template!") unless length($iB::IN{'TEMPLATE'}) > 1;

    my $template = $iB::CGI->param('TEMPLATE');
    
    #XXX Gimmie back my HTML

    $template =~ s!&#62;!>!g;
    $template =~ s!&#60;!<!g;

    my $OLD = Boardinfo->new();

    $OLD->{'NEWS_FORUM'}  = $iB::IN{'NEWS_FORUM'};
    $OLD->{'NEWS_TOPICS'} = $iB::IN{'NEWS_TOPICS'};
    $OLD->{'NEWS_LIMIT'}  = $iB::IN{'NEWS_LIMIT'};

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $db->update( TABLE  => 'ssi_templates',
                 KEY    => 'news',
                 VALUES => { TEMPLATE        => $template,
                             EXPORT_FILENAME => $iB::IN{'EXPORT_FILENAME'}
                           }
               );

    $ADMIN->write_log( TITLE => 'News settings updated');

    my $path = $iB::INFO->{'HTML_DIR'}."ssi/$iB::IN{'EXPORT_FILENAME'}";

    $ADMIN->static_screen( URL   => "act=template&CODE=news",
                           TITLE => "News Settings Updated",
                           TEXT  => "The text file can be used after an update to the news forum.<br>The path to use is: $path"
                         );

}


sub update {
    my ($obj, $db) = @_;


    my $html  = $SKIN->title( TITLE => "News Manager [Force Update]",
									   TEXT => "Clicking the button below will recreate the exported file from the news forum. Please
									   ensure that you have the News Manager set up before you use this feature. The news file will update automagically when a new
									   topic is started or edited in the news forum");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act   => 'template',
                                        CODE  => 'do_update'
                                      } );
    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Force an Update' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'News Manager', PRINT => $html);
}

sub do_update {
    my ($obj, $db) = @_;

    require SSI::Parser;

    SSI::Parser::parse( DB       => $db,
                        TEMPLATE => 'news',
                      );

    $ADMIN->static_screen( URL   => "act=template&CODE=news",
                           TITLE => "The news data file has been recreated",
                           TEXT  => ""
                         );
}



##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'choose'        => \&choose,
                 'doedit'        => \&doedit,
                 'news'          => \&news,
                 'donews'        => \&do_news,
                 'update'        => \&update,
                 'do_update'     => \&do_update,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
