package Admin::Tempfiles;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;

    opendir (DIR, $INFO->{'DB_DIR'}.'Temp');
    my @list = grep { !/\A\.{1,2}\Z/ } readdir(DIR);
    closedir(DIR);

    my $cnt = scalar @list;
    $cnt ||= 0;

    my $html  = $SKIN->title( TITLE => 'Temporary File Control', TEXT => "There are $cnt temporary files" );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'temps',
                                        CODE  => 'del'
                                      } );

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Please Choose Which Files to remove" );

    $html .= $SKIN->td_select( TEXT     => 'Redundant Table Locks',
                               NAME     => 'R_TL',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );


    $html .= $SKIN->td_select( TEXT     => 'Active Table Locks',
                               NAME     => 'A_TL',
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Redundant Administration Sessions',
                               NAME     => 'R_AS',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Active Administration Sessions',
                               NAME     => 'A_AS',
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Redundant Log in attempts',
                               NAME     => 'R_LA',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Active Log in attempts',
                               NAME     => 'A_LA',
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Remove the files' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MAINTAIN', NAV_ONE => 'Administration Logging Control', PRINT => $html);

}

sub delete {
    my ($obj, $db) = @_;

    my (@lock,  $r_lock_cnt, $a_lock_cnt,
        @logs,  $r_log_cnt,  $a_log_cnt,
        @admin, $r_ad_cnt,   $a_ad_cnt
       );

    opendir (DIR, $INFO->{'DB_DIR'}.'Temp');
    my @list = grep { !/\A\.{1,2}\Z/ } readdir(DIR);
    closedir(DIR);

    @lock  = grep {      /.+?(\.lck)\Z/     } @list;
    @logs  = grep {  /\Alog\-(.+?)\.cgi\Z/  } @list;
    @admin = grep { /\Aadmin\-(.+?)\.cgi\Z/ } @list;

    #XXX Lock Files

    for my $f (@lock) {

        if ( ($iB::IN{'A_TL'}) and (-M $INFO->{'DB_DIR'}."Temp/$f" > (time - (60 * 15)) ) ) {
            unlink ($INFO->{'DB_DIR'}."Temp/$f");
            ++$a_lock_cnt;
        }
        if ( ($iB::IN{'R_TL'}) and (-M $INFO->{'DB_DIR'}."Temp/$f" < (time - (60 * 15)) ) ) {
            unlink ($INFO->{'DB_DIR'}."Temp/$f");
            ++$r_lock_cnt;
        }

    }

    for my $f (@logs) {

        if ( ($iB::IN{'A_LA'}) and (-M $INFO->{'DB_DIR'}."Temp/$f" > (time - (60 * 15)) ) ) {
            unlink ($INFO->{'DB_DIR'}."Temp/$f");
            ++$a_log_cnt;
        }
        if ( ($iB::IN{'R_LA'}) and (-M $INFO->{'DB_DIR'}."Temp/$f" < (time - (60 * 15)) ) ) {
            unlink ($INFO->{'DB_DIR'}."Temp/$f");
            ++$r_log_cnt;
        }

    }

    for my $f (@admin) {

        if ( ($iB::IN{'A_AS'}) and (-M $INFO->{'DB_DIR'}."Temp/$f" > (time - (60 * 15)) ) ) {
            next if $f =~ /$ENV{'REMOTE_ADDR'}/;
            unlink ($INFO->{'DB_DIR'}."Temp/$f");
            ++$a_ad_cnt;
        }
        if ( ($iB::IN{'R_AS'}) and (-M $INFO->{'DB_DIR'}."Temp/$f" < (time - (60 * 120)) ) ) {
            unlink ($INFO->{'DB_DIR'}."Temp/$f");
            ++$r_ad_cnt;
        }

    }

    $a_lock_cnt ||= 0;
    $r_lock_cnt ||= 0;
    $a_log_cnt  ||= 0;
    $r_log_cnt  ||= 0;
    $a_ad_cnt   ||= 0;
    $r_ad_cnt   ||= 0;

    $ADMIN->static_screen( URL   => "act=temps",
                           TITLE => "Temporary Files Deleted",
                           TEXT  => "The changes were successful<br>
                                     <br>&nbsp;&nbsp;&nbsp;&nbsp;$a_lock_cnt Active Table Lock Files Deleted
                                     <br>&nbsp;&nbsp;&nbsp;&nbsp;$r_lock_cnt Redundant Table Lock Files Deleted
                                     <br>&nbsp;&nbsp;&nbsp;&nbsp;$a_log_cnt Active Log Attempt Files Deleted
                                     <br>&nbsp;&nbsp;&nbsp;&nbsp;$r_log_cnt Redundant Log Attempt Files Deleted
                                     <br>&nbsp;&nbsp;&nbsp;&nbsp;$a_ad_cnt Active Admin session Files Deleted
                                     <br>&nbsp;&nbsp;&nbsp;&nbsp;$r_ad_cnt Redundant Admin session Files Deleted"
                         );
}




sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'del'        => \&delete,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 





1;
