package Admin::Stats;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;


    my $html  = $SKIN->title( TITLE => 'Rebuild Board Statistics');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'stats',
                                        CODE  => 'edit'
                                      } );

    my $do = $INFO->{'B_ONLINE'} ? 0 : 1;

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Rebuilding Statistics", TEXT => "Only do this after a forum recount, it will recount the total members as well as the post/reply counters" );


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Rebuild the stats' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MAINTAIN', NAV_ONE => 'Rebuild Board Stats', PRINT => $html);

}


sub edit {
    my ($obj, $db) = @_;

    my ($post_count, $topic_count);
    my  $last = { DATE => 0, ID => '', NAME => '' };

    my $forums = $db->query( TABLE   => 'forum_info',
                             COLUMNS => ['FORUM_ID', 'FORUM_TOPICS', 'FORUM_POSTS', 'FORUM_LAST_POST', 'FORUM_LAST_POSTER', 'FORUM_LAST_POSTER_N'],
                           );

    # Get stats
    my $stats = $std->ib_stats;

    # Force complete update
    $stats->{RESET} = 1;

    my $members = $db->count( TABLE => 'member_profiles' );


    for my $f (@{$forums}) {
        $post_count  += $f->{'FORUM_POSTS'};
        $topic_count += $f->{'FORUM_TOPICS'};
        if ($f->{'FORUM_LAST_POST'} > $last->{'DATE'}) {
            $last->{'DATE'} = $f->{'FORUM_LAST_POST'};
            $last->{'ID'}   = $f->{'FORUM_LAST_POSTER'};
            $last->{'NAME'} = $f->{'FORUM_LAST_POSTER_N'};
        }
    }

    # Add new
    $stats->{'TOTAL_MEMBERS'}       = $members;
    $stats->{'TOTAL_TOPICS'}        = $topic_count;
    $stats->{'TOTAL_REPLIES'}       = $post_count;

    # Get last registered member...

    my $sts = $db->query( TABLE  => 'member_profiles',
                          COLUMNS => ['MEMBER_ID','MEMBER_NAME'],
                          RANGE  => "0 to 0",
                          SORT_KEY => 'MEMBER_JOINED',
                          SORT_BY => 'Z-A'
    );

    $stats->{'LAST_REG_MEMBER_N'} = $sts->[0]->{'MEMBER_NAME'};
    $stats->{'LAST_REG_MEMBER_ID'} = $sts->[0]->{'MEMBER_ID'};

    # Rebuild
    $std->ib_stats($stats);
                          
    $ADMIN->write_log( TITLE => 'Statistics Rebuilt');

    $ADMIN->static_screen( URL   => "act=stats",
                           TITLE => "Board Statistics Rebuilt",
                           TEXT  => "The database has been updated"
                         );
}

            


##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'        => \&edit,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
