package Admin::SkinHandler;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

use File::Path;
use File::Copy;
use Archive::Tar;

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();



sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}



sub splash {
    my ($obj, $db) = @_;

    $obj->display( CODE   => 'do_new',
                   SUBMIT => 'Create new Skin Pack',
                   TEXT   => 'Create a new Skin Pack',
                   DB     => $db,
                   A_TXT  => "Base the new pack on which current pack?"
                 );
}

sub export {
    my ($obj, $db) = @_;

    $obj->display( CODE   => 'do_export',
                   SUBMIT => 'Export a Skin Pack',
                   TEXT   => 'Export a Skin Pack',
                   DB     => $db,
                   A_TXT  => "Export which pack?"
                 );
}



sub import {
    my ($obj, $db) = @_;

    # Get a list of avilable .tar files
    # Rule 1: They must end in .tar
    # Rule 2: They must start with SKIN-

    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'INCOMING') or die  "Cannot Open the Directory!";
    my @tar_files =  grep  {   !/^\./ && /^SKIN-(?:[\w\d\-]+)\.tar$/   } readdir DIR;
    closedir DIR;

    my @list_of_tar_files;

    for (@tar_files) {
        push @list_of_tar_files, { NAME => $_, VALUE => $_ };
    }

    my $html  = $SKIN->title( TITLE => 'Skin Control', TEXT => "Import a skin package. The package must be uploaded into the 'INCOMING' directory." );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'skin',
                                        CODE  => 'do_import'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Choose a .tar file to install");

    $html .= $SKIN->td_select( TEXT     => "Valid archives ready for installation",
                               NAME     => 'INSTALL_NAME',
                               REQ      => 1,
                               VALUES   => '',
                               DATA     => \@list_of_tar_files
                             );

    $html .= $SKIN->td_input ( TEXT => 'Viewable Skin Name<br>&nbsp;&nbsp;&nbsp;&nbsp;(Example "Classic Skin")', NAME => 'PACK_NAME', VALUE=> '', REQ => 1);


    $html .= $SKIN->td_submit(   NAME => '', VALUE => "Import this skin file" );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => "Skin Control", PRINT => $html);
}


sub display {
    my $obj = shift;

    my %IN = ( CODE    => "",
               SUBMIT  => "",
               TEXT    => "",
               DB      => "",
               A_TXT   => "",
               B_TXT   => "",
               @_,
              );

    my $db = $IN{'DB'};


    my @sorted_skin_files;

    for my $l ( split( /\|\&\|/, $iB::INFO->{'SKINS'} ) ) {
        my ($id, $dir, $name) = split /:/, $l;
        push @sorted_skin_files, { NAME => $name, VALUE => $dir };
    }

    my $html  = $SKIN->title( TITLE => 'Skin Control', TEXT => $IN{'TEXT'} );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'skin',
                                        CODE  => $IN{'CODE'}
                                      } );

    $html .= $SKIN->section_header( TITLE => $IN{'A_TXT'}, TEXT => $IN{'B_TXT'});

    $html .= $SKIN->td_select( TEXT     => "Current Installed Skins",
                               NAME     => 'SKIN',
                               REQ      => 1,
                               VALUES   => '',
                               DATA     => \@sorted_skin_files
                             );

    if ($IN{'CODE'} eq 'do_new') {

        $html .= $SKIN->section_header( TITLE => "New Pack Specifics");

        $html .= $SKIN->td_input ( TEXT => 'Viewable Skin Name<br>&nbsp;&nbsp;&nbsp;&nbsp;(Example "Classic")', NAME => 'PACK_NAME', VALUE=> '', REQ => 1);
        $html .= $SKIN->td_input ( TEXT => 'Authors Name',          NAME => 'AUTHOR_NAME',  VALUE=> '', REQ => 1);
        $html .= $SKIN->td_input ( TEXT => 'Authors Email Address', NAME => 'AUTHOR_EMAIL', VALUE=> '', REQ => 1);


    }

    if ($IN{'CODE'} eq 'do_export') {

        $html .= $SKIN->section_header( TITLE => "Export Specifics");

        $html .= $SKIN->td_input ( TEXT => 'Export Filename (no spaces or non alphanumerics)<br>&nbsp;&nbsp;&nbsp;&nbsp;Example: "classic"', NAME => 'PACK_NAME', VALUE=> '', REQ => 1);

    }
    

    $html .= $SKIN->td_submit(   NAME => '', VALUE => $IN{'SUBMIT'} );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => "Skin Control", PRINT => $html);

}

sub remove {
    my ($obj, $db) = @_;

    my @sorted_skin_files;

    for my $l ( split( /\|\&\|/, $iB::INFO->{'SKINS'} ) ) {
        my ($id, $dir, $name) = split /:/, $l;
        push @sorted_skin_files, { NAME => $name, VALUE => $dir };
    }

    my $html  = $SKIN->title( TITLE => 'Skin Package Removal', TEXT => "Use this carefully, this WILL remove the skin selected" );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'skin',
                                        CODE  => 'do_remove',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Choose Carefully, there is NO confirmation screen!");

    $html .= $SKIN->td_select( TEXT     => "Remove which skin?",
                               NAME     => 'SKIN',
                               REQ      => 1,
                               VALUES   => '',
                               DATA     => \@sorted_skin_files
                             );

    
    $html .= $SKIN->td_submit(   NAME => '', VALUE => "REMOVE THIS SKIN" );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => "Skin Control", PRINT => $html);

}

sub do_remove {
    my ($obj, $db) = @_;

    unless (-e $iB::INFO->{'IKON_DIR'}.'Skin/'.$iB::IN{'SKIN'}) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "I cannot find that skin pack!");        
    }

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You cannot remove the default ikonboard skin. I need this as a fail safe so when you remove a skin that a user is currently using, it will load the standard skin") if $iB::IN{'SKIN'} eq 'Default';


    my ($string, @skins);

    # Remove the skin name from the Boardinfo file.
    for my $l ( split( /\|\&\|/, $iB::INFO->{'SKINS'} ) ) {
        my ($id, $dir, $name) = split /:/, $l;
        next if $dir eq $iB::IN{'SKIN'};
        $string .= '|&|'.$id.':'.$dir.':'.$name;
    }

    $string =~ s!\|\&\|$!!;
    $string =~ s!^\|\&\|!!;

    # Remove the perl modules..
    rmtree $iB::INFO->{'IKON_DIR'}.'Skin/'.$iB::IN{'SKIN'};
    # Remove the images/HTML stuff
    rmtree $iB::INFO->{'HTML_DIR'}.'Skin/'.$iB::IN{'SKIN'};

    my $OLD = Boardinfo->new();

    $OLD->{'SKINS'} = $string;

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );
   

    $ADMIN->static_screen( URL   => "act=skin&CODE=remove",
                           TITLE => "The skin package and all of it's files have been removed."
                                    
                         );
}

sub do_new {
    my ($obj, $db) = @_;

    unless (-e $iB::INFO->{'IKON_DIR'}.'Skin/'.$iB::IN{'SKIN'}) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "I cannot find that skin pack!");
    }

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter an email address") unless $iB::IN{'AUTHOR_EMAIL'};
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter an authors name")  unless $iB::IN{'AUTHOR_NAME'};
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a viewable package name")  unless $iB::IN{'PACK_NAME'};

    # Count up the current language files.
    my $cnt = 0;
    for my $l ( split( /\|\&\|/, $iB::INFO->{'SKINS'} ) ) {
        ++$cnt;
    }
    ++$cnt;
    
    my $new_directory = 'SKIN-'.$cnt;

    # Create the new CGI Directory
    mkdir ($iB::INFO->{'IKON_DIR'}.'Skin/'.$new_directory, 0777);

    # Create the new HTML Directory
    mkdir ($iB::INFO->{'HTML_DIR'}.'Skin/'.$new_directory, 0777);
   

    #############################################################
    # Get the CGI files
    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'Skin/'.$iB::IN{'SKIN'}) or die  "Cannot Open the Directory!";
    my @cgi_files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Copy the CGI files across
    for my $c_f (@cgi_files) {
        copy($iB::INFO->{'IKON_DIR'}."Skin/$iB::IN{'SKIN'}/$c_f"  ,
             $iB::INFO->{'IKON_DIR'}."Skin/$new_directory/$c_f"   );
        chmod (0777,$iB::INFO->{'IKON_DIR'}."Skin/$new_directory/$c_f");
    }
    #############################################################
    # Get the HTML files
    opendir (DIR, $iB::INFO->{'HTML_DIR'}.'Skin/'.$iB::IN{'SKIN'}) or die  "Cannot Open the Directory!";
    my @html_files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Copy the HTML files across
    for my $h_f (@html_files) {
        # is it a directory?
        if (-d $iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f") {
            # Create the new directory...
            mkdir ($iB::INFO->{'HTML_DIR'}."Skin/$new_directory/$h_f", 0777);
            # Grab the old directory contents..
            opendir (SUBDIR, $iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f") or die  "Cannot Open the Directory!";
            my @sub_files =  grep  {   !/^\./   } readdir SUBDIR;
            closedir SUBDIR;
            # Copy the files across...
            for my $ss (@sub_files) {
               copy($iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f/$ss"  ,
                    $iB::INFO->{'HTML_DIR'}."Skin/$new_directory/$h_f/$ss"   );
               chmod (0777,$iB::INFO->{'HTML_DIR'}."Skin/$new_directory/$h_f/$ss");
            }
        } else {
           copy($iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f"  ,
                $iB::INFO->{'HTML_DIR'}."Skin/$new_directory/$h_f"   );
           chmod (0777,$iB::INFO->{'HTML_DIR'}."Skin/$new_directory/$h_f");
        }
    }



    #############################################################
    # We now need to open the Styles data file and swop the old skin name
    # for the new skin name..

    open SKINFILE, $iB::INFO->{'IKON_DIR'}.'Skin/'.$new_directory.'/Styles.pm';
    flock (SKINFILE, 2) if $iB::INFO->{'FLOCK'};
    my @skin_data = <SKINFILE>;
    close SKINFILE;

    for my $sk (@skin_data) {
        $sk =~ s!\$iB::INFO->{'IMAGES_URL'}/Skin/$iB::IN{'SKIN'}/!\$iB::INFO->{'IMAGES_URL'}/Skin/$new_directory/!g;
    }

    # Save it back..

    open SKINFILE, ">".$iB::INFO->{'IKON_DIR'}.'Skin/'.$new_directory.'/Styles.pm';
    flock (SKINFILE, 2) if $iB::INFO->{'FLOCK'};
    for (@skin_data) {
        print SKINFILE $_;
    }
    close SKINFILE;


    #############################################################
    # Create the config file

    open CONF, ">".$iB::INFO->{'IKON_DIR'}."Skin/$new_directory/config.cfg";
    print CONF "AUTHOR=$iB::IN{'AUTHOR_NAME'}\nEMAIL=$iB::IN{'AUTHOR_EMAIL'}\nPACK_NAME=$iB::IN{'PACK_NAME'}\nCREATED=".time;
    close CONF;

    #Update the Boardinfo file

    my $OLD = Boardinfo->new();

    $OLD->{'SKINS'} .= '|&|'.$cnt.':'.$new_directory.':'.$iB::IN{'PACK_NAME'};

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );
   
    $ADMIN->write_log( TITLE => 'Skin Pack Created');

    $ADMIN->static_screen( URL   => "act=skin",
                           TITLE => "The changes were successful.<br><br>You may now edit your new package by using the 'Edit Skin Properties' feature"
                                    
                         );
}




sub do_export {
    my ($obj, $db) = @_;

    # Check for Language files
    unless (-e $iB::INFO->{'IKON_DIR'}.'Skin/'.$iB::IN{'SKIN'}) {
        $ADMIN->Error( DB => $db, STD => $std, MSG => "I cannot find that language pack!");
    }

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a export package name")  unless $iB::IN{'PACK_NAME'};

    # Remove non unix characters (alpha numerics)
    $iB::IN{'PACK_NAME'} =~ s!^(?:\W+)$!!g;
    # Swop whitespace into underscores
    $iB::IN{'PACK_NAME'} =~ y! !_!;

    my $new_directory = 'SKIN-'.$iB::IN{'PACK_NAME'};

    # Create the new Directory
    mkdir ($iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory, 0777);

    # Create the sub CGI directory
    mkdir ($iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory.'/modules', 0777);
    # Create the sub HTML directory
    mkdir ($iB::INFO->{'IKON_DIR'}."OUTGOING/$new_directory/html", 0777);
   

    # Get the CGI files
    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'Skin/'.$iB::IN{'SKIN'}) or die  "Cannot Open the Directory!";
    my @files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Copy the files across to the CGI temp dir
    for my $f (@files) {
        copy($iB::INFO->{'IKON_DIR'}."Skin/$iB::IN{'SKIN'}/$f"  ,
             $iB::INFO->{'IKON_DIR'}."OUTGOING/$new_directory/modules/$f"   );
    }


    #############################################################
    # Get the HTML files
    opendir (DIR, $iB::INFO->{'HTML_DIR'}.'Skin/'.$iB::IN{'SKIN'}) or die  "Cannot Open the Directory!";
    my @html_files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Copy the HTML files across
    for my $h_f (@html_files) {
        # is it a directory?
        if (-d $iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f") {
            # Create the new directory...
            mkdir ($iB::INFO->{'IKON_DIR'}."OUTGOING/$new_directory/html/$h_f", 0777);
            # Grab the old directory contents..
            opendir (SUBDIR, $iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f") or die  "Cannot Open the Directory!";
            my @sub_files =  grep  {   !/^\./   } readdir SUBDIR;
            closedir SUBDIR;
            # Copy the files across...
            for my $ss (@sub_files) {
               copy($iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f/$ss"  ,
                    $iB::INFO->{'IKON_DIR'}."OUTGOING/$new_directory/html/$h_f/$ss"   );
            }
        } else {
           copy($iB::INFO->{'HTML_DIR'}."Skin/$iB::IN{'SKIN'}/$h_f"  ,
                $iB::INFO->{'IKON_DIR'}."OUTGOING/$new_directory/html/$h_f"   );
        }
    }
    #############################################################

    # Get the new files and locations of the CGI stuff...
    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory.'/modules') or die  "Cannot Open the Directory!";
    my @new_files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Iterate over the file list and add on the full path
    my @files_to_archive;
    for (@new_files) {
        push @files_to_archive, "$new_directory/modules/$_";
    }

    # Get the new files and locations of the HTML stuff...
    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory.'/html') or die  "Cannot Open the Directory!";
    my @html_files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    for (@html_files) {
        if (-d $iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory.'/html/'.$_) {
            opendir (SUBDIR, $iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory.'/html/'.$_) or die  "Cannot Open the Directory!";
            my @sub_files =  grep  {   !/^\./   } readdir SUBDIR;
            closedir SUBDIR;
            for my $i (@sub_files) {
                push @files_to_archive, "$new_directory/html/$_/$i";
            }
        } else {
            push @files_to_archive, "$new_directory/html/$_";
        }
    }
    
    # Create the Tar file.

    {

        my $cwd  = $iB::INFO->{'IKON_DIR'};
        chdir $INFO->{'IKON_DIR'}."OUTGOING";
        my $tar  = Archive::Tar->new();
        $tar->add_files(@files_to_archive) or ($obj->{'ERROR'} = $Archive::Tar::error and chdir $cwd and return);
        $tar->write("$new_directory.tar")  or ($obj->{'ERROR'} = $Archive::Tar::error and chdir $cwd and return);
        chdir $cwd;

    }

    # Remove the non archived files

    rmtree $iB::INFO->{'IKON_DIR'}.'OUTGOING/'.$new_directory;

   
    $ADMIN->write_log( TITLE => 'Skin Pack Ready for export');

    $ADMIN->static_screen( URL   => "act=skin&CODE=new",
                           TITLE => "The changes were successful.<br><br>You may now download your new package by clicking on this link:
                                    <a href='$iB::INFO->{'BOARD_URL'}/OUTGOING/$new_directory.tar'>Download the Skin Pack</a>",
                         );
}


sub do_import {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a export package name")  unless $iB::IN{'PACK_NAME'};
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a export package name")  unless $iB::IN{'INSTALL_NAME'};


    # Remove .tar from the name to get the dir name
    my $new_directory =  $iB::IN{'INSTALL_NAME'};
    $new_directory    =~ s!\.tar$!!g;


    # Create the new Directory
    mkdir ($iB::INFO->{'IKON_DIR'}.'INCOMING/'.$new_directory, 0777);
    chmod (0777, $iB::INFO->{'IKON_DIR'}.'INCOMING/'.$new_directory);

    # Extract the .tar file

    {

        my $cwd = $iB::INFO->{'IKON_DIR'};
        my $tar = Archive::Tar->new();

        unless ($tar->read($iB::INFO->{'IKON_DIR'}."INCOMING/$iB::IN{'INSTALL_NAME'}", 0)) {
    	        die "+>ERROR: Cannot read the .tar file (Is it there and uploaded in Binary?)\n";
        }

        chdir $iB::INFO->{'IKON_DIR'}."INCOMING";
        my @files = $tar->list_files();

        for (@files) {
            if ($_ !~ /^(?:[\.\w\d\+\-\_\/\\]+)$/) {
                die "+>ERROR: Tar file is corrupted, please re-upload\n";
                
            }
        }

        $tar->extract(@files, $iB::INFO->{'IKON_DIR'}."INCOMING");
        chdir $cwd;

    }

    # Count up the current language files.
    my $cnt = 0;
    for my $l ( split( /\|\&\|/, $iB::INFO->{'SKINS'} ) ) {
        ++$cnt;
    }
    ++$cnt;
    
    my $new_skin = 'SKIN-'.$cnt;

    # Create the new CGI directory
    mkdir ($iB::INFO->{'IKON_DIR'}.'Skin/'.$new_skin, 0777);
    chmod (0777, $iB::INFO->{'IKON_DIR'}.'Skin/'.$new_skin);
    # Create the new HTML directory
    mkdir ($iB::INFO->{'HTML_DIR'}.'Skin/'.$new_skin, 0777);
    chmod (0777, $iB::INFO->{'HTML_DIR'}.'Skin/'.$new_skin);

    # Get the CGI files
    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'INCOMING/'.$new_directory.'/modules') or die  "Cannot Open the Directory (modules)!";
    my @files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Copy the files across to the language dir.
    for my $f (@files) {
        copy($iB::INFO->{'IKON_DIR'}."INCOMING/$new_directory/modules/$f"  ,
             $iB::INFO->{'IKON_DIR'}."Skin/$new_skin/$f"      );
        chmod (0777,$iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$f");
    }


    # Get the HTML files

    opendir (DIR, $iB::INFO->{'IKON_DIR'}.'INCOMING/'.$new_directory.'/html') or die  "Cannot Open the Directory (html)!";
    my @html_files =  grep  {   !/^\./   } readdir DIR;
    closedir DIR;

    # Copy the HTML files across
    for my $h_f (@html_files) {
        # is it a directory?
        if (-d $iB::INFO->{'IKON_DIR'}."INCOMING/$new_directory/html/$h_f") {
            # Create the new directory...
            mkdir ($iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$h_f", 0777);
            chmod (0777, $iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$h_f");
            # Grab the old directory contents..
            opendir (SUBDIR, $iB::INFO->{'IKON_DIR'}."INCOMING/$new_directory/html/$h_f") or die  "Cannot Open the Directory!";
            my @sub_files =  grep  {   !/^\./   } readdir SUBDIR;
            closedir SUBDIR;
            # Copy the files across...
            for my $ss (@sub_files) {
               copy($iB::INFO->{'IKON_DIR'}."INCOMING/$new_directory/html/$h_f/$ss"  ,
                    $iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$h_f/$ss"   );
               chmod (0777,$iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$h_f/$ss");
            }
        } else {
           copy($iB::INFO->{'IKON_DIR'}."INCOMING/$new_directory/html/$h_f"  ,
                $iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$h_f"   );
           chmod (0777,$iB::INFO->{'HTML_DIR'}."Skin/$new_skin/$h_f");
        }
    }

    #############################################################
    # We now need to open the Styles data file and swop the old skin name
    # for the new skin name..

    open SKINFILE, $iB::INFO->{'IKON_DIR'}.'Skin/'.$new_skin.'/Styles.pm';
    flock (SKINFILE, 2) if $iB::INFO->{'FLOCK'};
    my @skin_data = <SKINFILE>;
    close SKINFILE;

    for my $sk (@skin_data) {
        $sk =~ s!\$iB::INFO->{'IMAGES_URL'}/Skin/.+?/!\$iB::INFO->{'IMAGES_URL'}/Skin/$new_skin/!g;
    }

    # Save it back..

    open SKINFILE, ">".$iB::INFO->{'IKON_DIR'}.'Skin/'.$new_skin.'/Styles.pm';
    flock (SKINFILE, 2) if $iB::INFO->{'FLOCK'};
    for (@skin_data) {
        print SKINFILE $_;
    }
    close SKINFILE;


    # Remove the non archived files

    rmtree $iB::INFO->{'IKON_DIR'}.'INCOMING/'.$new_directory;

    #Update the Boardinfo file

    my $OLD = Boardinfo->new();

    $OLD->{'SKINS'} .= '|&|'.$cnt.':'.$new_skin.':'.$iB::IN{'PACK_NAME'};

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

   
    $ADMIN->write_log( TITLE => 'Skin Pack Imported');

    $ADMIN->static_screen( URL   => "act=skin&CODE=import",
                           TITLE => "The Skin pack has been imported successfully",
                         );
}


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 
                 'new'         => \&new_splash,
                 'do_new'      => \&do_new,
                 'export'      => \&export,
                 'do_export'   => \&do_export,
                 'import'      => \&import,
                 'do_import'   => \&do_import,
                 'remove'      => \&remove,
                 'do_remove'   => \&do_remove,
               );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 



sub do_tar {
    my ($obj, $file_path) = @_;
    my $cwd  = $iB::INFO->{'IKON_DIR'};

    chdir $INFO->{'IKON_DIR'}.'OUTGOING';

    my $tar      = Archive::Tar->new();
    my @filelist = $obj->Find_Files($file_path);

    $tar->add_files(@filelist)    or ($obj->{'ERROR'} = $Archive::Tar::error and chdir $cwd and return);
    $tar->write("$file_path.tar") or ($obj->{'ERROR'} = $Archive::Tar::error and chdir $cwd and return);
    chdir $cwd;
    return 1;
}

sub Find_Files {
    my ($obj, $file_path) = @_;

    my @filelist;

    opendir (DIR, "$INFO->{'IKON_DIR'}".'Languages/'.$file_path);
    my @list = readdir(DIR);
    closedir(DIR);

    foreach my $file (@list) {
        next if ($file =~ /^\.\.?$/);
        if (-d "$INFO->{'BACKUP_DIR'}/$file_path/$file") {
            push(@filelist, $obj->Find_Files($file_path.'/'.$file) );
        } else {
            push(@filelist, $file_path.'/'.$file);
        }
    }
    return @filelist;
}



1;
