package Admin::Session;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
    require 'Sessions.pm';
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();
my $sess  = Sessions->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;

    my $total_sessions = $db->query(  TABLE     => 'active_sessions',
                                      MATCH     => 'ALL',
                                      SORT_KEY  => 'RUNNING_TIME',
                                      SORT_BY   => 'Z-A',
                                    );

    my @choice;

    push @choice, { VALUE => 'ALT', NAME => "ALL USERS Inactive in the last 5 minutes" };
    push @choice, { VALUE => 'ALL', NAME => "ALL USERS Regardless of time"             };
    push @choice, { VALUE => 'ALT', NAME => "---------------------------------"        };

    for (@{ $total_sessions }) {
        if ($_->{MEMBER_NAME}) {
            push @choice, { NAME => $_->{MEMBER_NAME}, VALUE => $_->{MEMBER_NAME} };
        }
    }
    

    my $html  = $SKIN->title( TITLE => 'Session Control');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'sess',
                                        CODE  => 'delete'
                                      } );

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Please select an option", TEXT => "This will not affect your current session" );

    $html .= $SKIN->td_select( TEXT     => 'Delete Session for:',
                               NAME     => 'USERS',
                               VALUES   => 'ALL',
                               DATA     => \@choice
                             );



    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Reset Chosen Sessions' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MAINTAIN', NAV_ONE => 'Session Control', PRINT => $html);

}


sub delete {
    my ($obj, $db) = @_;

    my $query = "ID ne '$iB::SESSION'";

    if ($iB::IN{'USERS'} eq 'ALT') {
        $query .= qq! and RUNNING_TIME < (time - (60*5))!;
    } else {
        $query = qq!MEMBER_NAME eq "$iB::IN{'USERS'}"!;
    }

    $db->delete( TABLE  => 'active_sessions',
                 WHERE  => $query,
               );

    $ADMIN->write_log( TITLE => 'Sessions Deleted');

    $ADMIN->static_screen( URL   => "act=sess",
                           TITLE => "Chosen Session(s) Deleted",
                           TEXT  => "The changes were successful<br>"
                         );
}
            


##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'delete'        => \&delete,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
